/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.kube.wrappers;

import com.almostreliable.lootjs.util.Utils;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.script.KubeJSContext;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.RecordTypeInfo;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class MobEffectsPredicateWrapper {
    private static final RecordTypeInfo EIP_TYPE_INFO = (RecordTypeInfo)TypeInfo.of(MobEffectsPredicate.MobEffectInstancePredicate.class);

    public static MobEffectsPredicate of(Context cx, Object o) {
        if (o instanceof MobEffectsPredicate) {
            MobEffectsPredicate m = (MobEffectsPredicate)o;
            return m;
        }
        HolderLookup.RegistryLookup allEffects = ((KubeJSContext)cx).getRegistries().access().lookupOrThrow(Registries.MOB_EFFECT);
        HashMap<Holder.Reference, MobEffectsPredicate.MobEffectInstancePredicate> effectMap = new HashMap<Holder.Reference, MobEffectsPredicate.MobEffectInstancePredicate>();
        List<Object> list = Utils.listOrThrow(o);
        for (Object obj : list) {
            try {
                Map<String, Object> map = Utils.mapOrThrow(obj);
                if (!map.containsKey("id")) {
                    throw new RuntimeException("Expected effect id key");
                }
                String effectId = map.get("id").toString();
                Holder.Reference effect = allEffects.getOrThrow(ResourceKey.create((ResourceKey)Registries.MOB_EFFECT, (ResourceLocation)ResourceLocation.parse((String)effectId)));
                MobEffectsPredicate.MobEffectInstancePredicate instance = (MobEffectsPredicate.MobEffectInstancePredicate)EIP_TYPE_INFO.wrap(cx, map.get("duration"), (TypeInfo)EIP_TYPE_INFO);
                effectMap.put(effect, instance);
            }
            catch (Exception error) {
                ConsoleJS.SERVER.error((Object)error);
            }
        }
        return new MobEffectsPredicate(effectMap);
    }
}

