/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.registry.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.IOException;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import team.lodestar.lodestone.LodestoneLib;
import team.lodestar.lodestone.systems.rendering.shader.ShaderHolder;

@EventBusSubscriber(value={Dist.CLIENT}, modid="lodestone", bus=EventBusSubscriber.Bus.MOD)
public class LodestoneShaders {
    public static ShaderHolder LODESTONE_TEXTURE = new ShaderHolder(LodestoneLib.lodestonePath("lodestone_texture"), DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, "LumiTransparency");
    public static ShaderHolder DISTORTED_TEXTURE = new ShaderHolder(LodestoneLib.lodestonePath("distorted_texture"), DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, "Speed", "TimeOffset", "Intensity", "XFrequency", "YFrequency", "UVCoordinates");
    public static ShaderHolder LODESTONE_TEXT = new ShaderHolder(LodestoneLib.lodestonePath("lodestone_text"), DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, new String[0]);
    public static ShaderHolder PARTICLE = new ShaderHolder(LodestoneLib.lodestonePath("particle/lodestone_particle"), DefaultVertexFormat.PARTICLE, "LumiTransparency", "DepthFade");
    public static ShaderHolder SCREEN_PARTICLE = new ShaderHolder(LodestoneLib.lodestonePath("screen/screen_particle"), DefaultVertexFormat.POSITION_TEX_COLOR, new String[0]);
    public static ShaderHolder SCREEN_DISTORTED_TEXTURE = new ShaderHolder(LodestoneLib.lodestonePath("screen/screen_distorted_texture"), DefaultVertexFormat.POSITION_TEX_COLOR, "Speed", "TimeOffset", "Intensity", "XFrequency", "YFrequency", "UVCoordinates");
    public static ShaderHolder TRIANGLE_TEXTURE = new ShaderHolder(LodestoneLib.lodestonePath("shapes/triangle_texture"), DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, "LumiTransparency");
    public static ShaderHolder TWO_SIDED_TRIANGLE_TEXTURE = new ShaderHolder(LodestoneLib.lodestonePath("shapes/two_sided_triangle_texture"), DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, "LumiTransparency");
    public static ShaderHolder ROUNDED_TRIANGLE_TEXTURE = new ShaderHolder(LodestoneLib.lodestonePath("shapes/rounded_triangle_texture"), DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, "LumiTransparency");
    public static ShaderHolder SCROLLING_TEXTURE = new ShaderHolder(LodestoneLib.lodestonePath("shapes/scrolling_texture"), DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, "Speed", "LumiTransparency");
    public static ShaderHolder SCROLLING_TRIANGLE_TEXTURE = new ShaderHolder(LodestoneLib.lodestonePath("shapes/scrolling_triangle_texture"), DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, "Speed", "LumiTransparency");

    @SubscribeEvent
    public static void shaderRegistry(RegisterShadersEvent event) {
        LodestoneShaders.registerShader(event, LODESTONE_TEXTURE);
        LodestoneShaders.registerShader(event, DISTORTED_TEXTURE);
        LodestoneShaders.registerShader(event, LODESTONE_TEXT);
        LodestoneShaders.registerShader(event, PARTICLE);
        LodestoneShaders.registerShader(event, SCREEN_PARTICLE);
        LodestoneShaders.registerShader(event, SCREEN_DISTORTED_TEXTURE);
        LodestoneShaders.registerShader(event, TRIANGLE_TEXTURE);
        LodestoneShaders.registerShader(event, TWO_SIDED_TRIANGLE_TEXTURE);
        LodestoneShaders.registerShader(event, ROUNDED_TRIANGLE_TEXTURE);
        LodestoneShaders.registerShader(event, SCROLLING_TEXTURE);
        LodestoneShaders.registerShader(event, SCROLLING_TRIANGLE_TEXTURE);
    }

    public static void registerShader(RegisterShadersEvent event, ShaderHolder shaderHolder) {
        try {
            ResourceProvider provider = event.getResourceProvider();
            event.registerShader((ShaderInstance)shaderHolder.createInstance(provider), shaderHolder::setShaderInstance);
        }
        catch (IOException e) {
            LodestoneLib.LOGGER.error("Error registering shader", (Throwable)e);
            e.printStackTrace();
        }
    }
}

