/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.model.obj.modifier.modifiers;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import team.lodestar.lodestone.systems.model.obj.IndexedModel;
import team.lodestar.lodestone.systems.model.obj.ObjParser;
import team.lodestar.lodestone.systems.model.obj.data.IndexedMesh;
import team.lodestar.lodestone.systems.model.obj.modifier.ModelModifier;

public class PoseModifier
extends ModelModifier {
    private final Consumer<PoseStack> poseStackConsumer;

    public PoseModifier(Consumer<PoseStack> poseConsumer) {
        this.poseStackConsumer = poseConsumer;
    }

    @Override
    public void applyEarly(ObjParser.Builder parsedModel) {
        PoseStack poseStack = new PoseStack();
        this.poseStackConsumer.accept(poseStack);
        PoseStack.Pose pose = poseStack.last();
        for (Vector3f position : parsedModel.getPositions()) {
            Vector3f posCopy = new Vector3f((Vector3fc)position);
            Vector4f posCopy4 = new Vector4f((Vector3fc)posCopy, 1.0f);
            posCopy4.mul((Matrix4fc)pose.pose());
            posCopy.set(posCopy4.x(), posCopy4.y(), posCopy4.z());
            position.set((Vector3fc)posCopy);
        }
        for (Vector3f normal : parsedModel.getNormals()) {
            Vector3f normalCopy = new Vector3f((Vector3fc)normal);
            normalCopy.mul((Matrix3fc)pose.normal());
            normal.set(normalCopy.x(), normalCopy.y(), normalCopy.z());
        }
    }

    @Override
    public void apply(IndexedModel model) {
    }

    @Override
    public void apply(IndexedModel model, IndexedMesh mesh) {
    }
}

