/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.multiblock;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.helpers.NBTHelper;
import team.lodestar.lodestone.registry.common.LodestoneBlockEntities;
import team.lodestar.lodestone.systems.blockentity.IItemHandlerSupplier;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;
import team.lodestar.lodestone.systems.multiblock.MultiBlockCoreEntity;

public class MultiBlockComponentEntity
extends LodestoneBlockEntity
implements IItemHandlerSupplier {
    public BlockPos corePos;

    public MultiBlockComponentEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public MultiBlockComponentEntity(BlockPos pos, BlockState state) {
        super(LodestoneBlockEntities.MULTIBLOCK_COMPONENT.get(), pos, state);
    }

    @Override
    public IItemHandler getInventory(Direction direction) {
        MultiBlockCoreEntity core;
        BlockEntity blockEntity;
        if (this.corePos != null && (blockEntity = this.level.getBlockEntity(this.corePos)) instanceof MultiBlockCoreEntity && (core = (MultiBlockCoreEntity)blockEntity) instanceof IItemHandlerSupplier) {
            IItemHandlerSupplier supplier = (IItemHandlerSupplier)((Object)core);
            return supplier.getInventory(direction);
        }
        return null;
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        if (this.corePos != null) {
            NBTHelper.saveBlockPos(pTag, this.corePos);
        }
        super.saveAdditional(pTag, pRegistries);
    }

    @Override
    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.corePos = NBTHelper.readBlockPos(pTag);
        super.loadAdditional(pTag, pRegistries);
    }

    @Override
    public ItemInteractionResult onUse(Player pPlayer, InteractionHand pHand) {
        BlockEntity blockEntity;
        if (this.corePos != null && (blockEntity = this.level.getBlockEntity(this.corePos)) instanceof MultiBlockCoreEntity) {
            MultiBlockCoreEntity core = (MultiBlockCoreEntity)blockEntity;
            return core.onUse(pPlayer, pHand);
        }
        return super.onUse(pPlayer, pHand);
    }

    @Override
    public InteractionResult onUseWithoutItem(Player pPlayer) {
        BlockEntity blockEntity;
        if (this.corePos != null && (blockEntity = this.level.getBlockEntity(this.corePos)) instanceof MultiBlockCoreEntity) {
            MultiBlockCoreEntity core = (MultiBlockCoreEntity)blockEntity;
            return core.onUseWithoutItem(pPlayer);
        }
        return super.onUseWithoutItem(pPlayer);
    }

    @Override
    public ItemInteractionResult onUseWithItem(Player pPlayer, ItemStack pStack, InteractionHand pHand) {
        BlockEntity blockEntity;
        if (this.corePos != null && (blockEntity = this.level.getBlockEntity(this.corePos)) instanceof MultiBlockCoreEntity) {
            MultiBlockCoreEntity core = (MultiBlockCoreEntity)blockEntity;
            return core.onUseWithItem(pPlayer, pStack, pHand);
        }
        return super.onUseWithItem(pPlayer, pStack, pHand);
    }

    @Override
    public void onBreak(@Nullable Player player) {
        BlockEntity blockEntity;
        if (this.corePos != null && (blockEntity = this.level.getBlockEntity(this.corePos)) instanceof MultiBlockCoreEntity) {
            MultiBlockCoreEntity core = (MultiBlockCoreEntity)blockEntity;
            core.onBreak(player);
        }
        super.onBreak(player);
    }
}

