/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.particle.screen;

import com.mojang.blaze3d.vertex.BufferBuilder;
import java.awt.Color;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.joml.Vector3d;
import team.lodestar.lodestone.handlers.screenparticle.ScreenParticleHandler;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneScreenParticleRenderType;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleOptions;
import team.lodestar.lodestone.systems.particle.screen.base.TextureSheetScreenParticle;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;

public class LodestoneScreenParticle
extends TextureSheetScreenParticle {
    private final LodestoneScreenParticleRenderType renderType;
    protected final ParticleEngine.MutableSpriteSet spriteSet;
    protected final SimpleParticleOptions.ParticleSpritePicker spritePicker;
    protected final ColorParticleData colorData;
    protected final GenericParticleData transparencyData;
    protected final GenericParticleData scaleData;
    @Nullable
    protected final GenericParticleData lengthData;
    protected final SpinParticleData spinData;
    protected final Consumer<LodestoneScreenParticle> actor;
    private final boolean tracksStack;
    private final double stackTrackXOffset;
    private final double stackTrackYOffset;
    private int lifeDelay;
    private float quadLength;
    float[] hsv1 = new float[3];
    float[] hsv2 = new float[3];

    public LodestoneScreenParticle(ClientLevel world, ScreenParticleOptions options, ParticleEngine.MutableSpriteSet spriteSet, double x, double y, double xMotion, double yMotion) {
        super(world, x, y);
        this.renderType = options.renderType;
        this.spriteSet = spriteSet;
        this.spritePicker = options.spritePicker;
        this.colorData = options.colorData;
        this.transparencyData = options.transparencyData;
        this.scaleData = options.scaleData;
        this.lengthData = options.lengthData != WorldParticleOptions.DEFAULT_GENERIC ? options.lengthData : null;
        this.spinData = options.spinData;
        this.actor = options.actor;
        this.tracksStack = options.tracksStack;
        this.stackTrackXOffset = options.stackTrackXOffset;
        this.stackTrackYOffset = options.stackTrackYOffset;
        this.roll = options.spinData.spinOffset + options.spinData.startingValue;
        this.xMotion = xMotion;
        this.yMotion = yMotion;
        this.setLifetime((Integer)options.lifetimeSupplier.get());
        this.lifeDelay = (Integer)options.lifeDelaySupplier.get();
        this.gravity = ((Float)options.gravityStrengthSupplier.get()).floatValue();
        this.friction = ((Float)options.frictionStrengthSupplier.get()).floatValue();
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, this.colorData.r1)), (int)(255.0f * Math.min(1.0f, this.colorData.g1)), (int)(255.0f * Math.min(1.0f, this.colorData.b1)), this.hsv1);
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, this.colorData.r2)), (int)(255.0f * Math.min(1.0f, this.colorData.g2)), (int)(255.0f * Math.min(1.0f, this.colorData.b2)), this.hsv2);
        if (spriteSet != null) {
            switch (this.spritePicker) {
                case FIRST_INDEX: 
                case WITH_AGE: {
                    this.pickSprite(0);
                    break;
                }
                case LAST_INDEX: 
                case WITH_AGE_INVERSE: {
                    this.pickSprite(spriteSet.sprites.size() - 1);
                    break;
                }
                case RANDOM_SPRITE: {
                    this.pickSprite(this.random.nextInt(spriteSet.sprites.size()));
                }
            }
        }
        this.updateTraits();
    }

    @Override
    public float getQuadLength(float partialTicks) {
        return this.lengthData != null ? this.quadLength : super.getQuadLength(partialTicks);
    }

    public SimpleParticleOptions.ParticleSpritePicker getSpritePicker() {
        return this.spritePicker;
    }

    public void pickSprite(int spriteIndex) {
        this.setSprite((TextureAtlasSprite)this.spriteSet.sprites.get(Mth.clamp((int)spriteIndex, (int)0, (int)(this.spriteSet.sprites.size() - 1))));
    }

    public void pickColor(float colorCoeff) {
        float h = Mth.rotLerp((float)colorCoeff, (float)(360.0f * this.hsv1[0]), (float)(360.0f * this.hsv2[0])) / 360.0f;
        float s = Mth.lerp((float)colorCoeff, (float)this.hsv1[1], (float)this.hsv2[1]);
        float v = Mth.lerp((float)colorCoeff, (float)this.hsv1[2], (float)this.hsv2[2]);
        int packed = Color.HSBtoRGB(h, s, v);
        float r = (float)FastColor.ARGB32.red((int)packed) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)packed) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)packed) / 255.0f;
        this.setColor(r, g, b);
    }

    public float getCurve(float multiplier) {
        return Mth.clamp((float)((float)this.age * multiplier / (float)this.lifetime), (float)0.0f, (float)1.0f);
    }

    protected void updateTraits() {
        if (this.scaleData.getProgress(this.age, this.lifetime) > 0.8f || this.transparencyData.getProgress(this.age, this.lifetime) > 0.8f) {
            if (this.alpha <= 0.0f || this.getQuadSize(0.0f) <= 0.0f || this.getQuadLength(0.0f) <= 0.0f) {
                this.remove();
            }
            return;
        }
        this.pickColor(this.colorData.colorCurveEasing.ease(this.colorData.getProgress(this.age, this.lifetime), 0.0f, 1.0f, 1.0f));
        this.quadSize = this.scaleData.getValue(this.age, this.lifetime);
        this.quadLength = this.lengthData != null ? this.lengthData.getValue(this.age, this.lifetime) : this.quadSize;
        this.alpha = Mth.clamp((float)this.transparencyData.getValue(this.age, this.lifetime), (float)0.0f, (float)1.0f);
        this.oRoll = this.roll;
        this.roll += this.spinData.getValue(this.age, this.lifetime);
        if (this.actor != null) {
            this.actor.accept(this);
        }
    }

    @Override
    public void render(BufferBuilder bufferBuilder) {
        if (this.lifeDelay > 0) {
            return;
        }
        if (this.tracksStack) {
            this.x = (double)ScreenParticleHandler.currentItemX + this.stackTrackXOffset + this.xMoved;
            this.y = (double)ScreenParticleHandler.currentItemY + this.stackTrackYOffset + this.yMoved;
        }
        super.render(bufferBuilder);
    }

    @Override
    public void tick() {
        if (this.lifeDelay > 0) {
            --this.lifeDelay;
            return;
        }
        this.updateTraits();
        super.tick();
        if (this.spriteSet != null) {
            switch (this.spritePicker) {
                case WITH_AGE: {
                    this.setSpriteFromAge((SpriteSet)this.spriteSet);
                    break;
                }
                case WITH_AGE_INVERSE: {
                    this.setSpriteFromInverseAge((SpriteSet)this.spriteSet);
                }
            }
        }
    }

    @Override
    public LodestoneScreenParticleRenderType getRenderType() {
        return this.renderType;
    }

    public void setSpriteFromInverseAge(SpriteSet sprite) {
        if (!this.removed) {
            this.setSprite(sprite.get(this.lifetime - this.age, this.lifetime));
        }
    }

    public void setParticleSpeed(Vector3d speed) {
        this.setParticleSpeed(speed.x, speed.y);
    }
}

