/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.block;

import com.soytutta.mynethersdelight.common.registry.MNDBlocks;
import com.soytutta.mynethersdelight.common.tag.MNDTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.util.TriState;

public class LetiosCompostBlock
extends Block {
    public static IntegerProperty FORGOTING = IntegerProperty.create((String)"forgoting", (int)0, (int)9);

    public LetiosCompostBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)super.defaultBlockState().setValue((Property)FORGOTING, (Comparable)Integer.valueOf(0)));
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FORGOTING});
        super.createBlockStateDefinition(builder);
    }

    public int getMaxForgotingStage() {
        return 9;
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (!worldIn.isClientSide) {
            float chance = 0.0f;
            boolean hasLava = false;
            boolean isSoulBiome = false;
            for (BlockPos neighborPos : BlockPos.betweenClosed((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 1, 1))) {
                BlockState neighborState = worldIn.getBlockState(neighborPos);
                if (neighborState.is(MNDTags.LETIOS_ACTIVATORS)) {
                    chance += 0.02f;
                }
                if (neighborState.is(MNDTags.LETIOS_FLAMES) && (!neighborState.hasProperty((Property)BlockStateProperties.LIT) || neighborState.hasProperty((Property)BlockStateProperties.LIT) && ((Boolean)neighborState.getValue((Property)BlockStateProperties.LIT)).booleanValue())) {
                    chance += 0.02f;
                }
                if (neighborState.getFluidState().is(FluidTags.LAVA)) {
                    hasLava = true;
                }
                if (!worldIn.getBiome(pos).is(Biomes.SOUL_SAND_VALLEY)) continue;
                isSoulBiome = true;
            }
            chance += hasLava ? 0.3f : 0.0f;
            chance += isSoulBiome ? 0.3f : 0.0f;
            if (worldIn.getRandom().nextFloat() <= chance && worldIn.dimensionType().ultraWarm()) {
                if (((Integer)state.getValue((Property)FORGOTING)).intValue() == this.getMaxForgotingStage()) {
                    worldIn.setBlock(pos, MNDBlocks.RESURGENT_SOIL.get().defaultBlockState(), 3);
                } else {
                    worldIn.setBlock(pos, (BlockState)state.setValue((Property)FORGOTING, (Comparable)Integer.valueOf((Integer)state.getValue((Property)FORGOTING) + 1)), 3);
                }
            }
        }
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return false;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level worldIn, BlockPos pos) {
        return this.getMaxForgotingStage() + 1 - (Integer)blockState.getValue((Property)FORGOTING);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        if (random.nextInt(10) == 0 && level.dimensionType().ultraWarm()) {
            level.addParticle((ParticleOptions)ParticleTypes.SOUL, (double)pos.getX() + (double)random.nextFloat(), (double)pos.getY() + 1.1, (double)pos.getZ() + (double)random.nextFloat(), 0.0, 0.0, 0.0);
        }
    }

    public TriState canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, BlockState plantState) {
        if (plantState.getBlock() instanceof NetherWartBlock) {
            return TriState.TRUE;
        }
        return TriState.DEFAULT;
    }
}

