/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.block;

import com.mojang.serialization.MapCodec;
import com.soytutta.mynethersdelight.common.registry.MNDBlocks;
import com.soytutta.mynethersdelight.common.registry.MNDItems;
import com.soytutta.mynethersdelight.common.tag.MNDTags;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.Tags;
import vectorwing.farmersdelight.common.tag.CommonTags;

public class PowderyCaneBlock
extends BushBlock
implements BonemealableBlock {
    public static final MapCodec<PowderyCaneBlock> CODEC = PowderyCaneBlock.simpleCodec(PowderyCaneBlock::new);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final BooleanProperty BASE = BooleanProperty.create((String)"base");
    public static final BooleanProperty LEAVE = BooleanProperty.create((String)"leave");
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)2);
    public static final IntegerProperty PRESSURE = IntegerProperty.create((String)"pressure", (int)0, (int)2);
    private static final VoxelShape SHAPE = Block.box((double)6.5, (double)0.0, (double)6.5, (double)10.5, (double)16.0, (double)10.5);

    public PowderyCaneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)LEAVE, (Comparable)Boolean.valueOf(false))).setValue((Property)BASE, (Comparable)Boolean.valueOf(false))).setValue((Property)PRESSURE, (Comparable)Integer.valueOf(0))).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends PowderyCaneBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LIT, BASE, LEAVE, AGE, PRESSURE});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Vec3 vec3 = state.getOffset(worldIn, pos);
        return SHAPE.move(vec3.x, vec3.y, vec3.z);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockBelow = level.getBlockState(pos.below());
        return blockBelow.is(MNDTags.POWDERY_CANNON_PLANTABLE_ON) || blockBelow.is(MNDTags.POWDERY_CANE);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState offsetState, LevelAccessor level, BlockPos pos, BlockPos offsetPos) {
        if ((Integer)state.getValue((Property)PRESSURE) > 0) {
            level.scheduleTick(pos, (Block)this, 1);
        }
        BlockState blockAbove = level.getBlockState(pos.above());
        BlockState blockBelow = level.getBlockState(pos.below());
        if (blockBelow.is(MNDTags.POWDERY_CANNON_PLANTABLE_ON)) {
            state = (BlockState)state.setValue((Property)BASE, (Comparable)Boolean.valueOf(true));
        } else if (!blockAbove.is(MNDBlocks.BULLET_PEPPER.get()) && !blockAbove.is(Blocks.AIR)) {
            state = (BlockState)state.setValue((Property)LEAVE, (Comparable)Boolean.valueOf(false));
        } else if (blockBelow.is(MNDBlocks.POWDERY_CANE.get()) && !((Boolean)state.getValue((Property)BASE)).booleanValue() && !((Boolean)state.getValue((Property)LEAVE)).booleanValue()) {
            state = (BlockState)state.setValue((Property)LEAVE, (Comparable)Boolean.valueOf(new Random().nextInt(100) < 85));
        }
        if (direction == Direction.DOWN && (Integer)state.getValue((Property)PRESSURE) < 2) {
            level.setBlock(pos, (BlockState)state.setValue((Property)PRESSURE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)PRESSURE) + 1)), 2);
        }
        return super.updateShape(state, direction, offsetState, level, pos, offsetPos);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.isClientSide) {
            return;
        }
        BlockPos posAbove = pos.above();
        BlockState stateAbove = level.getBlockState(posAbove);
        int age = (Integer)state.getValue((Property)AGE);
        int pressure = (Integer)state.getValue((Property)PRESSURE);
        boolean isLit = (Boolean)state.getValue((Property)LIT);
        if (!state.canSurvive((LevelReader)level, pos)) {
            if (isLit) {
                this.explodeAndReset((Level)level, pos, state, age);
            }
            level.destroyBlock(pos, true);
        }
        if (pressure > 0) {
            level.setBlock(pos, (BlockState)state.setValue((Property)PRESSURE, (Comparable)Integer.valueOf(pressure - 1)), 2);
        }
        if (stateAbove.hasProperty((Property)PRESSURE) && (Integer)stateAbove.getValue((Property)PRESSURE) < 2 && (stateAbove.is(MNDTags.POWDERY_CANE) || stateAbove.is(MNDBlocks.BULLET_PEPPER.get()))) {
            level.setBlock(posAbove, (BlockState)stateAbove.setValue((Property)PRESSURE, (Comparable)Integer.valueOf((Integer)stateAbove.getValue((Property)PRESSURE) + 1)), 2);
        }
        if (pressure == 2 && isLit) {
            this.explodeAndReset((Level)level, pos, state, age);
        }
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int age = (Integer)state.getValue((Property)AGE);
        BlockState blockBelow = world.getBlockState(pos.below());
        if (age < 2 && CommonHooks.canCropGrow((Level)world, (BlockPos)pos, (BlockState)state, (random.nextInt(world.dimension() == Level.NETHER ? 6 : 12) == 0 ? 1 : 0) != 0) && (blockBelow.is(MNDBlocks.RESURGENT_SOIL.get()) || blockBelow.is(MNDBlocks.POWDERY_CANNON.get()))) {
            world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            CommonHooks.fireCropGrowPost((Level)world, (BlockPos)pos, (BlockState)state);
        } else if (world.isEmptyBlock(pos.above())) {
            world.setBlockAndUpdate(pos.above(), MNDBlocks.BULLET_PEPPER.get().defaultBlockState());
        } else if (age == 2) {
            world.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!(entity instanceof LivingEntity) || entity.getType() == EntityType.PANDA || entity.getType() == EntityType.BEE || entity.isCrouching()) {
            return;
        }
        entity.hurt(level.damageSources().cactus(), 1.0f);
        entity.makeStuckInBlock(state, new Vec3(0.8, 0.75, 0.8));
        if (!level.isClientSide && (Integer)state.getValue((Property)PRESSURE) < 2) {
            level.setBlock(pos, (BlockState)state.setValue((Property)PRESSURE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)PRESSURE) + 1)), 2);
        }
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            this.plantPepper(level, pos);
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        ItemStack heldItem;
        if (!level.isClientSide && (Integer)state.getValue((Property)PRESSURE) < 2 && !player.isCrouching()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)PRESSURE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)PRESSURE) + 1)), 2);
        }
        if (!(!((Boolean)state.getValue((Property)LIT)).booleanValue() || (heldItem = player.getItemInHand(InteractionHand.MAIN_HAND)).is(CommonTags.TOOLS_KNIFE) && heldItem.is(Tags.Items.TOOLS_SHEAR))) {
            int age = state.hasProperty((Property)AGE) ? (Integer)state.getValue((Property)AGE) : 0;
            this.explodeAndReset(level, pos, state, age);
        }
        super.playerWillDestroy(level, pos, state, player);
        return state;
    }

    public void wasExploded(Level level, BlockPos pos, Explosion explosion) {
        BlockState state = level.getBlockState(pos);
        if (!level.isClientSide && state.hasProperty((Property)LIT) && ((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            int age = state.hasProperty((Property)AGE) ? (Integer)state.getValue((Property)AGE) : 0;
            this.explodeAndReset(level, pos, state, age);
        }
    }

    private void plantPepper(Level level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = pos.relative(direction);
            BlockState neighborState = level.getBlockState(neighborPos);
            BlockState belowNeighborState = level.getBlockState(neighborPos.below());
            if (!neighborState.isAir() || !belowNeighborState.is(MNDTags.POWDERY_CANNON_PLANTABLE_ON) || !((double)level.random.nextFloat() < 0.25)) continue;
            level.setBlock(neighborPos, MNDBlocks.BULLET_PEPPER.get().defaultBlockState(), 3);
            break;
        }
    }

    private void explodeAndReset(Level level, BlockPos pos, BlockState state, int age) {
        level.playSound(null, pos, SoundEvents.CREEPER_PRIMED, SoundSource.BLOCKS, 0.5f, 0.25f);
        level.explode(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 1.25f, false, Level.ExplosionInteraction.NONE);
        level.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
        if (state.hasProperty((Property)AGE) && age > 0) {
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age - 1)), 3);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (heldItem.is(CommonTags.TOOLS_KNIFE) || heldItem.is(Tags.Items.TOOLS_SHEAR)) {
            int age = (Integer)state.getValue((Property)AGE);
            if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
                if (age > 0) {
                    level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age - 1)), 3);
                }
                int j = 2 + level.random.nextInt(3);
                PowderyCaneBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)MNDItems.BULLET_PEPPER.get(), j));
                level.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.FALSE), 2);
                heldItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            } else if (((Boolean)state.getValue((Property)LEAVE)).booleanValue()) {
                level.setBlock(pos, (BlockState)state.setValue((Property)LEAVE, (Comparable)Boolean.FALSE), 2);
                heldItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide && ((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            int age = state.hasProperty((Property)AGE) ? (Integer)state.getValue((Property)AGE) : 0;
            this.explodeAndReset(level, pos, state, age);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return false;
    }

    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        return (Boolean)state.getValue((Property)LIT) != false ? PathType.DAMAGE_FIRE : PathType.DAMAGE_OTHER;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return false;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return false;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
    }
}

