/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.block;

import com.soytutta.mynethersdelight.common.block.MagmaCakeBlock;
import com.soytutta.mynethersdelight.common.registry.MNDBlocks;
import com.soytutta.mynethersdelight.common.tag.MNDTags;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.TriState;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.MathUtils;

public class ResurgentSoilFarmlandBlock
extends FarmBlock {
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);

    public ResurgentSoilFarmlandBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private static boolean hasFireOrLava(LevelReader level, BlockPos pos) {
        Iterator var2 = BlockPos.betweenClosed((BlockPos)pos.offset(-7, -7, -7), (BlockPos)pos.offset(7, 7, 7)).iterator();
        while (true) {
            int distance;
            int lightLevel;
            if (!var2.hasNext()) {
                return false;
            }
            BlockPos nearbyPos = (BlockPos)var2.next();
            BlockState state = level.getBlockState(nearbyPos);
            if (state.getFluidState().is(FluidTags.LAVA)) {
                lightLevel = state.getLightEmission((BlockGetter)level, nearbyPos);
                distance = pos.distManhattan((Vec3i)nearbyPos);
                if (distance <= lightLevel) {
                    return true;
                }
            }
            if (!state.is(MNDTags.LETIOS_FLAMES) || state.hasProperty((Property)BlockStateProperties.LIT) && (!state.hasProperty((Property)BlockStateProperties.LIT) || !((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue())) continue;
            lightLevel = state.getLightEmission((BlockGetter)level, nearbyPos);
            distance = pos.distManhattan((Vec3i)nearbyPos);
            if (state.getBlock() instanceof TorchBlock || state.getBlock() instanceof WallTorchBlock) {
                lightLevel /= 2;
            } else if (state.getBlock() instanceof LanternBlock) {
                lightLevel = lightLevel / 2 + 2;
            } else if (state.getBlock() instanceof MagmaCakeBlock || state.getBlock() instanceof MagmaBlock) {
                lightLevel += 3;
            }
            if (distance <= lightLevel) break;
        }
        return true;
    }

    public static void turnToRichSoil(BlockState state, Level level, BlockPos pos) {
        level.setBlockAndUpdate(pos, ResurgentSoilFarmlandBlock.pushEntitiesUp((BlockState)state, (BlockState)MNDBlocks.RESURGENT_SOIL.get().defaultBlockState(), (LevelAccessor)level, (BlockPos)pos));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return !this.defaultBlockState().canSurvive((LevelReader)context.getLevel(), context.getClickedPos()) ? MNDBlocks.RESURGENT_SOIL.get().defaultBlockState() : super.getStateForPlacement(context);
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState aboveState = level.getBlockState(pos.above());
        return super.canSurvive(state, level, pos) || aboveState.getBlock().equals(Blocks.MELON) || aboveState.getBlock().equals(Blocks.PUMPKIN);
    }

    public boolean isFertile(BlockState state, BlockGetter world, BlockPos pos) {
        if (state.is(MNDBlocks.RESURGENT_SOIL_FARMLAND.get())) {
            return (Integer)state.getValue((Property)MOISTURE) > 0;
        }
        return false;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            ResurgentSoilFarmlandBlock.turnToRichSoil(state, (Level)level, pos);
        }
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int moisture = (Integer)state.getValue((Property)MOISTURE);
        BlockPos abovePos = pos.above();
        BlockState aboveState = level.getBlockState(abovePos);
        Block aboveBlock = aboveState.getBlock();
        BlockPos belowPos = pos.below();
        BlockState belowState = level.getBlockState(belowPos);
        Block belowBlock = belowState.getBlock();
        if (!ResurgentSoilFarmlandBlock.hasFireOrLava((LevelReader)level, pos) || level.isRainingAt(pos.above())) {
            if (moisture > 0) {
                level.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(moisture - 1)), 2);
            }
        } else if (moisture < 7) {
            level.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        } else if (moisture == 7) {
            int age;
            if ((Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() == 0.0) {
                return;
            }
            if (aboveBlock instanceof NetherWartBlock && (age = ((Integer)aboveState.getValue((Property)NetherWartBlock.AGE)).intValue()) < 3) {
                aboveState = (BlockState)aboveState.setValue((Property)NetherWartBlock.AGE, (Comparable)Integer.valueOf(age + 1));
                level.setBlockAndUpdate(abovePos, aboveState);
                return;
            }
            if (!aboveState.is(MNDTags.NOT_PROPAGATE_PLANT)) {
                if (aboveState.is(MNDTags.ABOVE_PROPAGATE_PLANT) && (double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() / 6.0) {
                    this.propagateAboveIfPossible(aboveBlock, abovePos, level);
                }
                if (aboveBlock instanceof NetherWartBlock) {
                    age = (Integer)aboveState.getValue((Property)NetherWartBlock.AGE);
                    if (age < 3) {
                        return;
                    }
                    if (age == 3 && level.random.nextInt(8) == 0) {
                        this.propagateAboveIfPossible(aboveBlock, abovePos, level);
                    }
                }
                if (aboveBlock instanceof DoublePlantBlock && (double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get()) {
                    this.propagateAboveIfPossible(aboveBlock, abovePos, level);
                }
            }
            int BonemealChance = 1;
            if (MathUtils.RAND.nextFloat() <= 0.2f) {
                BonemealChance = 2;
                if (MathUtils.RAND.nextFloat() <= 0.01f) {
                    BonemealChance = 3;
                }
            }
            for (int i = 0; i < MathUtils.RAND.nextInt(BonemealChance) + 1; ++i) {
                this.performBonemealIfPossible(aboveBlock, pos.above(), aboveState, level, 1);
                this.performBonemealIfPossible(belowBlock, pos.below(), belowState, level, 1);
            }
        }
        if (!belowState.is(MNDTags.NOT_PROPAGATE_PLANT) && belowState.is(MNDTags.BELOW_PROPAGATE_PLANT) && (double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() * (double)0.8f) {
            this.propagateBelowIfPossible(belowBlock, belowPos, level);
            return;
        }
    }

    private void performBonemealIfPossible(Block block, BlockPos position, BlockState state, ServerLevel level, int distance) {
        block7: {
            if (state.is(ModTags.UNAFFECTED_BY_RICH_SOIL) || block instanceof TallFlowerBlock) {
                return;
            }
            if (!(block instanceof BonemealableBlock)) break block7;
            BonemealableBlock growable = (BonemealableBlock)block;
            if ((double)MathUtils.RAND.nextFloat() <= (Double)Configuration.RICH_SOIL_BOOST_CHANCE.get() / (double)distance) {
                if (growable.isValidBonemealTarget((LevelReader)level, position, state) && CommonHooks.canCropGrow((Level)level, (BlockPos)position, (BlockState)state, (boolean)true)) {
                    growable.performBonemeal(level, level.random, position, state);
                    CommonHooks.fireCropGrowPost((Level)level, (BlockPos)position, (BlockState)state);
                    for (int i = 0; i < 3; ++i) {
                        double d0 = (double)position.getX() + level.getRandom().nextDouble();
                        double d1 = (double)position.getY() + level.getRandom().nextDouble();
                        double d2 = (double)position.getZ() + level.getRandom().nextDouble();
                        level.sendParticles((ParticleOptions)ParticleTypes.SOUL, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
                        level.playSound(null, position, (SoundEvent)SoundEvents.SOUL_ESCAPE.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                } else {
                    BlockPos checkPos = position.above();
                    BlockState checkState = level.getBlockState(checkPos);
                    Block checkBlock = checkState.getBlock();
                    while (checkBlock == block && distance <= 10) {
                        this.performBonemealIfPossible(checkBlock, checkPos, checkState, level, distance + 1);
                        ++distance;
                        checkPos = checkPos.above();
                        checkState = level.getBlockState(checkPos);
                        checkBlock = checkState.getBlock();
                    }
                    checkPos = position.below();
                    checkState = level.getBlockState(checkPos);
                    checkBlock = checkState.getBlock();
                    while (checkBlock == block && distance <= 10) {
                        this.performBonemealIfPossible(checkBlock, checkPos, checkState, level, distance + 1);
                        ++distance;
                        checkPos = checkPos.below();
                        checkState = level.getBlockState(checkPos);
                        checkBlock = checkState.getBlock();
                    }
                }
            }
        }
    }

    private void propagateAboveIfPossible(Block block, BlockPos position, ServerLevel level) {
        ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos newPos = position.offset(x, y, z);
                    BlockState newState = level.getBlockState(newPos);
                    if (!this.canAboveBlockSurvive(block, newState, level, newPos)) continue;
                    validPositions.add(newPos);
                }
            }
        }
        if (!validPositions.isEmpty()) {
            boolean canPropagate;
            BlockPos plantPos = (BlockPos)validPositions.get(level.random.nextInt(validPositions.size()));
            BlockState targetState = level.getBlockState(plantPos);
            boolean bl = canPropagate = block instanceof LiquidBlockContainer && targetState.getBlock() == Blocks.WATER || !(block instanceof LiquidBlockContainer) && targetState.getBlock() == Blocks.AIR || block instanceof SimpleWaterloggedBlock && (targetState.getBlock() == Blocks.AIR || targetState.getBlock() == Blocks.WATER);
            if (canPropagate) {
                this.placeBlock(block, level, plantPos);
            }
        }
    }

    private boolean canAboveBlockSurvive(Block block, BlockState newState, ServerLevel level, BlockPos newPos) {
        BlockState blockBelowState = level.getBlockState(newPos.below());
        if (block instanceof DoublePlantBlock && level.getBlockState(newPos.above()).getBlock() == Blocks.AIR) {
            return blockBelowState.getBlock() == ModBlocks.RICH_SOIL_FARMLAND.get() || blockBelowState.getBlock() == MNDBlocks.RESURGENT_SOIL_FARMLAND.get();
        }
        if (block instanceof NetherWartBlock) {
            return blockBelowState.getBlock() == Blocks.SOUL_SAND || blockBelowState.getBlock() == MNDBlocks.RESURGENT_SOIL.get() || blockBelowState.getBlock() == MNDBlocks.RESURGENT_SOIL_FARMLAND.get();
        }
        if (!(block instanceof DoublePlantBlock)) {
            return blockBelowState.getBlock() == ModBlocks.RICH_SOIL_FARMLAND.get() || blockBelowState.getBlock() == MNDBlocks.RESURGENT_SOIL_FARMLAND.get();
        }
        return false;
    }

    private void propagateBelowIfPossible(Block block, BlockPos position, ServerLevel level) {
        ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos newPos = position.offset(x, y, z);
                    if (!this.canBelowBlockSurvive(level, newPos)) continue;
                    validPositions.add(newPos);
                }
            }
        }
        if (!validPositions.isEmpty()) {
            boolean canPropagate;
            BlockPos plantPos = (BlockPos)validPositions.get(level.random.nextInt(validPositions.size()));
            BlockState targetState = level.getBlockState(plantPos);
            boolean bl = canPropagate = block instanceof LiquidBlockContainer && targetState.getBlock() == Blocks.WATER || !(block instanceof LiquidBlockContainer) && targetState.getBlock() == Blocks.AIR || block instanceof SimpleWaterloggedBlock && (targetState.getBlock() == Blocks.AIR || targetState.getBlock() == Blocks.WATER);
            if (canPropagate) {
                this.placeBlock(block, level, plantPos);
            }
        }
    }

    private boolean canBelowBlockSurvive(ServerLevel level, BlockPos newPos) {
        BlockState blockAboveState = level.getBlockState(newPos.above());
        return blockAboveState.getBlock() == ModBlocks.RICH_SOIL.get() || blockAboveState.getBlock() == MNDBlocks.RESURGENT_SOIL.get() || blockAboveState.getBlock() == ModBlocks.RICH_SOIL_FARMLAND.get() || blockAboveState.getBlock() == MNDBlocks.RESURGENT_SOIL_FARMLAND.get();
    }

    private void placeBlock(Block block, ServerLevel level, BlockPos pos) {
        BlockState state = block.defaultBlockState();
        if (block instanceof SimpleWaterloggedBlock) {
            FluidState fluidState = level.getFluidState(pos);
            state = fluidState.getType() == Fluids.WATER ? (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)) : (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        if (block instanceof DoublePlantBlock) {
            DoublePlantBlock.placeAt((LevelAccessor)level, (BlockState)state, (BlockPos)pos, (int)3);
        } else {
            level.setBlockAndUpdate(pos, state);
        }
        for (int i = 0; i < 3; ++i) {
            double d0 = (double)pos.getX() + level.getRandom().nextDouble();
            double d1 = (double)pos.getY() + level.getRandom().nextDouble();
            double d2 = (double)pos.getZ() + level.getRandom().nextDouble();
            level.sendParticles((ParticleOptions)ParticleTypes.SOUL, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
            level.playSound(null, pos, (SoundEvent)SoundEvents.SOUL_ESCAPE.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public TriState canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, BlockState plantState) {
        return TriState.TRUE;
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return false;
    }
}

