/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.entity;

import com.soytutta.mynethersdelight.common.registry.MNDEntityTypes;
import com.soytutta.mynethersdelight.common.registry.MNDItems;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class StriderRockEntity
extends ThrowableItemProjectile {
    public StriderRockEntity(EntityType<StriderRockEntity> StriderRockEntityType, Level level) {
        super(StriderRockEntityType, level);
    }

    public StriderRockEntity(Level level, LivingEntity livingEntity) {
        super(MNDEntityTypes.STRIDER_ROCK.get(), livingEntity, level);
    }

    public StriderRockEntity(Level level, double d, double e, double f) {
        super(MNDEntityTypes.STRIDER_ROCK.get(), d, e, f, level);
    }

    public void handleEntityEvent(byte id) {
        ItemStack entityStack = new ItemStack((ItemLike)this.getDefaultItem());
        if (id == 3) {
            ItemParticleOption iparticledata = new ItemParticleOption(ParticleTypes.ITEM, entityStack);
            for (int i = 0; i < 12; ++i) {
                this.level().addParticle((ParticleOptions)iparticledata, this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() * 2.0 - 1.0) * (double)0.1f, ((double)this.random.nextFloat() * 2.0 - 1.0) * (double)0.1f + (double)0.1f, ((double)this.random.nextFloat() * 2.0 - 1.0) * (double)0.1f);
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        result.getEntity().hurt(result.getEntity().damageSources().thrown((Entity)this, this.getOwner()), 1.0f);
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            int j;
            int i;
            this.playSound(SoundEvents.STONE_BREAK, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            boolean striderSpawned = false;
            if (this.random.nextInt(16) == 0) {
                i = 1;
                if (this.random.nextInt(64) == 0) {
                    i = 4;
                }
                for (j = 0; j < i; ++j) {
                    Strider strider = (Strider)EntityType.STRIDER.create(this.level());
                    if (strider == null) continue;
                    strider.setAge(-24000);
                    strider.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                    this.level().addFreshEntity((Entity)strider);
                    striderSpawned = true;
                }
            }
            if (!striderSpawned && this.random.nextInt(5) == 0) {
                i = 1;
                for (j = 0; j < i; ++j) {
                    ItemEntity stickItem = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack((ItemLike)MNDItems.STRIDER_EGG.get()));
                    this.level().addFreshEntity((Entity)stickItem);
                }
            }
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    protected Item getDefaultItem() {
        return MNDItems.STRIDER_ROCK.get();
    }
}

