/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.entity.ia;

import com.google.common.collect.Lists;
import com.soytutta.mynethersdelight.common.block.MagmaCakeBlock;
import com.soytutta.mynethersdelight.common.registry.MNDItems;
import com.soytutta.mynethersdelight.common.tag.MyCommonTags;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class EatMagmaCakeGoal
extends Goal {
    private static final int COOLDOWN_TICKS = 5;
    private static final int TONGUE_ANIMATION_DURATION = 10;
    private static final SoundEvent TONGUE_SOUND = SoundEvents.FROG_EAT;
    private final Frog frog;
    private final Level level;
    private Object targetPos;
    private int eatAnimationTick;
    private int tongueAnimationTick;
    private int cooldownTick;

    public EatMagmaCakeGoal(Frog frog) {
        this.frog = frog;
        this.level = frog.level();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        this.updateTarget();
        return this.targetPos != null;
    }

    public void start() {
        this.moveToTarget();
    }

    public void stop() {
        this.targetPos = null;
        this.eatAnimationTick = 0;
        this.tongueAnimationTick = 0;
        this.cooldownTick = 5;
        this.frog.setPose(Pose.STANDING);
    }

    public boolean canContinueToUse() {
        return this.targetPos != null;
    }

    public void tick() {
        Entity entity;
        double distanceSq;
        if (this.cooldownTick > 0) {
            --this.cooldownTick;
            return;
        }
        this.updateTarget();
        this.moveToTarget();
        if (this.targetPos instanceof BlockPos) {
            BlockPos pos = (BlockPos)this.targetPos;
            double distanceSq2 = this.frog.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            if (distanceSq2 <= 3.0625) {
                this.handleBlockInteraction(pos);
            }
        } else if (this.targetPos instanceof Entity && (distanceSq = this.frog.distanceToSqr((entity = (Entity)this.targetPos).getX(), entity.getY(), entity.getZ())) <= 3.0625) {
            this.handleEntityInteraction(entity);
        }
    }

    private void updateTarget() {
        List<BlockPos> nearbyCakes = this.findNearbyCakes();
        double minDistanceSq = Double.MAX_VALUE;
        BlockPos closestTarget = null;
        BlockPos frogPos = this.frog.blockPosition();
        for (BlockPos cakePos : nearbyCakes) {
            double distanceSq = frogPos.distSqr((Vec3i)cakePos);
            if (!(distanceSq < minDistanceSq)) continue;
            minDistanceSq = distanceSq;
            closestTarget = cakePos;
        }
        Player player = this.level.getNearestPlayer((Entity)this.frog, 6.0);
        if (player != null && player.distanceToSqr((Entity)this.frog) <= 36.0) {
            double playerDistanceSq;
            ItemStack mainHand = player.getMainHandItem();
            ItemStack offHand = player.getOffhandItem();
            if ((mainHand.is(MyCommonTags.FOODS_MAGMA_CUBE) || offHand.is(MyCommonTags.FOODS_MAGMA_CUBE)) && (playerDistanceSq = frogPos.distSqr((Vec3i)player.blockPosition())) < minDistanceSq) {
                minDistanceSq = playerDistanceSq;
                closestTarget = player;
            }
        }
        this.targetPos = closestTarget;
    }

    private void moveToTarget() {
        if (this.targetPos instanceof BlockPos) {
            BlockPos pos = (BlockPos)this.targetPos;
            this.frog.getNavigation().moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 1.5);
        } else if (this.targetPos instanceof Entity) {
            Entity entity = (Entity)this.targetPos;
            this.frog.getNavigation().moveTo(entity.getX(), entity.getY(), entity.getZ(), 1.5);
        }
    }

    private void handleBlockInteraction(BlockPos pos) {
        this.frog.getNavigation().stop();
        this.frog.getLookControl().setLookAt((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        ++this.eatAnimationTick;
        if (this.eatAnimationTick == 1) {
            this.level.playSound(null, (Entity)this.frog, TONGUE_SOUND, SoundSource.NEUTRAL, 2.0f, 1.0f);
            this.frog.setPose(Pose.USING_TONGUE);
            this.frog.getLookControl().setLookAt((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            BlockState state = this.level.getBlockState(pos);
            if (state.getBlock() instanceof MagmaCakeBlock) {
                for (int i = 0; i < 3; ++i) {
                    MagmaCube magmacube = (MagmaCube)EntityType.MAGMA_CUBE.create(this.level);
                    if (magmacube == null) continue;
                    magmacube.setSize(1, true);
                    magmacube.setHealth(1.0f);
                    magmacube.setInvisible(true);
                    magmacube.setPos(this.frog.getX(), this.frog.getY(), this.frog.getZ());
                    this.level.addFreshEntity((Entity)magmacube);
                    this.frog.doHurtTarget((Entity)magmacube);
                    if (magmacube.isAlive()) continue;
                    magmacube.remove(Entity.RemovalReason.KILLED);
                }
                this.frog.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 200, 0));
                int bites = (Integer)state.getValue((Property)MagmaCakeBlock.BITES);
                if (bites < 6) {
                    this.level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)MagmaCakeBlock.BITES, (Comparable)Integer.valueOf(bites + 1)));
                } else if (((Boolean)state.getValue((Property)MagmaCakeBlock.SECOND_CAKE)).booleanValue()) {
                    this.level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)MagmaCakeBlock.BITES, (Comparable)Integer.valueOf(0))).setValue((Property)MagmaCakeBlock.SECOND_CAKE, (Comparable)Boolean.valueOf(false)));
                } else {
                    this.level.destroyBlock(pos, false);
                }
                this.cooldownTick = 5;
            }
        }
        if (this.tongueAnimationTick < 10) {
            this.frog.getLookControl().setLookAt((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            ++this.tongueAnimationTick;
        } else {
            this.stop();
        }
    }

    private void handleEntityInteraction(Entity entity) {
        this.frog.getNavigation().stop();
        this.frog.getLookControl().setLookAt(entity.getX(), entity.getY(), entity.getZ());
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack mainHand = player.getMainHandItem();
            ItemStack offHand = player.getOffhandItem();
            if (mainHand.getItem() == MNDItems.MAGMA_CAKE_SLICE.get() || offHand.getItem() == MNDItems.MAGMA_CAKE_SLICE.get()) {
                ++this.eatAnimationTick;
                if (this.eatAnimationTick == 1) {
                    this.level.playSound(null, (Entity)this.frog, TONGUE_SOUND, SoundSource.NEUTRAL, 2.0f, 1.0f);
                    this.frog.setPose(Pose.USING_TONGUE);
                    this.frog.getLookControl().setLookAt(entity.getX(), entity.getY(), entity.getZ());
                    if (mainHand.getItem() == MNDItems.MAGMA_CAKE_SLICE.get()) {
                        mainHand.shrink(1);
                    } else if (offHand.getItem() == MNDItems.MAGMA_CAKE_SLICE.get()) {
                        offHand.shrink(1);
                    }
                    for (int i = 0; i < 3; ++i) {
                        MagmaCube magmacube = (MagmaCube)EntityType.MAGMA_CUBE.create(this.level);
                        if (magmacube == null) continue;
                        magmacube.setSize(1, true);
                        magmacube.setHealth(1.0f);
                        magmacube.setInvisible(true);
                        magmacube.setPos(this.frog.getX(), this.frog.getY(), this.frog.getZ());
                        this.level.addFreshEntity((Entity)magmacube);
                        this.frog.doHurtTarget((Entity)magmacube);
                        if (magmacube.isAlive()) continue;
                        magmacube.remove(Entity.RemovalReason.KILLED);
                    }
                    this.frog.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 200, 0));
                }
            }
        }
        if (this.tongueAnimationTick < 10) {
            this.frog.getLookControl().setLookAt(entity.getX(), entity.getY(), entity.getZ());
            ++this.tongueAnimationTick;
        } else {
            this.stop();
        }
    }

    private List<BlockPos> findNearbyCakes() {
        ArrayList cakePositions = Lists.newArrayList();
        BlockPos frogPos = this.frog.blockPosition();
        int searchRadius = 10;
        for (int x = -searchRadius; x <= searchRadius; ++x) {
            for (int y = -searchRadius; y <= searchRadius; ++y) {
                for (int z = -searchRadius; z <= searchRadius; ++z) {
                    BlockPos pos = frogPos.offset(x, y, z);
                    if (!(this.level.getBlockState(pos).getBlock() instanceof MagmaCakeBlock)) continue;
                    cakePositions.add(pos);
                }
            }
        }
        return cakePositions;
    }
}

