/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.events;

import com.soytutta.mynethersdelight.common.enchantment.PoachingData;
import com.soytutta.mynethersdelight.common.registry.MNDEnchantmentComponents;
import com.soytutta.mynethersdelight.common.tag.MNDTags;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.hoglin.HoglinBase;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biomes;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.tag.ModTags;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME)
public class CommonEvent {
    @SubscribeEvent
    public static void livingDie(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (!event.getEntity().level().isClientSide && (livingEntity = event.getEntity()) instanceof Mob) {
            LivingEntity directSource;
            Mob mob = (Mob)livingEntity;
            if (event.getSource() != null && (livingEntity = event.getSource().getDirectEntity()) instanceof LivingEntity && (directSource = livingEntity).getItemInHand(InteractionHand.MAIN_HAND).is(ItemTags.WEAPON_ENCHANTABLE) && EnchantmentHelper.has((ItemStack)directSource.getItemInHand(InteractionHand.MAIN_HAND), MNDEnchantmentComponents.POACHING.get()) && (mob.getMaxHealth() < 150.0f || mob.getType().is(MNDTags.SPECIAL_HUNT)) && ((directSource.hasEffect(MobEffects.LUCK) || directSource.hasEffect(MobEffects.UNLUCK)) && event.getEntity().level().random.nextFloat() < 0.6f || directSource.getItemInHand(InteractionHand.MAIN_HAND).is(ModTags.KNIVES) || event.getEntity().level().random.nextFloat() < 0.4f)) {
                PoachingData poachingData = EnchantmentHelper.pickHighestLevel((ItemStack)directSource.getItemInHand(InteractionHand.MAIN_HAND), MNDEnchantmentComponents.POACHING.get()).orElse(PoachingData.DEFAULT);
                Difficulty difficulty = event.getEntity().level().getDifficulty();
                float baseFailProbability = switch (difficulty) {
                    default -> poachingData.defaultProbability();
                    case Difficulty.PEACEFUL -> poachingData.peacefulProbability();
                    case Difficulty.EASY -> poachingData.easyProbability();
                    case Difficulty.NORMAL -> poachingData.normalProbability();
                    case Difficulty.HARD -> poachingData.hardProbability();
                };
                int luckLevel = directSource.hasEffect(MobEffects.LUCK) ? directSource.getEffect(MobEffects.LUCK).getAmplifier() + 1 : 0;
                int badLuckLevel = directSource.hasEffect(MobEffects.UNLUCK) ? directSource.getEffect(MobEffects.UNLUCK).getAmplifier() + 1 : 0;
                float FailProbability = baseFailProbability - (float)luckLevel * 0.1f + (float)badLuckLevel * 0.2f;
                CompoundTag mobNBT = new CompoundTag();
                mob.save(mobNBT);
                if (mob instanceof Slime && ((Slime)mob).getSize() != 1) {
                    for (int i = 0; i < 2; ++i) {
                        Mob mobCopy = (Mob)mob.getType().create(mob.level());
                        if (mobCopy == null) continue;
                        ((Slime)mobCopy).setSize(((Slime)mob).getSize() - 1, true);
                        mobCopy.moveTo(mob.getX() + (double)i, mob.getY(), mob.getZ() + (double)i, mob.getYRot(), mob.getXRot());
                        mob.level().addFreshEntity((Entity)mobCopy);
                    }
                    return;
                }
                if ((event.getEntity().level().random.nextFloat() < FailProbability || mob.isBaby() && event.getEntity().level().random.nextFloat() < 0.2f || directSource.getItemInHand(InteractionHand.MAIN_HAND).is(ModTags.KNIVES)) && !mob.hasEffect(MobEffects.CONFUSION)) {
                    Vex vex;
                    Witch witch;
                    CaveSpider caveSpider;
                    if (mob instanceof Horse) {
                        ZombieHorse zombieHorse;
                        Horse horse = (Horse)mob;
                        if ((event.getEntity().level().random.nextFloat() < FailProbability / 2.0f || horse.isTamed() && event.getEntity().level().random.nextFloat() < FailProbability || directSource.getItemInHand(InteractionHand.MAIN_HAND).is(ModTags.KNIVES) && event.getEntity().level().random.nextFloat() < FailProbability) && (zombieHorse = (ZombieHorse)EntityType.ZOMBIE_HORSE.create(mob.level())) != null) {
                            CommonEvent.transferAttributes(horse, zombieHorse);
                            mob.level().playSound(null, mob.getX(), mob.getY(), mob.getZ(), SoundEvents.ZOMBIE_VILLAGER_CONVERTED, SoundSource.PLAYERS, 1.0f, 1.0f);
                            zombieHorse.moveTo(mob.getX(), mob.getY(), mob.getZ(), mob.getYRot(), mob.getXRot());
                            mob.level().addFreshEntity((Entity)zombieHorse);
                            zombieHorse.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200, 0));
                            mob.setInvisible(true);
                            return;
                        }
                    }
                    mob.addTag("prevent_drops");
                    if (mob instanceof Spider && event.getEntity().level().random.nextFloat() < FailProbability && (caveSpider = (CaveSpider)EntityType.CAVE_SPIDER.create(mob.level())) != null) {
                        mob.level().playSound(null, mob.getX(), mob.getY(), mob.getZ(), SoundEvents.ZOMBIE_VILLAGER_CONVERTED, SoundSource.PLAYERS, 1.0f, 1.0f);
                        caveSpider.moveTo(mob.getX(), mob.getY(), mob.getZ(), mob.getYRot(), mob.getXRot());
                        mob.level().addFreshEntity((Entity)caveSpider);
                        caveSpider.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200, 0));
                        mob.setInvisible(true);
                        return;
                    }
                    if ((mob instanceof Frog || mob instanceof Bat) && (event.getEntity().level().random.nextFloat() < FailProbability / 2.0f || mob.level().getBiome(mob.blockPosition()).is(Biomes.SWAMP) && event.getEntity().level().random.nextFloat() < 0.3f || directSource.getItemInHand(InteractionHand.MAIN_HAND).is(ModTags.KNIVES) && event.getEntity().level().random.nextFloat() < 0.3f) && (witch = (Witch)EntityType.WITCH.create(mob.level())) != null) {
                        mob.level().playSound(null, mob.getX(), mob.getY(), mob.getZ(), SoundEvents.EVOKER_PREPARE_SUMMON, SoundSource.PLAYERS, 0.5f, 1.0f);
                        mob.level().playSound(null, mob.getX(), mob.getY(), mob.getZ(), SoundEvents.WITCH_CELEBRATE, SoundSource.PLAYERS, 1.0f, 1.0f);
                        witch.moveTo(mob.getX(), mob.getY(), mob.getZ(), mob.getYRot(), mob.getXRot());
                        mob.level().addFreshEntity((Entity)witch);
                        witch.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200, 0));
                        mob.setInvisible(true);
                        return;
                    }
                    if (mob instanceof Allay && (vex = (Vex)EntityType.VEX.create(mob.level())) != null) {
                        mob.level().playSound(null, mob.getX(), mob.getY(), mob.getZ(), SoundEvents.EVOKER_PREPARE_SUMMON, SoundSource.PLAYERS, 1.0f, 1.0f);
                        vex.moveTo(mob.getX(), mob.getY(), mob.getZ(), mob.getYRot(), mob.getXRot());
                        mob.level().addFreshEntity((Entity)vex);
                        vex.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200, 0));
                        mob.setInvisible(true);
                        return;
                    }
                    if (mob instanceof Villager) {
                        Villager villager = (Villager)mob;
                        mob.level().playSound(null, mob.getX(), mob.getY(), mob.getZ(), SoundEvents.ZOMBIE_VILLAGER_CONVERTED, SoundSource.PLAYERS, 1.0f, 1.0f);
                        EquipmentSlot[] zombieVillager = (EquipmentSlot[])EntityType.ZOMBIE_VILLAGER.create(mob.level());
                        if (zombieVillager != null) {
                            if (mob.isBaby()) {
                                zombieVillager.setBaby(true);
                            }
                            zombieVillager.setCanPickUpLoot(true);
                            zombieVillager.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200, 0));
                            zombieVillager.setVillagerData(villager.getVillagerData());
                            zombieVillager.moveTo(mob.getX(), mob.getY(), mob.getZ(), mob.getYRot(), mob.getXRot());
                            mob.level().addFreshEntity((Entity)zombieVillager);
                            mob.setInvisible(true);
                            return;
                        }
                    }
                    if (mob instanceof AbstractPiglin) {
                        mob.level().playSound(null, mob.getX(), mob.getY(), mob.getZ(), SoundEvents.PIGLIN_BRUTE_CONVERTED_TO_ZOMBIFIED, SoundSource.PLAYERS, 1.0f, 1.0f);
                        ZombifiedPiglin zombifiedPiglin = (ZombifiedPiglin)EntityType.ZOMBIFIED_PIGLIN.create(mob.level());
                        if (zombifiedPiglin != null) {
                            if (mob.isBaby()) {
                                zombifiedPiglin.setBaby(true);
                            }
                            for (EquipmentSlot slot : EquipmentSlot.values()) {
                                zombifiedPiglin.setItemSlot(slot, mob.getItemBySlot(slot));
                                mob.setItemSlot(slot, ItemStack.EMPTY);
                            }
                            zombifiedPiglin.setCanPickUpLoot(true);
                            zombifiedPiglin.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200, 0));
                            zombifiedPiglin.moveTo(mob.getX(), mob.getY(), mob.getZ(), mob.getYRot(), mob.getXRot());
                            mob.level().addFreshEntity((Entity)zombifiedPiglin);
                            mob.setInvisible(true);
                            return;
                        }
                    }
                    if (mob instanceof HoglinBase) {
                        mob.level().playSound(null, mob.getX(), mob.getY(), mob.getZ(), SoundEvents.HOGLIN_CONVERTED_TO_ZOMBIFIED, SoundSource.PLAYERS, 1.0f, 1.0f);
                        Zoglin zoglin = (Zoglin)EntityType.ZOGLIN.create(mob.level());
                        if (zoglin != null) {
                            if (mob.isBaby()) {
                                zoglin.setBaby(true);
                            }
                            zoglin.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200, 0));
                            zoglin.moveTo(mob.getX(), mob.getY(), mob.getZ(), mob.getYRot(), mob.getXRot());
                            mob.level().addFreshEntity((Entity)zoglin);
                            mob.setInvisible(true);
                            return;
                        }
                    }
                    List nearbyMobs = mob.level().getEntitiesOfClass(Mob.class, mob.getBoundingBox().inflate(10.0));
                    for (Mob nearbyMob : nearbyMobs) {
                        if (nearbyMob.getType() != mob.getType()) continue;
                        mob.level().playSound(null, mob.getX(), mob.getY(), mob.getZ(), (Holder)SoundEvents.SOUL_ESCAPE, SoundSource.PLAYERS, 0.5f, 1.0f);
                        mob.setInvisible(false);
                        DamageSource damageSource = event.getSource();
                        nearbyMob.hurt(damageSource, 0.0f);
                    }
                    return;
                }
                PiglinBrute Hunter = (PiglinBrute)EntityType.PIGLIN_BRUTE.create(mob.level());
                if (Hunter != null) {
                    Mob mobCopy = (Mob)mob.getType().create(mob.level());
                    if (mobCopy != null) {
                        mobCopy.load(mobNBT);
                        for (EquipmentSlot slot : EquipmentSlot.values()) {
                            mobCopy.setItemSlot(slot, mob.getItemBySlot(slot));
                            mob.setItemSlot(slot, ItemStack.EMPTY);
                        }
                        Hunter.setCustomName((Component)Component.literal((String)"\u00a7kHunter"));
                        mob.addTag("prevent_drops");
                        mobCopy.moveTo(mob.getX(), mob.getY(), mob.getZ(), mob.getYRot(), mob.getXRot());
                        mobCopy.setHealth(1.0f);
                        ItemStack knife = new ItemStack((ItemLike)ModItems.FLINT_KNIFE.get());
                        ItemStack playerItem = directSource.getItemInHand(InteractionHand.MAIN_HAND);
                        EnchantmentHelper.setEnchantments((ItemStack)knife, (ItemEnchantments)playerItem.getTagEnchantments());
                        EnchantmentHelper.updateEnchantments((ItemStack)knife, enchantments -> enchantments.removeIf(enchantmentHolder -> enchantmentHolder.is(MNDTags.POACHING_ENCHANTMENT)));
                        if (mob.isBaby()) {
                            mobCopy.setBaby(false);
                        } else {
                            Hunter.setItemInHand(InteractionHand.MAIN_HAND, knife);
                        }
                        Hunter.doHurtTarget((Entity)mobCopy);
                        mob.die(null);
                    }
                    Hunter.remove(Entity.RemovalReason.DISCARDED);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onMobDrop(LivingDropsEvent event) {
        Mob mob;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Mob && (mob = (Mob)livingEntity).getTags().contains("prevent_drops")) {
            event.getDrops().clear();
        }
    }

    private static void transferAttributes(Horse horse, ZombieHorse zombieHorse) {
        AttributeInstance horseMaxHealth = horse.getAttribute(Attributes.MAX_HEALTH);
        AttributeInstance zombieHorseMaxHealth = zombieHorse.getAttribute(Attributes.MAX_HEALTH);
        if (horseMaxHealth != null && zombieHorseMaxHealth != null) {
            zombieHorseMaxHealth.setBaseValue(horseMaxHealth.getBaseValue());
        }
        zombieHorse.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(horse.getAttribute(Attributes.MOVEMENT_SPEED).getBaseValue());
        zombieHorse.getAttribute(Attributes.JUMP_STRENGTH).setBaseValue(horse.getAttribute(Attributes.JUMP_STRENGTH).getBaseValue());
    }
}

