/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.item;

import java.util.ArrayList;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.EffectCures;
import vectorwing.farmersdelight.common.item.DrinkableItem;
import vectorwing.farmersdelight.common.registry.ModEffects;

public class StriderEggItem
extends DrinkableItem {
    public StriderEggItem(Item.Properties properties) {
        super(properties, false, true);
    }

    public void affectConsumer(ItemStack stack, Level level, LivingEntity consumer) {
        ArrayList<MobEffectInstance> harmfulEffects = new ArrayList<MobEffectInstance>();
        for (MobEffectInstance effectInstance : consumer.getActiveEffects()) {
            if (!((MobEffect)effectInstance.getEffect().value()).getCategory().equals((Object)MobEffectCategory.HARMFUL) || !effectInstance.getCures().contains(EffectCures.MILK)) continue;
            harmfulEffects.add(effectInstance);
        }
        if (!harmfulEffects.isEmpty()) {
            MobEffectInstance selectedEffect = (MobEffectInstance)harmfulEffects.get(level.random.nextInt(harmfulEffects.size()));
            int remainingDuration = selectedEffect.getDuration();
            int nourishDuration = remainingDuration / 2;
            if (nourishDuration > 0) {
                consumer.addEffect(new MobEffectInstance(ModEffects.NOURISHMENT, nourishDuration, 0));
                level.playSound(null, consumer.blockPosition(), SoundEvents.CHISELED_BOOKSHELF_INSERT_ENCHANTED, consumer.getSoundSource(), 1.0f, 1.0f);
            }
            consumer.removeEffect(selectedEffect.getEffect());
        }
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 45;
    }

    public SoundEvent getDrinkingSound() {
        return SoundEvents.HONEY_DRINK;
    }
}

