/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.connected.behavior;

import net.joefoxe.hexerei.block.connected.BlockConnectivity;
import net.joefoxe.hexerei.block.connected.CTDyable;
import net.joefoxe.hexerei.block.connected.CTSpriteShiftEntry;
import net.joefoxe.hexerei.block.connected.ConnectedTextureBehaviour;
import net.joefoxe.hexerei.util.ClientProxy;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class DyedFullBlockCTBehaviour
extends ConnectedTextureBehaviour.Base {
    private CTSpriteShiftEntry shift;

    public DyedFullBlockCTBehaviour(CTSpriteShiftEntry shift) {
        this.shift = shift;
    }

    @Override
    public boolean connectsTo(BlockState state, BlockState other, BlockAndTintGetter reader, BlockPos pos, BlockPos otherPos, Direction face) {
        if (this.isBeingBlocked(state, reader, pos, otherPos, face)) {
            return false;
        }
        Block block = state.getBlock();
        if (block instanceof CTDyable) {
            CTDyable waxedLayeredBlockDyed = (CTDyable)block;
            block = other.getBlock();
            if (block instanceof CTDyable) {
                CTDyable otherLayeredBlockDyed = (CTDyable)block;
                if (!waxedLayeredBlockDyed.getDyeColor(state).equals((Object)otherLayeredBlockDyed.getDyeColor(other))) {
                    return false;
                }
            }
        }
        BlockConnectivity cc = ClientProxy.BLOCK_CONNECTIVITY;
        BlockConnectivity.Entry entry = cc.get(state);
        BlockConnectivity.Entry otherEntry = cc.get(other);
        if (state.getBlock() != other.getBlock()) {
            return false;
        }
        if (entry == null || otherEntry == null) {
            return false;
        }
        if (!entry.isSideValid(state, face) || !otherEntry.isSideValid(other, face)) {
            return false;
        }
        return entry.getCTSpriteShiftEntry() == otherEntry.getCTSpriteShiftEntry();
    }

    @Override
    public CTSpriteShiftEntry getShift(BlockState state, Direction direction, @Nullable TextureAtlasSprite sprite) {
        return this.shift;
    }
}

