/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.connected.behavior;

import net.joefoxe.hexerei.block.connected.BlockConnectivity;
import net.joefoxe.hexerei.block.connected.CTSpriteShiftEntry;
import net.joefoxe.hexerei.block.connected.ConnectedTextureBehaviour;
import net.joefoxe.hexerei.util.ClientProxy;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class TrapdoorCTBehaviour
extends ConnectedTextureBehaviour.Base {
    private CTSpriteShiftEntry shift;

    public TrapdoorCTBehaviour(CTSpriteShiftEntry shift) {
        this.shift = shift;
    }

    @Override
    public boolean connectsTo(BlockState state, BlockState other, BlockAndTintGetter reader, BlockPos pos, BlockPos otherPos, Direction face) {
        double angleRadians;
        float angleDegrees;
        BlockPos offset;
        Direction facing;
        if (state.hasProperty((Property)HorizontalDirectionalBlock.FACING) && state.hasProperty((Property)TrapDoorBlock.OPEN) && !((Boolean)state.getValue((Property)TrapDoorBlock.OPEN)).booleanValue()) {
            facing = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
            offset = otherPos.subtract((Vec3i)pos);
            angleDegrees = facing.toYRot() - 180.0f;
            angleRadians = Math.toRadians(angleDegrees);
            otherPos = pos.offset((Vec3i)this.rotateOffset(offset, angleRadians));
            other = reader.getBlockState(otherPos);
        }
        facing = Direction.NORTH;
        if (state.hasProperty((Property)HorizontalDirectionalBlock.FACING)) {
            facing = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
            offset = otherPos.subtract((Vec3i)pos);
            if (state.hasProperty((Property)TrapDoorBlock.OPEN)) {
                if (((Boolean)state.getValue((Property)TrapDoorBlock.OPEN)).booleanValue()) {
                    if (state.hasProperty((Property)TrapDoorBlock.HALF) && state.getValue((Property)TrapDoorBlock.HALF) == Half.TOP) {
                        angleDegrees = facing.toYRot() - 180.0f;
                        angleRadians = Math.toRadians(angleDegrees);
                        offset = this.rotateXAxisOffset(this.rotateOffset(offset, angleRadians), angleRadians);
                        if (facing == Direction.SOUTH && (face == Direction.NORTH || face == Direction.SOUTH)) {
                            offset = new BlockPos(-offset.getX(), offset.getY(), offset.getZ());
                        }
                        if (facing == Direction.EAST && (face == Direction.UP || face == Direction.DOWN)) {
                            offset = this.rotateOffset(offset, Math.toRadians(90.0));
                            offset = new BlockPos(offset.getX(), offset.getY(), -offset.getZ());
                        }
                        if (facing == Direction.NORTH) {
                            offset = new BlockPos(-offset.getX(), offset.getY(), offset.getZ());
                        }
                        if (facing == Direction.WEST && (face == Direction.UP || face == Direction.DOWN)) {
                            offset = this.rotateOffset(offset, Math.toRadians(270.0));
                            offset = new BlockPos(offset.getX(), offset.getY(), -offset.getZ());
                        }
                    } else {
                        if (facing == Direction.SOUTH && (face == Direction.UP || face == Direction.DOWN)) {
                            offset = new BlockPos(-offset.getX(), offset.getY(), offset.getZ());
                        }
                        if (facing == Direction.EAST && (face == Direction.UP || face == Direction.DOWN)) {
                            offset = this.rotateOffset(offset, Math.toRadians(90.0));
                        }
                        if (facing == Direction.WEST && (face == Direction.UP || face == Direction.DOWN)) {
                            offset = this.rotateOffset(offset, Math.toRadians(270.0));
                        }
                    }
                } else {
                    if (facing == Direction.SOUTH) {
                        if (face == Direction.NORTH || face == Direction.SOUTH) {
                            offset = new BlockPos(-offset.getX(), offset.getY(), offset.getZ());
                        }
                        if (face == Direction.WEST || face == Direction.EAST) {
                            offset = new BlockPos(offset.getX(), offset.getY(), -offset.getZ());
                        }
                    }
                    if (facing == Direction.EAST) {
                        if (face == Direction.NORTH || face == Direction.SOUTH) {
                            offset = this.rotateOffset(offset, Math.toRadians(90.0));
                            offset = new BlockPos(-offset.getX(), offset.getY(), offset.getZ());
                        }
                        if (face == Direction.WEST || face == Direction.EAST) {
                            offset = this.rotateOffset(offset, Math.toRadians(90.0));
                            offset = new BlockPos(offset.getX(), offset.getY(), -offset.getZ());
                        }
                    }
                    if (facing == Direction.WEST) {
                        if (face == Direction.NORTH || face == Direction.SOUTH) {
                            offset = this.rotateOffset(offset, Math.toRadians(-90.0));
                            offset = new BlockPos(-offset.getX(), offset.getY(), offset.getZ());
                        }
                        if (face == Direction.WEST || face == Direction.EAST) {
                            offset = this.rotateOffset(offset, Math.toRadians(-90.0));
                            offset = new BlockPos(offset.getX(), offset.getY(), -offset.getZ());
                        }
                    }
                }
                otherPos = pos.offset((Vec3i)offset);
                other = reader.getBlockState(otherPos);
            }
        }
        if (this.isBeingBlocked(state, reader, pos, otherPos, face)) {
            return false;
        }
        BlockConnectivity cc = ClientProxy.BLOCK_CONNECTIVITY;
        BlockConnectivity.Entry entry = cc.get(state);
        BlockConnectivity.Entry otherEntry = cc.get(other);
        if (!(state.hasProperty((Property)TrapDoorBlock.OPEN) && state.hasProperty((Property)TrapDoorBlock.HALF) && state.hasProperty((Property)HorizontalDirectionalBlock.FACING) && other.hasProperty((Property)TrapDoorBlock.OPEN) && other.hasProperty((Property)TrapDoorBlock.HALF) && other.hasProperty((Property)HorizontalDirectionalBlock.FACING))) {
            return false;
        }
        if (state.getValue((Property)TrapDoorBlock.OPEN) != other.getValue((Property)TrapDoorBlock.OPEN) || state.getValue((Property)TrapDoorBlock.HALF) != other.getValue((Property)TrapDoorBlock.HALF) || state.getValue((Property)HorizontalDirectionalBlock.FACING) != other.getValue((Property)HorizontalDirectionalBlock.FACING)) {
            return false;
        }
        if (((Boolean)state.getValue((Property)TrapDoorBlock.OPEN)).booleanValue()) {
            if ((facing == Direction.SOUTH || facing == Direction.NORTH) && pos.getZ() != otherPos.getZ()) {
                return false;
            }
            if ((facing == Direction.EAST || facing == Direction.WEST) && pos.getX() != otherPos.getX()) {
                return false;
            }
        }
        if (entry == null || otherEntry == null) {
            return false;
        }
        if (!entry.isSideValid(state, face) || !otherEntry.isSideValid(other, face)) {
            return false;
        }
        return entry.getCTSpriteShiftEntry() == otherEntry.getCTSpriteShiftEntry();
    }

    private BlockPos rotateOffset(BlockPos offset, double angleRadians) {
        int x = offset.getX();
        int z = offset.getZ();
        int newX = (int)Math.round((double)x * Math.cos(angleRadians) - (double)z * Math.sin(angleRadians));
        int newZ = (int)Math.round((double)x * Math.sin(angleRadians) + (double)z * Math.cos(angleRadians));
        return new BlockPos(newX, offset.getY(), newZ);
    }

    private BlockPos rotateXAxisOffset(BlockPos offset, double angleRadians) {
        int x = offset.getX();
        int y = offset.getY();
        int z = offset.getZ();
        int newY = -y;
        int newZ = -z;
        int globalX = (int)Math.round((double)x * Math.cos(angleRadians) - (double)newZ * Math.sin(angleRadians));
        int globalZ = (int)Math.round((double)x * Math.sin(angleRadians) + (double)newZ * Math.cos(angleRadians));
        return new BlockPos(globalX, newY, globalZ);
    }

    @Override
    public CTSpriteShiftEntry getShift(BlockState state, Direction direction, @Nullable TextureAtlasSprite sprite) {
        return this.shift;
    }
}

