/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.custom;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.ITileEntity;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.data.candle.CandleData;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.custom.CandleItem;
import net.joefoxe.hexerei.particle.ModParticleTypes;
import net.joefoxe.hexerei.tileentity.CandleTile;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.EventHooks;

public class Candle
extends AbstractCandleBlock
implements ITileEntity<CandleTile>,
EntityBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<Candle> CODEC = Candle.simpleCodec(Candle::new);
    public static final IntegerProperty CANDLES = IntegerProperty.create((String)"candles", (int)1, (int)4);
    public static final IntegerProperty CANDLES_LIT = IntegerProperty.create((String)"candles_lit", (int)0, (int)4);
    public static final IntegerProperty POWER = IntegerProperty.create((String)"power", (int)0, (int)15);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final int BASE_COLOR = 13419416;
    private static final Int2ObjectMap<List<Vec3>> PARTICLE_OFFSETS = (Int2ObjectMap)Util.make(() -> {
        Int2ObjectOpenHashMap int2objectmap = new Int2ObjectOpenHashMap();
        int2objectmap.defaultReturnValue((Object)ImmutableList.of());
        int2objectmap.put(1, (Object)ImmutableList.of((Object)new Vec3(0.5, 0.5, 0.5)));
        int2objectmap.put(2, (Object)ImmutableList.of((Object)new Vec3(0.375, 0.44, 0.5), (Object)new Vec3(0.625, 0.5, 0.44)));
        int2objectmap.put(3, (Object)ImmutableList.of((Object)new Vec3(0.5, 0.313, 0.625), (Object)new Vec3(0.375, 0.44, 0.5), (Object)new Vec3(0.56, 0.5, 0.44)));
        int2objectmap.put(4, (Object)ImmutableList.of((Object)new Vec3(0.44, 0.313, 0.56), (Object)new Vec3(0.625, 0.44, 0.56), (Object)new Vec3(0.375, 0.44, 0.375), (Object)new Vec3(0.56, 0.5, 0.375)));
        return Int2ObjectMaps.unmodifiable((Int2ObjectMap)int2objectmap);
    });
    public static final VoxelShape ONE_SHAPE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0);
    public static final VoxelShape TWO_SHAPE = Block.box((double)3.5, (double)0.0, (double)3.5, (double)12.5, (double)9.0, (double)12.5);
    public static final VoxelShape THREE_SHAPE = Block.box((double)3.5, (double)0.0, (double)3.5, (double)12.5, (double)9.0, (double)12.5);
    public static final VoxelShape FOUR_SHAPE = Block.box((double)3.5, (double)0.0, (double)3.5, (double)12.5, (double)9.0, (double)12.5);
    public static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new OptionalDispenseItemBehavior(){

        public ItemStack execute(BlockSource source, ItemStack stack) {
            this.setSuccess(false);
            Item item = stack.getItem();
            if (item instanceof BlockItem) {
                Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
                BlockPos blockpos = source.pos().relative(direction);
                try {
                    this.setSuccess(((BlockItem)item).place((BlockPlaceContext)new DirectionalPlaceContext((Level)source.level(), blockpos, direction, stack, direction)).consumesAction());
                }
                catch (Exception exception) {
                    LOGGER.error("Error trying to place candle at {}", (Object)blockpos, (Object)exception);
                }
                BlockEntity blockEntity = source.level().getBlockEntity(blockpos);
                BlockState blockState = source.level().getBlockState(blockpos);
                if (blockEntity instanceof CandleTile) {
                    CandleTile candleTile = (CandleTile)blockEntity;
                    source.level().scheduleTick(blockpos, blockState.getBlock(), 1);
                }
            }
            return stack;
        }

        protected void playSound(BlockSource source) {
            source.level().levelEvent(1000, source.pos(), 0);
        }
    };

    protected MapCodec<? extends AbstractCandleBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState iBlockState) {
        return RenderShape.MODEL;
    }

    public void animateTick(BlockState p_220697_, Level p_220698_, BlockPos p_220699_, RandomSource p_220700_) {
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)HorizontalDirectionalBlock.FACING)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos());
        if (blockstate.is((Block)ModBlocks.CANDLE.get())) {
            return (BlockState)blockstate.setValue((Property)CANDLES, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockstate.getValue((Property)CANDLES) + 1)));
        }
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean flag = fluidstate.getType() == Fluids.WATER;
        return (BlockState)((BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)CANDLES_LIT, (Comparable)Integer.valueOf(0));
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof CandleTile) {
            CandleTile candleTile = (CandleTile)blockEntity;
            int analog = candleTile.updateAnalog();
            pLevel.updateNeighborsAt(pPos, pState.getBlock());
        }
        super.tick(pState, pLevel, pPos, pRandom);
    }

    public static boolean isLit(BlockState p_151934_) {
        return p_151934_.hasProperty((Property)LIT) && (p_151934_.is(BlockTags.CANDLES) || p_151934_.is(BlockTags.CANDLE_CAKES)) && (Boolean)p_151934_.getValue((Property)LIT) != false;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return useContext.getItemInHand().getItem() == ModItems.CANDLE.get() && (Integer)state.getValue((Property)CANDLES) < 4 || super.canBeReplaced(state, useContext);
    }

    public void dropCandles(Level level, BlockPos pos) {
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof CandleTile) {
            CandleTile candleTile = (CandleTile)entity;
            if (!level.isClientSide()) {
                for (int i = 0; i < 4; ++i) {
                    CandleData candleData = (CandleData)candleTile.candles.get(i);
                    if (!candleData.hasCandle) continue;
                    ItemStack itemStack = new ItemStack((ItemLike)ModBlocks.CANDLE.get());
                    CompoundTag tag = ((CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                    candleData.save(tag, (HolderLookup.Provider)level.registryAccess(), true, false);
                    itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
                    if (candleData.dyeColor != 13419416) {
                        itemStack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(candleData.dyeColor, true));
                    }
                    Candle.popResource((Level)level, (BlockPos)pos, (ItemStack)itemStack);
                }
            }
        }
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack item = new ItemStack((ItemLike)ModItems.CANDLE.get());
        Optional<CandleTile> tileEntityOptional = Optional.ofNullable((CandleTile)this.getBlockEntity((BlockGetter)level, pos));
        tileEntityOptional.ifPresent(candleTile -> {
            CompoundTag tag = ((CustomData)item.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            CandleData candleData = (CandleData)candleTile.candles.get(0);
            candleData.save(tag, (HolderLookup.Provider)level.registryAccess(), true, false);
            item.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            if (candleData.dyeColor != 13419416) {
                item.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(candleData.dyeColor, true));
            }
        });
        return item;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity tileentity = level.getBlockEntity(pos);
            if (tileentity != null) {
                this.dropCandles(level, pos);
            }
            for (Direction direction : Direction.values()) {
                level.updateNeighborsAt(pos.relative(direction), (Block)this);
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.getValue((Property)CANDLES)) {
            default -> ONE_SHAPE;
            case 2 -> TWO_SHAPE;
            case 3 -> THREE_SHAPE;
            case 4 -> FOUR_SHAPE;
        };
    }

    public static VoxelShape getShape(BlockState state) {
        return switch ((Integer)state.getValue((Property)CANDLES)) {
            default -> ONE_SHAPE;
            case 2 -> TWO_SHAPE;
            case 3 -> THREE_SHAPE;
            case 4 -> FOUR_SHAPE;
        };
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemstack = player.getItemInHand(hand);
        Random random = new Random();
        if (itemstack.getItem() == Items.FLINT_AND_STEEL && Candle.canBeLit(state, pos, level)) {
            CandleTile tile = (CandleTile)level.getBlockEntity(pos);
            if (tile == null) {
                return ItemInteractionResult.FAIL;
            }
            if (!((CandleData)tile.candles.get((int)0)).lit) {
                ((CandleData)tile.candles.get((int)0)).lit = true;
            } else if (!((CandleData)tile.candles.get((int)1)).lit) {
                ((CandleData)tile.candles.get((int)1)).lit = true;
            } else if (!((CandleData)tile.candles.get((int)2)).lit) {
                ((CandleData)tile.candles.get((int)2)).lit = true;
            } else if (!((CandleData)tile.candles.get((int)3)).lit) {
                ((CandleData)tile.candles.get((int)3)).lit = true;
            } else {
                return ItemInteractionResult.FAIL;
            }
            level.playSound(null, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, random.nextFloat() * 0.4f + 1.0f);
            itemstack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (itemstack.getItem() == Items.FIRE_CHARGE && Candle.canBeLit(state, pos, level)) {
            CandleTile tile = (CandleTile)level.getBlockEntity(pos);
            if (tile == null) {
                return ItemInteractionResult.FAIL;
            }
            if (!((CandleData)tile.candles.get((int)0)).hasCandle) {
                ((CandleData)tile.candles.get((int)0)).lit = true;
            }
            if (!((CandleData)tile.candles.get((int)1)).hasCandle) {
                ((CandleData)tile.candles.get((int)1)).lit = true;
            }
            if (!((CandleData)tile.candles.get((int)2)).hasCandle) {
                ((CandleData)tile.candles.get((int)2)).lit = true;
            }
            if (!((CandleData)tile.candles.get((int)3)).hasCandle) {
                ((CandleData)tile.candles.get((int)3)).lit = true;
            }
            level.playSound(null, pos, SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 1.0f, random.nextFloat() * 0.4f + 1.0f);
            itemstack.shrink(1);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public Candle(BlockBehaviour.Properties properties) {
        super(properties.noCollission());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWER, (Comparable)Integer.valueOf(0))).setValue((Property)CANDLES_LIT, (Comparable)Integer.valueOf(0))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected Iterable<Vec3> getParticleOffsets(BlockState blockState) {
        return (Iterable)PARTICLE_OFFSETS.get(((Integer)blockState.getValue((Property)CANDLES)).intValue());
    }

    public static void spawnSmokeParticles(Level level, BlockPos pos, boolean spawnExtraSmoke) {
        RandomSource random = level.getRandom();
        SimpleParticleType basicparticletype = (SimpleParticleType)ModParticleTypes.EXTINGUISH.get();
        Vec3 offset = new Vec3(random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1));
        level.addParticle((ParticleOptions)basicparticletype, true, (double)pos.getX() + 0.5 + offset.x, (double)pos.getY() + random.nextDouble() * (double)0.15f, (double)pos.getZ() + 0.5 + offset.z, offset.x / 8.0, random.nextDouble() * 0.1 + 0.1, offset.z / 8.0);
        if (spawnExtraSmoke) {
            level.addParticle((ParticleOptions)basicparticletype, true, (double)pos.getX() + 0.5 + offset.x, (double)pos.getY() + random.nextDouble() * (double)0.15f, (double)pos.getZ() + 0.5 + offset.z, offset.x / 8.0, random.nextDouble() * 0.1 + 0.1, offset.z / 8.0);
        }
    }

    public static void spawnParticleWave(Level level, BlockPos pos, boolean spawnExtraSmoke, List<String> particle, int amount) {
        RandomSource random = level.getRandom();
        for (int i = 0; i < amount; ++i) {
            float rotation = random.nextFloat() * 30.0f + 360.0f / (float)amount * (float)i;
            float ran = (float)random.nextDouble() * 0.15f + 0.15f;
            Vec3 offset = new Vec3((double)ran * Math.cos(rotation), 0.0, (double)ran * Math.sin(rotation));
            if (particle.isEmpty()) continue;
            try {
                ParticleOptions options = ParticleArgument.readParticle((StringReader)new StringReader(particle.get(random.nextInt(particle.size()))), (HolderLookup.Provider)level.registryAccess());
                level.addParticle(options, true, (double)pos.getX() + 0.5 + offset.x, (double)pos.getY() + random.nextDouble() * (double)0.15f, (double)pos.getZ() + 0.5 + offset.z, offset.x / 8.0, random.nextDouble() * 0.025, offset.z / 8.0);
                if (!spawnExtraSmoke) continue;
                level.addParticle(options, true, (double)pos.getX() + 0.5 + offset.x, (double)pos.getY() + random.nextDouble() * (double)0.15f, (double)pos.getZ() + 0.5 + offset.z, offset.x / 8.0, random.nextDouble() * 0.025, offset.z / 8.0);
                continue;
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
    }

    public static void extinguish(LevelAccessor level, BlockPos pos, BlockState state, CandleTile tile) {
        int i;
        int numLit = 0;
        for (i = 0; i < 4; ++i) {
            if (!((CandleData)tile.candles.get((int)i)).lit) continue;
            ++numLit;
        }
        ((CandleData)tile.candles.get((int)0)).lit = false;
        ((CandleData)tile.candles.get((int)1)).lit = false;
        ((CandleData)tile.candles.get((int)2)).lit = false;
        ((CandleData)tile.candles.get((int)3)).lit = false;
        if (!level.isClientSide()) {
            level.playSound(null, pos, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (level.isClientSide()) {
            for (i = 0; i < 10 * numLit; ++i) {
                Candle.spawnSmokeParticles((Level)level, pos, true);
            }
        }
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && fluidStateIn.getType() == Fluids.WATER) {
            boolean flag;
            CandleTile tile = (CandleTile)level.getBlockEntity(pos);
            boolean bl = flag = ((CandleData)tile.candles.get((int)0)).lit || ((CandleData)tile.candles.get((int)1)).lit || ((CandleData)tile.candles.get((int)2)).lit || ((CandleData)tile.candles.get((int)3)).lit;
            if (flag) {
                Candle.extinguish(level, pos, state, tile);
            }
            level.setBlock(pos, (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.TRUE), 3);
            level.scheduleTick(pos, fluidStateIn.getType(), fluidStateIn.getType().getTickDelay((LevelReader)level));
            return true;
        }
        return false;
    }

    public void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (projectile.isOnFire()) {
            boolean flag;
            CandleTile tile = (CandleTile)level.getBlockEntity(hit.getBlockPos());
            boolean flagLit = ((CandleData)tile.candles.get((int)0)).lit && ((CandleData)tile.candles.get((int)1)).lit && ((CandleData)tile.candles.get((int)2)).lit && ((CandleData)tile.candles.get((int)3)).lit;
            Entity entity = projectile.getOwner();
            boolean bl = flag = entity == null || entity instanceof Player || EventHooks.canEntityGrief((Level)level, (Entity)entity);
            if (flag && !flagLit && !((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
                if (((CandleData)tile.candles.get((int)0)).hasCandle) {
                    ((CandleData)tile.candles.get((int)0)).lit = true;
                }
                if (((CandleData)tile.candles.get((int)1)).hasCandle) {
                    ((CandleData)tile.candles.get((int)1)).lit = true;
                }
                if (((CandleData)tile.candles.get((int)2)).hasCandle) {
                    ((CandleData)tile.candles.get((int)2)).lit = true;
                }
                if (((CandleData)tile.candles.get((int)3)).hasCandle) {
                    ((CandleData)tile.candles.get((int)3)).lit = true;
                }
            }
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (stack == null) {
            return;
        }
        this.withTileEntityDo((BlockGetter)level, pos, te -> {
            int i;
            int newCandlePos = 0;
            for (i = 0; i < 4; ++i) {
                Item patt0$temp;
                if (((CandleData)te.candles.get((int)i)).hasCandle || !((patt0$temp = stack.getItem()) instanceof CandleItem)) continue;
                CandleItem candleItem = (CandleItem)patt0$temp;
                CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                ((CandleData)te.candles.get(i)).load(tag, (HolderLookup.Provider)level.registryAccess(), true);
                if (stack.has(DataComponents.DYED_COLOR)) {
                    ((CandleData)te.candles.get((int)0)).dyeColor = ((DyedItemColor)stack.get(DataComponents.DYED_COLOR)).rgb();
                }
                te.setOffsetPos(true);
                newCandlePos = i;
                break;
            }
            for (i = 0; i < 4; ++i) {
                if (!((CandleData)te.candles.get((int)i)).returnToBlock && i != newCandlePos) continue;
                te.setOffsetPos(i);
                ((CandleData)te.candles.get(i)).moveInstantlyToTarget();
            }
            te.sync();
        });
        for (Direction direction : Direction.values()) {
            level.updateNeighborsAt(pos.relative(direction), (Block)this);
        }
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        AtomicInteger toReturn = new AtomicInteger();
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof CandleTile) {
            CandleTile candleTile = (CandleTile)blockEntity;
            candleTile.updateAnalog();
            return candleTile.redstoneAnalogSignal;
        }
        return toReturn.get();
    }

    public int getDirectSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return (Integer)pBlockState.getValue((Property)POWER);
    }

    public boolean isSignalSource(BlockState pState) {
        return (Integer)pState.getValue((Property)POWER) > 0;
    }

    public int getSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return (Integer)pBlockState.getValue((Property)POWER);
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        for (Direction direction : Direction.values()) {
            pLevel.updateNeighborsAt(pPos.relative(direction), (Block)this);
        }
        super.onPlace(pState, pLevel, pPos, pOldState, pIsMoving);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HorizontalDirectionalBlock.FACING, CANDLES, WATERLOGGED, POWER, CANDLES_LIT, LIT});
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entityIn) {
        BlockEntity tileentity = level.getBlockEntity(pos);
        if (tileentity instanceof CandleTile) {
            CandleTile tile = (CandleTile)tileentity;
            tile.entityInside(entityIn);
        }
    }

    public static boolean canBeLit(BlockState state, BlockPos pos, Level world) {
        BlockEntity entity = world.getBlockEntity(pos);
        if (entity instanceof CandleTile) {
            CandleTile tile = (CandleTile)entity;
            return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) == false && (!((CandleData)tile.candles.get((int)0)).lit || !((CandleData)tile.candles.get((int)1)).lit && ((CandleData)tile.candles.get((int)1)).hasCandle || !((CandleData)tile.candles.get((int)2)).lit && ((CandleData)tile.candles.get((int)2)).hasCandle || !((CandleData)tile.candles.get((int)3)).lit && ((CandleData)tile.candles.get((int)3)).hasCandle);
        }
        return false;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        return !state.canSurvive((LevelReader)world, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, world, pos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return Candle.canSupportCenter((LevelReader)level, (BlockPos)pos.below(), (Direction)Direction.UP);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.candle_shift_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.candle_shift_2").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.candle_shift_3").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            String str = CandleItem.getEffectLocation(stack);
            if (str != null && str.length() > 0 && !str.equals("hexerei:no_effect")) {
                String translateEffect = "effect." + ResourceLocation.parse((String)str).getNamespace() + "." + ResourceLocation.parse((String)str).getPath();
                MutableComponent component = Component.translatable((String)translateEffect).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999)));
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.candle_effect", (Object[])new Object[]{component}));
            }
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    @Override
    public Class<CandleTile> getTileEntityClass() {
        return CandleTile.class;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CandleTile((BlockEntityType)ModTileEntities.CANDLE_TILE.get(), pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> entityType) {
        return entityType == ModTileEntities.CANDLE_TILE.get() ? (world2, pos, state2, entity) -> ((CandleTile)entity).tick() : null;
    }
}

