/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.custom;

import net.joefoxe.hexerei.block.ITileEntity;
import net.joefoxe.hexerei.tileentity.CuttingCrystalTile;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CuttingCrystal
extends Block
implements ITileEntity<CuttingCrystalTile>,
EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)5.0, (double)14.0, (double)16.0, (double)11.0);
    public static final VoxelShape SHAPE_TURNED = Block.box((double)5.0, (double)0.0, (double)2.0, (double)11.0, (double)16.0, (double)14.0);

    public RenderShape getRenderShape(BlockState p_60550_) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    private boolean posEquals(BlockPos pos, BlockPos pos2) {
        return pos.getX() == pos2.getX() && pos.getY() == pos2.getY() && pos.getZ() == pos2.getZ();
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockentity;
        if (!pState.is(pNewState.getBlock()) && (blockentity = pLevel.getBlockEntity(pPos)) instanceof CuttingCrystalTile) {
            CuttingCrystalTile cuttingCrystalTile = (CuttingCrystalTile)blockentity;
            if (!cuttingCrystalTile.boundPos.isEmpty()) {
                cuttingCrystalTile.boundPos.remove(pPos);
            }
            for (BlockPos pos : cuttingCrystalTile.boundPos) {
                BlockEntity blockEntity = pLevel.getBlockEntity(pos);
                if (!(blockEntity instanceof CuttingCrystalTile)) continue;
                CuttingCrystalTile cuttingCrystalTile1 = (CuttingCrystalTile)blockEntity;
                cuttingCrystalTile1.boundPos = cuttingCrystalTile.boundPos;
            }
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        this.withTileEntityDo((BlockGetter)pLevel, pPos, te -> {});
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
    }

    public VoxelShape getShape(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        if (p_220053_1_.getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.EAST || p_220053_1_.getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.WEST) {
            return SHAPE_TURNED;
        }
        return SHAPE;
    }

    public CuttingCrystal(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion());
        this.withPropertiesOf((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HorizontalDirectionalBlock.FACING, WATERLOGGED, LIT});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Override
    public Class<CuttingCrystalTile> getTileEntityClass() {
        return CuttingCrystalTile.class;
    }

    @javax.annotation.Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CuttingCrystalTile((BlockEntityType)ModTileEntities.CUTTING_CRYSTAL_TILE.get(), pos, state);
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> entityType) {
        return entityType == ModTileEntities.CUTTING_CRYSTAL_TILE.get() ? (world2, pos, state2, entity) -> ((CuttingCrystalTile)entity).tick() : null;
    }
}

