/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.joefoxe.hexerei.block.custom.PickableDoublePlant;
import net.joefoxe.hexerei.event.ClientEvents;
import net.joefoxe.hexerei.events.CrowWhitelistEvent;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class CrowWhitelistRenderer
implements LayeredDraw.Layer {
    private static final ResourceLocation GUI = HexereiUtil.getResource("textures/gui/crow_gui.png");

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        PoseStack poseStack = guiGraphics.pose();
        if (CrowWhitelistEvent.whiteListingCrow != null) {
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI);
            guiGraphics.blit(GUI, screenWidth / 2 - 9, screenHeight - 42, 238.0f, 178.0f, 18, 18, 256, 256);
            InventoryScreen.renderEntityInInventoryFollowsAngle((GuiGraphics)guiGraphics, (int)(screenWidth / 2 - 16), (int)(screenHeight - 94), (int)(screenWidth / 2 + 16), (int)(screenHeight - 62), (int)40, (float)0.0625f, (float)((float)Math.toRadians(-50.0)), (float)((float)Math.toRadians(10.0)), (LivingEntity)CrowWhitelistEvent.whiteListingCrow);
            if (!CrowWhitelistEvent.whiteListingCrow.harvestWhitelist.isEmpty()) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                poseStack.pushPose();
                poseStack.translate((float)screenWidth / 2.0f - 14.0f - (float)(CrowWhitelistEvent.whiteListingCrow.harvestWhitelist.size() - 1) / 2.0f * 21.0f, (float)(screenHeight - 40), 100.0f);
                poseStack.translate(8.0f, -8.0f, 0.0f);
                poseStack.scale(12.0f, 12.0f, 12.0f);
                poseStack.mulPose(new Matrix4f().scale(1.0f, -1.0f, 1.0f));
                Vec3 rotationOffset = new Vec3(0.5, 0.0, 0.5);
                MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
                Lighting.setupFor3DItems();
                poseStack.last().normal().rotate((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
                for (int itor = 0; itor < CrowWhitelistEvent.whiteListingCrow.harvestWhitelist.size(); ++itor) {
                    poseStack.pushPose();
                    poseStack.translate((double)((float)itor * 1.7f), Math.sin((ClientEvents.getClientTicks() + (float)(itor * 30)) / 30.0f) / 4.0, 0.0);
                    float zRot = 0.0f;
                    float xRot = 20.0f;
                    float yRot = 30.0f + ClientEvents.getClientTicks() + (float)(itor * 30);
                    poseStack.translate(rotationOffset.x, rotationOffset.y, rotationOffset.z);
                    poseStack.mulPose(Axis.ZP.rotationDegrees(zRot));
                    poseStack.mulPose(Axis.XP.rotationDegrees(xRot));
                    poseStack.mulPose(Axis.YP.rotationDegrees(yRot));
                    poseStack.translate(-rotationOffset.x, -rotationOffset.y, -rotationOffset.z);
                    BlockState state = CrowWhitelistEvent.whiteListingCrow.harvestWhitelist.get(itor).defaultBlockState();
                    if (state.hasProperty((Property)BlockStateProperties.AGE_1)) {
                        state = (BlockState)state.setValue((Property)BlockStateProperties.AGE_1, (Comparable)Integer.valueOf(Mth.clamp((int)((int)((Math.sin((ClientEvents.getClientTicks() + (float)(itor * 30)) / 30.0f) + 1.0) / 2.0 * 2.0)), (int)0, (int)1)));
                    } else if (state.hasProperty((Property)BlockStateProperties.AGE_2)) {
                        state = (BlockState)state.setValue((Property)BlockStateProperties.AGE_2, (Comparable)Integer.valueOf(Mth.clamp((int)((int)((Math.sin((ClientEvents.getClientTicks() + (float)(itor * 30)) / 30.0f) + 1.0) / 2.0 * 3.0)), (int)0, (int)2)));
                    } else if (state.hasProperty((Property)BlockStateProperties.AGE_3)) {
                        state = (BlockState)state.setValue((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(Mth.clamp((int)((int)((Math.sin((ClientEvents.getClientTicks() + (float)(itor * 30)) / 30.0f) + 1.0) / 2.0 * 4.0)), (int)0, (int)3)));
                    } else if (state.hasProperty((Property)BlockStateProperties.AGE_4)) {
                        state = (BlockState)state.setValue((Property)BlockStateProperties.AGE_4, (Comparable)Integer.valueOf(Mth.clamp((int)((int)((Math.sin((ClientEvents.getClientTicks() + (float)(itor * 30)) / 30.0f) + 1.0) / 2.0 * 5.0)), (int)0, (int)4)));
                    } else if (state.hasProperty((Property)BlockStateProperties.AGE_5)) {
                        state = (BlockState)state.setValue((Property)BlockStateProperties.AGE_5, (Comparable)Integer.valueOf(Mth.clamp((int)((int)((Math.sin((ClientEvents.getClientTicks() + (float)(itor * 30)) / 30.0f) + 1.0) / 2.0 * 6.0)), (int)0, (int)5)));
                    } else if (state.hasProperty((Property)BlockStateProperties.AGE_7)) {
                        state = (BlockState)state.setValue((Property)BlockStateProperties.AGE_7, (Comparable)Integer.valueOf(Mth.clamp((int)((int)((Math.sin((ClientEvents.getClientTicks() + (float)(itor * 30)) / 30.0f) + 1.0) / 2.0 * 8.0)), (int)0, (int)7)));
                    }
                    if (state.hasProperty((Property)BlockStateProperties.BERRIES)) {
                        state = (BlockState)state.setValue((Property)BlockStateProperties.BERRIES, (Comparable)Boolean.valueOf(true));
                    }
                    this.renderBlock(poseStack, (MultiBufferSource)buffer, 0xF000F0, state, -1);
                    if (state.hasProperty(PickableDoublePlant.HALF)) {
                        poseStack.pushPose();
                        poseStack.translate(0.0f, 1.0f, 0.0f);
                        state = (BlockState)state.setValue(PickableDoublePlant.HALF, (Comparable)DoubleBlockHalf.UPPER);
                        this.renderBlock(poseStack, (MultiBufferSource)buffer, 0xF000F0, state, -1);
                        poseStack.popPose();
                    }
                    poseStack.popPose();
                }
                buffer.endBatch();
                poseStack.popPose();
            }
        }
    }

    private void renderBlock(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, BlockState state, int color) {
        this.renderSingleBlock(state, matrixStack, bufferIn, combinedLightIn, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, color);
    }

    public void renderSingleBlock(BlockState p_110913_, PoseStack poseStack, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, int color) {
        RenderShape rendershape = p_110913_.getRenderShape();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
                    BakedModel bakedmodel = dispatcher.getBlockModel(p_110913_);
                    int i = color;
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    dispatcher.getModelRenderer().renderModel(poseStack.last(), p_110915_.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)p_110913_, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, null);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.getBlock());
                    poseStack.translate(0.2, -0.1, -0.1);
                    IClientItemExtensions.of((Item)stack.getItem()).getCustomRenderer().renderByItem(stack, ItemDisplayContext.NONE, poseStack, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }
}

