/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.custom;

import java.util.Arrays;
import java.util.function.Supplier;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.item.ModItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class ModChestBoatEntity
extends ChestBoat {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE = SynchedEntityData.defineId(ModChestBoatEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public ModChestBoatEntity(EntityType<ModChestBoatEntity> entityEntityType, Level level) {
        super(entityEntityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_TYPE, (Object)Type.WILLOW.ordinal());
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)this.getDropItem());
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        nbt.putString("model", this.getModel().getName());
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        if (nbt.contains("model", 8)) {
            this.entityData.set(DATA_ID_TYPE, (Object)Type.byName(nbt.getString("model")).ordinal());
        }
    }

    public void setType(Type pBoatType) {
        this.entityData.set(DATA_ID_TYPE, (Object)pBoatType.ordinal());
    }

    public Boat.Type getBoatType() {
        return Boat.Type.OAK;
    }

    public Type getModBoatType() {
        return Type.byId((Integer)this.entityData.get(DATA_ID_TYPE));
    }

    public Item getDropItem() {
        return switch (Type.byId((Integer)this.entityData.get(DATA_ID_TYPE)).ordinal()) {
            default -> (Item)ModItems.WILLOW_CHEST_BOAT.get();
            case 1 -> (Item)ModItems.POLISHED_WILLOW_CHEST_BOAT.get();
            case 2 -> (Item)ModItems.MAHOGANY_CHEST_BOAT.get();
            case 3 -> (Item)ModItems.POLISHED_MAHOGANY_CHEST_BOAT.get();
        };
    }

    public ModChestBoatEntity withModel(Type type) {
        this.entityData.set(DATA_ID_TYPE, (Object)type.ordinal());
        return this;
    }

    public Type getModel() {
        return Type.byId((Integer)this.entityData.get(DATA_ID_TYPE));
    }

    public static enum Type {
        WILLOW("willow", (Supplier<Block>)ModBlocks.WILLOW_PLANKS),
        POLISHED_WILLOW("polished_willow", (Supplier<Block>)ModBlocks.POLISHED_WILLOW_PLANKS),
        MAHOGANY("mahogany", (Supplier<Block>)ModBlocks.MAHOGANY_PLANKS),
        POLISHED_MAHOGANY("polished_mahogany", (Supplier<Block>)ModBlocks.POLISHED_MAHOGANY_PLANKS);

        private final String name;
        private final Supplier<Block> supplierPlanks;

        private Type(String name, Supplier<Block> supplierPlanks) {
            this.name = name;
            this.supplierPlanks = supplierPlanks;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.supplierPlanks.get();
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int id) {
            Type[] type = Type.values();
            return type[id < 0 || id >= type.length ? 0 : id];
        }

        public static Type byName(String aName) {
            Type[] type = Type.values();
            return Arrays.stream(type).filter(t -> t.getName().equals(aName)).findFirst().orElse(type[0]);
        }
    }
}

