/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;

public class CandleModel<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation CANDLE_LAYER = new ModelLayerLocation(HexereiUtil.getResource("candle_layer"), "main");
    public static final ModelLayerLocation CANDLE_HERB_LAYER = new ModelLayerLocation(HexereiUtil.getResource("candle_herb_layer"), "main");
    public static final ModelLayerLocation CANDLE_BASE_LAYER = new ModelLayerLocation(HexereiUtil.getResource("candle_base_layer"), "main");
    public static final ModelLayerLocation CANDLE_GLOW_LAYER = new ModelLayerLocation(HexereiUtil.getResource("candle_glow_layer"), "main");
    public static final ModelLayerLocation CANDLE_SWIRL_LAYER = new ModelLayerLocation(HexereiUtil.getResource("candle_swirl_layer"), "main");
    public final ModelPart wick;
    public final ModelPart wax1;
    public final ModelPart wax2;
    public final ModelPart wax3;
    public final ModelPart wax4;
    public final ModelPart wax5;
    public final ModelPart wax6;
    public final ModelPart wax7;
    public final ModelPart[] wax;
    public final ModelPart base;

    public CandleModel(ModelPart root) {
        this.wick = root.getChild("wick");
        this.wax1 = root.getChild("wax1");
        this.wax2 = root.getChild("wax2");
        this.wax3 = root.getChild("wax3");
        this.wax4 = root.getChild("wax4");
        this.wax5 = root.getChild("wax5");
        this.wax6 = root.getChild("wax6");
        this.wax7 = root.getChild("wax7");
        this.base = root.getChild("base");
        this.wax = new ModelPart[]{this.wax1, this.wax2, this.wax3, this.wax4, this.wax5, this.wax6, this.wax7};
    }

    public static LayerDefinition createBodyLayerHerb() {
        return CandleModel.createBodyLayer(new CubeDeformation(0.1f));
    }

    public static LayerDefinition createBodyLayerGlow() {
        return CandleModel.createBodyLayer(new CubeDeformation(0.15f));
    }

    public static LayerDefinition createBodyLayerSwirl() {
        return CandleModel.createBodyLayer(new CubeDeformation(0.2f));
    }

    public static LayerDefinition createBodyLayer() {
        return CandleModel.createBodyLayer(CubeDeformation.NONE);
    }

    public static LayerDefinition createBodyLayer(CubeDeformation cube) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition wick = partdefinition.addOrReplaceChild("wick", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 7.0f, 0.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(0.0f, 7.0f, -0.5f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition wax1 = partdefinition.addOrReplaceChild("wax1", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 15.0f, -1.0f, 2.0f, 1.0f, 2.0f, cube), PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition wax2 = partdefinition.addOrReplaceChild("wax2", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 14.0f, -1.0f, 2.0f, 2.0f, 2.0f, cube), PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition wax3 = partdefinition.addOrReplaceChild("wax3", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 13.0f, -1.0f, 2.0f, 3.0f, 2.0f, cube), PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition wax4 = partdefinition.addOrReplaceChild("wax4", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 12.0f, -1.0f, 2.0f, 4.0f, 2.0f, cube), PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition wax5 = partdefinition.addOrReplaceChild("wax5", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 11.0f, -1.0f, 2.0f, 5.0f, 2.0f, cube), PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition wax6 = partdefinition.addOrReplaceChild("wax6", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 10.0f, -1.0f, 2.0f, 6.0f, 2.0f, cube), PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition wax7 = partdefinition.addOrReplaceChild("wax7", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 9.0f, -1.0f, 2.0f, 7.0f, 2.0f, cube), PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition base = partdefinition.addOrReplaceChild("base", CubeListBuilder.create().texOffs(2, 11).addBox(-1.5f, -0.5f, -1.5f, 3.0f, 1.0f, 3.0f, cube), PartPose.offset((float)0.0f, (float)23.5f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    public static LayerDefinition createBaseLayer() {
        CubeDeformation cube = CubeDeformation.NONE;
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition wick = partdefinition.addOrReplaceChild("wick", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 7.0f, 0.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(0.0f, 7.0f, -0.5f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition wax1 = partdefinition.addOrReplaceChild("wax1", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 15.0f, -1.0f, 2.0f, 1.0f, 2.0f, cube), PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition wax2 = partdefinition.addOrReplaceChild("wax2", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 14.0f, -1.0f, 2.0f, 2.0f, 2.0f, cube), PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition wax3 = partdefinition.addOrReplaceChild("wax3", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 13.0f, -1.0f, 2.0f, 3.0f, 2.0f, cube), PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition wax4 = partdefinition.addOrReplaceChild("wax4", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 12.0f, -1.0f, 2.0f, 4.0f, 2.0f, cube), PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition wax5 = partdefinition.addOrReplaceChild("wax5", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 11.0f, -1.0f, 2.0f, 5.0f, 2.0f, cube), PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition wax6 = partdefinition.addOrReplaceChild("wax6", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 10.0f, -1.0f, 2.0f, 6.0f, 2.0f, cube), PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition wax7 = partdefinition.addOrReplaceChild("wax7", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 9.0f, -1.0f, 2.0f, 7.0f, 2.0f, cube), PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition base = partdefinition.addOrReplaceChild("base", CubeListBuilder.create().texOffs(2, 11).addBox(-1.5f, -0.5f, -1.5f, 3.0f, 1.0f, 3.0f, cube), PartPose.offset((float)0.0f, (float)23.5f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.wick.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.wax7.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.base.render(poseStack, buffer, packedLight, packedOverlay, color);
    }
}

