/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collections;
import java.util.Map;
import net.joefoxe.hexerei.client.renderer.entity.custom.CrowEntity;
import net.joefoxe.hexerei.event.ClientEvents;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.model.ColorableAgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import org.joml.Vector3f;

public class CrowModel<T extends CrowEntity>
extends ColorableAgeableListModel<T> {
    public final ModelPart body;
    public final ModelPart head;
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(HexereiUtil.getResource("crow"), "main");
    public static final ModelLayerLocation POWER_LAYER_LOCATION = new ModelLayerLocation(HexereiUtil.getResource("crow_power_layer"), "main");

    public CrowModel(ModelPart root) {
        this.body = root.getChild("body");
        this.head = this.body.getChild("head");
    }

    public static LayerDefinition createBodyLayerNone() {
        return CrowModel.createBodyLayer(CubeDeformation.NONE);
    }

    public static LayerDefinition createBodyLayerEnlarge() {
        return CrowModel.createBodyLayer(new CubeDeformation(0.1f));
    }

    public static LayerDefinition createBodyLayer(CubeDeformation cube) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition chest = body.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(1, 6).addBox(-1.5f, -3.0f, 0.0f, 3.0f, 3.0f, 5.0f, cube).texOffs(0, 14).addBox(-1.5f, -2.308f, -0.4665f, 3.0f, 2.0f, 0.0f, cube), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)-2.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition bandana_r1 = chest.addOrReplaceChild("bandana_r1", CubeListBuilder.create().texOffs(4, 16).addBox(-0.5f, -5.225f, -0.425f, 1.0f, 1.0f, 0.0f, cube), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)2.5f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition amulet_r1 = body.addOrReplaceChild("amulet_r1", CubeListBuilder.create().texOffs(1, 6).addBox(-1.5f, -3.0f, 0.0f, 3.0f, 3.0f, 5.0f, cube).texOffs(24, 23).addBox(-2.0f, -1.9205f, -0.0217f, 4.0f, 2.0f, 0.0f, cube), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)-2.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition amulet_r2 = amulet_r1.addOrReplaceChild("amulet_r2", CubeListBuilder.create().texOffs(30, 26).addBox(-1.0f, -4.225f, -0.2f, 2.0f, 1.0f, 0.0f, cube).texOffs(26, 25).addBox(-1.5f, -5.225f, -0.185f, 3.0f, 1.0f, 0.0f, cube), PartPose.offsetAndRotation((float)0.0f, (float)4.5f, (float)2.75f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = body.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(12, 7).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 1.0f, cube), PartPose.offset((float)-1.0f, (float)-3.0f, (float)0.5f));
        PartDefinition leftLeg = body.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(12, 7).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 1.0f, cube), PartPose.offset((float)1.0f, (float)-3.0f, (float)0.5f));
        PartDefinition rightWing = body.addOrReplaceChild("rightWing", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)-5.5f, (float)-1.5f));
        PartDefinition rightWing_r1 = rightWing.addOrReplaceChild("rightWing_r1", CubeListBuilder.create().texOffs(0, 25).mirror().addBox(-11.0f, -5.5f, -2.5f, 10.0f, 0.0f, 6.0f, cube).mirror(false), PartPose.offsetAndRotation((float)1.0f, (float)5.5f, (float)-0.5f, (float)0.0f, (float)0.1745f, (float)0.0f));
        PartDefinition leftWing = body.addOrReplaceChild("leftWing", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)-5.5f, (float)-1.5f));
        PartDefinition leftWing_r1 = leftWing.addOrReplaceChild("leftWing_r1", CubeListBuilder.create().texOffs(0, 25).addBox(1.0f, -5.5f, -2.5f, 10.0f, 0.0f, 6.0f, cube), PartPose.offsetAndRotation((float)-1.0f, (float)5.5f, (float)-0.5f, (float)0.0f, (float)-0.1745f, (float)0.0f));
        PartDefinition rightTail = body.addOrReplaceChild("rightTail", CubeListBuilder.create().texOffs(16, 14).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 6.0f, cube), PartPose.offsetAndRotation((float)-0.75f, (float)-3.0f, (float)2.5f, (float)-0.2618f, (float)-0.2618f, (float)0.0f));
        PartDefinition rightTail_dyed = body.addOrReplaceChild("rightTail_dyed", CubeListBuilder.create().texOffs(20, 14).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 6.0f, cube), PartPose.offsetAndRotation((float)-0.75f, (float)-3.0f, (float)2.5f, (float)-0.2618f, (float)-0.2618f, (float)0.0f));
        PartDefinition leftTail = body.addOrReplaceChild("leftTail", CubeListBuilder.create().texOffs(16, 14).mirror().addBox(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 6.0f, cube).mirror(false), PartPose.offsetAndRotation((float)0.75f, (float)-3.0f, (float)2.5f, (float)-0.2618f, (float)0.2618f, (float)0.0f));
        PartDefinition leftTail_dyed = body.addOrReplaceChild("leftTail_dyed", CubeListBuilder.create().texOffs(20, 14).mirror().addBox(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 6.0f, cube).mirror(false), PartPose.offsetAndRotation((float)0.75f, (float)-3.0f, (float)2.5f, (float)-0.2618f, (float)0.2618f, (float)0.0f));
        PartDefinition tailMid = body.addOrReplaceChild("tailMid", CubeListBuilder.create().texOffs(13, 0).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 7.0f, cube), PartPose.offsetAndRotation((float)0.0f, (float)-3.5f, (float)3.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition tailMid_dyed = body.addOrReplaceChild("tailMid_dyed", CubeListBuilder.create().texOffs(17, 0).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 7.0f, cube), PartPose.offsetAndRotation((float)0.0f, (float)-3.5f, (float)3.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition wings = body.addOrReplaceChild("wings", CubeListBuilder.create().texOffs(0, 14).addBox(-2.0f, -3.5f, -0.5f, 4.0f, 4.0f, 7.0f, cube), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)-2.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -3.0f, -3.0f, 3.0f, 3.0f, 3.0f, cube), PartPose.offset((float)0.0f, (float)-5.0f, (float)-1.5f));
        PartDefinition head_eyes_closed = body.addOrReplaceChild("head_eyes_closed", CubeListBuilder.create().texOffs(20, 7).addBox(-1.5f, -3.0f, -3.0f, 3.0f, 3.0f, 3.0f, cube), PartPose.offset((float)0.0f, (float)-5.0f, (float)-1.5f));
        PartDefinition head_r1 = head.addOrReplaceChild("head_r1", CubeListBuilder.create().texOffs(0, 6).addBox(-0.5f, -0.0434f, -2.0f, 1.0f, 1.0f, 2.0f, cube), PartPose.offsetAndRotation((float)0.0f, (float)-0.924f, (float)-2.7521f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition head_r2 = head.addOrReplaceChild("head_r2", CubeListBuilder.create().texOffs(0, 6).addBox(-0.5f, -0.25f, -0.925f, 1.0f, 1.0f, 2.0f, cube), PartPose.offsetAndRotation((float)0.0f, (float)-1.75f, (float)-4.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition head_eyes_closed_r1 = head_eyes_closed.addOrReplaceChild("head_eyes_closed_r1", CubeListBuilder.create().texOffs(0, 6).addBox(-0.5f, -0.0434f, -2.0f, 1.0f, 1.0f, 2.0f, cube), PartPose.offsetAndRotation((float)0.0f, (float)-0.924f, (float)-2.7521f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition head_eyes_closed_r2 = head_eyes_closed.addOrReplaceChild("head_eyes_closed_r2", CubeListBuilder.create().texOffs(0, 6).addBox(-0.5f, -0.25f, -0.925f, 1.0f, 1.0f, 2.0f, cube), PartPose.offsetAndRotation((float)0.0f, (float)-1.75f, (float)-4.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void renderOnShoulder(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float p_228284_5_, float p_228284_6_, float p_228284_7_, float p_228284_8_, int p_228284_9_) {
        this.body.getChild((String)"leftWing").visible = false;
        this.body.getChild((String)"rightWing").visible = false;
        this.body.getChild((String)"wings").visible = true;
        this.body.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn);
    }

    public void setupAnim(CrowEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setupInitialAnimationValues(entity, netHeadYaw, headPitch);
        ModelPart leftWing = this.body.getChild("leftWing");
        ModelPart rightWing = this.body.getChild("rightWing");
        ModelPart wings = this.body.getChild("wings");
        ModelPart rightLeg = this.body.getChild("rightLeg");
        ModelPart leftLeg = this.body.getChild("leftLeg");
        ModelPart head = this.body.getChild("head");
        ModelPart head_eyes_closed = this.body.getChild("head_eyes_closed");
        ModelPart rightTail = this.body.getChild("rightTail");
        ModelPart rightTail_dyed = this.body.getChild("rightTail_dyed");
        ModelPart leftTail = this.body.getChild("leftTail");
        ModelPart leftTail_dyed = this.body.getChild("leftTail_dyed");
        ModelPart tailMid = this.body.getChild("tailMid");
        ModelPart tailMid_dyed = this.body.getChild("tailMid_dyed");
        ModelPart head_r1 = head.getChild("head_r1");
        ModelPart head_eyes_closed_r1 = head_eyes_closed.getChild("head_eyes_closed_r1");
        if (!entity.onGround() || !entity.isInSittingPose()) {
            this.body.y = 24.0f;
        }
        if (entity.onGround() || !entity.isFlying()) {
            leftWing.visible = false;
            rightWing.visible = false;
            wings.visible = true;
            if (entity.isTame() && entity.isInSittingPose()) {
                rightLeg.xRot = -0.5235988f;
                leftLeg.xRot = -0.5235988f;
                rightLeg.y = -4.0f;
                rightLeg.z = 1.5f;
                leftLeg.y = -4.0f;
                leftLeg.z = 1.5f;
                this.body.y = 25.5f;
            } else {
                rightLeg.y = -3.0f;
                rightLeg.z = 0.5f;
                leftLeg.y = -3.0f;
                leftLeg.z = 0.5f;
                rightLeg.xRot = Mth.cos((float)(limbSwing * 2.0f + (float)Math.PI)) * 2.0f * limbSwingAmount;
                leftLeg.xRot = Mth.cos((float)(limbSwing * 2.0f)) * 2.0f * limbSwingAmount;
            }
            head.xRot = (float)Math.toRadians(headPitch);
            if (!entity.isPlayingDead()) {
                head.xRot += Mth.sin((float)(ClientEvents.getClientTicks() / 25.0f)) * 0.1f;
                rightTail.xRot = Mth.sin((float)(ClientEvents.getClientTicks() / 25.0f)) * 0.1f;
                leftTail.xRot = Mth.sin((float)(ClientEvents.getClientTicks() / 25.0f)) * 0.1f;
                tailMid.xRot = Mth.sin((float)(ClientEvents.getClientTicks() / 25.0f)) * 0.1f;
            }
            rightTail.yRot = -Mth.sin((float)0.05f);
            leftTail.yRot = Mth.sin((float)0.05f);
            rightTail.yRot += Mth.sin((float)(entity.tailWagTiltAngleActual / 100.0f)) * 0.2f;
            leftTail.yRot += Mth.sin((float)(entity.tailWagTiltAngleActual / 100.0f)) * 0.2f;
            tailMid.yRot = Mth.sin((float)(entity.tailWagTiltAngleActual / 100.0f)) * 0.2f;
            if (entity.tailWag) {
                rightTail.yRot += Mth.sin((float)0.15f) * 0.5f;
                leftTail.yRot -= Mth.sin((float)0.15f) * 0.5f;
            }
            rightTail.yRot -= Mth.sin((float)(entity.tailFanTiltAngleActual / 100.0f)) * 0.5f;
            leftTail.yRot += Mth.sin((float)(entity.tailFanTiltAngleActual / 100.0f)) * 0.5f;
        } else if (entity.isPassenger()) {
            leftWing.visible = false;
            rightWing.visible = false;
            wings.visible = true;
            rightLeg.xRot = -0.5235988f;
            leftLeg.xRot = -0.5235988f;
            rightLeg.y = -4.0f;
            rightLeg.z = 1.5f;
            leftLeg.y = -4.0f;
            leftLeg.z = 1.5f;
            this.body.y = 25.5f;
            head.xRot = (float)Math.toRadians(headPitch);
            if (!entity.isPlayingDead()) {
                head.xRot += Mth.sin((float)(ClientEvents.getClientTicks() / 25.0f)) * 0.1f;
                rightTail.xRot = Mth.sin((float)(ClientEvents.getClientTicks() / 25.0f)) * 0.1f;
                leftTail.xRot = Mth.sin((float)(ClientEvents.getClientTicks() / 25.0f)) * 0.1f;
                tailMid.xRot = Mth.sin((float)(ClientEvents.getClientTicks() / 25.0f)) * 0.1f;
            }
            rightTail.yRot = -Mth.sin((float)0.05f);
            leftTail.yRot = Mth.sin((float)0.05f);
            rightTail.yRot += Mth.sin((float)(entity.tailWagTiltAngleActual / 100.0f)) * 0.2f;
            leftTail.yRot += Mth.sin((float)(entity.tailWagTiltAngleActual / 100.0f)) * 0.2f;
            tailMid.yRot = Mth.sin((float)(entity.tailWagTiltAngleActual / 100.0f)) * 0.2f;
            if (entity.tailWag) {
                rightTail.yRot += Mth.sin((float)0.15f) * 0.5f;
                leftTail.yRot -= Mth.sin((float)0.15f) * 0.5f;
            }
            rightTail.yRot -= Mth.sin((float)(entity.tailFanTiltAngleActual / 100.0f)) * 0.5f;
            leftTail.yRot += Mth.sin((float)(entity.tailFanTiltAngleActual / 100.0f)) * 0.5f;
        } else {
            leftWing.visible = true;
            rightWing.visible = true;
            wings.visible = false;
            rightLeg.xRot = Mth.sin((float)20.0f);
            leftLeg.xRot = Mth.sin((float)20.0f);
            rightWing.zRot = entity.rightWingAngleActual;
            leftWing.zRot = entity.leftWingAngleActual;
            head.xRot = (float)Math.toRadians(headPitch);
            rightTail.yRot = -Mth.sin((float)0.15f);
            leftTail.yRot = Mth.sin((float)0.15f);
        }
        this.body.xRot = Mth.sin((float)(entity.peckTiltAngleActual / 100.0f));
        head.yRot = (float)Math.toRadians(netHeadYaw);
        head.zRot = Mth.sin((float)(entity.headZTiltAngleActual / 100.0f)) / 2.0f;
        head.xRot += Mth.sin((float)(entity.headXTiltAngleActual / 100.0f)) / 2.0f;
        if ((entity.onGround() || entity.isPassenger()) && entity.dance) {
            head.zRot = 0.0f;
            head.xRot = (float)Math.toRadians(headPitch) + Mth.sin((float)((float)entity.animationCounter / 1.5f)) / 12.0f;
            head.yRot = (float)Math.toRadians(netHeadYaw) + Mth.sin((float)((float)entity.animationCounter / 3.0f)) / 4.0f;
            rightTail.xRot = Mth.sin((float)((float)entity.animationCounter / 3.0f)) * 0.1f;
            leftTail.xRot = Mth.sin((float)((float)entity.animationCounter / 3.0f)) * 0.1f;
            tailMid.xRot = Mth.sin((float)((float)entity.animationCounter / 3.0f)) * 0.1f;
            this.body.yRot = Mth.sin((float)((float)entity.animationCounter / 3.0f)) * 0.2f;
            rightTail.yRot = Mth.sin((float)0.1f);
            leftTail.yRot = -Mth.sin((float)0.1f);
            this.body.y = 24.0f + Mth.abs((float)Mth.sin((float)((float)entity.animationCounter / 6.0f)));
            rightTail.yRot += Mth.sin((float)((float)entity.animationCounter / 3.0f)) * 0.4f;
            leftTail.yRot += Mth.sin((float)((float)entity.animationCounter / 3.0f)) * 0.4f;
            tailMid.yRot = Mth.sin((float)((float)entity.animationCounter / 3.0f)) * 0.4f;
            rightLeg.y = -3.0f - Mth.abs((float)Mth.sin((float)((float)entity.animationCounter / 6.0f)));
            rightLeg.z = 0.5f;
            leftLeg.y = -3.0f - Mth.abs((float)Mth.sin((float)((float)entity.animationCounter / 6.0f)));
            leftLeg.z = 0.5f;
            rightLeg.xRot = Mth.cos((float)(limbSwing * 2.0f + (float)Math.PI)) * 2.0f * limbSwingAmount;
            leftLeg.xRot = Mth.cos((float)(limbSwing * 2.0f)) * 2.0f * limbSwingAmount;
        } else {
            this.body.yRot = 0.0f;
        }
        head_r1.xRot = Mth.sin((float)(entity.cawTiltAngleActual / 100.0f));
        if (entity.peckTiltAngleActual > 0.0f) {
            head_r1.xRot = Mth.sin((float)(entity.peckTiltAngleActual / 100.0f));
        }
        head_eyes_closed.copyFrom(head);
        head_eyes_closed_r1.copyFrom(head_r1);
        tailMid_dyed.copyFrom(tailMid);
        leftTail_dyed.copyFrom(leftTail);
        rightTail_dyed.copyFrom(rightTail);
        if (entity.playingDead > 0 && !entity.isDeadOrDying()) {
            this.body.zRot = HexereiUtil.moveTo(this.body.zRot, 1.3962634f, 0.025f);
            this.body.y -= 4.0f * this.body.zRot / (float)Math.PI;
            head.visible = false;
            head_eyes_closed.visible = true;
            leftWing.visible = false;
            rightWing.visible = false;
            wings.visible = true;
        } else {
            if (this.body.zRot != 0.0f) {
                this.body.zRot = HexereiUtil.moveTo(this.body.zRot, 0.0f, 0.075f);
                this.body.y -= 4.0f * this.body.zRot / (float)Math.PI;
            }
            head.visible = true;
            head_eyes_closed.visible = false;
        }
        this.saveAnimationValues(entity);
    }

    private Vector3f getRotationVector(ModelPart pModelPart) {
        return new Vector3f(pModelPart.xRot, pModelPart.yRot, pModelPart.zRot);
    }

    private void setRotationFromVector(ModelPart pModelPart, Vector3f pRotationVector) {
        pModelPart.setRotation(pRotationVector.x(), pRotationVector.y(), pRotationVector.z());
    }

    private void saveAnimationValues(CrowEntity crow) {
        Map<String, Vector3f> map = crow.getModelRotationValues();
        map.put("body", this.getRotationVector(this.body));
    }

    private void setupInitialAnimationValues(CrowEntity crow, float pNetHeadYaw, float pHeadPitch) {
        this.body.x = 0.0f;
        this.body.y = 20.0f;
        Map<String, Vector3f> map = crow.getModelRotationValues();
        if (map.isEmpty()) {
            this.body.setRotation(pHeadPitch * ((float)Math.PI / 180), pNetHeadYaw * ((float)Math.PI / 180), 0.0f);
        } else {
            this.setRotationFromVector(this.body, map.get("body"));
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    protected Iterable<ModelPart> headParts() {
        return Collections.singleton(this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return Collections.singleton(this.body);
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.xRot = x;
        modelRenderer.yRot = y;
        modelRenderer.zRot = z;
    }
}

