/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.books;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.joefoxe.hexerei.data.books.BookHyperlink;
import net.joefoxe.hexerei.data.books.BookImageEffect;
import net.joefoxe.hexerei.data.books.BookTooltipExtra;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public class BookImage {
    public float x;
    public float y;
    public float z;
    public float u;
    public float v;
    public float width;
    public float height;
    public float imageWidth;
    public float imageHeight;
    public float scale;
    public String texture;
    public BookHyperlink hyperlink;
    public ArrayList<BookImageEffect> effects;
    List<Component> extra_tooltips = new ArrayList<Component>();
    List<BookTooltipExtra> extra_tooltips_raw;
    public static final Codec<BookImage> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("x", (Object)Float.valueOf(0.0f)).forGetter(e -> Float.valueOf(e.x)), (App)Codec.FLOAT.optionalFieldOf("y", (Object)Float.valueOf(0.0f)).forGetter(e -> Float.valueOf(e.y)), (App)Codec.FLOAT.optionalFieldOf("z", (Object)Float.valueOf(0.0f)).forGetter(e -> Float.valueOf(e.z)), (App)Codec.FLOAT.optionalFieldOf("u", (Object)Float.valueOf(0.0f)).forGetter(e -> Float.valueOf(e.u)), (App)Codec.FLOAT.optionalFieldOf("v", (Object)Float.valueOf(0.0f)).forGetter(e -> Float.valueOf(e.v)), (App)Codec.FLOAT.optionalFieldOf("width", (Object)Float.valueOf(16.0f)).forGetter(e -> Float.valueOf(e.width)), (App)Codec.FLOAT.optionalFieldOf("height", (Object)Float.valueOf(16.0f)).forGetter(e -> Float.valueOf(e.height)), (App)Codec.FLOAT.optionalFieldOf("imageWidth", (Object)Float.valueOf(16.0f)).forGetter(e -> Float.valueOf(e.imageWidth)), (App)Codec.FLOAT.optionalFieldOf("imageHeight", (Object)Float.valueOf(16.0f)).forGetter(e -> Float.valueOf(e.imageHeight)), (App)Codec.FLOAT.optionalFieldOf("scale", (Object)Float.valueOf(0.0f)).forGetter(e -> Float.valueOf(e.scale)), (App)Codec.STRING.optionalFieldOf("texture", (Object)"").forGetter(e -> e.texture), (App)BookHyperlink.CODEC.optionalFieldOf("hyperlink", (Object)new BookHyperlink(-1, -1)).forGetter(e -> e.hyperlink), (App)BookTooltipExtra.CODEC.listOf().optionalFieldOf("tooltip", new ArrayList()).forGetter(e -> e.extra_tooltips_raw), (App)BookImageEffect.CODEC.listOf().optionalFieldOf("effects", new ArrayList()).forGetter(e -> e.effects)).apply((Applicative)instance, BookImage::new));

    BookImage(float x, float y, float z, float u, float v, float width, float height, float imageWidth, float imageHeight, float scale, String texture, ArrayList<BookImageEffect> effects) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.u = u;
        this.v = v;
        this.width = width;
        this.height = height;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.scale = scale;
        this.texture = texture;
        this.effects = effects;
        this.hyperlink = new BookHyperlink(-1, -1);
        this.extra_tooltips_raw = new ArrayList<BookTooltipExtra>();
    }

    BookImage(float x, float y, float z, float u, float v, float width, float height, float imageWidth, float imageHeight, float scale, String texture, BookHyperlink hyperlink, List<BookTooltipExtra> extra_tooltips_raw, List<BookImageEffect> effects) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.u = u;
        this.v = v;
        this.width = width;
        this.height = height;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.scale = scale;
        this.texture = texture;
        this.effects = new ArrayList<BookImageEffect>(effects);
        this.hyperlink = hyperlink;
        this.extra_tooltips_raw = extra_tooltips_raw;
        for (BookTooltipExtra tooltipExtra : this.extra_tooltips_raw) {
            if (!tooltipExtra.color_hex.isEmpty()) {
                tooltipExtra.color = (int)Long.parseLong(tooltipExtra.color_hex, 16);
            }
            if (tooltipExtra.type.equals("append")) {
                this.extra_tooltips.getLast().getSiblings().add(Component.translatable((String)tooltipExtra.text).withStyle(Style.EMPTY.withColor(tooltipExtra.color)));
                continue;
            }
            this.extra_tooltips.add((Component)Component.translatable((String)tooltipExtra.text).withStyle(Style.EMPTY.withColor(tooltipExtra.color)));
        }
    }
}

