/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.books;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.joefoxe.hexerei.data.books.PaintSystem;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.util.thread.EffectiveSide;

public class BookPaintElement {
    public float x;
    public float y;
    public float z;
    public float width;
    public float height;
    public float scale;
    public int index;
    public ResourceLocation parentLocation;
    public Client client;
    public static final Codec<BookPaintElement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.optionalFieldOf("parentLocation", (Object)HexereiUtil.getResource("missing")).forGetter(p -> p.parentLocation), (App)Codec.FLOAT.optionalFieldOf("x", (Object)Float.valueOf(0.0f)).forGetter(p -> Float.valueOf(p.x)), (App)Codec.FLOAT.optionalFieldOf("y", (Object)Float.valueOf(0.0f)).forGetter(p -> Float.valueOf(p.y)), (App)Codec.FLOAT.optionalFieldOf("z", (Object)Float.valueOf(0.0f)).forGetter(p -> Float.valueOf(p.z)), (App)Codec.FLOAT.optionalFieldOf("width", (Object)Float.valueOf(16.0f)).forGetter(p -> Float.valueOf(p.width)), (App)Codec.FLOAT.optionalFieldOf("height", (Object)Float.valueOf(16.0f)).forGetter(p -> Float.valueOf(p.height)), (App)Codec.FLOAT.optionalFieldOf("scale", (Object)Float.valueOf(1.0f)).forGetter(p -> Float.valueOf(p.scale)), (App)Codec.INT.optionalFieldOf("index", (Object)0).forGetter(p -> p.index)).apply((Applicative)instance, BookPaintElement::new));

    BookPaintElement(ResourceLocation parentLocation, float x, float y, float z, float width, float height, float scale, int index) {
        this.parentLocation = parentLocation;
        this.x = x;
        this.y = y;
        this.z = z;
        this.width = width;
        this.height = height;
        this.scale = scale;
        this.index = index;
        this.client = EffectiveSide.get().isClient() ? new Client(this) : null;
    }

    public static class Client {
        BookPaintElement parent;
        Map<UUID, PaintSystem> paintSystems;

        public PaintSystem getPaintSystem(UUID uuid) {
            if (!this.paintSystems.containsKey(uuid)) {
                PaintSystem ps = new PaintSystem((int)this.parent.width, (int)this.parent.height, this.parent.parentLocation, uuid);
                this.paintSystems.put(uuid, ps);
                ps.addAndUpdateTexture();
            }
            return this.paintSystems.get(uuid);
        }

        public Client(BookPaintElement parent) {
            this.parent = parent;
            this.paintSystems = new HashMap<UUID, PaintSystem>();
        }
    }
}

