/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.books;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.math.Axis;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.block.custom.MixingCauldron;
import net.joefoxe.hexerei.client.renderer.ModRenderTypes;
import net.joefoxe.hexerei.config.HexConfig;
import net.joefoxe.hexerei.data.books.BookBlocks;
import net.joefoxe.hexerei.data.books.BookChapter;
import net.joefoxe.hexerei.data.books.BookEntity;
import net.joefoxe.hexerei.data.books.BookEntries;
import net.joefoxe.hexerei.data.books.BookHyperlink;
import net.joefoxe.hexerei.data.books.BookImage;
import net.joefoxe.hexerei.data.books.BookImageEffect;
import net.joefoxe.hexerei.data.books.BookItemsAndFluids;
import net.joefoxe.hexerei.data.books.BookManager;
import net.joefoxe.hexerei.data.books.BookNonItemTooltip;
import net.joefoxe.hexerei.data.books.BookPage;
import net.joefoxe.hexerei.data.books.BookPageEntry;
import net.joefoxe.hexerei.data.books.BookPaintElement;
import net.joefoxe.hexerei.data.books.BookParagraph;
import net.joefoxe.hexerei.data.books.BookParagraphElements;
import net.joefoxe.hexerei.data.books.BookWritableTextBox;
import net.joefoxe.hexerei.data.books.PageDrawingEvents;
import net.joefoxe.hexerei.data.books.PaintSystem;
import net.joefoxe.hexerei.event.ClientEvents;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.data_components.BookData;
import net.joefoxe.hexerei.particle.ModParticleTypes;
import net.joefoxe.hexerei.screen.BookOfShadowsScreen;
import net.joefoxe.hexerei.screen.CanvasPaintingCropScreen;
import net.joefoxe.hexerei.screen.tooltip.HexereiBookTooltip;
import net.joefoxe.hexerei.tileentity.BookOfShadowsAltarTile;
import net.joefoxe.hexerei.util.ClientProxy;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PageDrawing {
    public float lineWidth = 0.0f;
    public float lineHeight = 0.0f;
    public BookOfShadowsAltarTile altarTile;
    public ItemStack tooltipStack;
    public List<Component> tooltipText;
    public BookImage slotOverlay;
    public boolean drawTooltip;
    public boolean drawTooltipStack = false;
    public boolean drawTooltipStackFlag = false;
    public boolean drawTooltipTextFlag = false;
    public float drawTooltipScale = 0.0f;
    public float drawTooltipScaleOld;
    public boolean drawTooltipText = false;
    public boolean drawSlotOverlay = false;
    public PageOn slotOverlayPageOn;
    public ArrayList<Float> bookmarkHoverAmount = new ArrayList<Float>(Stream.generate(() -> Float.valueOf(0.0f)).limit(20L).toList());
    public ArrayList<Float> bookmarkHoverAmountOld = new ArrayList<Float>(Stream.generate(() -> Float.valueOf(0.0f)).limit(20L).toList());
    public ArrayList<Float> bookmarkHoverAmountRender = new ArrayList<Float>(Stream.generate(() -> Float.valueOf(0.0f)).limit(20L).toList());
    public ArrayList<Integer> bookmarkHovered = new ArrayList();
    public static boolean isClicked;
    public static boolean isClickedOld;
    public static ArrayList<ResourceLocation> pageTextureLocs;
    public static ArrayList<ResourceLocation> overlayTextureLocs;
    public static Triple<BookOfShadowsAltarTile, ResourceLocation, BookWritableTextBox> focusedWritableTextBox;
    public static Triple<BookOfShadowsAltarTile, ResourceLocation, BookWritableTextBox> focusedWritableTextBoxLast;
    public static ItemRenderer itemRenderer;
    private static final int TEXTURE_SIZE = 16;
    private static final int MIN_FLUID_HEIGHT = 1;
    private static final NumberFormat nf;
    public static final float CORNERS;
    public static final float MIN_Y = 0.25f;
    public static final float MAX_Y = 0.9375f;
    protected static final Quaternionf ITEM_LIGHT_ROTATION_3D;
    protected static final Quaternionf BLOCK_LIGHT_ROTATION_3D;
    protected static final Quaternionf ITEM_LIGHT_ROTATION_FLAT;

    public PageDrawing(BookOfShadowsAltarTile altarTile) {
        this.tooltipStack = ItemStack.EMPTY;
        this.tooltipText = new ArrayList<Component>();
        this.slotOverlay = new BookImage(0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 20.0f, 20.0f, 20.0f, 20.0f, 1.0f, "hexerei:textures/book/slot_hover.png", new ArrayList<BookImageEffect>());
        this.slotOverlayPageOn = PageOn.LEFT_PAGE;
        itemRenderer = Hexerei.proxy.getLevel() == null ? null : (Hexerei.proxy.getLevel().isClientSide ? Minecraft.getInstance().getItemRenderer() : null);
        this.altarTile = altarTile;
    }

    public static void clearFocusedWritableTextBox() {
        if (focusedWritableTextBox != null) {
            ((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.clicked = false;
            ((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.pageEdit.setCursorPos(((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.pageEdit.getCursorPos(), false);
            ((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.clearDisplayCache(((BookOfShadowsAltarTile)((Object)PageDrawing.focusedWritableTextBox.getLeft())).currentBook.getUUID());
        }
        PageDrawing.setFocusedWritableTextBoxNull();
    }

    public static void setFocusedWritableTextBoxNull() {
        PageDrawing.setFocusedWritableTextBox(null, null, null);
    }

    public static void setFocusedWritableTextBox(final BookOfShadowsAltarTile altarTile, final ResourceLocation pageLoc, final BookWritableTextBox bookWritableTextBox) {
        if (altarTile == null || bookWritableTextBox == null || pageLoc == null) {
            focusedWritableTextBoxLast = focusedWritableTextBox;
            focusedWritableTextBox = null;
        } else {
            focusedWritableTextBoxLast = focusedWritableTextBox;
            focusedWritableTextBox = new Triple<BookOfShadowsAltarTile, ResourceLocation, BookWritableTextBox>(){

                public BookOfShadowsAltarTile getLeft() {
                    return altarTile;
                }

                public ResourceLocation getMiddle() {
                    return pageLoc;
                }

                public BookWritableTextBox getRight() {
                    return bookWritableTextBox;
                }
            };
        }
    }

    public static ItemStack getTagStack(TagKey<Item> key) {
        float fl = 0.0f;
        if (FMLEnvironment.dist.isClient()) {
            fl = ClientEvents.getClientTicks();
        }
        return ((Item)BuiltInRegistries.ITEM.getRandomElementOf(key, RandomSource.create((long)((long)(fl * 1000.0f)))).orElse(Holder.direct((Object)Items.AIR)).value()).getDefaultInstance();
    }

    public static Block getTagBlock(TagKey<Block> key) {
        float fl = 0.0f;
        if (FMLEnvironment.dist.isClient()) {
            fl = ClientEvents.getClientTicks();
        }
        return (Block)BuiltInRegistries.BLOCK.getRandomElementOf(key, RandomSource.create((long)((long)(fl * 1000.0f)))).orElse(Holder.direct((Object)Blocks.AIR)).value();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderItem(BookOfShadowsAltarTile altarTile, @NotNull BookItemsAndFluids itemStackElement, PoseStack poseStack, MultiBufferSource buffer, float xIn, float yIn, float zLevel, int combinedLight, int combinedOverlay, PageOn pageOn, DrawingType drawingType) {
        ItemStack itemStack = itemStackElement.item;
        if (itemStackElement.type.equals("tag")) {
            int mod = (int)ClientEvents.getClientTicks() % 20;
            if (itemStackElement.item.isEmpty()) {
                itemStackElement.item = itemStack = PageDrawing.getTagStack(itemStackElement.key);
                itemStackElement.refreshTag = false;
            }
            if ((mod == 19 || mod == 18) && itemStackElement.refreshTag) {
                itemStack = PageDrawing.getTagStack(itemStackElement.key);
                if (itemStack.is(itemStackElement.item.getItem())) {
                    itemStack = PageDrawing.getTagStack(itemStackElement.key);
                }
                if (itemStack.is(itemStackElement.item.getItem())) {
                    itemStack = PageDrawing.getTagStack(itemStackElement.key);
                }
                itemStackElement.item = itemStack;
                itemStackElement.refreshTag = false;
                itemStackElement.modelCache = itemRenderer.getModel(itemStack, null, null, 0);
            }
            if (mod == 1 || mod == 2) {
                itemStackElement.refreshTag = true;
            }
        }
        poseStack.pushPose();
        if (pageOn == PageOn.LEFT_PAGE) {
            PageDrawing.translateToLeftPage(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_UNDER) {
            PageDrawing.translateToLeftPageUnder(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV) {
            PageDrawing.translateToLeftPagePrevious(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        }
        if (pageOn == PageOn.RIGHT_PAGE) {
            PageDrawing.translateToRightPage(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_UNDER) {
            PageDrawing.translateToRightPageUnder(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV) {
            PageDrawing.translateToRightPagePrevious(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        poseStack.translate(-0.5f, 0.34375f, -0.0013125f);
        poseStack.scale(0.049f, 0.049f, 0.001f);
        poseStack.translate(yIn * 1.259f, -xIn * 1.259f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(-180.0f));
        poseStack.translate(-0.59375f, -0.5625f, 0.0f);
        poseStack.scale(0.065f, 0.065f, 0.05f);
        PageDrawing.renderGuiItemDecorations(buffer, Minecraft.getInstance().font, itemStack, poseStack, 0.0f, 0.0f, combinedOverlay, combinedLight);
        poseStack.translate(1.4423077f, 0.9615385f, 0.0f);
        poseStack.scale(0.965f, 0.965f, 0.965f);
        PageDrawing.renderGuiItemCount(buffer, Minecraft.getInstance().font, itemStack, poseStack, 0.0f, 0.0f, combinedOverlay, combinedLight);
        poseStack.popPose();
        Vector3f[] shaderLightDirections = new Vector3f[]{new Vector3f((Vector3fc)RenderSystem.shaderLightDirections[0]), new Vector3f((Vector3fc)RenderSystem.shaderLightDirections[1])};
        int[] originalLightmap = (int[])Util.make(() -> {
            int[] vals = new int[12];
            for (int i = 0; i < 12; ++i) {
                vals[i] = RenderSystem.getShaderTexture((int)i);
            }
            return vals;
        });
        try {
            if (itemRenderer == null) {
                itemRenderer = Minecraft.getInstance().getItemRenderer();
            }
            if (itemStackElement.modelCache == null) {
                itemStackElement.modelCache = itemRenderer.getModel(itemStack, null, null, 0);
            }
            if (itemStackElement.modelCache.isGui3d()) {
                poseStack.last().normal().rotate((Quaternionfc)ITEM_LIGHT_ROTATION_3D);
            } else {
                poseStack.last().normal().rotate((Quaternionfc)ITEM_LIGHT_ROTATION_FLAT);
            }
            itemRenderer.render(itemStack, ItemDisplayContext.GUI, false, poseStack, buffer, combinedLight, combinedOverlay, itemStackElement.modelCache);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (buffer instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)buffer;
            bufferSource.endBatch();
        }
        for (int i = 0; i < 12; ++i) {
            RenderSystem.setShaderTexture((int)i, (int)originalLightmap[i]);
        }
        ShaderInstance shaderinstance = RenderSystem.getShader();
        RenderSystem.setShaderLights((Vector3f)shaderLightDirections[0], (Vector3f)shaderLightDirections[1]);
        RenderSystem.setupShaderLights((ShaderInstance)shaderinstance);
        poseStack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderBlock(BookOfShadowsAltarTile altarTile, @NotNull BookBlocks blockElement, PoseStack poseStack, MultiBufferSource buffer, float xIn, float yIn, float zLevel, int combinedLight, int combinedOverlay, PageOn pageOn, DrawingType drawingType) {
        BlockState blockState = blockElement.blockState;
        if (blockElement.type.equals("tag")) {
            int mod = (int)ClientEvents.getClientTicks() % 60;
            if (blockState.is(Blocks.AIR)) {
                blockElement.blockState = blockState = PageDrawing.getTagBlock(blockElement.key).defaultBlockState();
            }
            if ((mod == 59 || mod == 58) && blockElement.refreshTag) {
                blockState = PageDrawing.getTagBlock(blockElement.key).defaultBlockState();
                if (blockState.equals(blockElement.blockState)) {
                    blockState = PageDrawing.getTagBlock(blockElement.key).defaultBlockState();
                }
                if (blockState.equals(blockElement.blockState)) {
                    blockState = PageDrawing.getTagBlock(blockElement.key).defaultBlockState();
                }
                blockElement.blockState = blockState;
                blockElement.refreshTag = false;
            }
            if (mod == 1 || mod == 2) {
                blockElement.refreshTag = true;
            }
        }
        poseStack.pushPose();
        if (pageOn == PageOn.LEFT_PAGE) {
            PageDrawing.translateToLeftPage(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_UNDER) {
            PageDrawing.translateToLeftPageUnder(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV) {
            PageDrawing.translateToLeftPagePrevious(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        }
        if (pageOn == PageOn.RIGHT_PAGE) {
            PageDrawing.translateToRightPage(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_UNDER) {
            PageDrawing.translateToRightPageUnder(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV) {
            PageDrawing.translateToRightPagePrevious(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        }
        float scale = 0.62f;
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        poseStack.translate(-0.5f, 0.348125f, -0.0013125f);
        poseStack.scale(0.049f * scale, 0.049f * scale, 0.001f);
        poseStack.translate(yIn * 1.259f * (1.0f / scale), -xIn * 1.259f * (1.0f / scale), 0.0f);
        poseStack.translate(0.25f, 0.25f, 0.25f);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(30.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(45.0f));
        poseStack.translate(-0.25f, -0.25f, -0.25f);
        int light = blockState.getLightEmission((BlockGetter)altarTile.getLevel(), altarTile.getBlockPos());
        try {
            Block block = blockState.getBlock();
            if (block instanceof LiquidBlock) {
                LiquidBlock liquidBlock = (LiquidBlock)block;
                poseStack.last().normal().set((Matrix3fc)poseStack.last().normal().rotate((Quaternionfc)BLOCK_LIGHT_ROTATION_3D));
                PageDrawing.renderFluidBlockGUI(poseStack, buffer, new FluidStack((Fluid)liquidBlock.fluid, 2000), 1.0f, combinedLight, combinedOverlay);
                if (buffer instanceof MultiBufferSource.BufferSource) {
                    MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)buffer;
                    bufferSource.endBatch();
                }
            } else {
                poseStack.last().normal().set((Matrix3fc)poseStack.last().normal().rotate((Quaternionfc)BLOCK_LIGHT_ROTATION_3D));
                Minecraft.getInstance().getBlockRenderer().renderSingleBlock(blockState, poseStack, buffer, combinedLight, combinedOverlay, ModelData.EMPTY, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        poseStack.popPose();
    }

    public static int adjustCombinedLight(int currentCombinedLight, int otherBlockLight) {
        int currentBlockLight = currentCombinedLight >> 4 & 0xFFFF;
        int currentSkyLight = currentCombinedLight >> 20 & 0xFFFF;
        int adjustedBlockLight = Math.max(currentBlockLight, otherBlockLight);
        return LightTexture.pack((int)adjustedBlockLight, (int)currentSkyLight);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderFluidBlockGUI(PoseStack poseStack, MultiBufferSource renderTypeBuffer, FluidStack fluidStack, float alpha, int combinedLight, int combinedOverlay) {
        VertexConsumer vertexBuilder = renderTypeBuffer.getBuffer(RenderType.translucent());
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getStillTexture(fluidStack));
        int color = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        PageDrawing.renderQuadsBlock(poseStack.last().pose(), vertexBuilder, sprite, red, green, blue, alpha *= (float)(color >> 24 & 0xFF) / 255.0f, combinedLight, combinedOverlay);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderQuadsBlock(Matrix4f matrix, VertexConsumer vertexBuilder, TextureAtlasSprite sprite, float r, float g, float b, float alpha, int light, int overlay) {
        float height = 0.75f;
        float minU = sprite.getU(CORNERS);
        float maxU = sprite.getU(1.0f - CORNERS);
        float minV = sprite.getV(CORNERS);
        float maxV = sprite.getV(1.0f - CORNERS);
        vertexBuilder.addVertex(matrix, CORNERS / 5.0f, height, CORNERS / 5.0f).setColor(r, g, b, alpha).setUv(minU, minV).setOverlay(overlay).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
        vertexBuilder.addVertex(matrix, CORNERS / 5.0f, height, 1.0f - CORNERS / 5.0f).setColor(r, g, b, alpha).setUv(minU, maxV).setOverlay(overlay).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
        vertexBuilder.addVertex(matrix, 1.0f - CORNERS / 5.0f, height, 1.0f - CORNERS / 5.0f).setColor(r, g, b, alpha).setUv(maxU, maxV).setOverlay(overlay).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
        vertexBuilder.addVertex(matrix, 1.0f - CORNERS / 5.0f, height, CORNERS / 5.0f).setColor(r, g, b, alpha).setUv(maxU, minV).setOverlay(overlay).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
        float shading = 0.75f;
        vertexBuilder.addVertex(matrix, CORNERS / 5.0f, height, 1.0f - CORNERS / 5.0f).setColor(r * shading, g * shading, b * shading, alpha).setUv(minU, minV).setOverlay(overlay).setLight(light).setNormal(-1.0f, 0.0f, 0.0f);
        vertexBuilder.addVertex(matrix, CORNERS / 5.0f, height, CORNERS / 5.0f).setColor(r * shading, g * shading, b * shading, alpha).setUv(minU, maxV).setOverlay(overlay).setLight(light).setNormal(-1.0f, 0.0f, 0.0f);
        vertexBuilder.addVertex(matrix, CORNERS / 5.0f, 0.0f, CORNERS / 5.0f).setColor(r * shading, g * shading, b * shading, alpha).setUv(maxU, maxV).setOverlay(overlay).setLight(light).setNormal(-1.0f, 0.0f, 0.0f);
        vertexBuilder.addVertex(matrix, CORNERS / 5.0f, 0.0f, 1.0f - CORNERS / 5.0f).setColor(r * shading, g * shading, b * shading, alpha).setUv(maxU, minV).setOverlay(overlay).setLight(light).setNormal(-1.0f, 0.0f, 0.0f);
        shading = 0.45f;
        vertexBuilder.addVertex(matrix, 1.0f - CORNERS / 5.0f, height, 1.0f - CORNERS / 5.0f).setColor(r * shading, g * shading, b * shading, alpha).setUv(minU, minV).setOverlay(overlay).setLight(light).setNormal(0.0f, 0.0f, -1.0f);
        vertexBuilder.addVertex(matrix, CORNERS / 5.0f, height, 1.0f - CORNERS / 5.0f).setColor(r * shading, g * shading, b * shading, alpha).setUv(minU, maxV).setOverlay(overlay).setLight(light).setNormal(0.0f, 0.0f, -1.0f);
        vertexBuilder.addVertex(matrix, CORNERS / 5.0f, 0.0f, 1.0f - CORNERS / 5.0f).setColor(r * shading, g * shading, b * shading, alpha).setUv(maxU, maxV).setOverlay(overlay).setLight(light).setNormal(0.0f, 0.0f, -1.0f);
        vertexBuilder.addVertex(matrix, 1.0f - CORNERS / 5.0f, 0.0f, 1.0f - CORNERS / 5.0f).setColor(r * shading, g * shading, b * shading, alpha).setUv(maxU, minV).setOverlay(overlay).setLight(light).setNormal(0.0f, 0.0f, -1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderGuiItemDecorations(MultiBufferSource bufferSource, Font font, ItemStack itemStack, PoseStack poseStack, float xIn, float yIn, int overlay, int light) {
        if (itemStack.isBarVisible()) {
            poseStack.pushPose();
            int i = itemStack.getBarWidth();
            int j = itemStack.getBarColor();
            poseStack.translate(0.0f, 0.0f, -4.15f);
            PageDrawing.fillRect(poseStack, bufferSource, xIn + 2.75f, yIn + 13.75f, 0.0f, 13.0f, 1.5f, 0, 0, 0, 255, overlay, light);
            PageDrawing.fillRect(poseStack, bufferSource, xIn + 2.75f, yIn + 13.75f, -0.5f, i, 1.0f, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255, overlay, light);
            poseStack.popPose();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderGuiItemCount(MultiBufferSource bufferSource, Font font, ItemStack itemStack, PoseStack poseStack, float xIn, float yIn, int overlay, int light) {
        if (itemStack.getCount() > 1) {
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, -7.0f);
            String s = String.valueOf(itemStack.getCount());
            MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.getInstance().renderBuffers().bufferSource();
            font.drawInBatch(s, xIn + 19.0f - 2.0f - (float)font.width(s) + 1.0f, yIn + 6.0f + 3.0f + 1.0f, HexereiUtil.getColorValueAlpha(0.245f, 0.245f, 0.245f, 1.0f), false, poseStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, overlay, light);
            poseStack.translate(0.0f, 0.0f, -6.0f);
            font.drawInBatch(s, xIn + 19.0f - 2.0f - (float)font.width(s), yIn + 6.0f + 3.0f, 0xFFFFFF, false, poseStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, overlay, light);
            multibuffersource$buffersource.endBatch();
            poseStack.popPose();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderGuiItem(MultiBufferSource bufferSource, Font font, ItemStack itemStack, PoseStack poseStack, float xIn, float yIn, int overlay, int light) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        poseStack.pushPose();
        poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        poseStack.scale(16.0f, 16.0f, 1.0f);
        poseStack.translate(yIn * 1.25f * 2.0f / 40.0f + 0.55f, -xIn * 1.25f * 2.0f / 40.0f - 0.55f, -2.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        try {
            BakedModel itemModel = itemRenderer.getModel(itemStack, null, null, 0);
            if (itemModel.isGui3d()) {
                poseStack.last().normal().set((Matrix3fc)poseStack.last().normal().rotate((Quaternionfc)ITEM_LIGHT_ROTATION_3D));
            } else {
                poseStack.last().normal().set((Matrix3fc)poseStack.last().normal().rotate((Quaternionfc)ITEM_LIGHT_ROTATION_FLAT));
            }
            itemRenderer.render(itemStack, ItemDisplayContext.GUI, false, poseStack, bufferSource, light, overlay, itemModel);
        }
        catch (Exception exception) {
            // empty catch block
        }
        poseStack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void fill(RenderType renderType, PoseStack poseStack, MultiBufferSource bufferSource, float xIn, float yIn, float zIn, float widthIn, float heightIn, int p_115158_, int p_115159_, int p_115160_, int p_115161_, int overlay, int light) {
        poseStack.pushPose();
        PoseStack.Pose normal = poseStack.last();
        Matrix4f matrix4f = poseStack.last().pose();
        boolean u = false;
        boolean v = false;
        boolean imageWidth = true;
        boolean imageHeight = true;
        boolean width = true;
        boolean height = true;
        float u1 = ((float)u + 0.0f) / (float)imageWidth;
        float u2 = ((float)u + (float)width) / (float)imageWidth;
        float v1 = ((float)v + 0.0f) / (float)imageHeight;
        float v2 = ((float)v + (float)height) / (float)imageHeight;
        VertexConsumer buffer = bufferSource.getBuffer(renderType);
        buffer.addVertex(matrix4f, xIn + 0.0f, yIn + 0.0f, zIn).setColor(p_115158_, p_115159_, p_115160_, p_115161_).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(normal, -1.0f, -1.0f, 0.0f);
        buffer.addVertex(matrix4f, xIn + 0.0f, yIn + heightIn, zIn).setColor(p_115158_, p_115159_, p_115160_, p_115161_).setUv(u1, v2).setOverlay(overlay).setLight(light).setNormal(normal, -1.0f, -1.0f, 0.0f);
        buffer.addVertex(matrix4f, xIn + widthIn, yIn + heightIn, zIn).setColor(p_115158_, p_115159_, p_115160_, p_115161_).setUv(u2, v2).setOverlay(overlay).setLight(light).setNormal(normal, -1.0f, -1.0f, 0.0f);
        buffer.addVertex(matrix4f, xIn + widthIn, yIn + 0.0f, zIn).setColor(p_115158_, p_115159_, p_115160_, p_115161_).setUv(u2, v1).setOverlay(overlay).setLight(light).setNormal(normal, -1.0f, -1.0f, 0.0f);
        poseStack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void fillRect(PoseStack poseStack, MultiBufferSource p_115153_, float xIn, float yIn, float zIn, float widthIn, float heightIn, int p_115158_, int p_115159_, int p_115160_, int p_115161_, int overlay, int light) {
        poseStack.pushPose();
        PoseStack.Pose normal = poseStack.last();
        Matrix4f matrix4f = poseStack.last().pose();
        boolean u = false;
        boolean v = false;
        boolean imageWidth = true;
        boolean imageHeight = true;
        boolean width = true;
        boolean height = true;
        float u1 = ((float)u + 0.0f) / (float)imageWidth;
        float u2 = ((float)u + (float)width) / (float)imageWidth;
        float v1 = ((float)v + 0.0f) / (float)imageHeight;
        float v2 = ((float)v + (float)height) / (float)imageHeight;
        VertexConsumer buffer = p_115153_.getBuffer(RenderType.entityCutout((ResourceLocation)ResourceLocation.parse((String)"hexerei:textures/book/blank.png")));
        buffer.addVertex(matrix4f, xIn + 0.0f, yIn + 0.0f, zIn).setColor(p_115158_, p_115159_, p_115160_, p_115161_).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix4f, xIn + 0.0f, yIn + heightIn, zIn).setColor(p_115158_, p_115159_, p_115160_, p_115161_).setUv(u1, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix4f, xIn + widthIn, yIn + heightIn, zIn).setColor(p_115158_, p_115159_, p_115160_, p_115161_).setUv(u2, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix4f, xIn + widthIn, yIn + 0.0f, zIn).setColor(p_115158_, p_115159_, p_115160_, p_115161_).setUv(u2, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        poseStack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void translateToLeftPageUnder(BookOfShadowsAltarTile altarTile, PoseStack poseStack, DrawingType drawingType, ItemDisplayContext transformType) {
        float yPos = 0.0f;
        float xPos = 0.0f;
        float zPos = 0.0f;
        float degreesOpened = 0.0f;
        if (transformType == ItemDisplayContext.GUI) {
            yPos = 0.1875f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.375f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.03125f;
        }
        poseStack.translate(0.5f + xPos, 1.125f + yPos, 0.5f + zPos);
        poseStack.translate((float)Math.sin(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f));
        poseStack.translate(0.0f, (BookOfShadowsAltarTile.easeFlop(1.0f - altarTile.degreesFlopped / 90.0f) - 1.0f) / 16.0f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(altarTile.degreesSpunRender));
        if (drawingType == DrawingType.BOOK) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpenedRender / 2.0f + 45.0f)));
        } else if (drawingType == DrawingType.GUI) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpenedRender / 2.0f - 10.0f)));
        } else if (drawingType == DrawingType.SCREEN) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        }
        if (drawingType == DrawingType.GUI && transformType != ItemDisplayContext.NONE) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-55.0f));
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(-altarTile.degreesFloppedRender));
        poseStack.translate(0.0f, 0.0f, -(altarTile.degreesFloppedRender / 10.0f) / 32.0f);
        poseStack.translate(0.0f, 0.03125f, 0.0f);
        if (drawingType == DrawingType.SCREEN) {
            poseStack.mulPose(Axis.ZP.rotationDegrees(-(90.0f - altarTile.degreesOpenedRender)));
            poseStack.mulPose(Axis.ZP.rotationDegrees(-(90.0f - altarTile.degreesOpenedRender) / 90.0f * -altarTile.pageTwoRotationRender));
        } else {
            poseStack.mulPose(Axis.ZP.rotationDegrees(-(80.0f - altarTile.degreesOpenedRender / 1.12f)));
            poseStack.mulPose(Axis.ZP.rotationDegrees(-(80.0f - altarTile.degreesOpenedRender / 1.12f) / 90.0f * -altarTile.pageTwoRotationRender));
            poseStack.mulPose(Axis.ZP.rotationDegrees(-(80.0f - altarTile.degreesOpenedRender / 1.12f) / 90.0f * (altarTile.pageOneRotationRender / 16.0f)));
        }
        poseStack.mulPose(Axis.ZP.rotationDegrees(-180.0f));
        poseStack.translate(0.0f, -0.3828125f, 0.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void translateToLeftPage(BookOfShadowsAltarTile altarTile, PoseStack poseStack, DrawingType drawingType, ItemDisplayContext transformType) {
        float yPos = 0.0f;
        float xPos = 0.0f;
        float zPos = 0.0f;
        float degreesOpened = 0.0f;
        if (transformType == ItemDisplayContext.GUI) {
            yPos = 0.1875f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.375f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.03125f;
        }
        poseStack.translate(0.5f + xPos, 1.125f + yPos, 0.5f + zPos);
        poseStack.translate((float)Math.sin(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f));
        poseStack.translate(0.0f, (BookOfShadowsAltarTile.easeFlop(1.0f - altarTile.degreesFlopped / 90.0f) - 1.0f) / 16.0f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(altarTile.degreesSpunRender));
        if (drawingType == DrawingType.BOOK) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpenedRender / 2.0f + 45.0f)));
        } else if (drawingType == DrawingType.GUI) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpenedRender / 2.0f - 10.0f)));
        } else if (drawingType == DrawingType.SCREEN) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        }
        if (drawingType == DrawingType.GUI && transformType != ItemDisplayContext.NONE) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-55.0f));
        }
        poseStack.mulPose(Axis.XP.rotationDegrees(degreesOpened));
        poseStack.mulPose(Axis.YP.rotationDegrees(-altarTile.degreesFloppedRender));
        poseStack.translate(0.0f, 0.0f, -(altarTile.degreesFloppedRender / 10.0f) / 33.0f);
        poseStack.translate(0.0f, 0.03125f, 0.0f);
        if (drawingType == DrawingType.SCREEN) {
            poseStack.mulPose(Axis.ZP.rotationDegrees(-(90.0f - altarTile.degreesOpenedRender)));
            poseStack.mulPose(Axis.ZP.rotationDegrees(-(90.0f - altarTile.degreesOpenedRender) / 90.0f * -altarTile.pageTwoRotationRender));
        } else {
            poseStack.mulPose(Axis.ZP.rotationDegrees(-(80.0f - altarTile.degreesOpenedRender / 1.12f)));
            poseStack.mulPose(Axis.ZP.rotationDegrees(-(80.0f - altarTile.degreesOpenedRender / 1.12f) / 90.0f * -altarTile.pageTwoRotationRender));
            poseStack.mulPose(Axis.ZP.rotationDegrees(-(80.0f - altarTile.degreesOpenedRender / 1.12f) / 90.0f * (altarTile.pageOneRotationRender / 16.0f)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void translateToRightPageUnder(BookOfShadowsAltarTile altarTile, PoseStack poseStack, DrawingType drawingType, ItemDisplayContext transformType) {
        float yPos = 0.0f;
        float xPos = 0.0f;
        float zPos = 0.0f;
        float degreesOpened = 0.0f;
        if (transformType == ItemDisplayContext.GUI) {
            yPos = 0.1875f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.375f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.03125f;
        }
        poseStack.translate(0.5f + xPos, 1.125f + yPos, 0.5f + zPos);
        poseStack.translate((float)Math.sin(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f));
        poseStack.translate(0.0f, (BookOfShadowsAltarTile.easeFlop(1.0f - altarTile.degreesFlopped / 90.0f) - 1.0f) / 16.0f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(altarTile.degreesSpunRender));
        if (drawingType == DrawingType.BOOK) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpenedRender / 2.0f + 45.0f)));
        } else if (drawingType == DrawingType.GUI) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpenedRender / 2.0f - 10.0f)));
        } else if (drawingType == DrawingType.SCREEN) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        }
        if (drawingType == DrawingType.GUI && transformType != ItemDisplayContext.NONE) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-55.0f));
        }
        poseStack.mulPose(Axis.XP.rotationDegrees(degreesOpened));
        poseStack.mulPose(Axis.YP.rotationDegrees(-altarTile.degreesFloppedRender));
        poseStack.translate(0.0f, 0.0f, -(altarTile.degreesFloppedRender / 10.0f) / 32.0f);
        poseStack.translate(0.0f, 0.03125f, 0.0f);
        if (drawingType == DrawingType.SCREEN) {
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f - altarTile.degreesOpenedRender));
            poseStack.mulPose(Axis.ZP.rotationDegrees((90.0f - altarTile.degreesOpenedRender) / 90.0f * -altarTile.pageOneRotationRender));
        } else {
            poseStack.mulPose(Axis.ZP.rotationDegrees(80.0f - altarTile.degreesOpenedRender / 1.12f));
            poseStack.mulPose(Axis.ZP.rotationDegrees((80.0f - altarTile.degreesOpenedRender / 1.12f) / 90.0f * -altarTile.pageOneRotationRender));
            poseStack.mulPose(Axis.ZP.rotationDegrees((80.0f - altarTile.degreesOpenedRender / 1.12f) / 90.0f * (altarTile.pageTwoRotationRender / 16.0f)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void translateToRightPage(BookOfShadowsAltarTile altarTile, PoseStack poseStack, DrawingType drawingType, ItemDisplayContext transformType) {
        float yPos = 0.0f;
        float xPos = 0.0f;
        float zPos = 0.0f;
        float degreesOpened = 0.0f;
        if (transformType == ItemDisplayContext.GUI) {
            yPos = 0.1875f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.375f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.03125f;
        }
        poseStack.translate(0.5f + xPos, 1.125f + yPos, 0.5f + zPos);
        poseStack.translate((float)Math.sin(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f));
        poseStack.translate(0.0f, (BookOfShadowsAltarTile.easeFlop(1.0f - altarTile.degreesFlopped / 90.0f) - 1.0f) / 16.0f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(altarTile.degreesSpunRender));
        if (drawingType == DrawingType.BOOK) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpenedRender / 2.0f + 45.0f)));
        } else if (drawingType == DrawingType.GUI) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpenedRender / 2.0f - 10.0f)));
        } else if (drawingType == DrawingType.SCREEN) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        }
        if (drawingType == DrawingType.GUI && transformType != ItemDisplayContext.NONE) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-55.0f));
        }
        poseStack.mulPose(Axis.XP.rotationDegrees(degreesOpened));
        poseStack.mulPose(Axis.YP.rotationDegrees(-altarTile.degreesFloppedRender));
        poseStack.translate(0.0f, 0.0f, -(altarTile.degreesFloppedRender / 10.0f) / 32.0f);
        poseStack.translate(0.0f, 0.03125f, 0.0f);
        if (drawingType == DrawingType.SCREEN) {
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f - altarTile.degreesOpenedRender));
            poseStack.mulPose(Axis.ZP.rotationDegrees((90.0f - altarTile.degreesOpenedRender) / 90.0f * -altarTile.pageOneRotationRender));
        } else {
            poseStack.mulPose(Axis.ZP.rotationDegrees(80.0f - altarTile.degreesOpenedRender / 1.12f));
            poseStack.mulPose(Axis.ZP.rotationDegrees((80.0f - altarTile.degreesOpenedRender / 1.12f) / 90.0f * -altarTile.pageOneRotationRender));
            poseStack.mulPose(Axis.ZP.rotationDegrees((80.0f - altarTile.degreesOpenedRender / 1.12f) / 90.0f * (altarTile.pageTwoRotationRender / 16.0f)));
        }
        poseStack.mulPose(Axis.ZP.rotationDegrees(-180.0f));
        poseStack.translate(0.0f, -0.3828125f, 0.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void translateToLeftPagePrevious(BookOfShadowsAltarTile altarTile, PoseStack poseStack, DrawingType drawingType, ItemDisplayContext transformType) {
        float yPos = 0.0f;
        float xPos = 0.0f;
        float zPos = 0.0f;
        float degreesOpened = 0.0f;
        if (transformType == ItemDisplayContext.GUI) {
            yPos = 0.1875f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.375f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.03125f;
        }
        poseStack.translate(0.5f + xPos, 1.125f + yPos, 0.5f + zPos);
        poseStack.translate((float)Math.sin(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f));
        poseStack.translate(0.0f, (BookOfShadowsAltarTile.easeFlop(1.0f - altarTile.degreesFlopped / 90.0f) - 1.0f) / 16.0f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(altarTile.degreesSpunRender));
        if (drawingType == DrawingType.BOOK) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpenedRender / 2.0f + 45.0f)));
        } else if (drawingType == DrawingType.GUI) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpenedRender / 2.0f - 10.0f)));
        } else if (drawingType == DrawingType.SCREEN) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        }
        if (drawingType == DrawingType.GUI && transformType != ItemDisplayContext.NONE) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-55.0f));
        }
        poseStack.mulPose(Axis.XP.rotationDegrees(degreesOpened));
        poseStack.mulPose(Axis.YP.rotationDegrees(-altarTile.degreesFloppedRender));
        poseStack.translate(0.0f, 0.0f, -(altarTile.degreesFloppedRender / 10.0f) / 33.0f);
        poseStack.translate(0.0f, 0.03125f, 0.0f);
        if (drawingType == DrawingType.SCREEN) {
            poseStack.mulPose(Axis.ZP.rotationDegrees(-(90.0f - altarTile.degreesOpenedRender)));
        } else {
            poseStack.mulPose(Axis.ZP.rotationDegrees(-(80.0f - altarTile.degreesOpenedRender / 1.12f)));
            poseStack.mulPose(Axis.ZP.rotationDegrees(-(80.0f - altarTile.degreesOpenedRender / 1.12f) / 90.0f * (-altarTile.pageTwoRotationRender / 16.0f + 11.25f)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void translateToRightPagePrevious(BookOfShadowsAltarTile altarTile, PoseStack poseStack, DrawingType drawingType, ItemDisplayContext transformType) {
        float yPos = 0.0f;
        float xPos = 0.0f;
        float zPos = 0.0f;
        float degreesOpened = 0.0f;
        if (transformType == ItemDisplayContext.GUI) {
            yPos = 0.1875f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.375f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.03125f;
        }
        poseStack.translate(0.5f + xPos, 1.125f + yPos, 0.5f + zPos);
        poseStack.translate((float)Math.sin(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f));
        poseStack.translate(0.0f, (BookOfShadowsAltarTile.easeFlop(1.0f - altarTile.degreesFlopped / 90.0f) - 1.0f) / 16.0f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(altarTile.degreesSpunRender));
        if (drawingType == DrawingType.BOOK) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpenedRender / 2.0f + 45.0f)));
        } else if (drawingType == DrawingType.GUI) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpenedRender / 2.0f - 10.0f)));
        } else if (drawingType == DrawingType.SCREEN) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        }
        if (drawingType == DrawingType.GUI && transformType != ItemDisplayContext.NONE) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-55.0f));
        }
        poseStack.mulPose(Axis.XP.rotationDegrees(degreesOpened));
        poseStack.mulPose(Axis.YP.rotationDegrees(-altarTile.degreesFloppedRender));
        poseStack.translate(0.0f, 0.0f, -(altarTile.degreesFloppedRender / 10.0f) / 32.0f);
        poseStack.translate(0.0f, 0.03125f, 0.0f);
        if (drawingType == DrawingType.SCREEN) {
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f - altarTile.degreesOpenedRender));
        } else {
            poseStack.mulPose(Axis.ZP.rotationDegrees(80.0f - altarTile.degreesOpenedRender / 1.12f));
            poseStack.mulPose(Axis.ZP.rotationDegrees((80.0f - altarTile.degreesOpenedRender / 1.12f) / 90.0f * (-altarTile.pageOneRotationRender / 16.0f + 11.25f)));
        }
        poseStack.mulPose(Axis.ZP.rotationDegrees(-180.0f));
        poseStack.translate(0.0f, -0.3828125f, 0.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void translateToLeftPagePrevious2(BookOfShadowsAltarTile altarTile, PoseStack poseStack, DrawingType drawingType, ItemDisplayContext transformType) {
        float yPos = 0.0f;
        float xPos = 0.0f;
        float zPos = 0.0f;
        float degreesOpened = 0.0f;
        if (transformType == ItemDisplayContext.GUI) {
            yPos = 0.1875f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.375f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.03125f;
        }
        poseStack.translate(0.5f + xPos, 1.125f + yPos, 0.5f + zPos);
        poseStack.translate((float)Math.sin(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f));
        poseStack.translate(0.0f, (BookOfShadowsAltarTile.easeFlop(1.0f - altarTile.degreesFlopped / 90.0f) - 1.0f) / 16.0f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(altarTile.degreesSpunRender));
        if (drawingType == DrawingType.BOOK) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpenedRender / 2.0f + 45.0f)));
        } else if (drawingType == DrawingType.GUI) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpenedRender / 2.0f - 10.0f)));
        } else if (drawingType == DrawingType.SCREEN) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        }
        if (drawingType == DrawingType.GUI && transformType != ItemDisplayContext.NONE) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-55.0f));
        }
        poseStack.mulPose(Axis.XP.rotationDegrees(degreesOpened));
        poseStack.mulPose(Axis.YP.rotationDegrees(-altarTile.degreesFloppedRender));
        poseStack.translate(0.0f, 0.0f, -(altarTile.degreesFloppedRender / 10.0f) / 33.0f);
        poseStack.translate(0.0f, 0.03125f, 0.0f);
        if (drawingType == DrawingType.SCREEN) {
            poseStack.mulPose(Axis.ZP.rotationDegrees(-(90.0f - altarTile.degreesOpenedRender)));
        } else {
            poseStack.mulPose(Axis.ZP.rotationDegrees(-(80.0f - altarTile.degreesOpenedRender / 1.12f)));
            poseStack.mulPose(Axis.ZP.rotationDegrees(-(80.0f - altarTile.degreesOpenedRender / 1.12f) / 90.0f * 11.25f));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void translateToRightPagePrevious2(BookOfShadowsAltarTile altarTile, PoseStack poseStack, DrawingType drawingType, ItemDisplayContext transformType) {
        float yPos = 0.0f;
        float xPos = 0.0f;
        float zPos = 0.0f;
        float degreesOpened = 0.0f;
        if (transformType == ItemDisplayContext.GUI) {
            yPos = 0.1875f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.375f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.03125f;
        }
        poseStack.translate(0.5f + xPos, 1.125f + yPos, 0.5f + zPos);
        poseStack.translate((float)Math.sin(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f));
        poseStack.translate(0.0f, (BookOfShadowsAltarTile.easeFlop(1.0f - altarTile.degreesFlopped / 90.0f) - 1.0f) / 16.0f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(altarTile.degreesSpunRender));
        if (drawingType == DrawingType.BOOK) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpenedRender / 2.0f + 45.0f)));
        } else if (drawingType == DrawingType.GUI) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpenedRender / 2.0f - 10.0f)));
        } else if (drawingType == DrawingType.SCREEN) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        }
        if (drawingType == DrawingType.GUI && transformType != ItemDisplayContext.NONE) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-55.0f));
        }
        poseStack.mulPose(Axis.XP.rotationDegrees(degreesOpened));
        poseStack.mulPose(Axis.YP.rotationDegrees(-altarTile.degreesFloppedRender));
        poseStack.translate(0.0f, 0.0f, -(altarTile.degreesFloppedRender / 10.0f) / 32.0f);
        poseStack.translate(0.0f, 0.03125f, 0.0f);
        if (drawingType == DrawingType.SCREEN) {
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f - altarTile.degreesOpenedRender));
        } else {
            poseStack.mulPose(Axis.ZP.rotationDegrees(80.0f - altarTile.degreesOpenedRender / 1.12f));
            poseStack.mulPose(Axis.ZP.rotationDegrees((80.0f - altarTile.degreesOpenedRender / 1.12f) / 90.0f * 11.25f));
        }
        poseStack.mulPose(Axis.ZP.rotationDegrees(-180.0f));
        poseStack.translate(0.0f, -0.3828125f, 0.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void translateToMiddleButton(BookOfShadowsAltarTile altarTile, PoseStack poseStack, DrawingType drawingType, ItemDisplayContext transformType) {
        float yPos = 0.0f;
        float xPos = 0.0f;
        float zPos = 0.0f;
        float degreesOpened = 0.0f;
        if (transformType == ItemDisplayContext.GUI) {
            yPos = 0.1875f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.375f;
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            degreesOpened = 90.0f;
            xPos = 0.25f;
            zPos = -0.03125f;
        }
        poseStack.translate(0.5f + xPos, 1.125f + yPos, 0.5f + zPos);
        poseStack.translate((float)Math.sin(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f));
        poseStack.translate(0.0f, (BookOfShadowsAltarTile.easeFlop(1.0f - altarTile.degreesFlopped / 90.0f) - 1.0f) / 16.0f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(altarTile.degreesSpunRender));
        if (drawingType == DrawingType.BOOK) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpenedRender / 2.0f + 45.0f)));
        } else if (drawingType == DrawingType.GUI) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpenedRender / 2.0f - 13.0f)));
        } else if (drawingType == DrawingType.SCREEN) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        }
        if (drawingType == DrawingType.GUI && transformType != ItemDisplayContext.NONE) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-55.0f));
        }
        poseStack.mulPose(Axis.XP.rotationDegrees(degreesOpened));
        poseStack.mulPose(Axis.YP.rotationDegrees(-altarTile.degreesFloppedRender));
        poseStack.translate(0.0f, 0.0f, -(altarTile.degreesFloppedRender / 10.0f) / 32.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
        poseStack.translate(0.04609375f, 0.44375f, 0.34375f);
        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(-180.0f));
    }

    public void drawPage(BookPage page, BookOfShadowsAltarTile altarTile, float leftCursorX, float leftCursorY, float rightCursorX, float rightCursorY, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, PageOn pageOn, DrawingType drawingType, ItemDisplayContext transformType, float partial) {
        this.drawPage(page, altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferIn, combinedLightIn, combinedOverlayIn, pageOn, drawingType, transformType, -1, partial);
    }

    public void drawPage(BookPage page, BookOfShadowsAltarTile altarTile, float leftCursorX, float leftCursorY, float rightCursorX, float rightCursorY, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, PageOn pageOn, DrawingType drawingType, ItemDisplayContext transformType, int pageNum, float partial) {
        boolean left = pageOn == PageOn.LEFT_PAGE || pageOn == PageOn.LEFT_PAGE_PREV || pageOn == PageOn.RIGHT_PAGE_UNDER;
        BookEntries bookEntries = BookManager.getBookEntries(altarTile.currentBook.getBook());
        if (page != null && bookEntries != null) {
            BookParagraph bookParagraph2;
            for (BookPaintElement paintElement : page.paintElements) {
                this.drawPaintElement(paintElement, altarTile, pageOn == PageOn.LEFT_PAGE ? leftCursorX : rightCursorX, pageOn == PageOn.LEFT_PAGE ? leftCursorY : rightCursorY, poseStack, bufferIn, -0.25f, combinedLightIn, combinedOverlayIn, pageOn, -1, drawingType, transformType, partial);
            }
            for (BookWritableTextBox writableTextBox : page.writableTextBoxes) {
                this.drawString(writableTextBox, altarTile, poseStack, bufferIn, pageOn == PageOn.LEFT_PAGE ? leftCursorX : rightCursorX, pageOn == PageOn.LEFT_PAGE ? leftCursorY : rightCursorY, 0.0f, combinedLightIn, combinedOverlayIn, pageOn, drawingType);
            }
            for (BookParagraph bookParagraph2 : page.paragraph) {
                this.drawString(bookParagraph2, altarTile, poseStack, bufferIn, 0.0f, 0.0f, 0.0f, combinedLightIn, combinedOverlayIn, pageOn, drawingType);
            }
            int pageOnNum = pageNum + 1 - bookEntries.chapterList.getFirst().endPage;
            bookParagraph2 = new BookParagraph(new ArrayList<BookParagraphElements>(List.of(new BookParagraphElements(left ? 14.3f : 0.0f, 19.25f, 1.0f, 30.0f, "top"))), pageOnNum > 0 ? String.valueOf(pageOnNum) : HexereiUtil.intToRoman(pageNum + 1), "left");
            if (left) {
                bookParagraph2.paragraphElements.getFirst().x -= (float)Minecraft.getInstance().font.width(bookParagraph2.passage) / 8.0f;
            }
            this.drawString(bookParagraph2, altarTile, poseStack, bufferIn, 0.0f, 0.0f, 0.0f, combinedLightIn, combinedOverlayIn, pageOn, drawingType);
            for (BookItemsAndFluids bookItemStackInSlot : page.itemList) {
                this.drawItemInSlot(altarTile, bookItemStackInSlot, poseStack, bufferIn, bookItemStackInSlot.x, bookItemStackInSlot.y, 0.0f, combinedLightIn, combinedOverlayIn, pageOn, drawingType);
            }
            for (BookBlocks bookBlocks : page.blockList) {
                this.drawBlock(altarTile, bookBlocks, poseStack, bufferIn, bookBlocks.x, bookBlocks.y, 0.0f, combinedLightIn, combinedOverlayIn, pageOn, drawingType);
            }
            if (transformType == ItemDisplayContext.NONE && (pageOn == PageOn.LEFT_PAGE || pageOn == PageOn.RIGHT_PAGE)) {
                ArrayList<BookImageEffect> effects;
                for (BookItemsAndFluids bookItemStackInSlot : page.itemList) {
                    if (PageDrawing.canInteract(pageOn == PageOn.LEFT_PAGE ? leftCursorX : rightCursorX, pageOn == PageOn.LEFT_PAGE ? leftCursorY : rightCursorY, bookItemStackInSlot.x, bookItemStackInSlot.y, 0.86f, 0.86f, altarTile, drawingType)) {
                        if (bookItemStackInSlot.item != null) {
                            if (!bookItemStackInSlot.item.isEmpty()) {
                                this.tooltipStack = bookItemStackInSlot.item;
                                this.tooltipText = bookItemStackInSlot.extra_tooltips;
                                this.drawTooltipStack = true;
                            }
                        } else {
                            this.tooltipText = PageDrawing.getFluidTooltip(bookItemStackInSlot);
                            this.tooltipStack = ItemStack.EMPTY;
                            this.drawTooltipText = true;
                        }
                        this.slotOverlay.x = bookItemStackInSlot.x;
                        this.slotOverlay.y = bookItemStackInSlot.y;
                        effects = new ArrayList<BookImageEffect>();
                        effects.add(new BookImageEffect("scale", 20.0f, 1.1f));
                        this.slotOverlay.effects = effects;
                        this.slotOverlayPageOn = pageOn;
                        this.drawSlotOverlay = true;
                        break;
                    }
                    if (!this.drawTooltipStack) continue;
                    break;
                }
                for (BookBlocks bookBlock : page.blockList) {
                    if (PageDrawing.canInteract(pageOn == PageOn.LEFT_PAGE ? leftCursorX : rightCursorX, pageOn == PageOn.LEFT_PAGE ? leftCursorY : rightCursorY, bookBlock.x, bookBlock.y, 0.86f, 0.86f, altarTile, drawingType)) {
                        if (!bookBlock.blockState.is(Blocks.AIR)) {
                            ArrayList<Component> tooltipList = new ArrayList<Component>(bookBlock.extra_tooltips);
                            tooltipList.addFirst((Component)bookBlock.blockState.getBlock().getName().withStyle(ChatFormatting.WHITE));
                            this.tooltipText = tooltipList;
                            this.drawTooltipText = true;
                            this.tooltipStack = ItemStack.EMPTY;
                        }
                        this.slotOverlay.x = bookBlock.x;
                        this.slotOverlay.y = bookBlock.y;
                        effects = new ArrayList();
                        effects.add(new BookImageEffect("scale", 20.0f, 1.1f));
                        this.slotOverlay.effects = effects;
                        this.slotOverlayPageOn = pageOn;
                        this.drawSlotOverlay = true;
                        break;
                    }
                    if (!this.drawTooltipText) continue;
                    break;
                }
                for (BookEntity bookEntity : page.entityList) {
                    float yIn;
                    float width;
                    float xIn;
                    bookEntity.hoverTickRender = this.easeInOutElastic(Mth.lerp((float)partial, (float)bookEntity.hoverTickO, (float)bookEntity.hoverTick));
                    if (bookEntity.entity != null) {
                        bookEntity.entity.tickCount = (int)ClientEvents.getClientTicksWithoutPartial();
                    }
                    if (PageDrawing.canInteract(pageOn == PageOn.LEFT_PAGE ? leftCursorX : rightCursorX, pageOn == PageOn.LEFT_PAGE ? leftCursorY : rightCursorY, (xIn = bookEntity.x + bookEntity.offset.x + 0.52f) - (width = 1.25f + bookEntity.scale / 5.0f) / 2.0f, (yIn = bookEntity.y + bookEntity.offset.y) - width / 2.0f, width, width, altarTile, drawingType)) {
                        bookEntity.hovered = true;
                    }
                    if (!(bookEntity.hoverTickRender > 0.0f)) continue;
                    BookImage bookImage = new BookImage(bookEntity.x, bookEntity.y + 0.5f, 0.0f, 0.0f, 0.0f, 64.0f, 32.0f, 64.0f, 32.0f, 0.75f * bookEntity.hoverTickRender, "hexerei:textures/book/rotate_entity.png", new ArrayList<BookImageEffect>());
                    this.drawImage(bookImage, altarTile, pageOn == PageOn.LEFT_PAGE ? leftCursorX : rightCursorX, pageOn == PageOn.LEFT_PAGE ? leftCursorY : rightCursorY, poseStack, bufferIn, 0.0f, combinedLightIn, combinedOverlayIn, pageOn, drawingType);
                    float lerpRotate = Mth.lerp((float)ClientEvents.getPartial(), (float)bookEntity.toRotateO, (float)bookEntity.toRotate);
                    float v = Math.clamp(lerpRotate / 2000.0f, -0.8f, 0.8f);
                    float v1 = (float)Math.pow(Math.min(Math.abs(lerpRotate) / 4000.0f, 0.4f), 2.0) * 2.25f;
                    BookImage bookImage2 = bookEntity.clicked ? new BookImage(bookEntity.x - v, bookEntity.y + 0.85f - v1, 1.0f, 0.0f, 0.0f, 32.0f, 48.0f, 32.0f, 48.0f, 0.45f * bookEntity.hoverTickRender, "hexerei:textures/book/right_click_icon_hover.png", new ArrayList<BookImageEffect>()) : new BookImage(bookEntity.x - v, bookEntity.y + 0.85f - v1, 1.0f, 0.0f, 0.0f, 32.0f, 48.0f, 32.0f, 48.0f, 0.45f * bookEntity.hoverTickRender, "hexerei:textures/book/right_click_icon.png", new ArrayList<BookImageEffect>());
                    this.drawImage(bookImage2, altarTile, pageOn == PageOn.LEFT_PAGE ? leftCursorX : rightCursorX, pageOn == PageOn.LEFT_PAGE ? leftCursorY : rightCursorY, poseStack, bufferIn, 0.0f, combinedLightIn, combinedOverlayIn, pageOn, drawingType);
                }
                for (BookNonItemTooltip bookNonItemTooltip : page.nonItemTooltipList) {
                    if (PageDrawing.canInteract(leftCursorX, leftCursorY, bookNonItemTooltip.x, bookNonItemTooltip.y, bookNonItemTooltip.width, bookNonItemTooltip.height, altarTile, drawingType)) {
                        this.tooltipText = bookNonItemTooltip.tooltip;
                        this.tooltipStack = ItemStack.EMPTY;
                        this.drawTooltipText = true;
                    }
                    if (!this.drawTooltipText) continue;
                    break;
                }
                for (BookWritableTextBox bookWritableTextBox : page.writableTextBoxes) {
                    float yCursor;
                    float xCursor = pageOn == PageOn.LEFT_PAGE ? leftCursorX : rightCursorX;
                    if (!PageDrawing.canInteract(xCursor, yCursor = pageOn == PageOn.LEFT_PAGE ? leftCursorY : rightCursorY, bookWritableTextBox.paragraphElement.x + 0.45f, bookWritableTextBox.paragraphElement.y, bookWritableTextBox.paragraphElement.width / 6.15f, bookWritableTextBox.paragraphElement.height / 2.57f, altarTile, drawingType) || focusedWritableTextBox == null || focusedWritableTextBox.getLeft() != altarTile || focusedWritableTextBox.getRight() != bookWritableTextBox || !((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.clicked) continue;
                    BookWritableTextBox.Client.DisplayCache bookeditscreen$displaycache = ((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.getDisplayCache(((BookOfShadowsAltarTile)((Object)PageDrawing.focusedWritableTextBox.getLeft())).currentBook);
                    BookWritableTextBox.Client.Pos2i pos2i = new BookWritableTextBox.Client.Pos2i((int)((xCursor - bookWritableTextBox.paragraphElement.x - 0.45f) / 5.0f * 115.0f), (int)((yCursor - bookWritableTextBox.paragraphElement.y) / 7.1f * 162.0f));
                    if (pos2i.x == ((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.clickedPos.x && pos2i.y == ((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.clickedPos.y) continue;
                    int i = bookeditscreen$displaycache.getIndexAtPosition(ClientProxy.font(), pos2i);
                    ((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.pageEdit.setCursorPos(i, true);
                    ((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.clearDisplayCache(((BookOfShadowsAltarTile)((Object)PageDrawing.focusedWritableTextBox.getLeft())).currentBook.getUUID());
                }
            }
            for (BookImage bookImage : page.imageList) {
                float h;
                float y;
                float w;
                float x;
                this.drawImage(bookImage, altarTile, pageOn == PageOn.LEFT_PAGE ? leftCursorX : rightCursorX, pageOn == PageOn.LEFT_PAGE ? leftCursorY : rightCursorY, poseStack, bufferIn, 0.0f, combinedLightIn, combinedOverlayIn, pageOn, drawingType);
                if (bookImage.extra_tooltips == null || bookImage.extra_tooltips.isEmpty()) continue;
                if (!PageDrawing.canInteract(pageOn == PageOn.LEFT_PAGE ? leftCursorX : rightCursorX, pageOn == PageOn.LEFT_PAGE ? leftCursorY : rightCursorY, x = bookImage.x - (w = bookImage.width / 330.0f * bookImage.scale / 0.062f) / 2.0f + 0.45f, y = bookImage.y - (h = bookImage.height / 330.0f * bookImage.scale / 0.062f) / 2.0f + 0.49f, w, h, altarTile, drawingType) || pageOn != PageOn.LEFT_PAGE && pageOn != PageOn.RIGHT_PAGE) continue;
                this.tooltipText = bookImage.extra_tooltips;
                this.tooltipStack = ItemStack.EMPTY;
                this.drawTooltipText = true;
            }
            if (this.drawSlotOverlay) {
                this.drawImage(this.slotOverlay, altarTile, pageOn == PageOn.LEFT_PAGE ? leftCursorX : rightCursorX, pageOn == PageOn.LEFT_PAGE ? leftCursorY : rightCursorY, poseStack, bufferIn, 0.0f, combinedLightIn, combinedOverlayIn, this.slotOverlayPageOn, drawingType);
            }
            for (BookEntity bookEntity : page.entityList) {
                TamableAnimal tamable;
                bookEntity.markedForUpdate = true;
                Entity entity = bookEntity.entity;
                if (entity instanceof TamableAnimal && (tamable = (TamableAnimal)entity).isOrderedToSit() && !tamable.isInSittingPose()) {
                    tamable.setInSittingPose(true);
                }
                if ((entity = bookEntity.entity) instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    this.drawLivingEntity(altarTile, poseStack, bufferIn, bookEntity.scale, bookEntity.x, bookEntity.y, bookEntity.getRot(partial) + (float)Math.PI, 20, 107.0f, 58.0f, livingEntity, combinedLightIn, combinedOverlayIn, pageOn, drawingType);
                    continue;
                }
                if (bookEntity.entity == null) continue;
                this.drawEntity(altarTile, poseStack, bufferIn, bookEntity.scale, bookEntity.x, bookEntity.y, bookEntity.getRot(partial) + (float)Math.PI, 20, 107.0f, 58.0f, bookEntity.entity, combinedLightIn, combinedOverlayIn, pageOn, drawingType);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawLivingEntity(BookOfShadowsAltarTile altarTile, PoseStack poseStack, MultiBufferSource bufferIn, float scale, float xIn, float yIn, float rot, int p_98853_, float p_98854_, float p_98855_, LivingEntity livingEntity, int combinedLightIn, int combinedOverlayIn, PageOn pageOn, DrawingType drawingType) {
        poseStack.pushPose();
        if (pageOn == PageOn.LEFT_PAGE) {
            PageDrawing.translateToLeftPage(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_UNDER) {
            PageDrawing.translateToLeftPageUnder(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV) {
            PageDrawing.translateToLeftPagePrevious(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        }
        if (pageOn == PageOn.RIGHT_PAGE) {
            PageDrawing.translateToRightPage(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_UNDER) {
            PageDrawing.translateToRightPageUnder(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV) {
            PageDrawing.translateToRightPagePrevious(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        }
        poseStack.translate(-0.001953125f, 0.0f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        poseStack.translate(-0.5f, 0.34375f, -0.0025f);
        poseStack.scale(0.049f * scale, 0.049f * scale, 0.003f);
        poseStack.translate(yIn * 1.25f / scale, -xIn * 1.25f / scale, 0.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        float $$6 = (float)Math.atan(p_98854_ / 40.0f);
        float $$7 = (float)Math.atan(p_98855_ / 40.0f);
        Quaternionf $$10 = Axis.ZP.rotationDegrees(180.0f);
        Quaternionf $$11 = Axis.XP.rotationDegrees($$7 * 20.0f);
        $$10.mul((Quaternionfc)$$11);
        float $$12 = livingEntity.yBodyRot;
        float $$13 = livingEntity.getYRot();
        float $$15 = livingEntity.yHeadRotO;
        float $$16 = livingEntity.yHeadRot;
        livingEntity.yBodyRot = rot + (float)livingEntity.getId();
        livingEntity.setYRot(rot + (float)livingEntity.getId());
        livingEntity.yHeadRot = livingEntity.getYRot();
        livingEntity.yHeadRotO = livingEntity.getYRot();
        EntityRenderDispatcher $$17 = Minecraft.getInstance().getEntityRenderDispatcher();
        $$11.conjugate();
        $$17.overrideCameraOrientation($$11);
        $$17.setRenderShadow(false);
        MultiBufferSource.BufferSource $$18 = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderSystem.runAsFancy(() -> $$17.render((Entity)livingEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)$$18, combinedLightIn));
        $$18.endBatch();
        $$17.setRenderShadow(true);
        livingEntity.yBodyRot = $$12;
        livingEntity.setYRot($$13);
        livingEntity.yHeadRotO = $$15;
        livingEntity.yHeadRot = $$16;
        poseStack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawEntity(BookOfShadowsAltarTile altarTile, PoseStack poseStack, MultiBufferSource bufferIn, float scale, float xIn, float yIn, float rot, int p_98853_, float p_98854_, float p_98855_, Entity entity, int combinedLightIn, int combinedOverlayIn, PageOn pageOn, DrawingType drawingType) {
        poseStack.pushPose();
        if (pageOn == PageOn.LEFT_PAGE) {
            PageDrawing.translateToLeftPage(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_UNDER) {
            PageDrawing.translateToLeftPageUnder(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV) {
            PageDrawing.translateToLeftPagePrevious(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        }
        if (pageOn == PageOn.RIGHT_PAGE) {
            PageDrawing.translateToRightPage(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_UNDER) {
            PageDrawing.translateToRightPageUnder(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV) {
            PageDrawing.translateToRightPagePrevious(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        }
        poseStack.translate(-0.001953125f, 0.0f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        poseStack.translate(-0.5f, 0.34375f, -0.0025f);
        poseStack.scale(0.049f * scale, 0.049f * scale, 0.003f);
        poseStack.translate(yIn * 1.25f / scale, -xIn * 1.25f / scale, 0.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        float $$7 = (float)Math.atan(p_98855_ / 40.0f);
        Quaternionf $$10 = Axis.ZP.rotationDegrees(180.0f);
        Quaternionf $$11 = Axis.XP.rotationDegrees($$7 * 20.0f);
        $$10.mul((Quaternionfc)$$11);
        poseStack.mulPose(Axis.YP.rotationDegrees(-(rot + (float)entity.getId())));
        EntityRenderDispatcher $$17 = Minecraft.getInstance().getEntityRenderDispatcher();
        $$11.conjugate();
        $$17.overrideCameraOrientation($$11);
        $$17.setRenderShadow(false);
        MultiBufferSource.BufferSource $$18 = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderSystem.runAsFancy(() -> $$17.render(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)$$18, combinedLightIn));
        $$18.endBatch();
        $$17.setRenderShadow(true);
        poseStack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawTooltips(BookOfShadowsAltarTile altarTile, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, float partialTicks) throws CommandSyntaxException {
        this.drawTooltip = altarTile.turnPage == 0;
        this.drawTooltipScaleOld = this.drawTooltipScale = Mth.lerp((float)partialTicks, (float)altarTile.tooltipScaleOld, (float)altarTile.tooltipScale);
        if (this.drawTooltipStack && altarTile.turnPage == 0) {
            altarTile.drawTooltip = true;
            this.drawTooltipStackFlag = true;
            this.drawTooltipTextFlag = false;
        } else if (this.drawTooltipText && altarTile.turnPage == 0) {
            altarTile.drawTooltip = true;
            this.drawTooltipTextFlag = true;
            this.drawTooltipStackFlag = false;
        } else {
            altarTile.drawTooltip = false;
            if (this.drawTooltipScale == 0.0f) {
                this.drawTooltipStackFlag = false;
                this.drawTooltipTextFlag = false;
            }
        }
        if (this.drawTooltipScale > 0.0f) {
            if (this.drawTooltipStackFlag) {
                this.drawTooltipImage(this.tooltipStack, altarTile, poseStack, bufferSource, 0.0f, light, overlay, partialTicks);
            } else {
                this.drawTooltipText(altarTile, poseStack, bufferSource, 0.0f, light, overlay, partialTicks);
            }
        }
    }

    public int getBookPageSeed(String location, UUID bookuuid) {
        return location.hashCode() * 31959 * bookuuid.hashCode();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawPages(BookOfShadowsAltarTile altarTile, float leftCursorX, float leftCursorY, float rightCursorX, float rightCursorY, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, float partialTicks, DrawingType drawingType) {
        this.drawPages(altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, light, overlay, drawingType, ItemDisplayContext.NONE, partialTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawPages(BookOfShadowsAltarTile altarTile, float leftCursorX, float leftCursorY, float rightCursorX, float rightCursorY, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, DrawingType drawingType, ItemDisplayContext transformType, float partialTicks) {
        BookPageEntry pageEntry2;
        BookPageEntry pageEntry;
        BookPageEntry pageEntry3;
        if (ClientProxy.keys == null) {
            ClientProxy.keys = Minecraft.getInstance().options.keyMappings;
        }
        this.drawSlotOverlay = false;
        this.drawTooltipStack = false;
        this.drawTooltipText = false;
        BookData bookData = altarTile.currentBook;
        if (bookData == null) {
            return;
        }
        BookEntries bookEntries = BookManager.getBookEntries(bookData.getBook());
        if (bookEntries == null) {
            return;
        }
        String left_page = "";
        String right_page = "";
        String left_page_prev = "";
        String left_page_under = "";
        String left_page_under_under = "";
        String left_page_under_under_under = "";
        String right_page_under = "";
        String right_page_prev = "";
        String right_page_prev_prev = "";
        int location1_p = 0;
        int location2_p = 0;
        int location1_back_p = 0;
        int location2_back_p = 0;
        int location1_next_p = 0;
        int location2_next_p = 0;
        int chapter = 0;
        int page = 0;
        chapter = Math.max(0, bookData.getChapter());
        page = Math.max(0, bookData.getPage());
        if (page % 2 == 1) {
            --page;
        }
        if (bookEntries.chapterList.get((int)chapter).pages.size() > page && page >= 0) {
            pageEntry3 = bookEntries.chapterList.get((int)chapter).pages.get(page);
            left_page = pageEntry3.location;
            location1_p = pageEntry3.pageNum;
        }
        if (bookEntries.chapterList.get((int)chapter).pages.size() > page + 1 && page >= 0) {
            pageEntry3 = bookEntries.chapterList.get((int)chapter).pages.get(page + 1);
            right_page = pageEntry3.location;
            location2_p = pageEntry3.pageNum;
        }
        int next_page_chapter = chapter;
        int next_page_page = page;
        int back_page_chapter = chapter;
        int back_page_page = page;
        if (next_page_page < bookEntries.chapterList.get((int)chapter).pages.size() - 2) {
            next_page_page += 2;
        } else if (chapter < bookEntries.chapterList.size() - 1) {
            ++next_page_chapter;
            next_page_page = 0;
        } else {
            next_page_chapter = -1;
        }
        if (next_page_chapter != -1 && next_page_chapter < bookEntries.chapterList.size() && next_page_page < bookEntries.chapterList.get((int)next_page_chapter).pages.size()) {
            pageEntry = bookEntries.chapterList.get((int)next_page_chapter).pages.get(next_page_page);
            right_page_under = pageEntry.location;
            location1_next_p = pageEntry.pageNum;
            if (bookEntries.chapterList.get((int)next_page_chapter).pages.size() > next_page_page + 1) {
                pageEntry2 = bookEntries.chapterList.get((int)next_page_chapter).pages.get(next_page_page + 1);
                right_page_prev = pageEntry2.location;
                location2_next_p = pageEntry2.pageNum;
                List entries = bookEntries.chapterList.stream().flatMap(entry -> entry.pages.stream()).toList();
                if (location2_next_p + 2 < entries.size()) {
                    right_page_prev_prev = ((BookPageEntry)entries.get((int)(location2_next_p + 2))).location;
                }
            }
        }
        if (back_page_page - 2 >= 0) {
            back_page_page -= 2;
        } else if (back_page_chapter > 0) {
            back_page_page = bookEntries.chapterList.get((int)(--back_page_chapter)).pages.size() - 1;
            if (back_page_page % 2 == 1) {
                --back_page_page;
            }
        } else {
            back_page_chapter = -1;
        }
        if (back_page_chapter != -1 && back_page_chapter < bookEntries.chapterList.size() && back_page_page < bookEntries.chapterList.get((int)back_page_chapter).pages.size()) {
            pageEntry = bookEntries.chapterList.get((int)back_page_chapter).pages.get(back_page_page);
            left_page_prev = pageEntry.location;
            location1_back_p = pageEntry.pageNum;
            if (bookEntries.chapterList.get((int)back_page_chapter).pages.size() > back_page_page + 1) {
                pageEntry2 = bookEntries.chapterList.get((int)back_page_chapter).pages.get(back_page_page + 1);
                left_page_under = pageEntry2.location;
                location2_back_p = pageEntry2.pageNum;
            }
            if (back_page_page - 1 > 0) {
                pageEntry2 = bookEntries.chapterList.get((int)back_page_chapter).pages.get(back_page_page - 1);
                left_page_under_under = pageEntry2.location;
            } else if (back_page_chapter - 1 > 0) {
                pageEntry2 = bookEntries.chapterList.get((int)(back_page_chapter - 1)).pages.getLast();
                left_page_under_under = pageEntry2.location;
            }
            if (back_page_page - 3 > 0) {
                pageEntry2 = bookEntries.chapterList.get((int)back_page_chapter).pages.get(back_page_page - 3);
                left_page_under_under_under = pageEntry2.location;
            } else if (back_page_chapter - 1 > 0) {
                pageEntry2 = bookEntries.chapterList.get((int)(back_page_chapter - 1)).pages.get(bookEntries.chapterList.get((int)(back_page_chapter - 1)).pages.size() - 3);
                left_page_under_under_under = pageEntry2.location;
            }
        }
        if (transformType != ItemDisplayContext.GUI) {
            if (drawingType == DrawingType.SCREEN) {
                ResourceLocation loc;
                if (altarTile.pageOneRotationRender < 155.0f && altarTile.pageTwoRotationRender < 155.0f) {
                    int seed = this.getBookPageSeed(left_page_under, bookData.getUUID());
                    random = new Random(seed);
                    pageLoc = pageTextureLocs.isEmpty() ? "hexerei:textures/book/pages/page_1.png" : pageTextureLocs.get(random.nextInt(pageTextureLocs.size())).toString();
                    this.drawBasePage(new BookImage(2.325f, 3.0600002f, -0.2f, 0.0f, 0.0f, 13.0f, 18.0f, 13.0f, 18.0f, 10.2f, pageLoc, new ArrayList<BookImageEffect>()), altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.LEFT_PAGE, -1, drawingType, ItemDisplayContext.NONE);
                    seed = this.getBookPageSeed(right_page, bookData.getUUID());
                    random = new Random(seed);
                    pageLoc = pageTextureLocs.isEmpty() ? "hexerei:textures/book/pages/page_1.png" : pageTextureLocs.get(random.nextInt(pageTextureLocs.size())).toString();
                    this.drawBasePage(new BookImage(2.6750002f, 3.0600002f, -0.2f, 0.0f, 0.0f, 13.0f, 18.0f, -13.0f, 18.0f, 10.2f, pageLoc, new ArrayList<BookImageEffect>()), altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.RIGHT_PAGE, -1, drawingType, ItemDisplayContext.NONE);
                    seed = this.getBookPageSeed(right_page, bookData.getUUID());
                    random = new Random(seed);
                    loc = overlayTextureLocs.get(random.nextInt(overlayTextureLocs.size()));
                    if (loc != null && seed != 0) {
                        this.drawImage(new BookImage(2.6750002f, 3.0600002f, -0.19f, 0.0f, 0.0f, 13.0f, 18.0f, -13.0f, 18.0f, 10.2f, loc.toString(), new ArrayList<BookImageEffect>()), altarTile, rightCursorX, rightCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.RIGHT_PAGE, -1711276033, drawingType, ItemDisplayContext.NONE);
                    }
                    if ((loc = overlayTextureLocs.get((random = new Random(seed = this.getBookPageSeed(left_page, bookData.getUUID()))).nextInt(overlayTextureLocs.size()))) != null && seed != 0) {
                        this.drawBasePage(new BookImage(2.325f, 3.0600002f, -0.19f, 0.0f, 0.0f, 13.0f, 18.0f, 13.0f, 18.0f, 10.2f, loc.toString(), new ArrayList<BookImageEffect>()), altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.LEFT_PAGE, -1711276033, drawingType, ItemDisplayContext.NONE);
                    }
                    BookPage page1 = BookManager.getBookPages(bookData.getBook(), ResourceLocation.parse((String)left_page));
                    BookPage page2 = BookManager.getBookPages(bookData.getBook(), ResourceLocation.parse((String)right_page));
                    this.drawPage(page1, altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, light, overlay, PageOn.LEFT_PAGE, drawingType, transformType, location1_p, partialTicks);
                    this.drawPage(page2, altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, light, overlay, PageOn.RIGHT_PAGE, drawingType, transformType, location2_p, partialTicks);
                }
                if (altarTile.pageOneRotationRender > 15.0f) {
                    int seed = this.getBookPageSeed(right_page, bookData.getUUID());
                    random = new Random(seed);
                    pageLoc = pageTextureLocs.isEmpty() ? "hexerei:textures/book/pages/page_1.png" : pageTextureLocs.get(random.nextInt(pageTextureLocs.size())).toString();
                    this.drawBasePage(new BookImage(2.325f, 3.0600002f, -0.2f, 0.0f, 0.0f, 13.0f, 18.0f, 13.0f, 18.0f, 10.2f, pageLoc, new ArrayList<BookImageEffect>()), altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.RIGHT_PAGE_UNDER, -1, drawingType, ItemDisplayContext.NONE);
                    seed = this.getBookPageSeed(right_page_prev, bookData.getUUID());
                    random = new Random(seed);
                    pageLoc = pageTextureLocs.isEmpty() ? "hexerei:textures/book/pages/page_1.png" : pageTextureLocs.get(random.nextInt(pageTextureLocs.size())).toString();
                    this.drawBasePage(new BookImage(2.6750002f, 3.0600002f, -0.2f, 0.0f, 0.0f, 13.0f, 18.0f, -13.0f, 18.0f, 10.2f, pageLoc, new ArrayList<BookImageEffect>()), altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.RIGHT_PAGE_PREV, -1, drawingType, ItemDisplayContext.NONE);
                    seed = this.getBookPageSeed(right_page_prev, bookData.getUUID());
                    random = new Random(seed);
                    loc = overlayTextureLocs.get(random.nextInt(overlayTextureLocs.size()));
                    if (loc != null && seed != 0) {
                        this.drawImage(new BookImage(2.6750002f, 3.0600002f, -0.19f, 0.0f, 0.0f, 13.0f, 18.0f, -13.0f, 18.0f, 10.2f, loc.toString(), new ArrayList<BookImageEffect>()), altarTile, rightCursorX, rightCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.RIGHT_PAGE_PREV, -1711276033, drawingType, ItemDisplayContext.NONE);
                    }
                    if ((loc = overlayTextureLocs.get((random = new Random(seed = this.getBookPageSeed(right_page_under, bookData.getUUID()))).nextInt(overlayTextureLocs.size()))) != null && seed != 0) {
                        this.drawImage(new BookImage(2.325f, 3.0600002f, -0.19f, 0.0f, 0.0f, 13.0f, 18.0f, 13.0f, 18.0f, 10.2f, loc.toString(), new ArrayList<BookImageEffect>()), altarTile, leftCursorX, leftCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.RIGHT_PAGE_UNDER, -1711276033, drawingType, ItemDisplayContext.NONE);
                    }
                    BookPage page2_under = BookManager.getBookPages(bookData.getBook(), ResourceLocation.parse((String)right_page_under));
                    BookPage page2_prev = BookManager.getBookPages(bookData.getBook(), ResourceLocation.parse((String)right_page_prev));
                    this.drawPage(page2_under, altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, light, overlay, PageOn.RIGHT_PAGE_UNDER, drawingType, transformType, location1_next_p, partialTicks);
                    this.drawPage(page2_prev, altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, light, overlay, PageOn.RIGHT_PAGE_PREV, drawingType, transformType, location2_next_p, partialTicks);
                }
                if (altarTile.pageTwoRotationRender > 15.0f) {
                    int seed = this.getBookPageSeed(left_page_under_under, bookData.getUUID());
                    random = new Random(seed);
                    pageLoc = pageTextureLocs.isEmpty() ? "hexerei:textures/book/pages/page_1.png" : pageTextureLocs.get(random.nextInt(pageTextureLocs.size())).toString();
                    this.drawBasePage(new BookImage(2.325f, 3.0600002f, -0.2f, 0.0f, 0.0f, 13.0f, 18.0f, 13.0f, 18.0f, 10.2f, pageLoc, new ArrayList<BookImageEffect>()), altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.LEFT_PAGE_PREV, -1, drawingType, ItemDisplayContext.NONE);
                    seed = this.getBookPageSeed(left_page_under, bookData.getUUID());
                    random = new Random(seed);
                    pageLoc = pageTextureLocs.isEmpty() ? "hexerei:textures/book/pages/page_1.png" : pageTextureLocs.get(random.nextInt(pageTextureLocs.size())).toString();
                    this.drawBasePage(new BookImage(2.6750002f, 3.0600002f, -0.2f, 0.0f, 0.0f, 13.0f, 18.0f, -13.0f, 18.0f, 10.2f, pageLoc, new ArrayList<BookImageEffect>()), altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.LEFT_PAGE_UNDER, -1, drawingType, ItemDisplayContext.NONE);
                    seed = this.getBookPageSeed(left_page_under, bookData.getUUID());
                    random = new Random(seed);
                    loc = overlayTextureLocs.get(random.nextInt(overlayTextureLocs.size()));
                    if (loc != null && seed != 0) {
                        this.drawBasePage(new BookImage(2.6750002f, 3.0600002f, -0.19f, 0.0f, 0.0f, 13.0f, 18.0f, -13.0f, 18.0f, 10.2f, loc.toString(), new ArrayList<BookImageEffect>()), altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.LEFT_PAGE_UNDER, -1711276033, drawingType, ItemDisplayContext.NONE);
                    }
                    if ((loc = overlayTextureLocs.get((random = new Random(seed = this.getBookPageSeed(left_page_prev, bookData.getUUID()))).nextInt(overlayTextureLocs.size()))) != null && seed != 0) {
                        this.drawBasePage(new BookImage(2.325f, 3.0600002f, -0.19f, 0.0f, 0.0f, 13.0f, 18.0f, 13.0f, 18.0f, 10.2f, loc.toString(), new ArrayList<BookImageEffect>()), altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.LEFT_PAGE_PREV, -1711276033, drawingType, ItemDisplayContext.NONE);
                    }
                    BookPage page1_under = BookManager.getBookPages(bookData.getBook(), ResourceLocation.parse((String)left_page_under));
                    BookPage page1_prev = BookManager.getBookPages(bookData.getBook(), ResourceLocation.parse((String)left_page_prev));
                    this.drawPage(page1_under, altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, light, overlay, PageOn.LEFT_PAGE_UNDER, drawingType, transformType, location2_back_p, partialTicks);
                    this.drawPage(page1_prev, altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, light, overlay, PageOn.LEFT_PAGE_PREV, drawingType, transformType, location1_back_p, partialTicks);
                }
            } else {
                int seed = this.getBookPageSeed(left_page_under_under, bookData.getUUID());
                random = new Random(seed);
                pageLoc = pageTextureLocs.isEmpty() ? "hexerei:textures/book/pages/page_1.png" : pageTextureLocs.get(random.nextInt(pageTextureLocs.size())).toString();
                this.drawBasePage(new BookImage(2.325f, 3.0600002f, -0.2f, 0.0f, 0.0f, 13.0f, 18.0f, 13.0f, 18.0f, 10.2f, pageLoc, new ArrayList<BookImageEffect>()), altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.LEFT_PAGE_PREV, -1, drawingType, transformType);
                seed = this.getBookPageSeed(left_page_under, bookData.getUUID());
                random = new Random(seed);
                pageLoc = pageTextureLocs.isEmpty() ? "hexerei:textures/book/pages/page_1.png" : pageTextureLocs.get(random.nextInt(pageTextureLocs.size())).toString();
                this.drawBasePage(new BookImage(2.6750002f, 3.0600002f, -0.2f, 0.0f, 0.0f, 13.0f, 18.0f, -13.0f, 18.0f, 10.2f, pageLoc, new ArrayList<BookImageEffect>()), altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.LEFT_PAGE_UNDER, -1, drawingType, transformType);
                this.drawBasePage(new BookImage(2.325f, 3.0600002f, -0.2f, 0.0f, 0.0f, 13.0f, 18.0f, 13.0f, 18.0f, 10.2f, pageLoc, new ArrayList<BookImageEffect>()), altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.LEFT_PAGE, -1, drawingType, transformType);
                seed = this.getBookPageSeed(right_page, bookData.getUUID());
                random = new Random(seed);
                pageLoc = pageTextureLocs.isEmpty() ? "hexerei:textures/book/pages/page_1.png" : pageTextureLocs.get(random.nextInt(pageTextureLocs.size())).toString();
                this.drawBasePage(new BookImage(2.6750002f, 3.0600002f, -0.2f, 0.0f, 0.0f, 13.0f, 18.0f, -13.0f, 18.0f, 10.2f, pageLoc, new ArrayList<BookImageEffect>()), altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.RIGHT_PAGE, -1, drawingType, transformType);
                this.drawBasePage(new BookImage(2.325f, 3.0600002f, -0.2f, 0.0f, 0.0f, 13.0f, 18.0f, 13.0f, 18.0f, 10.2f, pageLoc, new ArrayList<BookImageEffect>()), altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.RIGHT_PAGE_UNDER, -1, drawingType, transformType);
                seed = this.getBookPageSeed(right_page_prev, bookData.getUUID());
                random = new Random(seed);
                pageLoc = pageTextureLocs.isEmpty() ? "hexerei:textures/book/pages/page_1.png" : pageTextureLocs.get(random.nextInt(pageTextureLocs.size())).toString();
                this.drawBasePage(new BookImage(2.6750002f, 3.0600002f, -0.2f, 0.0f, 0.0f, 13.0f, 18.0f, -13.0f, 18.0f, 10.2f, pageLoc, new ArrayList<BookImageEffect>()), altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.RIGHT_PAGE_PREV, -1, drawingType, transformType);
                seed = this.getBookPageSeed(left_page_prev, bookData.getUUID());
                random = new Random(seed);
                ResourceLocation loc = overlayTextureLocs.get(random.nextInt(overlayTextureLocs.size()));
                if (loc != null && seed != 0) {
                    this.drawImage(new BookImage(2.325f, 3.0600002f, -0.19f, 0.0f, 0.0f, 13.0f, 18.0f, 13.0f, 18.0f, 10.2f, loc.toString(), new ArrayList<BookImageEffect>()), altarTile, leftCursorX, leftCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.LEFT_PAGE_PREV, -1711276033, drawingType, ItemDisplayContext.NONE);
                }
                if ((loc = overlayTextureLocs.get((random = new Random(seed = this.getBookPageSeed(right_page, bookData.getUUID()))).nextInt(overlayTextureLocs.size()))) != null && seed != 0) {
                    this.drawImage(new BookImage(2.6750002f, 3.0600002f, -0.19f, 0.0f, 0.0f, 13.0f, 18.0f, -13.0f, 18.0f, 10.2f, loc.toString(), new ArrayList<BookImageEffect>()), altarTile, rightCursorX, rightCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.RIGHT_PAGE, -1711276033, drawingType, ItemDisplayContext.NONE);
                }
                if ((loc = overlayTextureLocs.get((random = new Random(seed = this.getBookPageSeed(right_page_under, bookData.getUUID()))).nextInt(overlayTextureLocs.size()))) != null && seed != 0) {
                    this.drawImage(new BookImage(2.325f, 3.0600002f, -0.19f, 0.0f, 0.0f, 13.0f, 18.0f, 13.0f, 18.0f, 10.2f, loc.toString(), new ArrayList<BookImageEffect>()), altarTile, leftCursorX, leftCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.RIGHT_PAGE_UNDER, -1711276033, drawingType, ItemDisplayContext.NONE);
                }
                if ((loc = overlayTextureLocs.get((random = new Random(seed = this.getBookPageSeed(left_page_under, bookData.getUUID()))).nextInt(overlayTextureLocs.size()))) != null && seed != 0) {
                    this.drawImage(new BookImage(2.6750002f, 3.0600002f, -0.19f, 0.0f, 0.0f, 13.0f, 18.0f, -13.0f, 18.0f, 10.2f, loc.toString(), new ArrayList<BookImageEffect>()), altarTile, rightCursorX, rightCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.LEFT_PAGE_UNDER, -1711276033, drawingType, ItemDisplayContext.NONE);
                }
                if ((loc = overlayTextureLocs.get((random = new Random(seed = this.getBookPageSeed(left_page, bookData.getUUID()))).nextInt(overlayTextureLocs.size()))) != null && seed != 0) {
                    this.drawImage(new BookImage(2.325f, 3.0600002f, -0.19f, 0.0f, 0.0f, 13.0f, 18.0f, 13.0f, 18.0f, 10.2f, loc.toString(), new ArrayList<BookImageEffect>()), altarTile, leftCursorX, leftCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.LEFT_PAGE, -1711276033, drawingType, ItemDisplayContext.NONE);
                }
                if ((loc = overlayTextureLocs.get((random = new Random(seed = this.getBookPageSeed(right_page_prev, bookData.getUUID()))).nextInt(overlayTextureLocs.size()))) != null && seed != 0) {
                    this.drawImage(new BookImage(2.6750002f, 3.0600002f, -0.19f, 0.0f, 0.0f, 13.0f, 18.0f, -13.0f, 18.0f, 10.2f, loc.toString(), new ArrayList<BookImageEffect>()), altarTile, rightCursorX, rightCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.RIGHT_PAGE_PREV, -1711276033, drawingType, ItemDisplayContext.NONE);
                }
                if (altarTile.openedPercent < 0.6f) {
                    seed = this.getBookPageSeed(left_page_under_under_under, bookData.getUUID());
                    random = new Random(seed);
                    pageLoc = pageTextureLocs.isEmpty() ? "hexerei:textures/book/pages/page_1.png" : pageTextureLocs.get(random.nextInt(pageTextureLocs.size())).toString();
                    this.drawImage(new BookImage(-0.5f - (0.5f - altarTile.pageTwoRotationRender / 180.0f * 0.05f) + 3.275f, 3.0600002f, -0.3f + -altarTile.pageOneRotationRender / 180.0f / 64.0f, 0.0f, 0.0f, 13.0f, 18.0f, 13.0f, 18.0f, 10.2f, pageLoc, new ArrayList<BookImageEffect>()), altarTile, leftCursorX, leftCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.LEFT_PAGE_PREV_PREV, drawingType);
                    seed = this.getBookPageSeed(left_page_under_under_under, bookData.getUUID());
                    random = new Random(seed);
                    loc = overlayTextureLocs.get(random.nextInt(overlayTextureLocs.size()));
                    if (loc != null && seed != 0) {
                        this.drawImage(new BookImage(-0.5f - (0.5f - altarTile.pageTwoRotationRender / 180.0f * 0.05f) + 3.275f, 3.0600002f, -0.29f, 0.0f, 0.0f, 13.0f, 18.0f, 13.0f, 18.0f, 10.2f, loc.toString(), new ArrayList<BookImageEffect>()), altarTile, leftCursorX, leftCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.LEFT_PAGE_PREV_PREV, -1711276033, drawingType, ItemDisplayContext.NONE);
                    }
                    seed = this.getBookPageSeed(right_page_prev_prev, bookData.getUUID());
                    random = new Random(seed);
                    pageLoc = pageTextureLocs.isEmpty() ? "hexerei:textures/book/pages/page_1.png" : pageTextureLocs.get(random.nextInt(pageTextureLocs.size())).toString();
                    this.drawImage(new BookImage(-0.5f - (0.05f + altarTile.pageOneRotationRender / 180.0f * 0.05f) + 3.275f, 3.0600002f, -0.3f + -altarTile.pageOneRotationRender / 180.0f / 64.0f, 0.0f, 0.0f, 13.0f, 18.0f, -13.0f, 18.0f, 10.2f, pageLoc, new ArrayList<BookImageEffect>()), altarTile, rightCursorX, rightCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.RIGHT_PAGE_PREV_PREV, drawingType);
                    seed = this.getBookPageSeed(right_page_prev_prev, bookData.getUUID());
                    random = new Random(seed);
                    loc = overlayTextureLocs.get(random.nextInt(overlayTextureLocs.size()));
                    if (loc != null && seed != 0) {
                        this.drawImage(new BookImage(-0.5f - (0.05f + altarTile.pageOneRotationRender / 180.0f * 0.05f) + 3.275f, 3.0600002f, -0.29f, 0.0f, 0.0f, 13.0f, 18.0f, -13.0f, 18.0f, 10.2f, loc.toString(), new ArrayList<BookImageEffect>()), altarTile, rightCursorX, rightCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.RIGHT_PAGE_PREV_PREV, -1711276033, drawingType, ItemDisplayContext.NONE);
                    }
                }
                BookPage page1 = BookManager.getBookPages(bookData.getBook(), ResourceLocation.parse((String)left_page));
                BookPage page2 = BookManager.getBookPages(bookData.getBook(), ResourceLocation.parse((String)right_page));
                this.drawPage(page1, altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, light, overlay, PageOn.LEFT_PAGE, drawingType, transformType, location1_p, partialTicks);
                this.drawPage(page2, altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, light, overlay, PageOn.RIGHT_PAGE, drawingType, transformType, location2_p, partialTicks);
                if (altarTile.pageTwoRotationRender < 87.5f) {
                    BookPage page2_under = BookManager.getBookPages(bookData.getBook(), ResourceLocation.parse((String)right_page_under));
                    BookPage page2_prev = BookManager.getBookPages(bookData.getBook(), ResourceLocation.parse((String)right_page_prev));
                    this.drawPage(page2_under, altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, light, overlay, PageOn.RIGHT_PAGE_UNDER, drawingType, transformType, location1_next_p, partialTicks);
                    this.drawPage(page2_prev, altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, light, overlay, PageOn.RIGHT_PAGE_PREV, drawingType, transformType, location2_next_p, partialTicks);
                }
                if (altarTile.pageOneRotationRender < 87.5f) {
                    BookPage page1_under = BookManager.getBookPages(bookData.getBook(), ResourceLocation.parse((String)left_page_under));
                    BookPage page1_prev = BookManager.getBookPages(bookData.getBook(), ResourceLocation.parse((String)left_page_prev));
                    this.drawPage(page1_under, altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, light, overlay, PageOn.LEFT_PAGE_UNDER, drawingType, transformType, location2_back_p, partialTicks);
                    this.drawPage(page1_prev, altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, light, overlay, PageOn.LEFT_PAGE_PREV, drawingType, transformType, location1_back_p, partialTicks);
                }
            }
        } else {
            BookPage page1 = BookManager.getBookPages(bookData.getBook(), ResourceLocation.parse((String)"hexerei:book/book_pages/gui_page_1"));
            BookPage page2 = BookManager.getBookPages(bookData.getBook(), ResourceLocation.parse((String)"hexerei:book/book_pages/gui_page_1"));
            this.drawPage(page1, altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, light, overlay, PageOn.LEFT_PAGE, drawingType, transformType, location1_p, partialTicks);
            this.drawPage(page2, altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, light, overlay, PageOn.RIGHT_PAGE, drawingType, transformType, location2_p, partialTicks);
        }
        this.drawBaseButtons(altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, light, overlay, !right_page_under.isEmpty(), !left_page_prev.isEmpty(), chapter, page, drawingType, partialTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawBaseButtons(BookOfShadowsAltarTile altarTile, float leftCursorX, float leftCursorY, float rightCursorX, float rightCursorY, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, boolean drawNext, boolean drawBack, int chapter, int page, DrawingType drawingType, float partial) {
        this.drawBaseButtons(altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, poseStack, bufferSource, light, overlay, drawNext, drawBack, chapter, page, drawingType, ItemDisplayContext.NONE, false, partial);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawBaseButtons(BookOfShadowsAltarTile altarTile, float leftCursorX, float leftCursorY, float rightCursorX, float rightCursorY, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, boolean drawNext, boolean drawBack, int chapter, int page, DrawingType drawingType, ItemDisplayContext transformType, boolean fullyExtended, float partial) {
        BookEntries bookEntries = BookManager.getBookEntries(altarTile.currentBook.getBook());
        if (bookEntries != null) {
            BookImageEffect bookImageEffect_tilt;
            BookImageEffect bookImageEffect_scale;
            ArrayList<BookImageEffect> effects;
            for (int i = 0; i < this.bookmarkHoverAmountRender.size(); ++i) {
                this.bookmarkHoverAmountRender.set(i, Float.valueOf(this.easeInOutElastic(Mth.lerp((float)partial, (float)this.bookmarkHoverAmountOld.get(i).floatValue(), (float)this.bookmarkHoverAmount.get(i).floatValue()))));
            }
            boolean drawBookmarkButton = chapter != 0;
            BookData bookData = altarTile.currentBook;
            if (drawBookmarkButton && drawingType != DrawingType.GUI) {
                effects = new ArrayList<BookImageEffect>();
                bookImageEffect_scale = new BookImageEffect("scale", 50.0f, 1.15f);
                bookImageEffect_tilt = new BookImageEffect("tilt", 35.0f, 10.0f);
                BookImageEffect bookImageEffect_hover_overlay = new BookImageEffect("hover_overlay", 35.0f, 10.0f, new BookImage(-0.5f, -1.0f, -1.0f, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f, altarTile.buttonScaleRender / 2.0f, "hexerei:textures/book/bookmark_button_hover.png", effects));
                boolean flag = PageDrawing.canInteract(leftCursorX, leftCursorY, -0.45f, -0.96f, 0.86f, 0.86f, altarTile, drawingType);
                if (flag) {
                    effects.add(bookImageEffect_scale);
                    effects.add(bookImageEffect_tilt);
                    effects.add(bookImageEffect_hover_overlay);
                }
                if (bookData != null) {
                    DyeColor bookmark_color = DyeColor.WHITE;
                    int bookmark_chapter = 0;
                    int bookmark_page = 0;
                    boolean flag2 = false;
                    for (BookData.Bookmarks.Slot slot : bookData.getBookmarks().getSlots()) {
                        boolean flag3 = false;
                        if (!slot.getId().isEmpty()) {
                            bookmark_color = slot.getColor();
                            String bookmark_id = slot.getId();
                            block2: for (BookChapter chapterEntry : bookEntries.chapterList) {
                                for (BookPageEntry pageEntry : chapterEntry.pages) {
                                    if (!pageEntry.location.equals(bookmark_id)) continue;
                                    bookmark_chapter = pageEntry.chapterNum;
                                    bookmark_page = pageEntry.chapterPageNum;
                                    flag3 = true;
                                    continue block2;
                                }
                            }
                        }
                        if (!flag3 || chapter != bookmark_chapter || page != bookmark_page && page + 1 != bookmark_page) continue;
                        flag2 = true;
                        break;
                    }
                    if (flag2) {
                        if (flag) {
                            list = new ArrayList<Component>();
                            Object output = bookmark_color.getName().substring(0, 1).toUpperCase() + bookmark_color.getName().substring(1);
                            output = ((String)output).replaceAll("_", " ");
                            list.add((Component)Component.translatable((String)"Change Color - %s", (Object[])new Object[]{Component.translatable((String)"%s", (Object[])new Object[]{output}).withStyle(Style.EMPTY.withColor(HexereiUtil.getColorValue(bookmark_color)))}).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(0x9D9D97)));
                            this.tooltipText = list;
                            this.tooltipStack = ItemStack.EMPTY;
                            this.drawTooltipText = true;
                        }
                        bookImage = new BookImage(-0.5f, -1.0f, 0.0f, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f, altarTile.buttonScaleRender / 2.0f * 1.15f, "hexerei:textures/book/bookmark_button_underlay.png", effects);
                        BookImage bookImage_overlay = new BookImage(-0.5f, -1.0f, 0.0f, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f, altarTile.buttonScaleRender / 2.0f * 1.15f, "hexerei:textures/book/bookmark_button_overlay.png", effects);
                        this.drawImage((BookImage)bookImage, altarTile, leftCursorX, leftCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.LEFT_PAGE, drawingType);
                        this.drawImage(bookImage_overlay, altarTile, leftCursorX, leftCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.LEFT_PAGE, HexereiUtil.getColorValue(bookmark_color), drawingType, transformType);
                    } else {
                        if (flag) {
                            list = new ArrayList();
                            list.add((Component)Component.translatable((String)"Bookmark Page").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(0x9D9D97)));
                            this.tooltipText = list;
                            this.tooltipStack = ItemStack.EMPTY;
                            this.drawTooltipText = true;
                        }
                        bookImage = new BookImage(-0.5f, -1.0f, 0.0f, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f, altarTile.buttonScaleRender / 2.0f * 1.15f, "hexerei:textures/book/bookmark_button.png", effects);
                        this.drawImage((BookImage)bookImage, altarTile, leftCursorX, leftCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.LEFT_PAGE, drawingType);
                    }
                }
            }
            if (bookData != null) {
                int bookmark_chapter = 0;
                int bookmark_page = 0;
                for (BookData.Bookmarks.Slot slot : bookData.getBookmarks().getSlots()) {
                    BookImage bookImageOverlay;
                    BookImage bookImageUnderlay;
                    BookPage bookmarkedPage;
                    String name;
                    boolean flag2 = false;
                    if (slot.getId().isEmpty()) continue;
                    DyeColor bookmark_color = slot.getColor();
                    ResourceLocation bookmark_id = !slot.getId().isEmpty() ? ResourceLocation.parse((String)slot.getId()) : null;
                    boolean flag3 = false;
                    if (bookmark_id != null) {
                        block5: for (BookChapter chapterEntry : bookEntries.chapterList) {
                            for (BookPageEntry pageEntry : chapterEntry.pages) {
                                if (!ResourceLocation.parse((String)pageEntry.location).equals((Object)bookmark_id)) continue;
                                bookmark_chapter = pageEntry.chapterNum;
                                bookmark_page = pageEntry.chapterPageNum;
                                flag3 = true;
                                continue block5;
                            }
                        }
                    }
                    ArrayList<BookImageEffect> effectsBookmark = new ArrayList<BookImageEffect>();
                    if (slot.getIndex() < 5) {
                        float width;
                        float xIn = -0.3f - altarTile.buttonScaleRender - 0.15f;
                        float yIn = (float)slot.getIndex() * 1.5f;
                        if (PageDrawing.canInteract(leftCursorX, leftCursorY, xIn, yIn, width = 0.935f, width, altarTile, drawingType)) {
                            if (!this.bookmarkHovered.contains(slot.getIndex())) {
                                this.bookmarkHovered.add(slot.getIndex());
                            }
                            ArrayList<Component> list = new ArrayList<Component>();
                            if (flag3) {
                                name = bookEntries.chapterList.get((int)Math.max((int)0, (int)bookmark_chapter)).pages.get((int)Math.max((int)0, (int)bookmark_page)).location;
                                bookmarkedPage = BookManager.getBookPages(bookData.getBook(), ResourceLocation.parse((String)name));
                                if (bookmarkedPage != null) {
                                    name = bookmarkedPage.name;
                                }
                                if (name.isEmpty()) {
                                    list.add((Component)Component.translatable((String)"%s%s - Page %s%s", (Object[])new Object[]{Component.translatable((String)"[").withStyle(Style.EMPTY.withColor(HexereiUtil.getColorValue(bookmark_color))), Component.translatable((String)"%s", (Object[])new Object[]{bookEntries.chapterList.get((int)Math.max((int)0, (int)bookmark_chapter)).name}).withStyle(Style.EMPTY.withColor(0x9D9D97)), Component.translatable((String)"%s", (Object[])new Object[]{bookEntries.chapterList.get((int)Math.max((int)0, (int)bookmark_chapter)).pages.get((int)Math.max((int)0, (int)bookmark_page)).pageNum - 1}).withStyle(Style.EMPTY.withColor(0x9D9D97)), Component.translatable((String)"]").withStyle(Style.EMPTY.withColor(HexereiUtil.getColorValue(bookmark_color)))}).withStyle(Style.EMPTY.withColor(0x9D9D97)));
                                } else {
                                    list.add((Component)Component.translatable((String)"%s%s - %s%s", (Object[])new Object[]{Component.translatable((String)"[").withStyle(Style.EMPTY.withColor(HexereiUtil.getColorValue(bookmark_color))), Component.translatable((String)"%s", (Object[])new Object[]{bookEntries.chapterList.get((int)Math.max((int)0, (int)bookmark_chapter)).name}).withStyle(Style.EMPTY.withColor(0x9D9D97)), Component.translatable((String)name).withStyle(Style.EMPTY.withColor(0x9D9D97)), Component.translatable((String)"]").withStyle(Style.EMPTY.withColor(HexereiUtil.getColorValue(bookmark_color)))}).withStyle(Style.EMPTY.withColor(0x9D9D97)));
                                }
                                this.tooltipText = list;
                                this.tooltipStack = ItemStack.EMPTY;
                                this.drawTooltipText = true;
                            }
                        }
                        float bookX = xIn + 0.8f - this.bookmarkHoverAmountRender.get(slot.getIndex()).floatValue() / 2.0f * altarTile.buttonScaleRender;
                        if (fullyExtended) {
                            bookX = xIn + 0.4f - 0.33f;
                        }
                        bookImageUnderlay = new BookImage(bookX, yIn, 0.0f, 0.0f, 0.0f, 64.0f, 64.0f, 64.0f, 64.0f, 0.5f, "hexerei:textures/book/bookmark_underlay.png", effectsBookmark);
                        bookImageOverlay = new BookImage(bookX, yIn, 0.0f, 0.0f, 0.0f, 64.0f, 64.0f, 64.0f, 64.0f, 0.5f, "hexerei:textures/book/bookmark_overlay.png", effectsBookmark);
                        this.drawBookmark(bookImageUnderlay, altarTile, poseStack, bufferSource, -10.0f, 90.0f, light, overlay, PageOn.LEFT_PAGE, HexereiUtil.getColorValue(bookmark_color), drawingType, transformType);
                        this.drawBookmark(bookImageOverlay, altarTile, poseStack, bufferSource, -10.0f, 90.0f, light, overlay, PageOn.LEFT_PAGE, HexereiUtil.getColorValue(bookmark_color), drawingType, transformType);
                    }
                    if (slot.getIndex() >= 5 && slot.getIndex() < 10) {
                        float width;
                        float yIn;
                        float xIn = -5.5f + (float)slot.getIndex() * 1.15f;
                        if (PageDrawing.canInteract(leftCursorX, leftCursorY, xIn, yIn = -0.75f - altarTile.buttonScaleRender - 0.25f, width = 0.86f, width, altarTile, drawingType)) {
                            if (!this.bookmarkHovered.contains(slot.getIndex())) {
                                this.bookmarkHovered.add(slot.getIndex());
                            }
                            ArrayList<Component> list = new ArrayList<Component>();
                            if (flag3) {
                                name = bookEntries.chapterList.get((int)Math.max((int)0, (int)bookmark_chapter)).pages.get((int)Math.max((int)0, (int)bookmark_page)).location;
                                bookmarkedPage = BookManager.getBookPages(bookData.getBook(), ResourceLocation.parse((String)name));
                                if (bookmarkedPage != null) {
                                    name = bookmarkedPage.name;
                                }
                                if (name.isEmpty()) {
                                    list.add((Component)Component.translatable((String)"%s%s - Page %s%s", (Object[])new Object[]{Component.translatable((String)"[").withStyle(Style.EMPTY.withColor(HexereiUtil.getColorValue(bookmark_color))), Component.translatable((String)"%s", (Object[])new Object[]{bookEntries.chapterList.get((int)Math.max((int)0, (int)bookmark_chapter)).name}).withStyle(Style.EMPTY.withColor(0x9D9D97)), Component.translatable((String)"%s", (Object[])new Object[]{bookEntries.chapterList.get((int)Math.max((int)0, (int)bookmark_chapter)).pages.get((int)Math.max((int)0, (int)bookmark_page)).pageNum - 1}).withStyle(Style.EMPTY.withColor(0x9D9D97)), Component.translatable((String)"]").withStyle(Style.EMPTY.withColor(HexereiUtil.getColorValue(bookmark_color)))}).withStyle(Style.EMPTY.withColor(0x9D9D97)));
                                } else {
                                    list.add((Component)Component.translatable((String)"%s%s - %s%s", (Object[])new Object[]{Component.translatable((String)"[").withStyle(Style.EMPTY.withColor(HexereiUtil.getColorValue(bookmark_color))), Component.translatable((String)"%s", (Object[])new Object[]{bookEntries.chapterList.get((int)Math.max((int)0, (int)bookmark_chapter)).name}).withStyle(Style.EMPTY.withColor(0x9D9D97)), Component.translatable((String)name).withStyle(Style.EMPTY.withColor(0x9D9D97)), Component.translatable((String)"]").withStyle(Style.EMPTY.withColor(HexereiUtil.getColorValue(bookmark_color)))}).withStyle(Style.EMPTY.withColor(0x9D9D97)));
                                }
                                this.tooltipText = list;
                                this.tooltipStack = ItemStack.EMPTY;
                                this.drawTooltipText = true;
                            }
                        }
                        float bookY = yIn + 0.8f - this.bookmarkHoverAmountRender.get(slot.getIndex()).floatValue() / 2.0f * altarTile.buttonScaleRender;
                        bookImageUnderlay = new BookImage(xIn, bookY, 0.0f, 0.0f, 0.0f, 64.0f, 64.0f, 64.0f, 64.0f, 0.5f, "hexerei:textures/book/bookmark_underlay.png", effectsBookmark);
                        bookImageOverlay = new BookImage(xIn, bookY, 0.0f, 0.0f, 0.0f, 64.0f, 64.0f, 64.0f, 64.0f, 0.5f, "hexerei:textures/book/bookmark_overlay.png", effectsBookmark);
                        this.drawBookmark(bookImageUnderlay, altarTile, poseStack, bufferSource, -10.0f, 0.0f, light, overlay, PageOn.LEFT_PAGE, HexereiUtil.getColorValue(bookmark_color), drawingType, transformType);
                        this.drawBookmark(bookImageOverlay, altarTile, poseStack, bufferSource, -10.0f, 0.0f, light, overlay, PageOn.LEFT_PAGE, HexereiUtil.getColorValue(bookmark_color), drawingType, transformType);
                    }
                    if (slot.getIndex() >= 10 && slot.getIndex() < 15) {
                        float width;
                        float yIn;
                        float xIn = -11.25f + (float)slot.getIndex() * 1.15f;
                        if (PageDrawing.canInteract(rightCursorX, rightCursorY, xIn, yIn = -0.75f - altarTile.buttonScaleRender - 0.25f, width = 0.86f, width, altarTile, drawingType)) {
                            if (!this.bookmarkHovered.contains(slot.getIndex())) {
                                this.bookmarkHovered.add(slot.getIndex());
                            }
                            ArrayList<Component> list = new ArrayList<Component>();
                            if (flag3) {
                                name = bookEntries.chapterList.get((int)Math.max((int)0, (int)bookmark_chapter)).pages.get((int)Math.max((int)0, (int)bookmark_page)).location;
                                bookmarkedPage = BookManager.getBookPages(bookData.getBook(), ResourceLocation.parse((String)name));
                                if (bookmarkedPage != null) {
                                    name = bookmarkedPage.name;
                                }
                                if (name.isEmpty()) {
                                    list.add((Component)Component.translatable((String)"%s%s - Page %s%s", (Object[])new Object[]{Component.translatable((String)"[").withStyle(Style.EMPTY.withColor(HexereiUtil.getColorValue(bookmark_color))), Component.translatable((String)"%s", (Object[])new Object[]{bookEntries.chapterList.get((int)Math.max((int)0, (int)bookmark_chapter)).name}).withStyle(Style.EMPTY.withColor(0x9D9D97)), Component.translatable((String)"%s", (Object[])new Object[]{bookEntries.chapterList.get((int)Math.max((int)0, (int)bookmark_chapter)).pages.get((int)Math.max((int)0, (int)bookmark_page)).pageNum - 1}).withStyle(Style.EMPTY.withColor(0x9D9D97)), Component.translatable((String)"]").withStyle(Style.EMPTY.withColor(HexereiUtil.getColorValue(bookmark_color)))}).withStyle(Style.EMPTY.withColor(0x9D9D97)));
                                } else {
                                    list.add((Component)Component.translatable((String)"%s%s - %s%s", (Object[])new Object[]{Component.translatable((String)"[").withStyle(Style.EMPTY.withColor(HexereiUtil.getColorValue(bookmark_color))), Component.translatable((String)"%s", (Object[])new Object[]{bookEntries.chapterList.get((int)Math.max((int)0, (int)bookmark_chapter)).name}).withStyle(Style.EMPTY.withColor(0x9D9D97)), Component.translatable((String)name).withStyle(Style.EMPTY.withColor(0x9D9D97)), Component.translatable((String)"]").withStyle(Style.EMPTY.withColor(HexereiUtil.getColorValue(bookmark_color)))}).withStyle(Style.EMPTY.withColor(0x9D9D97)));
                                }
                                this.tooltipText = list;
                                this.tooltipStack = ItemStack.EMPTY;
                                this.drawTooltipText = true;
                            }
                        }
                        float bookY = yIn + 0.8f - this.bookmarkHoverAmountRender.get(slot.getIndex()).floatValue() / 2.0f * altarTile.buttonScaleRender;
                        bookImageUnderlay = new BookImage(xIn, bookY, 0.0f, 0.0f, 0.0f, 64.0f, 64.0f, 64.0f, 64.0f, 0.5f, "hexerei:textures/book/bookmark_underlay.png", effectsBookmark);
                        bookImageOverlay = new BookImage(xIn, bookY, 0.0f, 0.0f, 0.0f, 64.0f, 64.0f, 64.0f, 64.0f, 0.5f, "hexerei:textures/book/bookmark_overlay.png", effectsBookmark);
                        this.drawBookmark(bookImageUnderlay, altarTile, poseStack, bufferSource, -10.0f, 0.0f, light, overlay, PageOn.RIGHT_PAGE, HexereiUtil.getColorValue(bookmark_color), drawingType, transformType);
                        this.drawBookmark(bookImageOverlay, altarTile, poseStack, bufferSource, -10.0f, 0.0f, light, overlay, PageOn.RIGHT_PAGE, HexereiUtil.getColorValue(bookmark_color), drawingType, transformType);
                    }
                    if (slot.getIndex() >= 15) {
                        float width;
                        float xIn = 5.2f + altarTile.buttonScaleRender + 0.15f;
                        float yIn = (float)(slot.getIndex() - 15) * 1.5f;
                        if (PageDrawing.canInteract(rightCursorX, rightCursorY, xIn, yIn, width = 0.86f, width, altarTile, drawingType)) {
                            if (!this.bookmarkHovered.contains(slot.getIndex())) {
                                this.bookmarkHovered.add(slot.getIndex());
                            }
                            ArrayList<Component> list = new ArrayList<Component>();
                            if (flag3) {
                                name = bookEntries.chapterList.get((int)Math.max((int)0, (int)bookmark_chapter)).pages.get((int)Math.max((int)0, (int)bookmark_page)).location;
                                bookmarkedPage = BookManager.getBookPages(bookData.getBook(), ResourceLocation.parse((String)name));
                                if (bookmarkedPage != null) {
                                    name = bookmarkedPage.name;
                                }
                                if (name.isEmpty()) {
                                    list.add((Component)Component.translatable((String)"%s%s - Page %s%s", (Object[])new Object[]{Component.translatable((String)"[").withStyle(Style.EMPTY.withColor(HexereiUtil.getColorValue(bookmark_color))), Component.translatable((String)"%s", (Object[])new Object[]{bookEntries.chapterList.get((int)Math.max((int)0, (int)bookmark_chapter)).name}).withStyle(Style.EMPTY.withColor(0x9D9D97)), Component.translatable((String)"%s", (Object[])new Object[]{bookEntries.chapterList.get((int)Math.max((int)0, (int)bookmark_chapter)).pages.get((int)Math.max((int)0, (int)bookmark_page)).pageNum - 1}).withStyle(Style.EMPTY.withColor(0x9D9D97)), Component.translatable((String)"]").withStyle(Style.EMPTY.withColor(HexereiUtil.getColorValue(bookmark_color)))}).withStyle(Style.EMPTY.withColor(0x9D9D97)));
                                } else {
                                    list.add((Component)Component.translatable((String)"%s%s - %s%s", (Object[])new Object[]{Component.translatable((String)"[").withStyle(Style.EMPTY.withColor(HexereiUtil.getColorValue(bookmark_color))), Component.translatable((String)"%s", (Object[])new Object[]{bookEntries.chapterList.get((int)Math.max((int)0, (int)bookmark_chapter)).name}).withStyle(Style.EMPTY.withColor(0x9D9D97)), Component.translatable((String)name).withStyle(Style.EMPTY.withColor(0x9D9D97)), Component.translatable((String)"]").withStyle(Style.EMPTY.withColor(HexereiUtil.getColorValue(bookmark_color)))}).withStyle(Style.EMPTY.withColor(0x9D9D97)));
                                }
                                this.tooltipText = list;
                                this.tooltipStack = ItemStack.EMPTY;
                                this.drawTooltipText = true;
                            }
                        }
                        float bookX = xIn - 0.7f + this.bookmarkHoverAmountRender.get(slot.getIndex()).floatValue() / 2.0f * altarTile.buttonScaleRender;
                        bookImageUnderlay = new BookImage(bookX, yIn, 0.0f, 0.0f, 0.0f, 64.0f, 64.0f, 64.0f, 64.0f, 0.5f, "hexerei:textures/book/bookmark_underlay.png", effectsBookmark);
                        bookImageOverlay = new BookImage(bookX, yIn, 0.0f, 0.0f, 0.0f, 64.0f, 64.0f, 64.0f, 64.0f, 0.5f, "hexerei:textures/book/bookmark_overlay.png", effectsBookmark);
                        this.drawBookmark(bookImageUnderlay, altarTile, poseStack, bufferSource, -10.0f, -90.0f, light, overlay, PageOn.RIGHT_PAGE, HexereiUtil.getColorValue(bookmark_color), drawingType, transformType);
                        this.drawBookmark(bookImageOverlay, altarTile, poseStack, bufferSource, -10.0f, -90.0f, light, overlay, PageOn.RIGHT_PAGE, HexereiUtil.getColorValue(bookmark_color), drawingType, transformType);
                    }
                    if (chapter != bookmark_chapter || page != bookmark_page && page + 1 != bookmark_page || this.bookmarkHovered.contains(slot.getIndex())) continue;
                    this.bookmarkHovered.add(slot.getIndex());
                }
                if (altarTile.slotClicked != -1) {
                    for (int i = 0; i < 20; ++i) {
                        if (i == altarTile.slotClicked) continue;
                        ArrayList<BookImageEffect> effectsBookmark = new ArrayList<BookImageEffect>();
                        if (i < 5) {
                            float xIn = -0.3f - altarTile.buttonScaleRender - 0.15f;
                            float yIn = (float)i * 1.5f;
                            float width = 0.935f;
                            if (PageDrawing.canInteract(leftCursorX, leftCursorY, xIn, yIn, width, width, altarTile, drawingType)) {
                                effectsBookmark.add(new BookImageEffect("scale", 50.0f, 1.15f));
                                effectsBookmark.add(new BookImageEffect("tilt", 35.0f, 10.0f));
                            }
                            BookImage bookSelector = new BookImage(xIn, yIn, 0.0f, 0.0f, 0.0f, 64.0f, 64.0f, 64.0f, 64.0f, 0.5f * altarTile.bookmarkSelectorScale, "hexerei:textures/book/bookmark_selector.png", effectsBookmark);
                            this.drawBookmark(bookSelector, altarTile, poseStack, bufferSource, 1.0f, 90.0f, light, overlay, PageOn.LEFT_PAGE, -1, drawingType, transformType);
                        }
                        if (i >= 5 && i < 10) {
                            float xIn = -5.5f + (float)i * 1.15f;
                            float yIn = -0.75f - altarTile.buttonScaleRender - 0.25f;
                            float width = 0.935f;
                            if (PageDrawing.canInteract(leftCursorX, leftCursorY, xIn, yIn, width, width, altarTile, drawingType)) {
                                effectsBookmark.add(new BookImageEffect("scale", 50.0f, 1.15f));
                                effectsBookmark.add(new BookImageEffect("tilt", 35.0f, 10.0f));
                            }
                            BookImage bookSelector = new BookImage(xIn, yIn, 0.0f, 0.0f, 0.0f, 64.0f, 64.0f, 64.0f, 64.0f, 0.5f * altarTile.bookmarkSelectorScale, "hexerei:textures/book/bookmark_selector.png", effectsBookmark);
                            this.drawBookmark(bookSelector, altarTile, poseStack, bufferSource, 1.0f, 0.0f, light, overlay, PageOn.LEFT_PAGE, -1, drawingType, transformType);
                        }
                        if (i >= 10 && i < 15) {
                            float xIn = -11.25f + (float)i * 1.15f;
                            float yIn = -0.75f - altarTile.buttonScaleRender - 0.25f;
                            float width = 0.935f;
                            if (PageDrawing.canInteract(rightCursorX, rightCursorY, xIn, yIn, width, width, altarTile, drawingType)) {
                                effectsBookmark.add(new BookImageEffect("scale", 50.0f, 1.15f));
                                effectsBookmark.add(new BookImageEffect("tilt", 35.0f, 10.0f));
                            }
                            BookImage bookSelector = new BookImage(xIn, yIn, 0.0f, 0.0f, 0.0f, 64.0f, 64.0f, 64.0f, 64.0f, 0.5f * altarTile.bookmarkSelectorScale, "hexerei:textures/book/bookmark_selector.png", effectsBookmark);
                            this.drawBookmark(bookSelector, altarTile, poseStack, bufferSource, 1.0f, 0.0f, light, overlay, PageOn.RIGHT_PAGE, -1, drawingType, transformType);
                        }
                        if (i < 15) continue;
                        float xIn = 5.2f + altarTile.buttonScaleRender + 0.15f;
                        float yIn = (float)(i - 15) * 1.5f;
                        float width = 0.935f;
                        if (PageDrawing.canInteract(rightCursorX, rightCursorY, xIn, yIn, width, width, altarTile, drawingType)) {
                            effectsBookmark.add(new BookImageEffect("scale", 50.0f, 1.15f));
                            effectsBookmark.add(new BookImageEffect("tilt", 35.0f, 10.0f));
                        }
                        BookImage bookSelector = new BookImage(xIn, yIn, 0.0f, 0.0f, 0.0f, 64.0f, 64.0f, 64.0f, 64.0f, 0.5f * altarTile.bookmarkSelectorScale, "hexerei:textures/book/bookmark_selector.png", effectsBookmark);
                        this.drawBookmark(bookSelector, altarTile, poseStack, bufferSource, 1.0f, -90.0f, light, overlay, PageOn.RIGHT_PAGE, -1, drawingType, transformType);
                    }
                }
            }
            if (drawingType != DrawingType.GUI) {
                float width;
                float y;
                float x;
                effects = new ArrayList();
                bookImageEffect_scale = new BookImageEffect("scale", 50.0f, 1.15f);
                bookImageEffect_tilt = new BookImageEffect("tilt", 35.0f, 10.0f);
                String loc = "hexerei:textures/book/font_button.png";
                if (drawBack) {
                    loc = "hexerei:textures/book/back_page.png";
                }
                if (PageDrawing.canInteract(leftCursorX, leftCursorY, x = -0.45f, y = 7.2f, width = 0.86f, width, altarTile, drawingType)) {
                    effects.add(bookImageEffect_scale);
                    effects.add(bookImageEffect_tilt);
                    ArrayList<Component> list = new ArrayList<Component>();
                    if (drawBack) {
                        list.add((Component)Component.translatable((String)"Back").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(0x9D9D97)));
                        loc = "hexerei:textures/book/back_page_hover.png";
                    } else {
                        list.add((Component)Component.translatable((String)"Change Font").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(0x9D9D97)));
                        loc = "hexerei:textures/book/font_button_hover.png";
                    }
                    this.tooltipText = list;
                    this.tooltipStack = ItemStack.EMPTY;
                    this.drawTooltipText = true;
                }
                BookImage bookImage = new BookImage(-0.5f, 7.25f, 0.0f, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f, altarTile.buttonScaleRender / 2.0f, loc, effects);
                this.drawImage(bookImage, altarTile, leftCursorX, leftCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.LEFT_PAGE, drawingType);
            }
            if (drawingType != DrawingType.GUI) {
                ArrayList<Object> list;
                effects = new ArrayList();
                bookImageEffect_scale = new BookImageEffect("scale", 50.0f, 1.15f);
                bookImageEffect_tilt = new BookImageEffect("tilt", 35.0f, 10.0f);
                String loc_close = "hexerei:textures/book/close.png";
                String loc_del = "hexerei:textures/book/delete.png";
                float width = 0.86f;
                if (PageDrawing.canInteract(rightCursorX, rightCursorY, -0.25f - width / 2.0f, 7.5f - width / 2.0f, width, width, altarTile, drawingType)) {
                    effects.add(bookImageEffect_scale);
                    effects.add(bookImageEffect_tilt);
                    if (altarTile.slotClicked != -1 && altarTile.slotClickedTick > 5) {
                        loc_del = "hexerei:textures/book/delete_hover.png";
                        list = new ArrayList();
                        list.add((Component)Component.translatable((String)"Delete Bookmark").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(0x9D9D97)));
                        this.tooltipText = list;
                    } else {
                        loc_close = "hexerei:textures/book/close_hover.png";
                        list = new ArrayList<Component>();
                        list.add((Component)Component.translatable((String)"Close Book").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(0x9D9D97)));
                        this.tooltipText = list;
                    }
                    this.drawTooltipText = true;
                    this.tooltipStack = ItemStack.EMPTY;
                }
                BookImage bookImage = altarTile.slotClicked != -1 && altarTile.slotClickedTick > 5 ? new BookImage(0.0f, 0.0f, 35.0f, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f, altarTile.bookmarkSelectorScale / 1.5f, loc_del, effects) : new BookImage(0.0f, 0.0f, 35.0f, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f, altarTile.buttonScaleRender / 2.0f, loc_close, effects);
                this.drawImage(bookImage, altarTile, rightCursorX, rightCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.MIDDLE_BUTTON, drawingType);
                effects = new ArrayList();
                bookImageEffect_scale = new BookImageEffect("scale", 50.0f, 1.15f);
                bookImageEffect_tilt = new BookImageEffect("tilt", 35.0f, 10.0f);
                String loc = "hexerei:textures/book/home.png";
                if (PageDrawing.canInteract(rightCursorX, rightCursorY, -0.25f - width / 2.0f, -0.5f - width / 2.0f, width, width, altarTile, drawingType)) {
                    effects.add(bookImageEffect_scale);
                    effects.add(bookImageEffect_tilt);
                    loc = "hexerei:textures/book/home_hover.png";
                    list = new ArrayList<Component>();
                    list.add(Component.translatable((String)"Home").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(0x9D9D97)));
                    this.tooltipText = list;
                    this.drawTooltipText = true;
                    this.tooltipStack = ItemStack.EMPTY;
                }
                bookImage = new BookImage(0.0f, -8.1f, 0.0f, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f, altarTile.buttonScaleRender / 2.0f, loc, effects);
                this.drawImage(bookImage, altarTile, rightCursorX, rightCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.MIDDLE_BUTTON, drawingType);
                if (drawNext) {
                    effects = new ArrayList();
                    bookImageEffect_scale = new BookImageEffect("scale", 50.0f, 1.15f);
                    bookImageEffect_tilt = new BookImageEffect("tilt", 35.0f, 10.0f);
                    loc = "hexerei:textures/book/next_page.png";
                    if (PageDrawing.canInteract(rightCursorX, rightCursorY, 5.415f, 7.2f, 0.86f, 0.86f, altarTile, drawingType)) {
                        effects.add(bookImageEffect_scale);
                        effects.add(bookImageEffect_tilt);
                        loc = "hexerei:textures/book/next_page_hover.png";
                        list = new ArrayList();
                        list.add((Component)Component.translatable((String)"Next").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(0x9D9D97)));
                        this.tooltipText = list;
                        this.drawTooltipText = true;
                        this.tooltipStack = ItemStack.EMPTY;
                    }
                    bookImage = new BookImage(5.5f, 7.25f, 0.0f, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f, altarTile.buttonScaleRender / 2.0f, loc, effects);
                    this.drawImage(bookImage, altarTile, rightCursorX, rightCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.RIGHT_PAGE, drawingType);
                }
                if (drawingType != DrawingType.SCREEN) {
                    effects = new ArrayList();
                    bookImageEffect_scale = new BookImageEffect("scale", 50.0f, 1.15f);
                    bookImageEffect_tilt = new BookImageEffect("tilt", 35.0f, 10.0f);
                    loc = "hexerei:textures/book/open_gui.png";
                    if (Minecraft.getInstance().screen == null && PageDrawing.canInteract(5.49f, -0.97f, 0.86f, 0.86f, altarTile, PageOn.RIGHT_PAGE)) {
                        effects.add(bookImageEffect_scale);
                        effects.add(bookImageEffect_tilt);
                        loc = "hexerei:textures/book/open_gui_hover.png";
                        list = new ArrayList();
                        list.add((Component)Component.translatable((String)"Open in GUI").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(0x9D9D97)));
                        this.tooltipText = list;
                        this.drawTooltipText = true;
                        this.tooltipStack = ItemStack.EMPTY;
                    }
                    bookImage = new BookImage(5.5f, -1.0f, 0.0f, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f, altarTile.buttonScaleRender / 2.0f, loc, effects);
                    this.drawImage(bookImage, altarTile, rightCursorX, rightCursorY, poseStack, bufferSource, 0.0f, light, overlay, PageOn.RIGHT_PAGE, drawingType);
                }
            }
        }
    }

    private float moveTo(float input, float moveTo, float speed) {
        float distance = moveTo - input;
        if (Math.abs(distance) <= speed) {
            return moveTo;
        }
        input = distance > 0.0f ? (input += speed) : (input -= speed);
        return input;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawItemInSlot(BookOfShadowsAltarTile altarTile, BookItemsAndFluids bookItemStackInSlot, PoseStack poseStack, MultiBufferSource bufferSource, float xIn, float yIn, float zLevel, int light, int overlay, PageOn pageOn, DrawingType drawingType) {
        if (bookItemStackInSlot.type.equals("item") || bookItemStackInSlot.type.equals("tag")) {
            if (bookItemStackInSlot.show_slot) {
                this.drawSlot(altarTile, poseStack, bufferSource, xIn, yIn, 0.0f, light, overlay, pageOn, drawingType);
            }
            PageDrawing.renderItem(altarTile, bookItemStackInSlot, poseStack, bufferSource, xIn, yIn, 0.0f, light, overlay, pageOn, drawingType);
        } else if (bookItemStackInSlot.type.equals("fluid")) {
            this.drawFluidInSlot(altarTile, bookItemStackInSlot, poseStack, bufferSource, xIn, yIn, 0.0f, light, overlay, pageOn, drawingType);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawBlock(BookOfShadowsAltarTile altarTile, BookBlocks bookItemStackInSlot, PoseStack poseStack, MultiBufferSource bufferSource, float xIn, float yIn, float zLevel, int light, int overlay, PageOn pageOn, DrawingType drawingType) {
        if (bookItemStackInSlot.type.equals("block") || bookItemStackInSlot.type.equals("tag")) {
            if (bookItemStackInSlot.show_slot) {
                this.drawSlot(altarTile, poseStack, bufferSource, xIn, yIn, 0.0f, light, overlay, pageOn, drawingType);
            }
            PageDrawing.renderBlock(altarTile, bookItemStackInSlot, poseStack, bufferSource, xIn, yIn, 0.0f, light, overlay, pageOn, drawingType);
        }
    }

    public static Vec3 getPointOnPlane(float x, float y, float xscale, float yscale, BookOfShadowsAltarTile altarTile, PageOn pageOn) {
        Vector3f leftOffset = new Vector3f(0.375f, 0.532f, -0.03f);
        Vector3f rightOffset = new Vector3f(-0.012f, 0.532f, -0.03f);
        return PageDrawing.getPointOnPlane(leftOffset, rightOffset, x, y, xscale, yscale, altarTile, pageOn);
    }

    public static Vec3 getPointOnPlane(Vector3f leftOffset, Vector3f rightOffset, float x, float y, float xscale, float yscale, BookOfShadowsAltarTile altarTile, PageOn pageOn) {
        Vector3f offset = pageOn == PageOn.RIGHT_PAGE ? rightOffset : leftOffset;
        BlockPos blockPos = altarTile.getBlockPos();
        Vec3 pointBase = new Vec3((double)((float)blockPos.getX() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.3f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)((float)blockPos.getY() + 1.125f + (BookOfShadowsAltarTile.easeFlop(1.0f - altarTile.degreesFlopped / 90.0f) - 1.0f) / 16.0f), (double)((float)blockPos.getZ() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.3f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
        Vector3f vector3f = new Vector3f(offset.x, offset.y, offset.z).add(x * -xscale, y * -yscale, 0.03f);
        vector3f.rotate((Quaternionfc)Axis.YP.rotationDegrees((float)(pageOn == PageOn.RIGHT_PAGE ? -1 : 1) * (10.0f + altarTile.degreesOpened / 1.12f)));
        vector3f.add(0.0f, 0.0f, -0.03f);
        vector3f.rotate((Quaternionfc)Axis.XP.rotationDegrees(45.0f - altarTile.degreesOpened / 2.0f));
        vector3f.rotate((Quaternionfc)Axis.YP.rotationDegrees(altarTile.degreesSpun));
        return pointBase.add((double)vector3f.x, (double)vector3f.y, (double)vector3f.z);
    }

    public void tick() {
        isClickedOld = isClicked;
        this.bookmarkHoverAmountOld = new ArrayList<Float>(this.bookmarkHoverAmount);
        for (int i = 0; i < this.bookmarkHoverAmount.size(); ++i) {
            int finalI = i;
            if (!this.bookmarkHovered.stream().filter(f -> f == finalI).toList().isEmpty()) {
                this.bookmarkHoverAmount.set(i, Float.valueOf(this.moveTo(this.bookmarkHoverAmount.get(i).floatValue(), 1.0f, 0.1f)));
                continue;
            }
            this.bookmarkHoverAmount.set(i, Float.valueOf(this.moveTo(this.bookmarkHoverAmount.get(i).floatValue(), 0.0f, 0.05f)));
        }
        this.bookmarkHovered = new ArrayList();
        this.drawTooltipScaleOld = this.drawTooltipScale;
        if (this.drawTooltipStack && this.drawTooltip) {
            this.drawTooltipStackFlag = true;
            this.drawTooltipTextFlag = false;
            this.drawTooltipScale = this.moveTo(this.drawTooltipScale, 1.0f, 0.1f);
        } else if (this.drawTooltipText && this.drawTooltip) {
            this.drawTooltipTextFlag = true;
            this.drawTooltipStackFlag = false;
            this.drawTooltipScale = this.moveTo(this.drawTooltipScale, 1.0f, 0.1f);
        } else {
            this.drawTooltipScale = this.moveTo(this.drawTooltipScale, 0.0f, 0.2f);
            if (this.drawTooltipScale == 0.0f) {
                this.drawTooltipStackFlag = false;
                this.drawTooltipTextFlag = false;
            }
        }
        boolean debugDraw = false;
        if (this.altarTile.currentBook != null && BookManager.getBookEntries(this.altarTile.currentBook.getBook()) != null && this.altarTile.openedPercent != 1.0f && debugDraw) {
            boolean drawCorners;
            Vec3 planePoint2;
            Vec3 planePoint;
            float yscale;
            float height;
            float width;
            boolean drawBookmarks;
            float yIn;
            float xIn;
            int i;
            BookEntries bookEntries = BookManager.getBookEntries(this.altarTile.currentBook.getBook());
            boolean drawEdges = true;
            if (drawEdges) {
                Vec3 planePoint3;
                float yscale2;
                float xscale;
                int count = 15;
                for (i = 0; i < count + 1; ++i) {
                    xIn = -0.5f + (float)i * 6.5f / (float)count;
                    yIn = -1.0f;
                    xscale = 0.062f;
                    yscale2 = 0.062f;
                    planePoint3 = PageDrawing.getPointOnPlane(xIn, yIn, xscale, yscale2, this.altarTile, PageOn.LEFT_PAGE);
                    this.altarTile.getLevel().addParticle((ParticleOptions)ModParticleTypes.BOOK_TEST.get(), planePoint3.x, planePoint3.y, planePoint3.z, 0.0, 0.0, 0.0);
                }
                for (i = 0; i < count + 1; ++i) {
                    xIn = -0.5f + (float)i * 6.5f / (float)count;
                    yIn = 8.0f;
                    xscale = 0.062f;
                    yscale2 = 0.062f;
                    planePoint3 = PageDrawing.getPointOnPlane(xIn, yIn, xscale, yscale2, this.altarTile, PageOn.LEFT_PAGE);
                    this.altarTile.getLevel().addParticle((ParticleOptions)ModParticleTypes.BOOK_TEST.get(), planePoint3.x, planePoint3.y, planePoint3.z, 0.0, 0.0, 0.0);
                }
                for (i = 0; i < count + 1; ++i) {
                    xIn = -0.5f;
                    yIn = (float)(i * 9) / (float)count - 1.0f;
                    xscale = 0.062f;
                    yscale2 = 0.062f;
                    planePoint3 = PageDrawing.getPointOnPlane(xIn, yIn, xscale, yscale2, this.altarTile, PageOn.LEFT_PAGE);
                    this.altarTile.getLevel().addParticle((ParticleOptions)ModParticleTypes.BOOK_TEST.get(), planePoint3.x, planePoint3.y, planePoint3.z, 0.0, 0.0, 0.0);
                }
                for (i = 0; i < count + 1; ++i) {
                    xIn = -0.15f + (float)i * 6.5f / (float)count;
                    yIn = -1.0f;
                    xscale = 0.062f;
                    yscale2 = 0.062f;
                    planePoint3 = PageDrawing.getPointOnPlane(xIn, yIn, xscale, yscale2, this.altarTile, PageOn.RIGHT_PAGE);
                    this.altarTile.getLevel().addParticle((ParticleOptions)ModParticleTypes.BOOK_TEST.get(), planePoint3.x, planePoint3.y, planePoint3.z, 0.0, 0.0, 0.0);
                }
                for (i = 0; i < count + 1; ++i) {
                    xIn = -0.15f + (float)i * 6.5f / (float)count;
                    yIn = 8.0f;
                    xscale = 0.062f;
                    yscale2 = 0.062f;
                    planePoint3 = PageDrawing.getPointOnPlane(xIn, yIn, xscale, yscale2, this.altarTile, PageOn.RIGHT_PAGE);
                    this.altarTile.getLevel().addParticle((ParticleOptions)ModParticleTypes.BOOK_TEST.get(), planePoint3.x, planePoint3.y, planePoint3.z, 0.0, 0.0, 0.0);
                }
                for (i = 0; i < count + 1; ++i) {
                    xIn = 6.35f;
                    yIn = (float)(i * 9) / (float)count - 1.0f;
                    xscale = 0.062f;
                    yscale2 = 0.062f;
                    planePoint3 = PageDrawing.getPointOnPlane(xIn, yIn, xscale, yscale2, this.altarTile, PageOn.RIGHT_PAGE);
                    this.altarTile.getLevel().addParticle((ParticleOptions)ModParticleTypes.BOOK_TEST.get(), planePoint3.x, planePoint3.y, planePoint3.z, 0.0, 0.0, 0.0);
                }
            }
            if (drawBookmarks = false) {
                for (i = 0; i < 5; ++i) {
                    xIn = -0.3f - this.altarTile.buttonScaleRender - 0.15f;
                    yIn = (float)i * 1.5f;
                    width = 0.935f;
                    height = 0.935f;
                    float xscale = 0.062f;
                    yscale = 0.062f;
                    planePoint = PageDrawing.getPointOnPlane(xIn, yIn, xscale, yscale, this.altarTile, PageOn.LEFT_PAGE);
                    planePoint2 = PageDrawing.getPointOnPlane(xIn + width, yIn + height, xscale, yscale, this.altarTile, PageOn.LEFT_PAGE);
                    this.altarTile.getLevel().addParticle((ParticleOptions)ModParticleTypes.BOOK_TEST.get(), planePoint.x, planePoint.y, planePoint.z, 0.0, 0.0, 0.0);
                    this.altarTile.getLevel().addParticle((ParticleOptions)ModParticleTypes.BOOK_TEST.get(), planePoint2.x, planePoint2.y, planePoint2.z, 0.0, 0.0, 0.0);
                }
                for (i = 5; i < 10; ++i) {
                    xIn = -5.5f + (float)i * 1.15f;
                    yIn = -0.75f - this.altarTile.buttonScaleRender - 0.25f;
                    width = 0.935f;
                    height = 0.935f;
                    float xscale = 0.062f;
                    yscale = 0.062f;
                    planePoint = PageDrawing.getPointOnPlane(xIn, yIn, xscale, yscale, this.altarTile, PageOn.LEFT_PAGE);
                    planePoint2 = PageDrawing.getPointOnPlane(xIn + width, yIn + height, xscale, yscale, this.altarTile, PageOn.LEFT_PAGE);
                    this.altarTile.getLevel().addParticle((ParticleOptions)ModParticleTypes.BOOK_TEST.get(), planePoint.x, planePoint.y, planePoint.z, 0.0, 0.0, 0.0);
                    this.altarTile.getLevel().addParticle((ParticleOptions)ModParticleTypes.BOOK_TEST.get(), planePoint2.x, planePoint2.y, planePoint2.z, 0.0, 0.0, 0.0);
                }
                for (i = 10; i < 15; ++i) {
                    xIn = -11.25f + (float)i * 1.15f;
                    yIn = -0.75f - this.altarTile.buttonScaleRender - 0.25f;
                    width = 0.935f;
                    height = 0.935f;
                    float xscale = 0.062f;
                    yscale = 0.062f;
                    planePoint = PageDrawing.getPointOnPlane(xIn, yIn, xscale, yscale, this.altarTile, PageOn.RIGHT_PAGE);
                    planePoint2 = PageDrawing.getPointOnPlane(xIn + width, yIn + height, xscale, yscale, this.altarTile, PageOn.RIGHT_PAGE);
                    this.altarTile.getLevel().addParticle((ParticleOptions)ModParticleTypes.BOOK_TEST.get(), planePoint.x, planePoint.y, planePoint.z, 0.0, 0.0, 0.0);
                    this.altarTile.getLevel().addParticle((ParticleOptions)ModParticleTypes.BOOK_TEST.get(), planePoint2.x, planePoint2.y, planePoint2.z, 0.0, 0.0, 0.0);
                }
                for (i = 15; i < 20; ++i) {
                    xIn = 5.2f + this.altarTile.buttonScaleRender + 0.15f;
                    yIn = (float)(i - 15) * 1.5f;
                    width = 0.935f;
                    height = 0.935f;
                    float xscale = 0.062f;
                    yscale = 0.062f;
                    planePoint = PageDrawing.getPointOnPlane(xIn, yIn, xscale, yscale, this.altarTile, PageOn.RIGHT_PAGE);
                    planePoint2 = PageDrawing.getPointOnPlane(xIn + width, yIn + height, xscale, yscale, this.altarTile, PageOn.RIGHT_PAGE);
                    this.altarTile.getLevel().addParticle((ParticleOptions)ModParticleTypes.BOOK_TEST.get(), planePoint.x, planePoint.y, planePoint.z, 0.0, 0.0, 0.0);
                    this.altarTile.getLevel().addParticle((ParticleOptions)ModParticleTypes.BOOK_TEST.get(), planePoint2.x, planePoint2.y, planePoint2.z, 0.0, 0.0, 0.0);
                }
            }
            if (drawCorners = false) {
                xIn = 5.415f;
                yIn = 7.2f;
                width = 0.86f;
                height = 0.86f;
                float xscale = 0.062f;
                yscale = 0.062f;
                planePoint = PageDrawing.getPointOnPlane(xIn, yIn, xscale, yscale, this.altarTile, PageOn.RIGHT_PAGE);
                planePoint2 = PageDrawing.getPointOnPlane(xIn + width, yIn + height, xscale, yscale, this.altarTile, PageOn.RIGHT_PAGE);
                this.altarTile.getLevel().addParticle((ParticleOptions)ModParticleTypes.BOOK_TEST.get(), planePoint.x, planePoint.y, planePoint.z, 0.0, 0.0, 0.0);
                this.altarTile.getLevel().addParticle((ParticleOptions)ModParticleTypes.BOOK_TEST.get(), planePoint2.x, planePoint2.y, planePoint2.z, 0.0, 0.0, 0.0);
                xIn = 5.415f;
                yIn = -0.97f;
                width = 0.86f;
                height = 0.86f;
                xscale = 0.062f;
                yscale = 0.062f;
                planePoint = PageDrawing.getPointOnPlane(xIn, yIn, xscale, yscale, this.altarTile, PageOn.RIGHT_PAGE);
                planePoint2 = PageDrawing.getPointOnPlane(xIn + width, yIn + height, xscale, yscale, this.altarTile, PageOn.RIGHT_PAGE);
                this.altarTile.getLevel().addParticle((ParticleOptions)ModParticleTypes.BOOK_TEST.get(), planePoint.x, planePoint.y, planePoint.z, 0.0, 0.0, 0.0);
                this.altarTile.getLevel().addParticle((ParticleOptions)ModParticleTypes.BOOK_TEST.get(), planePoint2.x, planePoint2.y, planePoint2.z, 0.0, 0.0, 0.0);
                xIn = -0.45f;
                yIn = -0.96f;
                width = 0.86f;
                height = 0.86f;
                xscale = 0.062f;
                yscale = 0.062f;
                planePoint = PageDrawing.getPointOnPlane(xIn, yIn, xscale, yscale, this.altarTile, PageOn.LEFT_PAGE);
                planePoint2 = PageDrawing.getPointOnPlane(xIn + width, yIn + height, xscale, yscale, this.altarTile, PageOn.LEFT_PAGE);
                this.altarTile.getLevel().addParticle((ParticleOptions)ModParticleTypes.BOOK_TEST.get(), planePoint.x, planePoint.y, planePoint.z, 0.0, 0.0, 0.0);
                this.altarTile.getLevel().addParticle((ParticleOptions)ModParticleTypes.BOOK_TEST.get(), planePoint2.x, planePoint2.y, planePoint2.z, 0.0, 0.0, 0.0);
                xIn = -0.45f;
                yIn = 7.2f;
                width = 0.86f;
                height = 0.86f;
                xscale = 0.062f;
                yscale = 0.062f;
                planePoint = PageDrawing.getPointOnPlane(xIn, yIn, xscale, yscale, this.altarTile, PageOn.LEFT_PAGE);
                planePoint2 = PageDrawing.getPointOnPlane(xIn + width, yIn + height, xscale, yscale, this.altarTile, PageOn.LEFT_PAGE);
                this.altarTile.getLevel().addParticle((ParticleOptions)ModParticleTypes.BOOK_TEST.get(), planePoint.x, planePoint.y, planePoint.z, 0.0, 0.0, 0.0);
                this.altarTile.getLevel().addParticle((ParticleOptions)ModParticleTypes.BOOK_TEST.get(), planePoint2.x, planePoint2.y, planePoint2.z, 0.0, 0.0, 0.0);
            }
            String location1 = "";
            String location2 = "";
            int chapter = this.altarTile.currentBook.getChapter();
            int page = this.altarTile.currentBook.getPage();
            if (page % 2 == 1) {
                --page;
            }
            if (bookEntries.chapterList.get((int)chapter).pages.size() > page && page >= 0) {
                location1 = bookEntries.chapterList.get((int)chapter).pages.get((int)page).location;
            }
            if (bookEntries.chapterList.get((int)chapter).pages.size() > page + 1 && page >= 0) {
                location2 = bookEntries.chapterList.get((int)chapter).pages.get((int)(page + 1)).location;
            }
            BookPage page1 = BookManager.getBookPages(this.altarTile.currentBook.getBook(), ResourceLocation.parse((String)location1));
            BookPage page2 = BookManager.getBookPages(this.altarTile.currentBook.getBook(), ResourceLocation.parse((String)location2));
            MutableComponent component = Component.literal((String)"");
            for (PageOn pageOn : List.of(PageOn.LEFT_PAGE, PageOn.RIGHT_PAGE)) {
                BookPage pageUsed = pageOn == PageOn.LEFT_PAGE ? page1 : page2;
                if (pageUsed == null) continue;
                for (BookEntity entity : pageUsed.entityList) {
                    float xIn2 = entity.x + entity.offset.x + 0.52f;
                    float yIn2 = entity.y + entity.offset.y;
                    float xscale = 0.062f;
                    float width2 = 1.25f + entity.scale / 5.0f;
                    Vec3 planePoint22 = PageDrawing.getPointOnPlane(xIn2 - width2 / 2.0f, yIn2 - width2 / 2.0f, xscale, xscale, this.altarTile, pageOn);
                    Vec3 planePoint3 = PageDrawing.getPointOnPlane(xIn2 + width2 / 2.0f, yIn2 + width2 / 2.0f, xscale, xscale, this.altarTile, pageOn);
                    this.altarTile.getLevel().addParticle((ParticleOptions)ModParticleTypes.BOOK_TEST.get(), planePoint22.x, planePoint22.y, planePoint22.z, 0.0, 0.0, 0.0);
                    this.altarTile.getLevel().addParticle((ParticleOptions)ModParticleTypes.BOOK_TEST.get(), planePoint3.x, planePoint3.y, planePoint3.z, 0.0, 0.0, 0.0);
                }
                Vec2 ip = PageDrawing.getIntersectPoint(Hexerei.proxy.getPlayer().getLookAngle(), Hexerei.proxy.getPlayer().getEyePosition(), this.altarTile, pageOn);
                if (ip == null) continue;
                if (!component.getString().isEmpty()) {
                    component.append((Component)Component.literal((String)"    -    "));
                }
                component.append((Component)Component.literal((String)(String.valueOf((Object)pageOn) + String.format(": %.3f,  %.3f", Float.valueOf(ip.x), Float.valueOf(ip.y)))));
                Vec3 planePoint4 = PageDrawing.getPointOnPlane(ip.x, ip.y, 0.062f, 0.062f, this.altarTile, pageOn);
                this.altarTile.getLevel().addParticle((ParticleOptions)ModParticleTypes.BOOK_TEST.get(), planePoint4.x, planePoint4.y, planePoint4.z, 2.0, 0.0, 0.0);
            }
            if (!component.getString().isEmpty() && Math.sqrt(this.altarTile.getBlockPos().distToCenterSqr((Position)Hexerei.proxy.getPlayer().getEyePosition())) < Hexerei.proxy.getPlayer().getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE)) {
                Hexerei.proxy.getPlayer().displayClientMessage((Component)component, true);
            }
        }
    }

    public static String getModNameForModId(String modId) {
        return HexereiUtil.getModNameForModId(modId);
    }

    public static List<BlockPos> getAltars(Player playerIn) {
        double reach = playerIn.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
        ArrayList<BlockPos> altars = new ArrayList<BlockPos>();
        float f = playerIn.getXRot();
        float f1 = playerIn.getYRot();
        Vec3 vec3 = playerIn.getEyePosition();
        Vec3 vec31 = new Vec3(0.0, 0.0, 0.25);
        float f2 = Mth.cos((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.sin((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.cos((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.sin((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        float section = 0.0f;
        while ((double)section <= reach) {
            BlockPos pos = BlockPos.containing((Position)vec3.add((double)f6 * (double)section, (double)f5 * (double)section - 1.0, (double)f7 * (double)section));
            BlockPos pos2 = BlockPos.containing((Position)vec3.add((double)f6 * (double)section, (double)f5 * (double)section - 1.0, (double)f7 * (double)section).add(vec31.yRot(f1).yRot((float)Math.toRadians(90.0))));
            BlockPos pos3 = BlockPos.containing((Position)vec3.add((double)f6 * (double)section, (double)f5 * (double)section - 1.0, (double)f7 * (double)section).add(vec31.yRot(f1).yRot((float)Math.toRadians(-90.0))));
            if (!altars.contains(pos)) {
                altars.add(pos);
            }
            if (!altars.contains(pos2)) {
                altars.add(pos2);
            }
            if (!altars.contains(pos3)) {
                altars.add(pos3);
            }
            if ((double)section > reach) {
                section = (float)reach;
                pos = BlockPos.containing((Position)vec3.add((double)f6 * (double)section, (double)f5 * (double)section - 1.0, (double)f7 * (double)section));
                pos2 = BlockPos.containing((Position)vec3.add((double)f6 * (double)section, (double)f5 * (double)section - 1.0, (double)f7 * (double)section).add(vec31.yRot(f1).yRot((float)Math.toRadians(90.0))));
                pos3 = BlockPos.containing((Position)vec3.add((double)f6 * (double)section, (double)f5 * (double)section - 1.0, (double)f7 * (double)section).add(vec31.yRot(f1).yRot((float)Math.toRadians(-90.0))));
                if (!altars.contains(pos)) {
                    altars.add(pos);
                }
                if (!altars.contains(pos2)) {
                    altars.add(pos2);
                }
                if (altars.contains(pos3)) break;
                altars.add(pos3);
                break;
            }
            section += 0.25f;
        }
        return altars;
    }

    public static Vec3 calculatePlaneNormal(Vec3 originPointOnPlane, Vec3 anotherPointOnPlane, Vec3 thirdPointOnPlane) {
        Vec3 V1 = anotherPointOnPlane.subtract(originPointOnPlane);
        Vec3 V2 = thirdPointOnPlane.subtract(originPointOnPlane);
        Vec3 normal = V1.cross(V2).normalize();
        return normal;
    }

    public static Vec2 getLookingAtPointOnPlane(Vec3 originPointOnPlane, Vec3 anotherPointOnPlane, Vec3 thirdPointOnPlane, Vec3 rayStart, Vec3 rayDirection) {
        Vec3 planeNormal = PageDrawing.calculatePlaneNormal(originPointOnPlane, anotherPointOnPlane, thirdPointOnPlane);
        Vec3 u = anotherPointOnPlane.subtract(originPointOnPlane).normalize();
        Vec3 v = planeNormal.cross(u).normalize();
        double t = planeNormal.dot(originPointOnPlane.subtract(rayStart)) / planeNormal.dot(rayDirection);
        if (t < 0.0) {
            return null;
        }
        Vec3 intersection = rayStart.add(rayDirection.scale(t));
        Vec3 planeToPoint = intersection.subtract(originPointOnPlane);
        double x = planeToPoint.dot(u);
        double y = planeToPoint.dot(v);
        return new Vec2((float)x, (float)y);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean canInteract(float x, float y, float width, float height, BookOfShadowsAltarTile altarTile, PageOn pageOn) {
        LocalPlayer player = Minecraft.getInstance().player;
        Vec2 ip = PageDrawing.getIntersectPoint(player.getLookAngle(), player.getEyePosition(), altarTile, pageOn);
        return ip != null && ip.x >= x && ip.x <= x + width && ip.y >= y && ip.y <= y + height && Math.sqrt(altarTile.getBlockPos().distToCenterSqr((Position)player.getEyePosition())) <= player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean canInteract(float xCursor, float yCursor, float x, float y, float width, float height, BookOfShadowsAltarTile altarTile, DrawingType drawingType) {
        LocalPlayer player = Minecraft.getInstance().player;
        return xCursor >= x && xCursor <= x + width && yCursor >= y && yCursor <= y + height && (drawingType == DrawingType.SCREEN || Math.sqrt(altarTile.getBlockPos().distToCenterSqr((Position)player.getEyePosition())) <= player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean canInteract(Vector3f leftOffset, Vector3f rightOffset, float x, float y, float width, float height, Player player, BookOfShadowsAltarTile altarTile, PageOn pageOn) {
        Vec2 ip = PageDrawing.getIntersectPoint(leftOffset, rightOffset, player.getLookAngle(), player.getEyePosition(), altarTile, pageOn);
        return ip != null && ip.x >= x && ip.x <= x + width && ip.y >= y && ip.y <= y + height && Math.sqrt(altarTile.getBlockPos().distToCenterSqr((Position)player.getEyePosition())) <= player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Vec2 getIntersectPoint(Vec3 rayVector, Vec3 rayPoint, BookOfShadowsAltarTile altarTile, PageOn pageOn) {
        Vector3f rightOffset = new Vector3f(-0.012f, 0.532f, -0.03f);
        Vector3f leftOffset = new Vector3f(0.375f, 0.532f, -0.03f);
        return PageDrawing.getIntersectPoint(leftOffset, rightOffset, rayVector, rayPoint, altarTile, pageOn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Vec2 getIntersectPoint(Vector3f leftOffset, Vector3f rightOffset, Vec3 rayVector, Vec3 rayPoint, BookOfShadowsAltarTile altarTile, PageOn pageOn) {
        if (pageOn != PageOn.LEFT_PAGE && pageOn != PageOn.RIGHT_PAGE && pageOn != PageOn.MIDDLE_BUTTON) {
            return null;
        }
        float scale = 0.062f;
        Vector3f middleOffset = new Vector3f(0.0f, 0.5f, -0.03f);
        Vector3f offset = pageOn == PageOn.RIGHT_PAGE ? rightOffset : (pageOn == PageOn.LEFT_PAGE ? leftOffset : middleOffset);
        BlockPos blockPos = altarTile.getBlockPos();
        Vec3 pointBase = new Vec3((double)((float)blockPos.getX() + 0.5f + (float)Math.sin(altarTile.degreesSpun / 57.3f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)), (double)((float)blockPos.getY() + 1.125f + (BookOfShadowsAltarTile.easeFlop(1.0f - altarTile.degreesFlopped / 90.0f) - 1.0f) / 16.0f), (double)((float)blockPos.getZ() + 0.5f + (float)Math.cos(altarTile.degreesSpun / 57.3f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f)));
        Vector3f vector3f = new Vector3f(offset.x, offset.y, offset.z).add(0.0f * -scale, 0.0f * -scale, 0.03f);
        if (pageOn != PageOn.MIDDLE_BUTTON) {
            vector3f.rotate((Quaternionfc)Axis.YP.rotationDegrees((float)(pageOn == PageOn.RIGHT_PAGE ? -1 : 1) * (10.0f + altarTile.degreesOpened / 1.12f)));
        }
        vector3f.add(0.0f, 0.0f, -0.03f);
        vector3f.rotate((Quaternionfc)Axis.XP.rotationDegrees(45.0f - altarTile.degreesOpened / 2.0f));
        vector3f.rotate((Quaternionfc)Axis.YP.rotationDegrees(altarTile.degreesSpun));
        Vec3 planePoint = pointBase.add((double)vector3f.x, (double)vector3f.y, (double)vector3f.z);
        vector3f = new Vector3f(offset.x, offset.y, offset.z).add(5.0f * -scale, 0.0f * -scale, 0.0f);
        if (pageOn != PageOn.MIDDLE_BUTTON) {
            vector3f.rotate((Quaternionfc)Axis.YP.rotationDegrees((float)(pageOn == PageOn.RIGHT_PAGE ? -1 : 1) * (10.0f + altarTile.degreesOpened / 1.12f)));
        }
        vector3f.rotate((Quaternionfc)Axis.XP.rotationDegrees(45.0f - altarTile.degreesOpened / 2.0f));
        vector3f.rotate((Quaternionfc)Axis.YP.rotationDegrees(altarTile.degreesSpun));
        Vec3 planePoint2 = pointBase.add((double)vector3f.x, (double)vector3f.y, (double)vector3f.z);
        vector3f = new Vector3f(offset.x, offset.y, offset.z).add(0.0f * -scale, 5.0f * -scale, 0.0f);
        if (pageOn != PageOn.MIDDLE_BUTTON) {
            vector3f.rotate((Quaternionfc)Axis.YP.rotationDegrees((float)(pageOn == PageOn.RIGHT_PAGE ? -1 : 1) * (10.0f + altarTile.degreesOpened / 1.12f)));
        }
        vector3f.rotate((Quaternionfc)Axis.XP.rotationDegrees(45.0f - altarTile.degreesOpened / 2.0f));
        vector3f.rotate((Quaternionfc)Axis.YP.rotationDegrees(altarTile.degreesSpun));
        Vec3 planePoint3 = pointBase.add((double)vector3f.x, (double)vector3f.y, (double)vector3f.z);
        Vec2 val = PageDrawing.getLookingAtPointOnPlane(planePoint, planePoint2, planePoint3, rayPoint, rayVector);
        return val != null ? val.scale(1.0f / scale) : null;
    }

    public boolean interactClick(BookOfShadowsAltarTile altarTile, Player playerIn, float leftCursorX, float leftCursorY, float rightCursorX, float rightCursorY, DrawingType drawingType) {
        if (altarTile.turnPage == 0) {
            BookData bookData;
            if (altarTile.slotClicked != -1 && ++altarTile.slotClickedTick > 0) {
                playerIn.swinging = false;
            }
            if ((bookData = altarTile.currentBook) != null && bookData.isOpened() && PageDrawing.checkClick(bookData, altarTile, leftCursorX, leftCursorY, rightCursorX, rightCursorY, drawingType)) {
                isClickedOld = true;
                return true;
            }
        }
        return false;
    }

    public boolean releaseClick(BookOfShadowsAltarTile altarTile, Player playerIn, float leftCursorX, float leftCursorY, float rightCursorX, float rightCursorY, DrawingType drawingType) {
        BookEntries bookEntries;
        BookData bookData;
        if (focusedWritableTextBox != null) {
            ((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.clicked = false;
        }
        if (altarTile.turnPage == 0 && (bookData = altarTile.currentBook) != null && (bookEntries = BookManager.getBookEntries(bookData.getBook())) != null) {
            int chapterNum = bookData.getChapter();
            int pageNum = bookData.getPage();
            if (pageNum % 2 == 1) {
                --pageNum;
            }
            String location1 = "";
            if (bookEntries.chapterList.get((int)chapterNum).pages.size() > pageNum && pageNum >= 0) {
                location1 = bookEntries.chapterList.get((int)chapterNum).pages.get((int)pageNum).location;
            }
            BookPage page1 = BookManager.getBookPages(bookData.getBook(), ResourceLocation.parse((String)location1));
            List entries = bookEntries.chapterList.stream().flatMap(entry -> entry.pages.stream()).toList();
            for (BookPageEntry bookPageEntry : entries) {
                BookPage page = BookManager.getBookPages(bookData.getBook(), ResourceLocation.parse((String)bookPageEntry.location));
                if (page == null) continue;
                boolean flag = page == page1;
                for (BookPaintElement paintElement : page.paintElements) {
                    PaintSystem paintSystem = paintElement.client.getPaintSystem(bookData.getUUID());
                    if (paintElement.client == null) continue;
                    float w = paintElement.width / 326.0f * 2.55f * paintElement.scale / 0.062f;
                    float h = paintElement.height / 326.0f * 2.55f * paintElement.scale / 0.062f;
                    float x = paintElement.x + 0.025f;
                    float y = paintElement.y - 0.5f;
                    int xPixel = (int)(((flag ? leftCursorX : rightCursorX) - x + (flag ? 0.0f : 0.2f)) / w * paintElement.width);
                    int yPixel = (int)(((flag ? leftCursorY : rightCursorY) - y) / h * paintElement.height);
                    paintSystem.released(xPixel, yPixel);
                    paintSystem.getValueSliders().release();
                }
            }
            if (altarTile.slotClicked != -1) {
                float width = 0.86f;
                int bookmark_chapter = 0;
                int bookmark_page = 0;
                BookData.Bookmarks bookmarks = bookData.getBookmarks();
                float x = -0.25f;
                float y = 7.5f;
                if (PageDrawing.canInteract(rightCursorX, rightCursorY, x - width / 2.0f, y - width / 2.0f, width, width, altarTile, drawingType)) {
                    altarTile.deleteBookmark(altarTile.slotClicked);
                    altarTile.slotClicked = -1;
                    altarTile.slotClickedTick = 0;
                    return true;
                }
                boolean flag2 = false;
                for (BookData.Bookmarks.Slot slot : bookmarks.getSlots()) {
                    ResourceLocation bookmark_id = ResourceLocation.parse((String)slot.getId());
                    if (slot.getIndex() < 5 && PageDrawing.canInteract(leftCursorX, leftCursorY, x = -0.3f - altarTile.buttonScaleRender - 0.15f, y = (float)slot.getIndex() * 1.5f, width = 0.935f, width, altarTile, drawingType)) {
                        flag2 = true;
                    }
                    if (slot.getIndex() >= 5 && slot.getIndex() < 10 && PageDrawing.canInteract(leftCursorX, leftCursorY, x = -5.5f + (float)slot.getIndex() * 1.15f, y = -0.75f - altarTile.buttonScaleRender - 0.25f, width = 0.935f, width, altarTile, drawingType)) {
                        flag2 = true;
                    }
                    if (slot.getIndex() >= 10 && slot.getIndex() < 15 && PageDrawing.canInteract(rightCursorX, rightCursorY, x = -11.25f + (float)slot.getIndex() * 1.15f, y = -0.75f - altarTile.buttonScaleRender - 0.25f, width = 0.935f, width, altarTile, drawingType)) {
                        flag2 = true;
                    }
                    if (slot.getIndex() >= 15 && PageDrawing.canInteract(rightCursorX, rightCursorY, x = 5.2f + altarTile.buttonScaleRender + 0.15f, y = (float)(slot.getIndex() - 15) * 1.5f, width = 0.935f, width, altarTile, drawingType)) {
                        flag2 = true;
                    }
                    if (!flag2) continue;
                    if (altarTile.slotClicked == slot.getIndex()) {
                        if (altarTile.slotClickedTick >= 20) break;
                        for (BookChapter chapter : bookEntries.chapterList) {
                            for (BookPageEntry pageEntry : chapter.pages) {
                                if (!ResourceLocation.parse((String)pageEntry.location).equals((Object)bookmark_id)) continue;
                                altarTile.setTurnPage(-1, pageEntry.chapterNum, pageEntry.chapterPageNum);
                                altarTile.slotClicked = -1;
                                altarTile.slotClickedTick = 0;
                                return true;
                            }
                        }
                        altarTile.setTurnPage(-1, bookmark_chapter, bookmark_page);
                        altarTile.slotClicked = -1;
                        altarTile.slotClickedTick = 0;
                        return true;
                    }
                    altarTile.swapBookmarks(altarTile.slotClicked, slot.getIndex());
                    altarTile.drawing.bookmarkHoverAmount.set(slot.getIndex(), Float.valueOf(0.0f));
                    altarTile.drawing.bookmarkHoverAmount.set(altarTile.slotClicked, Float.valueOf(0.0f));
                    altarTile.slotClicked = -1;
                    altarTile.slotClickedTick = 0;
                    return true;
                }
            }
        }
        altarTile.slotClicked = -1;
        altarTile.slotClickedTick = 0;
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean checkClick(BookData bookData, BookOfShadowsAltarTile altarTile, float leftCursorX, float leftCursorY, float rightCursorX, float rightCursorY, DrawingType drawingType) {
        float y1;
        float h1;
        float x1;
        PaintSystem.Colors.ColorSelection colorSelection;
        BookEntries bookEntries = BookManager.getBookEntries(bookData.getBook());
        if (bookEntries == null) {
            return false;
        }
        if (!isClicked) {
            float x = -0.45f;
            float y = -0.96f;
            float width = 0.86f;
            if (PageDrawing.canInteract(leftCursorX, leftCursorY, x, y, width, width, altarTile, drawingType) && altarTile.currentBook.getChapter() != 0) {
                altarTile.clickPageBookmark(altarTile.currentBook.getChapter(), altarTile.currentBook.getPage());
                return true;
            }
            x = -0.45f;
            y = 7.2f;
            if (PageDrawing.canInteract(leftCursorX, leftCursorY, x, y, width, width, altarTile, drawingType)) {
                if (altarTile.slotClicked == -1 && PageDrawingEvents.clickedBack(altarTile)) {
                    altarTile.setTurnPage(2);
                    return true;
                }
                if (altarTile.slotClicked == -1) {
                    ++ClientProxy.fontIndex;
                    return true;
                }
            }
            if (PageDrawing.canInteract(rightCursorX, rightCursorY, (x = -0.25f) - width / 2.0f, (y = -0.5f) - width / 2.0f, width, width, altarTile, drawingType)) {
                altarTile.setTurnPage(-1, 0, 0);
                return true;
            }
            x = -0.25f;
            y = 7.5f;
            if (PageDrawing.canInteract(rightCursorX, rightCursorY, x - width / 2.0f, y - width / 2.0f, width, width, altarTile, drawingType)) {
                altarTile.setTurnPage(-2);
                return true;
            }
            x = 5.49f;
            y = -0.97f;
            if (PageDrawing.canInteract(rightCursorX, rightCursorY, x, y, width, width, altarTile, drawingType) && Minecraft.getInstance().screen == null) {
                Minecraft.getInstance().setScreen((Screen)new BookOfShadowsScreen(altarTile));
                return true;
            }
            x = 5.415f;
            y = 7.2f;
            if (PageDrawing.canInteract(rightCursorX, rightCursorY, x, y, width, width, altarTile, drawingType) && altarTile.slotClicked == -1 && PageDrawingEvents.clickedNext(altarTile)) {
                altarTile.setTurnPage(1);
                return true;
            }
            for (BookData.Bookmarks.Slot slot : bookData.getBookmarks().getSlots()) {
                float yIn;
                float xIn;
                if (slot.getId().isEmpty()) continue;
                if (slot.getIndex() < 5 && PageDrawing.canInteract(leftCursorX, leftCursorY, xIn = -0.3f - altarTile.buttonScaleRender - 0.15f, yIn = (float)slot.getIndex() * 1.5f, width = 0.935f, width, altarTile, drawingType)) {
                    altarTile.slotClicked = slot.getIndex();
                    return true;
                }
                if (slot.getIndex() >= 5 && slot.getIndex() < 10 && PageDrawing.canInteract(leftCursorX, leftCursorY, xIn = -5.5f + (float)slot.getIndex() * 1.15f, yIn = -0.75f - altarTile.buttonScaleRender - 0.25f, width = 0.935f, width, altarTile, drawingType)) {
                    altarTile.slotClicked = slot.getIndex();
                    return true;
                }
                if (slot.getIndex() >= 10 && slot.getIndex() < 15 && PageDrawing.canInteract(rightCursorX, rightCursorY, xIn = -11.25f + (float)slot.getIndex() * 1.15f, yIn = -0.75f - altarTile.buttonScaleRender - 0.25f, width = 0.935f, width, altarTile, drawingType)) {
                    altarTile.slotClicked = slot.getIndex();
                    return true;
                }
                if (slot.getIndex() < 15 || !PageDrawing.canInteract(rightCursorX, rightCursorY, xIn = 5.2f + altarTile.buttonScaleRender + 0.15f, yIn = (float)(slot.getIndex() - 15) * 1.5f, width = 0.935f, width, altarTile, drawingType)) continue;
                altarTile.slotClicked = slot.getIndex();
                return true;
            }
        }
        String location1 = "";
        String location2 = "";
        int chapter = bookData.getChapter();
        int page = bookData.getPage();
        if (page % 2 == 1) {
            --page;
        }
        if (bookEntries.chapterList.get((int)chapter).pages.size() > page && page >= 0) {
            location1 = bookEntries.chapterList.get((int)chapter).pages.get((int)page).location;
        }
        if (bookEntries.chapterList.get((int)chapter).pages.size() > page + 1 && page >= 0) {
            location2 = bookEntries.chapterList.get((int)chapter).pages.get((int)(page + 1)).location;
        }
        BookPage page1 = BookManager.getBookPages(bookData.getBook(), ResourceLocation.parse((String)location1));
        BookPage page2 = BookManager.getBookPages(bookData.getBook(), ResourceLocation.parse((String)location2));
        if (page1 != null && !isClicked) {
            for (BookPaintElement paintElement : page1.paintElements) {
                float h;
                float w;
                float y;
                float x;
                if (paintElement.client == null) continue;
                PaintSystem paintSystem = paintElement.client.getPaintSystem(bookData.getUUID());
                float cursorX = leftCursorX;
                float cursorY = leftCursorY;
                if (Minecraft.getInstance().player != null && Minecraft.getInstance().player.getItemInHand(InteractionHand.MAIN_HAND).getItem() == ModItems.BOOK_CANVAS.get() && PageDrawing.canInteract(cursorX, cursorY, x = paintElement.x + 0.025f, y = paintElement.y - 0.5f, w = paintElement.width / 326.0f * 2.55f * paintElement.scale / 0.062f, h = paintElement.height / 326.0f * 2.55f * paintElement.scale / 0.062f, altarTile, drawingType)) {
                    Minecraft.getInstance().setScreen((Screen)new CanvasPaintingCropScreen(paintElement, paintSystem));
                    return true;
                }
                if (paintSystem.getMovingSelection() == null) {
                    for (PaintSystem.Button button : paintSystem.buttons) {
                        if (!button.isVisible(paintSystem)) continue;
                        BookImage image = new BookImage(button.getX(paintSystem, PageOn.LEFT_PAGE, 0.0f), button.getY(paintSystem, PageOn.LEFT_PAGE, 0.0f), 0.0f, 0.0f, 0.0f, button.width, button.height, button.width, button.height, button.getScale(altarTile.buttonScaleRender), button.getTexture(paintSystem), new ArrayList<BookImageEffect>());
                        w = image.width / 330.0f * image.scale / 0.062f;
                        x = image.x - w / 2.0f + 0.455f;
                        h = image.height / 330.0f * image.scale / 0.062f;
                        y = image.y - h / 2.0f + 0.49f;
                        if (!PageDrawing.canInteract(cursorX, cursorY, x, y, w, h, altarTile, drawingType)) continue;
                        if (!button.getDisabled(paintSystem)) {
                            button.onClick(paintSystem);
                            button.clicked = true;
                            return true;
                        }
                        return false;
                    }
                    if (paintSystem.toolsVisible) {
                        for (int i = 0; i < 3; ++i) {
                            if (i >= paintSystem.getColors().colors.size()) continue;
                            colorSelection = paintSystem.getColors().colors.get(i);
                            float w1 = colorSelection.colorPosData.width / 326.0f * 2.55f / 0.062f;
                            x1 = (float)colorSelection.colorPosData.pos.x + 0.025f - w1 / 2.0f;
                            h1 = colorSelection.colorPosData.height / 326.0f * 2.55f / 0.062f;
                            y1 = (float)colorSelection.colorPosData.pos.y - 0.5f - 0.025f - h1 / 2.0f;
                            if (!PageDrawing.canInteract(cursorX, cursorY, x1, y1, w1, h1, altarTile, drawingType)) continue;
                            if (i == 2) {
                                paintSystem.getColors().cycleColorBack(paintSystem);
                            } else {
                                paintSystem.getColors().cycleColor(paintSystem);
                            }
                            return true;
                        }
                    }
                    if (paintSystem.toolsVisible && paintSystem.getValueSliders().click(cursorX, cursorY, PageOn.LEFT_PAGE)) {
                        return true;
                    }
                }
                if (!paintSystem.toolsVisible) continue;
                w = paintElement.width / 326.0f * 2.55f * paintElement.scale / 0.062f;
                h = paintElement.height / 326.0f * 2.55f * paintElement.scale / 0.062f;
                x = paintElement.x + 0.025f;
                y = paintElement.y - 0.5f;
                paintSystem.getBrush();
                float cushion = (float)PaintSystem.Brush.size * 0.12f;
                if (!PageDrawing.canInteract(cursorX, cursorY, x - cushion, y - cushion, w + cushion * 2.0f, h + cushion * 2.0f, altarTile, drawingType)) continue;
                float xPixel = (cursorX - x) / w * paintElement.width;
                float yPixel = (cursorY - y) / h * paintElement.height;
                paintSystem.click(xPixel, yPixel);
                return true;
            }
            for (BookWritableTextBox bookWritableTextBox : page1.writableTextBoxes) {
                if (!PageDrawing.canInteract(leftCursorX, leftCursorY, bookWritableTextBox.paragraphElement.x + 0.45f, bookWritableTextBox.paragraphElement.y, bookWritableTextBox.paragraphElement.width / 6.15f, bookWritableTextBox.paragraphElement.height / 2.57f, altarTile, drawingType)) continue;
                PageDrawing.setFocusedWritableTextBox(altarTile, page1.location, bookWritableTextBox);
                long i = Util.getMillis();
                BookWritableTextBox.Client.DisplayCache bookeditscreen$displaycache = ((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.getDisplayCache(((BookOfShadowsAltarTile)((Object)PageDrawing.focusedWritableTextBox.getLeft())).currentBook);
                BookWritableTextBox.Client.Pos2i pos2i = new BookWritableTextBox.Client.Pos2i((int)((leftCursorX - bookWritableTextBox.paragraphElement.x - 0.45f) / 5.0f * 115.0f), (int)((leftCursorY - bookWritableTextBox.paragraphElement.y) / 7.1f * 162.0f));
                int j = bookeditscreen$displaycache.getIndexAtPosition(ClientProxy.font(), pos2i);
                bookWritableTextBox.client.clicked = true;
                bookWritableTextBox.client.clickedPos = pos2i;
                if (j >= 0) {
                    if (j != ((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.lastIndex || i - ((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.lastClickTime >= 250L) {
                        ((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.pageEdit.setCursorPos(j, Screen.hasShiftDown());
                    } else if (!((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.pageEdit.isSelecting()) {
                        ((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.selectWord(j, ((BookOfShadowsAltarTile)((Object)PageDrawing.focusedWritableTextBox.getLeft())).currentBook);
                    } else {
                        ((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.pageEdit.selectAll();
                    }
                    ((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.clearDisplayCache(((BookOfShadowsAltarTile)((Object)PageDrawing.focusedWritableTextBox.getLeft())).currentBook.getUUID());
                }
                ((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.lastIndex = j;
                ((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.lastClickTime = i;
                return true;
            }
            for (BookNonItemTooltip bookNonItemTooltip : page1.nonItemTooltipList) {
                if (bookNonItemTooltip.hyperlink.id.isEmpty() && bookNonItemTooltip.hyperlink.url.isEmpty() || !PageDrawing.canInteract(leftCursorX, leftCursorY, bookNonItemTooltip.x, bookNonItemTooltip.y, bookNonItemTooltip.width, bookNonItemTooltip.height, altarTile, drawingType)) continue;
                if (!bookNonItemTooltip.hyperlink.url.isEmpty()) {
                    PageDrawing.showLinkScreenClient(bookNonItemTooltip.hyperlink.url);
                }
                if (bookNonItemTooltip.hyperlink.id.isEmpty()) break;
                for (BookChapter chapterEntry : bookEntries.chapterList) {
                    for (BookPageEntry pageEntry : chapterEntry.pages) {
                        if (!pageEntry.location.equals(bookNonItemTooltip.hyperlink.id)) continue;
                        altarTile.setTurnPage(-1, pageEntry.chapterNum, pageEntry.chapterPageNum);
                        return true;
                    }
                }
            }
            for (BookItemsAndFluids bookItemStackInSlot : page1.itemList) {
                if (!PageDrawing.canInteract(leftCursorX, leftCursorY, bookItemStackInSlot.x, bookItemStackInSlot.y, 0.86f, 0.86f, altarTile, drawingType)) continue;
                String itemRegistryName = bookItemStackInSlot.item != null ? HexereiUtil.getRegistryName(bookItemStackInSlot.item.getItem()).toString() : HexereiUtil.getRegistryName(bookItemStackInSlot.fluid.getFluid()).toString();
                boolean flag = false;
                if (BookManager.getBookItemHyperlinks().containsKey(itemRegistryName)) {
                    BookHyperlink hyperlink = BookManager.getBookItemHyperlinks().get(itemRegistryName);
                    if (chapter != hyperlink.chapter || page != hyperlink.page && page != hyperlink.page - 1) {
                        altarTile.setTurnPage(-1, hyperlink.chapter, hyperlink.page);
                    }
                    flag = true;
                }
                if (flag) break;
                for (int j = 1; j < bookEntries.chapterList.size(); ++j) {
                    for (int k = 0; k < bookEntries.chapterList.get((int)j).pages.size(); ++k) {
                        String location3 = bookEntries.chapterList.get((int)j).pages.get((int)k).location;
                        BookPage page_check = BookManager.getBookPages(bookData.getBook(), ResourceLocation.parse((String)location3));
                        if (page_check == null || !page_check.itemHyperlink.equals(itemRegistryName)) continue;
                        if (chapter != j || page != k && page != k - 1) {
                            altarTile.setTurnPage(-1, j, k);
                        }
                        BookManager.addBookItemHyperlink(itemRegistryName, new BookHyperlink(j, k));
                        return true;
                    }
                }
            }
            for (BookImage bookImage : page1.imageList) {
                float w = bookImage.width / 330.0f * bookImage.scale / 0.062f;
                float x = bookImage.x - w / 2.0f + 0.45f;
                float h = bookImage.height / 330.0f * bookImage.scale / 0.062f;
                float y = bookImage.y - h / 2.0f + 0.49f;
                if (!PageDrawing.canInteract(leftCursorX, leftCursorY, x, y, w, h, altarTile, drawingType)) continue;
                if (!bookImage.hyperlink.url.isEmpty()) {
                    PageDrawing.showLinkScreenClient(bookImage.hyperlink.url);
                }
                if (bookImage.hyperlink.id.isEmpty()) break;
                for (BookChapter chapterEntry : bookEntries.chapterList) {
                    for (BookPageEntry pageEntry : chapterEntry.pages) {
                        if (!pageEntry.location.equals(bookImage.hyperlink.id)) continue;
                        altarTile.setTurnPage(-1, pageEntry.chapterNum, pageEntry.chapterPageNum);
                        return true;
                    }
                }
            }
            if (altarTile.slotClicked == -1) {
                for (BookEntity bookEntity : page1.entityList) {
                    float xIn = bookEntity.x + bookEntity.offset.x + 0.52f;
                    float width = 1.25f + bookEntity.scale / 5.0f;
                    float yIn = bookEntity.y + bookEntity.offset.y;
                    if (!PageDrawing.canInteract(leftCursorX, leftCursorY, xIn - width / 2.0f, yIn - width / 2.0f, width, width, altarTile, drawingType)) continue;
                    bookEntity.clicked = true;
                    return true;
                }
            }
        }
        if (page2 != null) {
            if (!isClicked) {
                for (BookPaintElement paintElement : page2.paintElements) {
                    float h;
                    float w;
                    float y;
                    float x;
                    if (paintElement.client == null) continue;
                    PaintSystem paintSystem = paintElement.client.getPaintSystem(bookData.getUUID());
                    float cursorX = rightCursorX;
                    float cursorY = rightCursorY;
                    if (Minecraft.getInstance().player != null && Minecraft.getInstance().player.getItemInHand(InteractionHand.MAIN_HAND).getItem() == ModItems.BOOK_CANVAS.get() && PageDrawing.canInteract(cursorX + 0.22f, cursorY, x = paintElement.x + 0.025f, y = paintElement.y - 0.5f, w = paintElement.width / 326.0f * 2.55f * paintElement.scale / 0.062f, h = paintElement.height / 326.0f * 2.55f * paintElement.scale / 0.062f, altarTile, drawingType)) {
                        Minecraft.getInstance().setScreen((Screen)new CanvasPaintingCropScreen(paintElement, paintSystem));
                        return true;
                    }
                    if (paintSystem.getMovingSelection() == null) {
                        for (PaintSystem.Button button : paintSystem.buttons) {
                            if (!button.isVisible(paintSystem)) continue;
                            BookImage image = new BookImage(button.getX(paintSystem, PageOn.RIGHT_PAGE, 0.0f), button.getY(paintSystem, PageOn.RIGHT_PAGE, 0.0f), 0.0f, 0.0f, 0.0f, button.width, button.height, button.width, button.height, button.getScale(altarTile.buttonScaleRender), button.getTexture(paintSystem), new ArrayList<BookImageEffect>());
                            w = image.width / 330.0f * image.scale / 0.062f;
                            x = image.x - w / 2.0f + 0.455f;
                            float h2 = image.height / 330.0f * image.scale / 0.062f;
                            y = image.y - h2 / 2.0f + 0.49f;
                            if (!PageDrawing.canInteract(cursorX, cursorY, x, y, w, h2, altarTile, drawingType)) continue;
                            if (!button.getDisabled(paintSystem)) {
                                button.onClick(paintSystem);
                                button.clicked = true;
                                return true;
                            }
                            return false;
                        }
                        if (paintSystem.toolsVisible) {
                            for (int i = 0; i < 3; ++i) {
                                if (i >= paintSystem.getColors().colors.size()) continue;
                                colorSelection = paintSystem.getColors().colors.get(i);
                                float w1 = colorSelection.colorPosData.width / 326.0f * 2.55f / 0.062f;
                                x1 = (float)colorSelection.colorPosData.pos.x + 0.025f - w1 / 2.0f + 0.8f;
                                h1 = colorSelection.colorPosData.height / 326.0f * 2.55f / 0.062f;
                                y1 = (float)colorSelection.colorPosData.pos.y - 0.5f - 0.025f - h1 / 2.0f;
                                if (!PageDrawing.canInteract(cursorX, cursorY, x1, y1, w1, h1, altarTile, drawingType)) continue;
                                if (i == 2) {
                                    paintSystem.getColors().cycleColorBack(paintSystem);
                                } else {
                                    paintSystem.getColors().cycleColor(paintSystem);
                                }
                                return true;
                            }
                        }
                        if (paintSystem.toolsVisible && paintSystem.getValueSliders().click(cursorX, cursorY, PageOn.RIGHT_PAGE)) {
                            return true;
                        }
                    }
                    if (!paintSystem.toolsVisible) continue;
                    w = paintElement.width / 326.0f * 2.55f * paintElement.scale / 0.062f;
                    float h3 = paintElement.height / 326.0f * 2.55f * paintElement.scale / 0.062f;
                    x = paintElement.x + 0.025f;
                    y = paintElement.y - 0.5f;
                    paintSystem.getBrush();
                    float cushion = (float)PaintSystem.Brush.size * 0.12f;
                    if (!PageDrawing.canInteract(cursorX + 0.22f, cursorY, x - cushion, y - cushion, w + cushion * 2.0f, h3 + cushion * 2.0f, altarTile, drawingType)) continue;
                    float xPixel = (cursorX - x) / w * paintElement.width + 1.8f;
                    float yPixel = (cursorY - y) / h3 * paintElement.height;
                    paintSystem.click(xPixel, yPixel);
                    return true;
                }
                for (BookWritableTextBox bookWritableTextBox : page2.writableTextBoxes) {
                    if (!PageDrawing.canInteract(rightCursorX, rightCursorY, bookWritableTextBox.paragraphElement.x + 0.45f, bookWritableTextBox.paragraphElement.y, bookWritableTextBox.paragraphElement.width / 6.15f, bookWritableTextBox.paragraphElement.height / 2.57f, altarTile, drawingType)) continue;
                    PageDrawing.setFocusedWritableTextBox(altarTile, page2.location, bookWritableTextBox);
                    long i = Util.getMillis();
                    BookWritableTextBox.Client.DisplayCache bookeditscreen$displaycache = ((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.getDisplayCache(((BookOfShadowsAltarTile)((Object)PageDrawing.focusedWritableTextBox.getLeft())).currentBook);
                    BookWritableTextBox.Client.Pos2i pos2i = new BookWritableTextBox.Client.Pos2i((int)((rightCursorX - bookWritableTextBox.paragraphElement.x - 0.45f) / 5.0f * 115.0f), (int)((rightCursorY - bookWritableTextBox.paragraphElement.y) / 7.1f * 162.0f));
                    int j = bookeditscreen$displaycache.getIndexAtPosition(ClientProxy.font(), pos2i);
                    bookWritableTextBox.client.clicked = true;
                    bookWritableTextBox.client.clickedPos = pos2i;
                    if (j >= 0) {
                        if (j != ((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.lastIndex || i - ((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.lastClickTime >= 250L) {
                            ((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.pageEdit.setCursorPos(j, Screen.hasShiftDown());
                        } else if (!((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.pageEdit.isSelecting()) {
                            ((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.selectWord(j, ((BookOfShadowsAltarTile)((Object)PageDrawing.focusedWritableTextBox.getLeft())).currentBook);
                        } else {
                            ((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.pageEdit.selectAll();
                        }
                        ((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.clearDisplayCache(((BookOfShadowsAltarTile)((Object)PageDrawing.focusedWritableTextBox.getLeft())).currentBook.getUUID());
                    }
                    ((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.lastIndex = j;
                    ((BookWritableTextBox)PageDrawing.focusedWritableTextBox.getRight()).client.lastClickTime = i;
                    return true;
                }
                for (BookNonItemTooltip bookNonItemTooltip : page2.nonItemTooltipList) {
                    if (bookNonItemTooltip.hyperlink.id.isEmpty() && bookNonItemTooltip.hyperlink.url.isEmpty() || !PageDrawing.canInteract(rightCursorX, rightCursorY, bookNonItemTooltip.x, bookNonItemTooltip.y, bookNonItemTooltip.width, bookNonItemTooltip.height, altarTile, drawingType)) continue;
                    if (!bookNonItemTooltip.hyperlink.url.isEmpty()) {
                        PageDrawing.showLinkScreenClient(bookNonItemTooltip.hyperlink.url);
                    }
                    if (bookNonItemTooltip.hyperlink.id.isEmpty()) break;
                    for (BookChapter chapterEntry : bookEntries.chapterList) {
                        for (BookPageEntry pageEntry : chapterEntry.pages) {
                            if (!pageEntry.location.equals(bookNonItemTooltip.hyperlink.id)) continue;
                            altarTile.setTurnPage(-1, pageEntry.chapterNum, pageEntry.chapterPageNum);
                            return true;
                        }
                    }
                }
                for (BookItemsAndFluids bookItemStackInSlot : page2.itemList) {
                    if (!PageDrawing.canInteract(rightCursorX, rightCursorY, bookItemStackInSlot.x, bookItemStackInSlot.y, 0.86f, 0.86f, altarTile, drawingType)) continue;
                    String itemRegistryName = bookItemStackInSlot.item != null ? HexereiUtil.getRegistryName(bookItemStackInSlot.item.getItem()).toString() : HexereiUtil.getRegistryName(bookItemStackInSlot.fluid.getFluid()).toString();
                    boolean flag = false;
                    if (BookManager.getBookItemHyperlinks().containsKey(itemRegistryName)) {
                        BookHyperlink hyperlink = BookManager.getBookItemHyperlinks().get(itemRegistryName);
                        if (chapter != hyperlink.chapter || page != hyperlink.page && page != hyperlink.page - 1) {
                            altarTile.setTurnPage(-1, hyperlink.chapter, hyperlink.page);
                        }
                        flag = true;
                    }
                    if (flag) break;
                    for (int j = 1; j < bookEntries.chapterList.size(); ++j) {
                        for (int k = 0; k < bookEntries.chapterList.get((int)j).pages.size(); ++k) {
                            String location3 = bookEntries.chapterList.get((int)j).pages.get((int)k).location;
                            BookPage page_check = BookManager.getBookPages(bookData.getBook(), ResourceLocation.parse((String)location3));
                            if (page_check == null || !page_check.itemHyperlink.equals(itemRegistryName)) continue;
                            if (chapter != j || page != k && page != k - 1) {
                                altarTile.setTurnPage(-1, j, k);
                            }
                            BookManager.addBookItemHyperlink(itemRegistryName, new BookHyperlink(j, k));
                            return true;
                        }
                    }
                }
                for (BookImage bookImage : page2.imageList) {
                    float h;
                    float y;
                    float w;
                    float x;
                    if (bookImage.hyperlink.id.isEmpty() && bookImage.hyperlink.url.isEmpty() || !PageDrawing.canInteract(rightCursorX, rightCursorY, x = bookImage.x - (w = bookImage.width / 330.0f * bookImage.scale / 0.062f) / 2.0f + 0.45f, y = bookImage.y - (h = bookImage.height / 330.0f * bookImage.scale / 0.062f) / 2.0f + 0.49f, w, h, altarTile, drawingType)) continue;
                    if (!bookImage.hyperlink.url.isEmpty()) {
                        PageDrawing.showLinkScreenClient(bookImage.hyperlink.url);
                    }
                    if (bookImage.hyperlink.id.isEmpty()) break;
                    for (BookChapter chapterEntry : bookEntries.chapterList) {
                        for (BookPageEntry pageEntry : chapterEntry.pages) {
                            if (!pageEntry.location.equals(bookImage.hyperlink.id)) continue;
                            altarTile.setTurnPage(-1, pageEntry.chapterNum, pageEntry.chapterPageNum);
                            return true;
                        }
                    }
                }
            }
            if (altarTile.slotClicked == -1) {
                for (BookEntity bookEntity : page2.entityList) {
                    float xIn = bookEntity.x + bookEntity.offset.x + 0.52f;
                    float width = 1.25f + bookEntity.scale / 5.0f;
                    float yIn = bookEntity.y + bookEntity.offset.y;
                    if (!PageDrawing.canInteract(rightCursorX, rightCursorY, xIn - width / 2.0f, yIn - width / 2.0f, width, width, altarTile, drawingType)) continue;
                    bookEntity.clicked = true;
                    return true;
                }
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void showLinkScreenClient(String link) {
        ConfirmLinkScreen screen = new ConfirmLinkScreen(p_169232_ -> {
            if (p_169232_) {
                Util.getPlatform().openUri(link);
            }
            Minecraft.getInstance().setScreen(null);
        }, link, true);
        Minecraft.getInstance().setScreen((Screen)screen);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawSlot(BookOfShadowsAltarTile altarTile, PoseStack poseStack, MultiBufferSource bufferSource, float xIn, float yIn, float zLevel, int light, int overlay, PageOn pageOn, DrawingType drawingType) {
        poseStack.pushPose();
        if (pageOn == PageOn.LEFT_PAGE) {
            PageDrawing.translateToLeftPage(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_UNDER) {
            PageDrawing.translateToLeftPageUnder(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV) {
            PageDrawing.translateToLeftPagePrevious(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        }
        if (pageOn == PageOn.RIGHT_PAGE) {
            PageDrawing.translateToRightPage(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_UNDER) {
            PageDrawing.translateToRightPageUnder(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV) {
            PageDrawing.translateToRightPagePrevious(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        poseStack.translate(-0.5f, 0.34375f, -7.5E-4f);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
        poseStack.translate(-0.001875f, -0.0033125f, 0.0f);
        poseStack.translate(xIn / 8.1f, yIn / 8.1f, 0.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        RenderSystem.setShader(GameRenderer::getRendertypeEntityCutoutNoCullShader);
        Matrix4f matrix = poseStack.last().pose();
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)ResourceLocation.parse((String)"hexerei:textures/book/slot.png")));
        PoseStack.Pose normal = poseStack.last();
        boolean u = false;
        boolean v = false;
        int imageWidth = 32;
        int imageHeight = 32;
        int width = 18;
        int height = 18;
        float u1 = ((float)u + 0.0f) / (float)imageWidth;
        float u2 = ((float)u + (float)width) / (float)imageWidth;
        float v1 = ((float)v + 0.0f) / (float)imageHeight;
        float v2 = ((float)v + (float)height) / (float)imageHeight;
        buffer.addVertex(matrix, 0.0f, -0.0030555555f * (float)height, -0.0030555555f * (float)width).setColor(255, 255, 255, 125).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 0.0f, 0.0030555555f * (float)height, -0.0030555555f * (float)width).setColor(255, 255, 255, 125).setUv(u1, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 0.0f, 0.0030555555f * (float)height, 0.0030555555f * (float)width).setColor(255, 255, 255, 125).setUv(u2, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 0.0f, -0.0030555555f * (float)height, 0.0030555555f * (float)width).setColor(255, 255, 255, 125).setUv(u2, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        if (bufferSource instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource source = (MultiBufferSource.BufferSource)bufferSource;
            source.endBatch();
        }
        poseStack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawFluidInSlot(BookOfShadowsAltarTile altarTile, @NotNull BookItemsAndFluids bookItemsAndFluids, PoseStack poseStack, MultiBufferSource bufferSource, float xIn, float yIn, float zLevel, int light, int overlay, PageOn pageOn, DrawingType drawingType) {
        poseStack.pushPose();
        FluidStack stack = bookItemsAndFluids.fluid;
        int capacity = bookItemsAndFluids.capacity;
        boolean showSlot = bookItemsAndFluids.show_slot;
        if (pageOn == PageOn.LEFT_PAGE) {
            PageDrawing.translateToLeftPage(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_UNDER) {
            PageDrawing.translateToLeftPageUnder(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV) {
            PageDrawing.translateToLeftPagePrevious(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        }
        if (pageOn == PageOn.RIGHT_PAGE) {
            PageDrawing.translateToRightPage(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_UNDER) {
            PageDrawing.translateToRightPageUnder(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV) {
            PageDrawing.translateToRightPagePrevious(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        poseStack.translate(-0.5f, 0.34375f, -7.5E-4f);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
        poseStack.translate(-0.001875f, -0.0033125f, 0.0f);
        poseStack.translate(xIn / 8.1f, yIn / 8.1f, 0.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        RenderSystem.setShader(GameRenderer::getRendertypeEntityCutoutNoCullShader);
        Matrix4f matrix = poseStack.last().pose();
        if (showSlot) {
            VertexConsumer buffer = bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)ResourceLocation.parse((String)"hexerei:textures/book/slot.png")));
            PoseStack.Pose normal = poseStack.last();
            boolean u = false;
            boolean v = false;
            int imageWidth = 18;
            int imageHeight = 18;
            int width = 18;
            int height = 18;
            float u1 = ((float)u + 0.0f) / (float)imageWidth;
            float u2 = ((float)u + (float)width) / (float)imageWidth;
            float v1 = ((float)v + 0.0f) / (float)imageHeight;
            float v2 = ((float)v + (float)height) / (float)imageHeight;
            buffer.addVertex(matrix, 0.0f, -0.0030555555f * (float)height, -0.0030555555f * (float)width).setColor(255, 255, 255, 255).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(matrix, 0.0f, 0.0030555555f * (float)height, -0.0030555555f * (float)width).setColor(255, 255, 255, 255).setUv(u1, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(matrix, 0.0f, 0.0030555555f * (float)height, 0.0030555555f * (float)width).setColor(255, 255, 255, 255).setUv(u2, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(matrix, 0.0f, -0.0030555555f * (float)height, 0.0030555555f * (float)width).setColor(255, 255, 255, 255).setUv(u2, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        }
        this.drawFluid(poseStack, bufferSource, (int)bookItemsAndFluids.fluid_width, (int)bookItemsAndFluids.fluid_height, stack, capacity, light, overlay, bookItemsAndFluids.fluid_offset_x, bookItemsAndFluids.fluid_offset_y, bookItemsAndFluids.fluid_width, bookItemsAndFluids.fluid_height);
        poseStack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void drawFluid(PoseStack poseStack, MultiBufferSource bufferSource, int tiledWidth, int tiledHeight, FluidStack fluidStack, int capacity, int light, int overlay, float x_offset, float y_offset, float width, float height) {
        Fluid fluid = fluidStack.getFluid();
        TextureAtlasSprite fluidStillSprite = PageDrawing.getStillFluidSprite(fluidStack);
        int fluidColor = IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor(fluidStack);
        int amount = fluidStack.getAmount();
        if (amount == 0) {
            amount = capacity > 0 ? capacity : 1000;
        }
        int scaledAmount = amount * tiledHeight / (capacity != 0 ? capacity : 1000);
        if (amount > 0 && scaledAmount < 1) {
            scaledAmount = 1;
        }
        if (scaledAmount > tiledHeight) {
            scaledAmount = tiledHeight;
        }
        if (capacity == 0) {
            scaledAmount = tiledHeight;
        }
        PageDrawing.drawTiledSprite(poseStack, bufferSource, tiledWidth, tiledHeight, fluidColor, scaledAmount, fluidStillSprite, capacity, amount, light, overlay, x_offset, y_offset, width, height);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawTiledSprite(PoseStack poseStack, MultiBufferSource bufferSource, int tiledWidth, int tiledHeight, int color, int scaledAmount, TextureAtlasSprite sprite, int capacity, int amount, int light, int overlay, float x_offset, float y_offset, float width, float height) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        int xTileCount = tiledWidth / 16;
        int xRemainder = tiledWidth - xTileCount * 16;
        int yTileCount = scaledAmount / 16;
        int yRemainder = scaledAmount - yTileCount * 16;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int width2 = xTile == xTileCount ? xRemainder : (int)width;
                int height2 = yTile == yTileCount ? yRemainder : (int)height;
                int x_tile = xTile * 16;
                int y_tile = tiledHeight - (yTile + 1) * (int)height;
                if (width2 <= 0 || height2 <= 0) continue;
                int maskTop = (int)height - height2;
                int maskRight = (int)width - width2;
                PageDrawing.drawTextureWithMasking(poseStack, bufferSource, capacity, amount, x_tile, y_tile, sprite, color, maskTop, maskRight, 1.0f, light, overlay, x_offset, y_offset, width, height);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static TextureAtlasSprite getStillFluidSprite(FluidStack fluidStack) {
        Minecraft minecraft = Minecraft.getInstance();
        if (fluidStack.isEmpty()) {
            return (TextureAtlasSprite)minecraft.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(ResourceLocation.withDefaultNamespace((String)"missingno"));
        }
        Fluid fluid = fluidStack.getFluid();
        ResourceLocation fluidStill = IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture(fluidStack);
        return (TextureAtlasSprite)minecraft.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(fluidStill);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawTextureWithMasking(PoseStack poseStack, MultiBufferSource bufferSource, int capacity, int amount, float xCoord, float yCoord, TextureAtlasSprite textureSprite, int color, int maskTop, int maskRight, float zLevel, int light, int overlay, float x_offset, float y_offset, float width, float height) {
        float uMin = textureSprite.getU0();
        float uMax = textureSprite.getU1();
        float vMin = textureSprite.getV0();
        float vMax = textureSprite.getV1();
        uMax -= (float)maskRight / width * (uMax - uMin);
        vMax -= (float)maskTop / height * (vMax - vMin);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        poseStack.pushPose();
        poseStack.translate(0.001f, 0.0485f + y_offset * 0.005975f, x_offset * 0.005975f);
        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        Matrix4f matrix = poseStack.last().pose();
        PoseStack.Pose normal = poseStack.last();
        poseStack.popPose();
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.cutout());
        buffer.addVertex(matrix, 0.0f, -0.0030555555f * width, 0.0f).setColor(red, green, blue, alpha).setUv(uMin, vMax).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 0.0f, 0.0030555555f * width, 0.0f).setColor(red, green, blue, alpha).setUv(uMax, vMax).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 0.0f, 0.0030555555f * width, 0.006111111f * (height - (float)maskTop)).setColor(red, green, blue, alpha).setUv(uMax, vMin).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 0.0f, -0.0030555555f * width, 0.006111111f * (height - (float)maskTop)).setColor(red, green, blue, alpha).setUv(uMin, vMin).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
    }

    private float easeInOutElastic(double x) {
        double c5 = 1.3962634015954636;
        return (float)(x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : (x < 0.5 ? 4.0 * x * x * x : Math.pow(2.0, -20.0 * x + 10.0) * Math.sin((20.0 * x - 11.125) * c5) / 2.0 + 1.0)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawTooltipImage(ItemStack stack, BookOfShadowsAltarTile altarTile, PoseStack poseStack, MultiBufferSource bufferSource, float zLevel, int light, int overlay, float partialTicks) {
        poseStack.pushPose();
        poseStack.translate(0.5f, 1.125f, 0.5f);
        poseStack.translate((float)Math.sin(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f));
        poseStack.translate(0.0f, (BookOfShadowsAltarTile.easeFlop(1.0f - altarTile.degreesFlopped / 90.0f) - 1.0f) / 16.0f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(altarTile.degreesSpunRender));
        poseStack.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpenedRender / 2.0f + 45.0f)));
        poseStack.mulPose(Axis.YP.rotationDegrees(-altarTile.degreesFloppedRender));
        poseStack.translate(0.0f, 0.0f, -(altarTile.degreesFloppedRender / 10.0f) / 32.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
        float scale = this.easeInOutElastic(Mth.lerp((float)partialTicks, (float)this.drawTooltipScaleOld, (float)this.drawTooltipScale));
        poseStack.translate(0.05f + 0.1f * scale, -(1.0f - (this.drawTooltipScale < 0.5f ? this.drawTooltipScale * 2.0f : 1.0f)) / 12.0f, 0.0f);
        poseStack.scale(scale, scale, scale);
        RenderSystem.setShader(GameRenderer::getRendertypeEntityCutoutNoCullShader);
        this.tooltipStack = stack;
        if (!this.tooltipStack.isEmpty()) {
            List tooltip = stack.getTooltipLines(Item.TooltipContext.EMPTY, Hexerei.proxy.getPlayer(), (TooltipFlag)(Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
            if (!tooltip.isEmpty()) {
                tooltip.addAll(this.tooltipText);
            }
            String modId = HexereiUtil.getRegistryName(this.tooltipStack.getItem()).getNamespace();
            String modName = PageDrawing.getModNameForModId(modId);
            MutableComponent modNameComponent = Component.translatable((String)modName);
            modNameComponent.withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(0x5555FF));
            if (tooltip.isEmpty() || !((Component)tooltip.getLast()).getString().equals(modName)) {
                tooltip.add(modNameComponent);
            }
            ArrayList<Component> list = new ArrayList<Component>(this.tooltipText);
            list.addFirst((Component)Component.translatable((String)""));
            this.renderTooltip(this.tooltipStack, bufferSource, poseStack, tooltip, stack.getTooltipImage(), 0, 0, overlay, light);
        }
        poseStack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static List<Component> getFluidTooltip(BookItemsAndFluids bookItemStackInSlot) {
        FluidStack fluidStack = bookItemStackInSlot.fluid;
        int capacity = bookItemStackInSlot.capacity;
        int amount = bookItemStackInSlot.amount;
        ArrayList<Component> tooltip = new ArrayList<Component>();
        Fluid fluidType = fluidStack.getFluid();
        MutableComponent displayName = (MutableComponent)fluidStack.getHoverName();
        displayName.withStyle(ChatFormatting.WHITE);
        tooltip.add((Component)displayName);
        if (capacity != 0) {
            amountString = Component.translatable((String)"book.hexerei.tooltip.liquid.amount.with.capacity", (Object[])new Object[]{nf.format(amount), nf.format(capacity)});
            tooltip.add((Component)amountString.withStyle(ChatFormatting.GRAY));
        } else if (amount != 0) {
            amountString = Component.translatable((String)"book.hexerei.tooltip.liquid.amount", (Object[])new Object[]{nf.format(amount)});
            tooltip.add((Component)amountString.withStyle(ChatFormatting.GRAY));
        }
        if (!bookItemStackInSlot.extra_tooltips.isEmpty()) {
            tooltip.addAll(bookItemStackInSlot.extra_tooltips);
        }
        String modId = HexereiUtil.getRegistryName(fluidStack.getFluid()).getNamespace();
        String modName = PageDrawing.getModNameForModId(modId);
        MutableComponent modNameComponent = Component.translatable((String)modName);
        modNameComponent.withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(0x5555FF));
        tooltip.add((Component)modNameComponent);
        return tooltip;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawTooltipText(BookOfShadowsAltarTile altarTile, PoseStack poseStack, MultiBufferSource bufferSource, float zLevel, int light, int overlay, float partialTicks) {
        poseStack.pushPose();
        poseStack.translate(0.5f, 1.125f, 0.5f);
        poseStack.translate((float)Math.sin(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f));
        poseStack.translate(0.0f, (BookOfShadowsAltarTile.easeFlop(1.0f - altarTile.degreesFlopped / 90.0f) - 1.0f) / 16.0f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(altarTile.degreesSpunRender));
        poseStack.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpenedRender / 2.0f + 45.0f)));
        poseStack.mulPose(Axis.YP.rotationDegrees(-altarTile.degreesFloppedRender));
        poseStack.translate(0.0f, 0.0f, -(altarTile.degreesFloppedRender / 10.0f) / 32.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
        float scale = this.easeInOutElastic(Mth.lerp((float)partialTicks, (float)this.drawTooltipScaleOld, (float)this.drawTooltipScale));
        poseStack.translate(0.05f + 0.1f * scale, -(1.0f - (Math.min(this.drawTooltipScale, 1.0f) < 0.5f ? Math.min(this.drawTooltipScale, 1.0f) * 2.0f : 1.0f)) / 12.0f, 0.0f);
        if (scale < 0.0f) {
            scale = 0.0f;
        }
        poseStack.scale(scale, scale, scale);
        ArrayList<Component> list = new ArrayList<Component>(this.tooltipText);
        list.addFirst((Component)Component.translatable((String)""));
        this.renderTooltip(this.tooltipStack, bufferSource, poseStack, this.tooltipText, Optional.empty(), 0, 0, overlay, light);
        poseStack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderTooltip(ItemStack stack, MultiBufferSource buffer, PoseStack p_169389_, List<Component> components, Optional<TooltipComponent> p_169391_, int p_169392_, int p_169393_, int overlay, int light) {
        List<Object> list = new ArrayList<ClientTooltipComponent>();
        List<Object> list2 = new ArrayList<ClientTooltipComponent>();
        try {
            list = ClientHooks.gatherTooltipComponents((ItemStack)stack, components, p_169391_, (int)p_169392_, (int)300, (int)750, (Font)Minecraft.getInstance().font);
            ArrayList<MutableComponent> newComponentList = new ArrayList<MutableComponent>();
            for (Component component : components) {
                newComponentList.add(Component.translatable((String)component.getString()).withStyle(component.getStyle().withColor(0x292929)));
            }
            list2 = ClientHooks.gatherTooltipComponents((ItemStack)stack, newComponentList, p_169391_, (int)p_169392_, (int)300, (int)750, (Font)Minecraft.getInstance().font);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.renderTooltipInternal(buffer, p_169389_, list, list2, p_169392_, p_169393_, overlay, light);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderTooltipInternal(MultiBufferSource bufferSource, PoseStack poseStack, List<ClientTooltipComponent> clientTooltipComponentList, List<ClientTooltipComponent> clientTooltipComponentList2, int p_169386_, int p_169387_, int overlay, int light) {
        if (!clientTooltipComponentList.isEmpty()) {
            HexereiBookTooltip hexereiBookTooltip;
            ClientTooltipComponent clientTooltipComponent2;
            int l2;
            RenderTooltipEvent.Pre preEvent = ClientHooks.onRenderTooltipPre((ItemStack)this.tooltipStack, (GuiGraphics)new GuiGraphics(Minecraft.getInstance(), (MultiBufferSource.BufferSource)bufferSource), (int)p_169386_, (int)p_169387_, (int)750, (int)750, clientTooltipComponentList, (Font)Minecraft.getInstance().font, (ClientTooltipPositioner)DefaultTooltipPositioner.INSTANCE);
            if (preEvent.isCanceled()) {
                return;
            }
            int i = 0;
            int j = clientTooltipComponentList.size() == 1 ? -2 : 0;
            for (ClientTooltipComponent clientTooltipComponent : clientTooltipComponentList) {
                int l = clientTooltipComponent.getWidth(preEvent.getFont());
                if (l > i) {
                    i = l;
                }
                j += clientTooltipComponent.getHeight();
            }
            int j2 = preEvent.getX() + 12;
            int k2 = preEvent.getY() - 12;
            if (j2 + i > 750) {
                j2 -= 28 + i;
            }
            if (k2 + j + 6 > 750) {
                k2 = 750 - j - 6;
            }
            VertexConsumer buffer = bufferSource.getBuffer(RenderType.itemEntityTranslucentCull((ResourceLocation)ResourceLocation.parse((String)"hexerei:textures/book/blank.png")));
            poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
            poseStack.scale(0.003f, 0.003f, 0.003f);
            poseStack.translate((float)(-(i + 15)) / 2.0f, (float)(-(j + 15)) / 2.0f, -10.0f);
            RenderTooltipEvent.Color colorEvent = ClientHooks.onRenderTooltipColor((ItemStack)this.tooltipStack, (GuiGraphics)new GuiGraphics(Minecraft.getInstance(), (MultiBufferSource.BufferSource)bufferSource), (int)j2, (int)k2, (Font)preEvent.getFont(), clientTooltipComponentList);
            PageDrawing.fillGradient(poseStack, buffer, j2 - 3, k2 - 3, j2 + i + 3, k2 + j + 3, 0.2f, colorEvent.getBackgroundStart(), colorEvent.getBackgroundEnd(), overlay, light);
            PageDrawing.fillGradient(poseStack, buffer, j2 - 3, k2 - 4, j2 + i + 3, k2 - 2, 0.1f, colorEvent.getBackgroundStart(), colorEvent.getBackgroundStart(), overlay, light);
            PageDrawing.fillGradient(poseStack, buffer, j2 - 3, k2 + j + 2, j2 + i + 3, k2 + j + 4, 0.1f, colorEvent.getBackgroundEnd(), colorEvent.getBackgroundEnd(), overlay, light);
            PageDrawing.fillGradient(poseStack, buffer, j2 - 4, k2 - 3, j2 - 2, k2 + j + 3, 0.1f, colorEvent.getBackgroundStart(), colorEvent.getBackgroundEnd(), overlay, light);
            PageDrawing.fillGradient(poseStack, buffer, j2 + i + 2, k2 - 3, j2 + i + 4, k2 + j + 3, 0.1f, colorEvent.getBackgroundStart(), colorEvent.getBackgroundEnd(), overlay, light);
            ((MultiBufferSource.BufferSource)bufferSource).endBatch();
            buffer = bufferSource.getBuffer(RenderType.itemEntityTranslucentCull((ResourceLocation)ResourceLocation.parse((String)"hexerei:textures/book/blank.png")));
            PageDrawing.fillGradient(poseStack, buffer, j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + j + 3 - 1, 0.0f, colorEvent.getBorderStart(), colorEvent.getBorderEnd(), overlay, light);
            PageDrawing.fillGradient(poseStack, buffer, j2 + i + 2, k2 - 3 + 1, j2 + i + 3, k2 + j + 3 - 1, 0.0f, colorEvent.getBorderStart(), colorEvent.getBorderEnd(), overlay, light);
            PageDrawing.fillGradient(poseStack, buffer, j2 - 3, k2 - 3, j2 + i + 3, k2 - 3 + 1, 0.0f, colorEvent.getBorderStart(), colorEvent.getBorderStart(), overlay, light);
            PageDrawing.fillGradient(poseStack, buffer, j2 - 3, k2 + j + 2, j2 + i + 3, k2 + j + 3, 0.0f, colorEvent.getBorderEnd(), colorEvent.getBorderEnd(), overlay, light);
            RenderSystem.enableDepthTest();
            MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.getInstance().renderBuffers().bufferSource();
            poseStack.translate(0.0, 0.0, 0.01);
            poseStack.scale(1.0f, 1.0f, 1.0E-5f);
            int l1 = k2;
            Matrix4f matrix4f = poseStack.last().pose();
            for (l2 = 0; l2 < clientTooltipComponentList.size(); ++l2) {
                clientTooltipComponent2 = clientTooltipComponentList.get(l2);
                if (clientTooltipComponent2 instanceof HexereiBookTooltip) {
                    hexereiBookTooltip = (HexereiBookTooltip)clientTooltipComponent2;
                    hexereiBookTooltip.renderText(preEvent.getFont(), j2, l1, matrix4f, multibuffersource$buffersource, overlay, light);
                } else if (clientTooltipComponent2 instanceof ClientTextTooltip) {
                    ClientTextTooltip clientTextTooltip = (ClientTextTooltip)clientTooltipComponent2;
                    int r = 63;
                    int g = 63;
                    int b = 63;
                    int a = 255;
                    int col = a << 24 | r << 16 | g << 8 | b;
                    Font font = preEvent.getFont();
                    matrix4f = poseStack.last().pose();
                    font.drawInBatch(clientTextTooltip.text, (float)j2, (float)l1, col, false, matrix4f, (MultiBufferSource)multibuffersource$buffersource, Font.DisplayMode.NORMAL, 0, light);
                    poseStack.pushPose();
                    poseStack.translate(0.5f, 0.5f, 7500.0f);
                    matrix4f = poseStack.last().pose();
                    font.drawInBatch(((ClientTextTooltip)clientTooltipComponentList2.get((int)l2)).text, (float)j2, (float)l1, col, false, matrix4f, (MultiBufferSource)multibuffersource$buffersource, Font.DisplayMode.NORMAL, 0, light);
                    poseStack.popPose();
                }
                l1 += clientTooltipComponent2.getHeight() + (l2 == 0 ? 2 : 0);
            }
            multibuffersource$buffersource.endBatch();
            l1 = k2;
            poseStack.scale(1.0f, 1.0f, 333.333f);
            for (l2 = 0; l2 < clientTooltipComponentList.size(); ++l2) {
                clientTooltipComponent2 = clientTooltipComponentList.get(l2);
                RenderSystem.enableDepthTest();
                if (clientTooltipComponent2 instanceof HexereiBookTooltip) {
                    hexereiBookTooltip = (HexereiBookTooltip)clientTooltipComponent2;
                    hexereiBookTooltip.renderImage(preEvent.getFont(), bufferSource, j2, l1, poseStack, itemRenderer, 0, overlay, light);
                }
                l1 += clientTooltipComponent2.getHeight() + (l2 == 0 ? 2 : 0);
            }
        }
    }

    private static int adjustColor(int p_92720_) {
        return (p_92720_ & 0xFC000000) == 0 ? p_92720_ | 0xFF000000 : p_92720_;
    }

    protected static void fillGradient(PoseStack poseStack, VertexConsumer buffer, int p_93126_, int p_93127_, int p_93128_, int p_93129_, float p_93130_, int pColorFrom, int pColorTo, int overlay, int light) {
        float fromAlpha = (float)FastColor.ARGB32.alpha((int)pColorFrom) / 255.0f * 0.9f;
        float f1 = (float)FastColor.ARGB32.red((int)pColorFrom) / 255.0f;
        float f2 = (float)FastColor.ARGB32.green((int)pColorFrom) / 255.0f;
        float f3 = (float)FastColor.ARGB32.blue((int)pColorFrom) / 255.0f;
        float toAlpha = (float)FastColor.ARGB32.alpha((int)pColorTo) / 255.0f * 0.9f;
        float f5 = (float)FastColor.ARGB32.red((int)pColorTo) / 255.0f;
        float f6 = (float)FastColor.ARGB32.green((int)pColorTo) / 255.0f;
        float f7 = (float)FastColor.ARGB32.blue((int)pColorTo) / 255.0f;
        PoseStack.Pose normal = poseStack.last();
        Matrix4f matrix4f = poseStack.last().pose();
        boolean u = false;
        boolean v = false;
        boolean imageWidth = true;
        boolean imageHeight = true;
        boolean width = true;
        boolean height = true;
        float u1 = ((float)u + 0.0f) / (float)imageWidth;
        float u2 = ((float)u + (float)width) / (float)imageWidth;
        float v1 = ((float)v + 0.0f) / (float)imageHeight;
        float v2 = ((float)v + (float)height) / (float)imageHeight;
        buffer.addVertex(matrix4f, (float)p_93128_, (float)p_93127_, p_93130_).setColor(f1, f2, f3, fromAlpha).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix4f, (float)p_93126_, (float)p_93127_, p_93130_).setColor(f1, f2, f3, fromAlpha).setUv(u1, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix4f, (float)p_93126_, (float)p_93129_, p_93130_).setColor(f5, f6, f7, toAlpha).setUv(u2, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix4f, (float)p_93128_, (float)p_93129_, p_93130_).setColor(f5, f6, f7, toAlpha).setUv(u2, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawBookmark(BookImage bookImage, BookOfShadowsAltarTile altarTile, PoseStack poseStack, MultiBufferSource bufferSource, float zLevel, float rotate, int light, int overlay, PageOn pageOn, int color, DrawingType drawingType, ItemDisplayContext transformType) {
        poseStack.pushPose();
        if (pageOn == PageOn.LEFT_PAGE) {
            PageDrawing.translateToLeftPage(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.LEFT_PAGE_UNDER) {
            PageDrawing.translateToLeftPageUnder(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV) {
            PageDrawing.translateToLeftPagePrevious(altarTile, poseStack, drawingType, transformType);
        }
        if (pageOn == PageOn.RIGHT_PAGE) {
            PageDrawing.translateToRightPage(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.RIGHT_PAGE_UNDER) {
            PageDrawing.translateToRightPageUnder(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV) {
            PageDrawing.translateToRightPagePrevious(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.MIDDLE_BUTTON) {
            this.translateToMiddleButton(altarTile, poseStack, drawingType, transformType);
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        poseStack.translate(-0.5f, 0.34375f, -7.5E-4f);
        poseStack.scale(0.5f * bookImage.scale, 0.5f * bookImage.scale, 0.5f * bookImage.scale);
        poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
        poseStack.translate((bookImage.x / 8.1f - 0.001875f) / bookImage.scale, (bookImage.y / 8.1f - 0.0033125f) / bookImage.scale, (drawingType == DrawingType.SCREEN ? -5.0f - zLevel : -zLevel) / 1600.0f / bookImage.scale);
        bookImage.effects.forEach(bookImageEffect -> {
            if (bookImageEffect.type.equals("scale")) {
                float f = bookImageEffect.amount - 1.0f;
                float x = f / 2.0f + 1.0f + f / 2.0f * Mth.sin((float)(ClientEvents.getClientTicks() / bookImageEffect.speed));
                poseStack.scale(x, x, x);
            }
        });
        poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        bookImage.effects.forEach(bookImageEffect -> {
            if (bookImageEffect.type.equals("tilt")) {
                poseStack.mulPose(Axis.XP.rotationDegrees(-bookImageEffect.amount * Mth.sin((float)(ClientEvents.getClientTicks() / bookImageEffect.speed))));
            }
        });
        poseStack.mulPose(Axis.XP.rotationDegrees(rotate));
        if (transformType != ItemDisplayContext.NONE) {
            poseStack.mulPose(Axis.ZP.rotationDegrees(-35.0f));
        }
        RenderSystem.setShader(GameRenderer::getRendertypeEntityCutoutNoCullShader);
        Matrix4f matrix = poseStack.last().pose();
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)ResourceLocation.parse((String)bookImage.texture)));
        PoseStack.Pose normal = poseStack.last();
        int u = (int)bookImage.u;
        int v = (int)bookImage.v;
        int imageWidth = (int)bookImage.imageWidth;
        int imageHeight = (int)bookImage.imageHeight;
        int width = (int)bookImage.width;
        int height = (int)bookImage.height;
        float u1 = ((float)u + 0.0f) / (float)imageWidth;
        float u2 = ((float)u + (float)width) / (float)imageWidth;
        float v1 = ((float)v + 0.0f) / (float)imageHeight;
        float v2 = ((float)v + (float)height) / (float)imageHeight;
        float a = 1.0f;
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        if (color != -1) {
            r = (float)(color >> 16 & 0xFF) / 255.0f;
            g = (float)(color >> 8 & 0xFF) / 255.0f;
            b = (float)(color & 0xFF) / 255.0f;
        }
        if (transformType != ItemDisplayContext.NONE) {
            buffer.addVertex(matrix, 0.0f, -0.006111111f * (float)height, -0.0030555555f * (float)width).setColor(r, g, b, a).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(matrix, 0.0f, 0.0f, -0.0030555555f * (float)width).setColor(r, g, b, a).setUv(u1, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(matrix, 0.0f, 0.0f, 0.0030555555f * (float)width).setColor(r, g, b, a).setUv(u2, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(matrix, 0.0f, -0.006111111f * (float)height, 0.0030555555f * (float)width).setColor(r, g, b, a).setUv(u2, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(matrix, 0.0f, -0.006111111f * (float)height, 0.0030555555f * (float)width).setColor(r, g, b, a).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(matrix, 0.0f, 0.0f, 0.0030555555f * (float)width).setColor(r, g, b, a).setUv(u1, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(matrix, 0.0f, 0.0f, -0.0030555555f * (float)width).setColor(r, g, b, a).setUv(u2, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(matrix, 0.0f, -0.006111111f * (float)height, -0.0030555555f * (float)width).setColor(r, g, b, a).setUv(u2, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        } else {
            buffer.addVertex(matrix, 0.0f, -0.0030555555f * (float)height, -0.0030555555f * (float)width).setColor(r, g, b, a).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(matrix, 0.0f, 0.0030555555f * (float)height, -0.0030555555f * (float)width).setColor(r, g, b, a).setUv(u1, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(matrix, 0.0f, 0.0030555555f * (float)height, 0.0030555555f * (float)width).setColor(r, g, b, a).setUv(u2, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(matrix, 0.0f, -0.0030555555f * (float)height, 0.0030555555f * (float)width).setColor(r, g, b, a).setUv(u2, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        }
        poseStack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawImage(BookImage bookImage, BookOfShadowsAltarTile altarTile, float cursorX, float cursorY, PoseStack poseStack, MultiBufferSource bufferSource, float zLevel, int light, int overlay, PageOn pageOn, DrawingType drawingType) {
        this.drawImage(bookImage, altarTile, cursorX, cursorY, poseStack, bufferSource, zLevel, light, overlay, pageOn, -1, drawingType, ItemDisplayContext.NONE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawImage(BookImage bookImage, BookOfShadowsAltarTile altarTile, float cursorX, float cursorY, PoseStack poseStack, MultiBufferSource bufferSource, float zLevel, int light, int overlay, PageOn pageOn, int color, DrawingType drawingType, ItemDisplayContext transformType) {
        this.drawImage(bookImage, altarTile, cursorX, cursorY, poseStack, bufferSource, zLevel, light, overlay, pageOn, color, drawingType, transformType, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawImage(BookImage bookImage, BookOfShadowsAltarTile altarTile, float cursorX, float cursorY, PoseStack poseStack, MultiBufferSource bufferSource, float zLevel, int light, int overlay, PageOn pageOn, int color, DrawingType drawingType, ItemDisplayContext transformType, boolean transparent) {
        poseStack.pushPose();
        if (pageOn == PageOn.LEFT_PAGE) {
            PageDrawing.translateToLeftPage(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.LEFT_PAGE_UNDER) {
            PageDrawing.translateToLeftPageUnder(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV) {
            PageDrawing.translateToLeftPagePrevious(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV_PREV) {
            PageDrawing.translateToLeftPagePrevious2(altarTile, poseStack, drawingType, transformType);
        }
        if (pageOn == PageOn.RIGHT_PAGE) {
            PageDrawing.translateToRightPage(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.RIGHT_PAGE_UNDER) {
            PageDrawing.translateToRightPageUnder(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV) {
            PageDrawing.translateToRightPagePrevious(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV_PREV) {
            PageDrawing.translateToRightPagePrevious2(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.MIDDLE_BUTTON) {
            this.translateToMiddleButton(altarTile, poseStack, drawingType, transformType);
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        poseStack.translate(-0.5f, 0.34375f, -7.5E-4f);
        poseStack.scale(0.5f * bookImage.scale, 0.5f * bookImage.scale, 0.5f * bookImage.scale);
        poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
        poseStack.translate((bookImage.x / 8.1f - 0.001875f) / bookImage.scale, (bookImage.y / 8.1f - 0.0033125f) / bookImage.scale, -(zLevel + bookImage.z) / 1600.0f);
        bookImage.effects.forEach(bookImageEffect -> {
            if (bookImageEffect.type.equals("scale")) {
                float f = bookImageEffect.amount - 1.0f;
                float x = f / 2.0f + 1.0f + f / 2.0f * Mth.sin((float)(ClientEvents.getClientTicks() / bookImageEffect.speed));
                poseStack.scale(x, x, x);
            }
        });
        poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        bookImage.effects.forEach(bookImageEffect -> {
            if (bookImageEffect.type.equals("tilt")) {
                poseStack.mulPose(Axis.XP.rotationDegrees(-bookImageEffect.amount * Mth.sin((float)(ClientEvents.getClientTicks() / bookImageEffect.speed))));
            }
        });
        RenderSystem.setShader(GameRenderer::getRendertypeEntityCutoutNoCullShader);
        AtomicReference<String> loc = new AtomicReference<String>(bookImage.texture);
        AtomicReference<BookImage> overlay_image = new AtomicReference<BookImage>(bookImage);
        AtomicReference<Boolean> overlay_draw = new AtomicReference<Boolean>(false);
        AtomicReference<Integer> u = new AtomicReference<Integer>((int)bookImage.u);
        AtomicReference<Integer> v = new AtomicReference<Integer>((int)bookImage.v);
        AtomicReference<Integer> imageWidth = new AtomicReference<Integer>((int)bookImage.imageWidth);
        AtomicReference<Integer> imageHeight = new AtomicReference<Integer>((int)bookImage.imageHeight);
        AtomicReference<Integer> width = new AtomicReference<Integer>((int)bookImage.width);
        AtomicReference<Integer> height = new AtomicReference<Integer>((int)bookImage.height);
        AtomicBoolean flag = new AtomicBoolean(false);
        bookImage.effects.forEach(bookImageEffect -> {
            float h;
            float y;
            float w;
            float x;
            if (bookImageEffect.type.equals("hover_change_texture") && PageDrawing.canInteract(cursorX, cursorY, x = bookImage.x - (w = bookImage.width / 330.0f * bookImage.scale / 0.062f) / 2.0f + 0.455f, y = bookImage.y - (h = bookImage.height / 330.0f * bookImage.scale / 0.062f) / 2.0f + 0.49f, w, h, altarTile, drawingType)) {
                flag.set(true);
                loc.set(bookImageEffect.hoverImage.texture);
            }
            if (bookImageEffect.type.equals("hover_overlay") && PageDrawing.canInteract(cursorX, cursorY, x = bookImage.x - (w = bookImage.width / 330.0f * bookImage.scale / 0.062f) / 2.0f + 0.45f, y = bookImage.y - (h = bookImage.height / 330.0f * bookImage.scale / 0.062f) / 2.0f + 0.49f, w, h, altarTile, drawingType)) {
                overlay_image.set(bookImageEffect.hoverImage);
                overlay_draw.set(true);
            }
            if (flag.get()) {
                bookImageEffect.hoverImage.effects.forEach(bookHoverImageEffect -> {
                    if (bookHoverImageEffect.type.equals("scale")) {
                        float f = bookHoverImageEffect.amount - 1.0f;
                        float x = f / 2.0f + 1.0f + f / 2.0f * Mth.sin((float)(ClientEvents.getClientTicks() / bookHoverImageEffect.speed));
                        poseStack.scale(x, x, x);
                    }
                });
                bookImageEffect.hoverImage.effects.forEach(bookHoverImageEffect -> {
                    if (bookHoverImageEffect.type.equals("tilt")) {
                        poseStack.mulPose(Axis.XP.rotationDegrees(-bookHoverImageEffect.amount * Mth.sin((float)(ClientEvents.getClientTicks() / bookHoverImageEffect.speed))));
                    }
                });
            }
        });
        Matrix4f matrix = poseStack.last().pose();
        PoseStack.Pose normal = poseStack.last();
        float u1 = ((float)u.get().intValue() + 0.0f) / (float)imageWidth.get().intValue();
        float u2 = ((float)u.get().intValue() + (float)width.get().intValue()) / (float)imageWidth.get().intValue();
        float v1 = ((float)v.get().intValue() + 0.0f) / (float)imageHeight.get().intValue();
        float v2 = ((float)v.get().intValue() + (float)height.get().intValue()) / (float)imageHeight.get().intValue();
        float a = 1.0f;
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        if (color != -1) {
            a = (float)(color >> 24 & 0xFF) / 255.0f;
            r = (float)(color >> 16 & 0xFF) / 255.0f;
            g = (float)(color >> 8 & 0xFF) / 255.0f;
            b = (float)(color & 0xFF) / 255.0f;
        }
        VertexConsumer buffer = a != 1.0f || transparent ? (((Boolean)HexConfig.BOOK_SHADERS_TOGGLE.get()).booleanValue() ? bufferSource.getBuffer(ModRenderTypes.bookTranslucent(ResourceLocation.parse((String)loc.get()))) : bufferSource.getBuffer(ModRenderTypes.entityTranslucent((ResourceLocation)ResourceLocation.parse((String)loc.get())))) : bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)ResourceLocation.parse((String)loc.get())));
        buffer.addVertex(matrix, 0.0f, -0.0030555555f * (float)height.get().intValue(), -0.0030555555f * (float)width.get().intValue()).setColor(r, g, b, a).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 0.0f, 0.0030555555f * (float)height.get().intValue(), -0.0030555555f * (float)width.get().intValue()).setColor(r, g, b, a).setUv(u1, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 0.0f, 0.0030555555f * (float)height.get().intValue(), 0.0030555555f * (float)width.get().intValue()).setColor(r, g, b, a).setUv(u2, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 0.0f, -0.0030555555f * (float)height.get().intValue(), 0.0030555555f * (float)width.get().intValue()).setColor(r, g, b, a).setUv(u2, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        if (bufferSource instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource multiBufferSource = (MultiBufferSource.BufferSource)bufferSource;
            multiBufferSource.endBatch();
        }
        if (overlay_draw.get().booleanValue()) {
            BookImage ov_img = overlay_image.get();
            VertexConsumer buffer2 = a != 1.0f || transparent ? bufferSource.getBuffer(ModRenderTypes.bookTranslucent(ResourceLocation.parse((String)loc.get()))) : bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)ResourceLocation.parse((String)loc.get())));
            float overlay_u1 = (ov_img.u + 0.0f) / ov_img.imageWidth;
            float overlay_u2 = (ov_img.u + ov_img.width) / ov_img.imageWidth;
            float overlay_v1 = (ov_img.v + 0.0f) / ov_img.imageHeight;
            float overlay_v2 = (ov_img.v + ov_img.height) / ov_img.imageHeight;
            float overlay_a = 1.0f;
            float overlay_r = 1.0f;
            float overlay_g = 1.0f;
            float overlay_b = 1.0f;
            if (color != -1) {
                overlay_r = (float)(color >> 16 & 0xFF) / 255.0f;
                overlay_g = (float)(color >> 8 & 0xFF) / 255.0f;
                overlay_b = (float)(color & 0xFF) / 255.0f;
            }
            poseStack.pushPose();
            buffer2.addVertex(matrix, ov_img.z / 2000.0f, -0.0030555555f * ov_img.height, -0.0030555555f * ov_img.width).setColor(overlay_r, overlay_g, overlay_b, overlay_a).setUv(overlay_u1, overlay_v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer2.addVertex(matrix, ov_img.z / 2000.0f, 0.0030555555f * ov_img.height, -0.0030555555f * ov_img.width).setColor(overlay_r, overlay_g, overlay_b, overlay_a).setUv(overlay_u1, overlay_v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer2.addVertex(matrix, ov_img.z / 2000.0f, 0.0030555555f * ov_img.height, 0.0030555555f * ov_img.width).setColor(overlay_r, overlay_g, overlay_b, overlay_a).setUv(overlay_u2, overlay_v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer2.addVertex(matrix, ov_img.z / 2000.0f, -0.0030555555f * ov_img.height, 0.0030555555f * ov_img.width).setColor(overlay_r, overlay_g, overlay_b, overlay_a).setUv(overlay_u2, overlay_v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            poseStack.popPose();
            if (bufferSource instanceof MultiBufferSource.BufferSource) {
                MultiBufferSource.BufferSource multiBufferSource = (MultiBufferSource.BufferSource)bufferSource;
                multiBufferSource.endBatch();
            }
        }
        poseStack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawPaintColorSlider(float offset, PaintSystem.ValueSlider valueSlider, BookOfShadowsAltarTile altarTile, float cursorX, float cursorY, float scale, PoseStack poseStack, MultiBufferSource bufferSource, float zLevel, int light, int overlay, PageOn pageOn, int color, DrawingType drawingType, ItemDisplayContext transformType, float partial) {
        MultiBufferSource.BufferSource multiBufferSource;
        float height;
        float width;
        float y;
        float x;
        if (scale == 0.0f) {
            return;
        }
        if (valueSlider.isHorizontal()) {
            x = valueSlider.getX(pageOn) + valueSlider.getValue() * valueSlider.width / 8.0f + 0.006f;
            y = valueSlider.getY(pageOn) + offset;
            width = 0.85f;
            height = 1.35f;
            height *= valueSlider.getHoveringScale(partial);
        } else {
            x = valueSlider.getX(pageOn) + offset;
            y = valueSlider.getY(pageOn) - valueSlider.getValue() * valueSlider.height / 8.0f + valueSlider.height / 16.0f;
            width = 1.35f;
            height = 0.85f;
            width *= valueSlider.getHoveringScale(partial);
        }
        float width2 = width - 0.6f;
        float height2 = height - 0.6f;
        poseStack.pushPose();
        if (pageOn == PageOn.LEFT_PAGE) {
            PageDrawing.translateToLeftPage(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.LEFT_PAGE_UNDER) {
            PageDrawing.translateToLeftPageUnder(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV) {
            PageDrawing.translateToLeftPagePrevious(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV_PREV) {
            PageDrawing.translateToLeftPagePrevious2(altarTile, poseStack, drawingType, transformType);
        }
        if (pageOn == PageOn.RIGHT_PAGE) {
            PageDrawing.translateToRightPage(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.RIGHT_PAGE_UNDER) {
            PageDrawing.translateToRightPageUnder(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV) {
            PageDrawing.translateToRightPagePrevious(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV_PREV) {
            PageDrawing.translateToRightPagePrevious2(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.MIDDLE_BUTTON) {
            this.translateToMiddleButton(altarTile, poseStack, drawingType, transformType);
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        poseStack.translate(-0.5f, 0.34375f, -7.5E-4f);
        poseStack.scale(0.5f * scale * 2.55f, 0.5f * scale * 2.55f, 1.275f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
        poseStack.translate((x / 8.1f - 0.05864197f) / (scale * 2.55f), (y / 8.1f - 0.12345678f) / (scale * 2.55f), -zLevel / 1600.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        RenderSystem.setShader(GameRenderer::getRendertypeEntityCutoutNoCullShader);
        Matrix4f matrix = poseStack.last().pose();
        PoseStack.Pose normal = poseStack.last();
        float u1 = 0.0f;
        float u2 = 1.0f;
        float v1 = 0.0f;
        float v2 = 1.0f;
        float a = 1.0f;
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)ResourceLocation.parse((String)"hexerei:textures/book/blank.png")));
        a = (float)(color >> 24 & 0xFF) / 255.0f;
        r = (float)(color >> 16 & 0xFF) / 255.0f;
        g = (float)(color >> 8 & 0xFF) / 255.0f;
        b = (float)(color & 0xFF) / 255.0f;
        buffer.addVertex(matrix, 1.0E-5f, -0.0030555555f * height2, -0.0030555555f * width2).setColor(r, g, b, a).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 1.0E-5f, 0.0030555555f * height2, -0.0030555555f * width2).setColor(r, g, b, a).setUv(u1, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 1.0E-5f, 0.0030555555f * height2, 0.0030555555f * width2).setColor(r, g, b, a).setUv(u2, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 1.0E-5f, -0.0030555555f * height2, 0.0030555555f * width2).setColor(r, g, b, a).setUv(u2, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        if (bufferSource instanceof MultiBufferSource.BufferSource) {
            multiBufferSource = (MultiBufferSource.BufferSource)bufferSource;
            multiBufferSource.endBatch();
        }
        buffer = bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)ResourceLocation.parse((String)"hexerei:textures/book/blank.png")));
        a = 1.0f;
        r = 0.0f;
        g = 0.0f;
        b = 0.0f;
        buffer.addVertex(matrix, 0.0f, -0.0030555555f * height, -0.0030555555f * width).setColor(r, g, b, a).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 0.0f, 0.0030555555f * height, -0.0030555555f * width).setColor(r, g, b, a).setUv(u1, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 0.0f, 0.0030555555f * height, 0.0030555555f * width).setColor(r, g, b, a).setUv(u2, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 0.0f, -0.0030555555f * height, 0.0030555555f * width).setColor(r, g, b, a).setUv(u2, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        if (bufferSource instanceof MultiBufferSource.BufferSource) {
            multiBufferSource = (MultiBufferSource.BufferSource)bufferSource;
            multiBufferSource.endBatch();
        }
        poseStack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawPaintColors(PaintSystem paintSystem, BookOfShadowsAltarTile altarTile, float cursorX, float cursorY, float scale, PoseStack poseStack, MultiBufferSource bufferSource, float zLevel, int light, int overlay, PageOn pageOn, DrawingType drawingType, ItemDisplayContext transformType, float partial) {
        if (scale <= 0.0f) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            MultiBufferSource.BufferSource multiBufferSource;
            if (i > paintSystem.getColors().colors.size()) continue;
            PaintSystem.Colors.ColorSelection colorSelection = paintSystem.getColors().colors.get(i);
            float x = Mth.lerp((float)partial, (float)((float)colorSelection.colorPosDataOld.pos.x), (float)((float)colorSelection.colorPosData.pos.x)) + (pageOn.isOnLeftSide() ? 0.0f : 0.8f);
            float y = Mth.lerp((float)partial, (float)((float)colorSelection.colorPosDataOld.pos.y), (float)((float)colorSelection.colorPosData.pos.y));
            float z = Mth.lerp((float)partial, (float)((float)colorSelection.colorPosDataOld.pos.z), (float)((float)colorSelection.colorPosData.pos.z));
            float width = Mth.lerp((float)partial, (float)colorSelection.colorPosDataOld.width, (float)colorSelection.colorPosData.width);
            float height = Mth.lerp((float)partial, (float)colorSelection.colorPosDataOld.height, (float)colorSelection.colorPosData.height);
            float width2 = width - 0.75f;
            float height2 = height - 0.75f;
            poseStack.pushPose();
            if (pageOn == PageOn.LEFT_PAGE) {
                PageDrawing.translateToLeftPage(altarTile, poseStack, drawingType, transformType);
            } else if (pageOn == PageOn.LEFT_PAGE_UNDER) {
                PageDrawing.translateToLeftPageUnder(altarTile, poseStack, drawingType, transformType);
            } else if (pageOn == PageOn.LEFT_PAGE_PREV) {
                PageDrawing.translateToLeftPagePrevious(altarTile, poseStack, drawingType, transformType);
            } else if (pageOn == PageOn.LEFT_PAGE_PREV_PREV) {
                PageDrawing.translateToLeftPagePrevious2(altarTile, poseStack, drawingType, transformType);
            }
            if (pageOn == PageOn.RIGHT_PAGE) {
                PageDrawing.translateToRightPage(altarTile, poseStack, drawingType, transformType);
            } else if (pageOn == PageOn.RIGHT_PAGE_UNDER) {
                PageDrawing.translateToRightPageUnder(altarTile, poseStack, drawingType, transformType);
            } else if (pageOn == PageOn.RIGHT_PAGE_PREV) {
                PageDrawing.translateToRightPagePrevious(altarTile, poseStack, drawingType, transformType);
            } else if (pageOn == PageOn.RIGHT_PAGE_PREV_PREV) {
                PageDrawing.translateToRightPagePrevious2(altarTile, poseStack, drawingType, transformType);
            } else if (pageOn == PageOn.MIDDLE_BUTTON) {
                this.translateToMiddleButton(altarTile, poseStack, drawingType, transformType);
            }
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            poseStack.translate(-0.5f, 0.34375f, -7.5E-4f);
            poseStack.scale(0.5f * scale * 2.55f, 0.5f * scale * 2.55f, 1.275f);
            poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
            poseStack.translate((x / 8.1f - 0.05864197f) / (scale * 2.55f), (y / 8.1f - 0.12345678f) / (scale * 2.55f), -zLevel / 1600.0f);
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
            RenderSystem.setShader(GameRenderer::getRendertypeEntityCutoutNoCullShader);
            Matrix4f matrix = poseStack.last().pose();
            PoseStack.Pose normal = poseStack.last();
            float u1 = 0.0f;
            float u2 = 1.0f;
            float v1 = 0.0f;
            float v2 = 1.0f;
            int color = colorSelection.getColor();
            VertexConsumer buffer = bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)ResourceLocation.parse((String)"hexerei:textures/book/blank.png")));
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            buffer.addVertex(matrix, 1.0E-4f + z, -0.0030555555f * height2, -0.0030555555f * width2).setColor(r, g, b, 1.0f).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(matrix, 1.0E-4f + z, 0.0030555555f * height2, -0.0030555555f * width2).setColor(r, g, b, a).setUv(u1, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(matrix, 1.0E-4f + z, 0.0030555555f * height2, 0.0030555555f * width2).setColor(r, g, b, a).setUv(u2, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(matrix, 1.0E-4f + z, -0.0030555555f * height2, 0.0030555555f * width2).setColor(r, g, b, 1.0f).setUv(u2, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            if (bufferSource instanceof MultiBufferSource.BufferSource) {
                multiBufferSource = (MultiBufferSource.BufferSource)bufferSource;
                multiBufferSource.endBatch();
            }
            buffer = bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)ResourceLocation.parse((String)"hexerei:textures/book/blank.png")));
            a = 1.0f;
            r = 0.0f;
            g = 0.0f;
            b = 0.0f;
            buffer.addVertex(matrix, 7.0E-5f + z, -0.0030555555f * height, -0.0030555555f * width).setColor(r, g, b, a).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(matrix, 7.0E-5f + z, 0.0030555555f * height, -0.0030555555f * width).setColor(r, g, b, a).setUv(u1, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(matrix, 7.0E-5f + z, 0.0030555555f * height, 0.0030555555f * width).setColor(r, g, b, a).setUv(u2, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(matrix, 7.0E-5f + z, -0.0030555555f * height, 0.0030555555f * width).setColor(r, g, b, a).setUv(u2, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            if (bufferSource instanceof MultiBufferSource.BufferSource) {
                multiBufferSource = (MultiBufferSource.BufferSource)bufferSource;
                multiBufferSource.endBatch();
            }
            poseStack.popPose();
            float w1 = width / 326.0f * 2.55f / 0.062f;
            float h1 = height / 326.0f * 2.55f / 0.062f;
            float x1 = x + 0.025f - w1 / 2.0f;
            float y1 = y - 0.5f - 0.025f - h1 / 2.0f;
            if (!PageDrawing.canInteract(cursorX, cursorY, x1, y1, w1, h1, altarTile, drawingType)) continue;
            ArrayList<Component> tooltipList = new ArrayList<Component>();
            tooltipList.add((Component)Component.translatable((String)"Cycle Colors").withStyle(ChatFormatting.GRAY));
            this.tooltipText = tooltipList;
            this.drawTooltipText = true;
            this.tooltipStack = ItemStack.EMPTY;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawPaintColorSliderBar(float heightPercent, PaintSystem.ValueSlider valueSlider, BookOfShadowsAltarTile altarTile, float cursorX, float cursorY, float scale, PoseStack poseStack, MultiBufferSource bufferSource, float zLevel, int light, int overlay, PageOn pageOn, int color1, int color2, DrawingType drawingType, ItemDisplayContext transformType, boolean hueSlider, float partial) {
        VertexConsumer buffer;
        if (scale == 0.0f) {
            return;
        }
        float x = valueSlider.getX(pageOn);
        float y = valueSlider.getY(pageOn);
        float width = valueSlider.width;
        float height = valueSlider.height * heightPercent;
        poseStack.pushPose();
        if (pageOn == PageOn.LEFT_PAGE) {
            PageDrawing.translateToLeftPage(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.LEFT_PAGE_UNDER) {
            PageDrawing.translateToLeftPageUnder(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV) {
            PageDrawing.translateToLeftPagePrevious(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV_PREV) {
            PageDrawing.translateToLeftPagePrevious2(altarTile, poseStack, drawingType, transformType);
        }
        if (pageOn == PageOn.RIGHT_PAGE) {
            PageDrawing.translateToRightPage(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.RIGHT_PAGE_UNDER) {
            PageDrawing.translateToRightPageUnder(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV) {
            PageDrawing.translateToRightPagePrevious(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV_PREV) {
            PageDrawing.translateToRightPagePrevious2(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.MIDDLE_BUTTON) {
            this.translateToMiddleButton(altarTile, poseStack, drawingType, transformType);
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        poseStack.translate(-0.5f, 0.34375f, -7.5E-4f);
        poseStack.scale(0.5f * scale * 2.55f, 0.5f * scale * 2.55f, 1.275f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
        poseStack.translate((x / 8.1f - 0.05864197f) / (scale * 2.55f), (y / 8.1f - 0.12345678f) / (scale * 2.55f), -zLevel / 1600.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        RenderSystem.setShader(GameRenderer::getRendertypeEntityCutoutNoCullShader);
        Matrix4f matrix = poseStack.last().pose();
        PoseStack.Pose normal = poseStack.last();
        float u1 = 0.0f;
        float u2 = 1.0f;
        float v1 = 0.0f;
        float v2 = 1.0f;
        float a1 = 1.0f;
        float r1 = 1.0f;
        float g1 = 1.0f;
        float b1 = 1.0f;
        if (color1 != -1) {
            a1 = (float)(color1 >> 24 & 0xFF) / 255.0f;
            r1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
            g1 = (float)(color1 >> 8 & 0xFF) / 255.0f;
            b1 = (float)(color1 & 0xFF) / 255.0f;
        }
        float a2 = 1.0f;
        float r2 = 1.0f;
        float g2 = 1.0f;
        float b2 = 1.0f;
        if (color2 != -1) {
            a2 = (float)(color2 >> 24 & 0xFF) / 255.0f;
            r2 = (float)(color2 >> 16 & 0xFF) / 255.0f;
            g2 = (float)(color2 >> 8 & 0xFF) / 255.0f;
            b2 = (float)(color2 & 0xFF) / 255.0f;
        }
        if (hueSlider) {
            float bubblePosX = valueSlider.getValue();
            float bubblePosY = 0.5f;
            float bubbleRadius = 0.275f;
            float bubbleStrength = valueSlider.getHoveringScale(partial) - 1.0f;
            if (!valueSlider.isHorizontal()) {
                bubblePosY = 1.0f - valueSlider.getValue();
                bubblePosX = 0.5f;
            }
            if (((Boolean)HexConfig.BOOK_SHADERS_TOGGLE.get()).booleanValue()) {
                ClientEvents.hueSliderShader.safeGetUniform("bubblePos").set(bubblePosX, bubblePosY);
                ClientEvents.hueSliderShader.safeGetUniform("bubbleRadius").set(bubbleRadius);
                ClientEvents.hueSliderShader.safeGetUniform("bubbleStrength").set(bubbleStrength);
                ClientEvents.hueSliderShader.safeGetUniform("isHorizontal").set(valueSlider.isHorizontal() ? 1 : 0);
                buffer = bufferSource.getBuffer(ModRenderTypes.hueSlider(ResourceLocation.parse((String)"hexerei:textures/book/blank.png")));
            } else {
                buffer = bufferSource.getBuffer(ModRenderTypes.entityTranslucent((ResourceLocation)ResourceLocation.parse((String)"hexerei:textures/book/hue_slider.png")));
            }
        } else {
            float bubblePosX = valueSlider.getValue();
            float bubblePosY = 0.5f;
            float bubbleRadius = 0.275f;
            float bubbleStrength = valueSlider.getHoveringScale(partial) - 1.0f;
            if (!valueSlider.isHorizontal()) {
                bubblePosY = 1.0f - valueSlider.getValue();
                bubblePosX = 0.5f;
            }
            if (((Boolean)HexConfig.BOOK_SHADERS_TOGGLE.get()).booleanValue()) {
                ClientEvents.sliderShader.safeGetUniform("bubblePos").set(bubblePosX, bubblePosY);
                ClientEvents.sliderShader.safeGetUniform("bubbleRadius").set(bubbleRadius);
                ClientEvents.sliderShader.safeGetUniform("bubbleStrength").set(bubbleStrength);
                ClientEvents.sliderShader.safeGetUniform("isHorizontal").set(valueSlider.isHorizontal() ? 1 : 0);
                buffer = bufferSource.getBuffer(ModRenderTypes.slider(ResourceLocation.parse((String)"hexerei:textures/book/blank.png")));
            } else {
                buffer = valueSlider.isHorizontal() ? bufferSource.getBuffer(ModRenderTypes.entityTranslucent((ResourceLocation)ResourceLocation.parse((String)"hexerei:textures/book/blank_slider.png"))) : bufferSource.getBuffer(ModRenderTypes.entityTranslucent((ResourceLocation)ResourceLocation.parse((String)"hexerei:textures/book/blank_slider_v.png")));
            }
        }
        if (hueSlider) {
            if (valueSlider.isHorizontal()) {
                buffer.addVertex(matrix, 0.0f, -0.0030555555f * height, 0.0f).setColor(255, 255, 255, 255).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
                buffer.addVertex(matrix, 0.0f, 0.0030555555f * height, 0.0f).setColor(255, 255, 255, 255).setUv(u1, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
                buffer.addVertex(matrix, 0.0f, 0.0030555555f * height, 0.006111111f * width).setColor(255, 255, 255, 255).setUv(u2, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
                buffer.addVertex(matrix, 0.0f, -0.0030555555f * height, 0.006111111f * width).setColor(255, 255, 255, 255).setUv(u2, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            } else {
                buffer.addVertex(matrix, 0.0f, -0.0030555555f * height, 0.0f).setColor(255, 255, 255, 255).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
                buffer.addVertex(matrix, 0.0f, 0.0030555555f * height, 0.0f).setColor(255, 255, 255, 255).setUv(u1, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
                buffer.addVertex(matrix, 0.0f, 0.0030555555f * height, 0.006111111f * width).setColor(255, 255, 255, 255).setUv(u2, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
                buffer.addVertex(matrix, 0.0f, -0.0030555555f * height, 0.006111111f * width).setColor(255, 255, 255, 255).setUv(u2, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            }
        } else if (valueSlider.isHorizontal()) {
            buffer.addVertex(matrix, 0.0f, -0.0030555555f * height, 0.0f).setColor(r1, g1, b1, a1).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(matrix, 0.0f, 0.0030555555f * height, 0.0f).setColor(r1, g1, b1, a1).setUv(u1, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(matrix, 0.0f, 0.0030555555f * height, 0.006111111f * width).setColor(r2, g2, b2, a2).setUv(u2, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(matrix, 0.0f, -0.0030555555f * height, 0.006111111f * width).setColor(r2, g2, b2, a2).setUv(u2, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        } else {
            buffer.addVertex(matrix, 0.0f, -0.0030555555f * height, 0.0f).setColor(r2, g2, b2, a2).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(matrix, 0.0f, 0.0030555555f * height, 0.0f).setColor(r1, g1, b1, a1).setUv(u1, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(matrix, 0.0f, 0.0030555555f * height, 0.006111111f * width).setColor(r1, g1, b1, a1).setUv(u2, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(matrix, 0.0f, -0.0030555555f * height, 0.006111111f * width).setColor(r2, g2, b2, a2).setUv(u2, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        }
        poseStack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawPaintElement(BookPaintElement paintElement, BookOfShadowsAltarTile altarTile, float cursorX, float cursorY, PoseStack poseStack, MultiBufferSource bufferSource, float zLevel, int light, int overlay, PageOn pageOn, int color, DrawingType drawingType, ItemDisplayContext transformType, float partial) {
        block38: {
            PaintSystem paintSystem;
            block37: {
                if (paintElement.client == null) {
                    paintElement.client = new BookPaintElement.Client(paintElement);
                    return;
                }
                BookData bookData = altarTile.currentBook;
                paintSystem = paintElement.client.getPaintSystem(bookData.getUUID());
                paintSystem.shouldTick = true;
                poseStack.pushPose();
                if (pageOn == PageOn.LEFT_PAGE) {
                    PageDrawing.translateToLeftPage(altarTile, poseStack, drawingType, transformType);
                } else if (pageOn == PageOn.LEFT_PAGE_UNDER) {
                    PageDrawing.translateToLeftPageUnder(altarTile, poseStack, drawingType, transformType);
                } else if (pageOn == PageOn.LEFT_PAGE_PREV) {
                    PageDrawing.translateToLeftPagePrevious(altarTile, poseStack, drawingType, transformType);
                } else if (pageOn == PageOn.LEFT_PAGE_PREV_PREV) {
                    PageDrawing.translateToLeftPagePrevious2(altarTile, poseStack, drawingType, transformType);
                }
                if (pageOn == PageOn.RIGHT_PAGE) {
                    PageDrawing.translateToRightPage(altarTile, poseStack, drawingType, transformType);
                } else if (pageOn == PageOn.RIGHT_PAGE_UNDER) {
                    PageDrawing.translateToRightPageUnder(altarTile, poseStack, drawingType, transformType);
                } else if (pageOn == PageOn.RIGHT_PAGE_PREV) {
                    PageDrawing.translateToRightPagePrevious(altarTile, poseStack, drawingType, transformType);
                } else if (pageOn == PageOn.RIGHT_PAGE_PREV_PREV) {
                    PageDrawing.translateToRightPagePrevious2(altarTile, poseStack, drawingType, transformType);
                } else if (pageOn == PageOn.MIDDLE_BUTTON) {
                    this.translateToMiddleButton(altarTile, poseStack, drawingType, transformType);
                }
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                poseStack.translate(-0.5f, 0.34375f, -7.5E-4f);
                poseStack.scale(0.5f * paintElement.scale * 2.55f, 0.5f * paintElement.scale * 2.55f, 1.275f);
                poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
                poseStack.translate((paintElement.x / 8.1f - 0.05864197f) / (paintElement.scale * 2.55f) - (pageOn.isOnLeftSide() ? 0.0f : 0.0072621643f), (paintElement.y / 8.1f - 0.12345678f) / (paintElement.scale * 2.55f), -(zLevel + paintElement.z) / 1600.0f);
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                RenderSystem.setShader(GameRenderer::getRendertypeEntityCutoutNoCullShader);
                AtomicReference<Integer> width = new AtomicReference<Integer>((int)paintElement.width);
                AtomicReference<Integer> height = new AtomicReference<Integer>((int)paintElement.height);
                Matrix4f matrix = poseStack.last().pose();
                PoseStack.Pose normal = poseStack.last();
                float u1 = 0.0f;
                float u2 = 1.0f;
                float v1 = 0.0f;
                float v2 = 1.0f;
                float a = 1.0f;
                float r = 1.0f;
                float g = 1.0f;
                float b = 1.0f;
                if (color != -1) {
                    a = (float)(color >> 24 & 0xFF) / 255.0f;
                    r = (float)(color >> 16 & 0xFF) / 255.0f;
                    g = (float)(color >> 8 & 0xFF) / 255.0f;
                    b = (float)(color & 0xFF) / 255.0f;
                }
                VertexConsumer buffer = (Boolean)HexConfig.BOOK_SHADERS_TOGGLE.get() != false ? bufferSource.getBuffer(ModRenderTypes.bookTranslucent(paintSystem.getImageLocation())) : bufferSource.getBuffer(ModRenderTypes.entityTranslucent((ResourceLocation)paintSystem.getImageLocation()));
                buffer.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(r, g, b, a).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
                buffer.addVertex(matrix, 0.0f, 0.006111111f * (float)height.get().intValue(), 0.0f).setColor(r, g, b, a).setUv(u1, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
                buffer.addVertex(matrix, 0.0f, 0.006111111f * (float)height.get().intValue(), 0.006111111f * (float)width.get().intValue()).setColor(r, g, b, a).setUv(u2, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
                buffer.addVertex(matrix, 0.0f, 0.0f, 0.006111111f * (float)width.get().intValue()).setColor(r, g, b, a).setUv(u2, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
                if (bufferSource instanceof MultiBufferSource.BufferSource) {
                    MultiBufferSource.BufferSource multiBufferSource = (MultiBufferSource.BufferSource)bufferSource;
                    multiBufferSource.endBatch();
                }
                poseStack.popPose();
                if (pageOn != PageOn.LEFT_PAGE) break block37;
                float w = paintElement.width / 326.0f * 2.55f * paintElement.scale / 0.062f;
                float h = paintElement.height / 326.0f * 2.55f * paintElement.scale / 0.062f;
                float x = paintElement.x + 0.025f;
                float y = paintElement.y - 0.5f;
                if (paintSystem.toolsVisible && PageDrawing.canInteract(cursorX, cursorY, x - paintElement.width * paintElement.scale * 0.24f, y - paintElement.height * paintElement.scale * 0.24f, w + paintElement.width * paintElement.scale * 0.24f * 2.0f, h + paintElement.height * paintElement.scale * 0.24f * 2.0f, altarTile, drawingType)) {
                    float xPixel = (cursorX - x) / w * paintElement.width;
                    float yPixel = (cursorY - y) / h * paintElement.height;
                    paintSystem.hover(xPixel, yPixel);
                }
                this.drawPaintColors(paintSystem, altarTile, cursorX, cursorY, altarTile.buttonScaleRender * paintSystem.getColorsVisibility(partial), poseStack, bufferSource, 0.0f, light, overlay, pageOn, drawingType, ItemDisplayContext.NONE, partial);
                for (PaintSystem.ValueSlider slider : paintSystem.getValueSliders().getSliders()) {
                    if (!slider.shouldRender(paintSystem)) continue;
                    if (slider.isDragging() && slider.isVisible(paintSystem)) {
                        slider.updateValue(cursorX, cursorY, pageOn);
                    }
                    this.drawPaintColorSlider(slider.isHorizontal() ? 0.0f : slider.width / 326.0f * 5.0f * 4.1f, slider, altarTile, cursorX, cursorY, altarTile.buttonScaleRender * slider.getVisibility(partial), poseStack, bufferSource, 0.0f, light, overlay, pageOn, slider.getSliderColor(paintSystem), drawingType, ItemDisplayContext.NONE, partial);
                    this.drawPaintColorSliderBar(1.0f, slider, altarTile, cursorX, cursorY, altarTile.buttonScaleRender * slider.getVisibility(partial), poseStack, bufferSource, -0.1f, light, overlay, pageOn, slider.getColor1(paintSystem), slider.getColor2(paintSystem), drawingType, ItemDisplayContext.NONE, slider.isSpecialHueSlider(), partial);
                    w = slider.width / 326.0f * 2.55f / 0.062f;
                    h = slider.height / 326.0f * 2.55f / 0.062f;
                    x = slider.getX(pageOn) + 0.025f;
                    y = slider.getY(pageOn) - 0.5f - h / 2.0f;
                    if (!slider.isVisible(paintSystem) || !slider.isDragging() && !PageDrawing.canInteract(cursorX, cursorY, x, y, w, h, altarTile, drawingType)) continue;
                    slider.setHovering();
                    ArrayList<Component> tooltipList = new ArrayList<Component>();
                    tooltipList.add(slider.getTooltip(paintSystem));
                    this.tooltipText = tooltipList;
                    this.drawTooltipText = true;
                    this.tooltipStack = ItemStack.EMPTY;
                }
                ArrayList<BookImageEffect> effects = new ArrayList<BookImageEffect>(List.of(new BookImageEffect("scale", 50.0f, 1.25f), new BookImageEffect("tilt", 35.0f, 10.0f)));
                for (PaintSystem.Button button : paintSystem.buttons) {
                    if (!button.shouldRender(paintSystem) || !button.selected.apply(paintSystem).booleanValue()) continue;
                    BookImage selectedTool = new BookImage(button.getX(paintSystem, pageOn, partial), button.getY(paintSystem, pageOn, partial), 0.0f, 0.0f, 0.0f, button.width, button.height, button.width, button.height, Math.max(0.0f, button.getScale(altarTile.buttonScaleRender) * button.getVisibility(partial)), "hexerei:textures/book/paint_tools/tool_selected.png", new ArrayList<BookImageEffect>());
                    this.drawImage(selectedTool, altarTile, cursorX, cursorY, poseStack, bufferSource, 0.0f, light, overlay, pageOn, drawingType);
                }
                for (PaintSystem.Button button : paintSystem.buttons) {
                    if (!button.shouldRender(paintSystem)) continue;
                    boolean disabled = button.getDisabled(paintSystem);
                    BookImage image = new BookImage(button.getX(paintSystem, pageOn, partial), button.getY(paintSystem, pageOn, partial), 0.0f, 0.0f, 0.0f, button.width, button.height, button.width, button.height, Math.max(0.0f, button.getScale(altarTile.buttonScaleRender) * button.getVisibility(partial)), disabled ? button.getDisabledTexture(paintSystem) : button.getTexture(paintSystem), new ArrayList<BookImageEffect>());
                    BookImage imageHover = new BookImage(button.getX(paintSystem, pageOn, partial), button.getY(paintSystem, pageOn, partial), 0.0f, 0.0f, 0.0f, button.width, button.height, button.width, button.height, Math.max(0.0f, button.getScale(altarTile.buttonScaleRender) * button.getVisibility(partial)), button.getHoverTexture(paintSystem), effects);
                    boolean drawHover = false;
                    w = image.width / 330.0f * image.scale / 0.062f;
                    h = image.height / 330.0f * image.scale / 0.062f;
                    x = image.x - w / 2.0f + 0.455f;
                    y = image.y - h / 2.0f + 0.49f;
                    if (button.clickedScale != 1.0f) {
                        drawHover = true;
                    }
                    if (button.isVisible(paintSystem) && PageDrawing.canInteract(cursorX, cursorY, x, y, w, h, altarTile, drawingType)) {
                        drawHover = true;
                        if (!button.getTooltipList().isEmpty()) {
                            this.tooltipText = button.getTooltipList();
                            this.drawTooltipText = true;
                            this.tooltipStack = ItemStack.EMPTY;
                        }
                    }
                    if (drawHover && !disabled) {
                        this.drawImage(imageHover, altarTile, cursorX, cursorY, poseStack, bufferSource, 0.1f, light, overlay, pageOn, -1, drawingType, ItemDisplayContext.NONE, true);
                        continue;
                    }
                    this.drawImage(image, altarTile, cursorX, cursorY, poseStack, bufferSource, 0.1f, light, overlay, pageOn, -1, drawingType, ItemDisplayContext.NONE, true);
                }
                break block38;
            }
            if (pageOn != PageOn.RIGHT_PAGE) break block38;
            float w = paintElement.width / 326.0f * 2.55f * paintElement.scale / 0.062f;
            float h = paintElement.height / 326.0f * 2.55f * paintElement.scale / 0.062f;
            float x = paintElement.x + 0.025f;
            float y = paintElement.y - 0.5f;
            if (paintSystem.toolsVisible && PageDrawing.canInteract(cursorX + (pageOn.isOnLeftSide() ? 0.0f : 0.22f), cursorY, x - paintElement.width * paintElement.scale * 0.24f, y - paintElement.height * paintElement.scale * 0.24f, w + paintElement.width * paintElement.scale * 0.24f * 2.0f, h + paintElement.height * paintElement.scale * 0.24f * 2.0f, altarTile, drawingType)) {
                float xPixel = (cursorX - x) / w * paintElement.width + (pageOn.isOnLeftSide() ? 0.0f : 1.8f);
                float yPixel = (cursorY - y) / h * paintElement.height;
                paintSystem.hover(xPixel, yPixel);
            }
            this.drawPaintColors(paintSystem, altarTile, cursorX, cursorY, altarTile.buttonScaleRender * paintSystem.getColorsVisibility(partial), poseStack, bufferSource, 0.0f, light, overlay, pageOn, drawingType, ItemDisplayContext.NONE, partial);
            for (PaintSystem.ValueSlider slider : paintSystem.getValueSliders().getSliders()) {
                if (!slider.shouldRender(paintSystem)) continue;
                if (slider.isDragging() && slider.isVisible(paintSystem)) {
                    slider.updateValue(cursorX, cursorY, pageOn);
                }
                this.drawPaintColorSlider(slider.isHorizontal() ? 0.0f : slider.width / 326.0f * 5.0f * 4.1f, slider, altarTile, cursorX, cursorY, altarTile.buttonScaleRender * slider.getVisibility(partial), poseStack, bufferSource, 0.0f, light, overlay, pageOn, slider.getSliderColor(paintSystem), drawingType, ItemDisplayContext.NONE, partial);
                this.drawPaintColorSliderBar(1.0f, slider, altarTile, cursorX, cursorY, altarTile.buttonScaleRender * slider.getVisibility(partial), poseStack, bufferSource, -0.1f, light, overlay, pageOn, slider.getColor1(paintSystem), slider.getColor2(paintSystem), drawingType, ItemDisplayContext.NONE, slider.isSpecialHueSlider(), partial);
                w = slider.width / 326.0f * 2.55f / 0.062f;
                h = slider.height / 326.0f * 2.55f / 0.062f;
                x = slider.getX(pageOn) + 0.025f - (pageOn.isOnLeftSide() ? 0.0f : 0.09f);
                y = slider.getY(pageOn) - 0.5f - h / 2.0f;
                if (!slider.isVisible(paintSystem) || !slider.isDragging() && !PageDrawing.canInteract(cursorX, cursorY, x, y, w, h, altarTile, drawingType)) continue;
                slider.setHovering();
                ArrayList<Component> tooltipList = new ArrayList<Component>();
                tooltipList.add(slider.getTooltip(paintSystem));
                this.tooltipText = tooltipList;
                this.drawTooltipText = true;
                this.tooltipStack = ItemStack.EMPTY;
            }
            ArrayList<BookImageEffect> effects = new ArrayList<BookImageEffect>(List.of(new BookImageEffect("scale", 50.0f, 1.25f), new BookImageEffect("tilt", 35.0f, 10.0f)));
            for (PaintSystem.Button button : paintSystem.buttons) {
                if (!button.shouldRender(paintSystem) || !button.selected.apply(paintSystem).booleanValue()) continue;
                BookImage selectedTool = new BookImage(button.getX(paintSystem, pageOn, partial), button.getY(paintSystem, pageOn, partial), 0.0f, 0.0f, 0.0f, button.width, button.height, button.width, button.height, Math.max(0.0f, button.getScale(altarTile.buttonScaleRender) * button.getVisibility(partial)), "hexerei:textures/book/paint_tools/tool_selected.png", new ArrayList<BookImageEffect>());
                this.drawImage(selectedTool, altarTile, cursorX, cursorY, poseStack, bufferSource, 0.0f, light, overlay, pageOn, drawingType);
            }
            for (PaintSystem.Button button : paintSystem.buttons) {
                if (!button.shouldRender(paintSystem)) continue;
                boolean disabled = button.getDisabled(paintSystem);
                BookImage image = new BookImage(button.getX(paintSystem, pageOn, partial), button.getY(paintSystem, pageOn, partial), 0.0f, 0.0f, 0.0f, button.width, button.height, button.width, button.height, Math.max(0.0f, button.getScale(altarTile.buttonScaleRender) * button.getVisibility(partial)), disabled ? button.getDisabledTexture(paintSystem) : button.getTexture(paintSystem), new ArrayList<BookImageEffect>());
                BookImage imageHover = new BookImage(button.getX(paintSystem, pageOn, partial), button.getY(paintSystem, pageOn, partial), 0.0f, 0.0f, 0.0f, button.width, button.height, button.width, button.height, Math.max(0.0f, button.getScale(altarTile.buttonScaleRender) * button.getVisibility(partial)), button.getHoverTexture(paintSystem), effects);
                boolean drawHover = false;
                w = image.width / 330.0f * image.scale / 0.062f;
                h = image.height / 330.0f * image.scale / 0.062f;
                x = image.x - w / 2.0f + 0.455f;
                y = image.y - h / 2.0f + 0.49f;
                if (button.clickedScale != 1.0f) {
                    drawHover = true;
                }
                if (button.isVisible(paintSystem) && PageDrawing.canInteract(cursorX, cursorY, x, y, w, h, altarTile, drawingType)) {
                    drawHover = true;
                    if (!button.getTooltipList().isEmpty()) {
                        this.tooltipText = button.getTooltipList();
                        this.drawTooltipText = true;
                        this.tooltipStack = ItemStack.EMPTY;
                    }
                }
                if (drawHover && !disabled) {
                    this.drawImage(imageHover, altarTile, cursorX, cursorY, poseStack, bufferSource, 0.1f, light, overlay, pageOn, -1, drawingType, ItemDisplayContext.NONE, true);
                    continue;
                }
                this.drawImage(image, altarTile, cursorX, cursorY, poseStack, bufferSource, 0.1f, light, overlay, pageOn, -1, drawingType, ItemDisplayContext.NONE, true);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawBasePage(BookImage bookImage, BookOfShadowsAltarTile altarTile, float leftCursorX, float leftCursorY, float rightCursorX, float rightCursorY, PoseStack poseStack, MultiBufferSource bufferSource, float zLevel, int light, int overlay, PageOn pageOn, int color, DrawingType drawingType, ItemDisplayContext transformType) {
        poseStack.pushPose();
        if (pageOn == PageOn.LEFT_PAGE) {
            PageDrawing.translateToLeftPage(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.LEFT_PAGE_UNDER) {
            PageDrawing.translateToLeftPageUnder(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV) {
            PageDrawing.translateToLeftPagePrevious(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV_PREV) {
            PageDrawing.translateToLeftPagePrevious2(altarTile, poseStack, drawingType, transformType);
        }
        if (pageOn == PageOn.RIGHT_PAGE) {
            PageDrawing.translateToRightPage(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.RIGHT_PAGE_UNDER) {
            PageDrawing.translateToRightPageUnder(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV) {
            PageDrawing.translateToRightPagePrevious(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV_PREV) {
            PageDrawing.translateToRightPagePrevious2(altarTile, poseStack, drawingType, transformType);
        } else if (pageOn == PageOn.MIDDLE_BUTTON) {
            this.translateToMiddleButton(altarTile, poseStack, drawingType, transformType);
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        poseStack.translate(-0.5f, 0.34375f, -7.5E-4f);
        poseStack.scale(0.5f * bookImage.scale, 0.5f * bookImage.scale, 0.5f * bookImage.scale);
        poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
        poseStack.translate((bookImage.x / 8.1f - 0.001875f) / bookImage.scale, (bookImage.y / 8.1f - 0.0033125f) / bookImage.scale, -(zLevel + bookImage.z) / 1600.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        RenderSystem.setShader(GameRenderer::getRendertypeEntityCutoutNoCullShader);
        AtomicReference<String> loc = new AtomicReference<String>(bookImage.texture);
        AtomicReference<BookImage> overlay_image = new AtomicReference<BookImage>(bookImage);
        AtomicReference<Boolean> overlay_draw = new AtomicReference<Boolean>(false);
        int u = (int)bookImage.u;
        int v = (int)bookImage.v;
        int imageWidth = (int)bookImage.imageWidth;
        int imageHeight = (int)bookImage.imageHeight;
        int width = (int)bookImage.width;
        int height = (int)bookImage.height;
        Matrix4f matrix = poseStack.last().pose();
        PoseStack.Pose normal = poseStack.last();
        float u1 = 0.0f;
        float u2 = (float)imageWidth / (float)Mth.abs((int)imageWidth);
        float v1 = 0.0f;
        float v2 = (float)imageHeight / (float)Mth.abs((int)imageHeight);
        float a = 1.0f;
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        if (color != -1) {
            a = (float)(color >> 24 & 0xFF) / 255.0f;
            r = (float)(color >> 16 & 0xFF) / 255.0f;
            g = (float)(color >> 8 & 0xFF) / 255.0f;
            b = (float)(color & 0xFF) / 255.0f;
        }
        VertexConsumer buffer = a != 1.0f ? bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)ResourceLocation.parse((String)loc.get()))) : bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)ResourceLocation.parse((String)loc.get())));
        if (((Boolean)HexConfig.BOOK_SHADERS_TOGGLE.get()).booleanValue()) {
            buffer = bufferSource.getBuffer(ModRenderTypes.bookTranslucent(ResourceLocation.parse((String)loc.get())));
        }
        buffer.addVertex(matrix, 0.0f, -0.0030555555f * (float)height, -0.0030555555f * (float)width).setColor(r, g, b, a).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 0.0f, 0.0030555555f * (float)height, -0.0030555555f * (float)width).setColor(r, g, b, a).setUv(u1, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 0.0f, 0.0030555555f * (float)height, 0.0030555555f * (float)width).setColor(r, g, b, a).setUv(u2, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 0.0f, -0.0030555555f * (float)height, 0.0030555555f * (float)width).setColor(r, g, b, a).setUv(u2, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        if (bufferSource instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource multiBufferSource = (MultiBufferSource.BufferSource)bufferSource;
            multiBufferSource.endBatch();
        }
        if (overlay_draw.get().booleanValue()) {
            BookImage ov_img = overlay_image.get();
            VertexConsumer buffer2 = bufferSource.getBuffer(ModRenderTypes.bookTranslucent(ResourceLocation.parse((String)ov_img.texture)));
            float overlay_u1 = (ov_img.u + 0.0f) / ov_img.imageWidth;
            float overlay_u2 = (ov_img.u + ov_img.width) / ov_img.imageWidth;
            float overlay_v1 = (ov_img.v + 0.0f) / ov_img.imageHeight;
            float overlay_v2 = (ov_img.v + ov_img.height) / ov_img.imageHeight;
            float overlay_a = 1.0f;
            float overlay_r = 1.0f;
            float overlay_g = 1.0f;
            float overlay_b = 1.0f;
            if (color != -1) {
                overlay_r = (float)(color >> 16 & 0xFF) / 255.0f;
                overlay_g = (float)(color >> 8 & 0xFF) / 255.0f;
                overlay_b = (float)(color & 0xFF) / 255.0f;
            }
            poseStack.pushPose();
            buffer2.addVertex(matrix, ov_img.z / 2000.0f, -0.0030555555f * ov_img.height, -0.0030555555f * ov_img.width).setColor(overlay_r, overlay_g, overlay_b, overlay_a).setUv(overlay_u1, overlay_v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer2.addVertex(matrix, ov_img.z / 2000.0f, 0.0030555555f * ov_img.height, -0.0030555555f * ov_img.width).setColor(overlay_r, overlay_g, overlay_b, overlay_a).setUv(overlay_u1, overlay_v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer2.addVertex(matrix, ov_img.z / 2000.0f, 0.0030555555f * ov_img.height, 0.0030555555f * ov_img.width).setColor(overlay_r, overlay_g, overlay_b, overlay_a).setUv(overlay_u2, overlay_v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            buffer2.addVertex(matrix, ov_img.z / 2000.0f, -0.0030555555f * ov_img.height, 0.0030555555f * ov_img.width).setColor(overlay_r, overlay_g, overlay_b, overlay_a).setUv(overlay_u2, overlay_v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
            poseStack.popPose();
            if (bufferSource instanceof MultiBufferSource.BufferSource) {
                MultiBufferSource.BufferSource multiBufferSource = (MultiBufferSource.BufferSource)bufferSource;
                multiBufferSource.endBatch();
            }
        }
        poseStack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawTitle(BookOfShadowsAltarTile altarTile, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, PageOn pageOn, DrawingType drawingType) {
        poseStack.pushPose();
        if (pageOn == PageOn.LEFT_PAGE) {
            PageDrawing.translateToLeftPage(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_UNDER) {
            PageDrawing.translateToLeftPageUnder(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV) {
            PageDrawing.translateToLeftPagePrevious(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        }
        if (pageOn == PageOn.RIGHT_PAGE) {
            PageDrawing.translateToRightPage(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_UNDER) {
            PageDrawing.translateToRightPageUnder(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV) {
            PageDrawing.translateToRightPagePrevious(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        poseStack.translate(-0.5f, 0.34375f, -7.5E-4f);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
        poseStack.translate(-0.001875f, -0.0033125f, 0.0f);
        poseStack.translate(0.296875f, 0.0f, 0.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        RenderSystem.setShader(GameRenderer::getRendertypeEntityCutoutNoCullShader);
        Matrix4f matrix = poseStack.last().pose();
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)ResourceLocation.parse((String)"hexerei:textures/book/title.png")));
        PoseStack.Pose normal = poseStack.last();
        boolean u = false;
        boolean v = false;
        int imageWidth = 128;
        int imageHeight = 128;
        int width = 100;
        int height = 26;
        float u1 = ((float)u + 0.0f) / (float)imageWidth;
        float u2 = ((float)u + (float)width) / (float)imageWidth;
        float v1 = ((float)v + 0.0f) / (float)imageHeight;
        float v2 = ((float)v + (float)height) / (float)imageHeight;
        buffer.addVertex(matrix, 0.0f, -0.0030555555f * (float)height, -0.0030555555f * (float)width).setColor(255, 255, 255, 255).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 0.0f, 0.0030555555f * (float)height, -0.0030555555f * (float)width).setColor(255, 255, 255, 255).setUv(u1, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 0.0f, 0.0030555555f * (float)height, 0.0030555555f * (float)width).setColor(255, 255, 255, 255).setUv(u2, v2).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, 0.0f, -0.0030555555f * (float)height, 0.0030555555f * (float)width).setColor(255, 255, 255, 255).setUv(u2, v1).setOverlay(overlay).setLight(light).setNormal(normal, 1.0f, 0.0f, 0.0f);
        poseStack.popPose();
    }

    public void resetLines() {
        this.lineWidth = 0.0f;
        this.lineHeight = 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BookParagraphElements resetLinesNewBox(List<BookParagraphElements> elements, int boxOn) {
        this.lineWidth = 0.0f;
        this.lineHeight = 0.0f;
        if (boxOn + 1 < elements.size()) {
            return elements.get(boxOn + 1);
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawString(BookParagraph bookParagraph, BookOfShadowsAltarTile altarTile, PoseStack poseStack, MultiBufferSource bufferSource, float mouseX, float mouseY, float zLevel, int light, int overlay, PageOn pageOn, DrawingType drawingType) {
        if (bookParagraph.paragraphElements.isEmpty()) {
            return;
        }
        MutableComponent pageText = bookParagraph.translatablePassage;
        int wordNumber = -1;
        int boxOn = 0;
        BookParagraphElements activeElement = bookParagraph.paragraphElements.getFirst();
        Font font = ClientProxy.font();
        boolean findNewWord = true;
        String[] words = pageText.getString().trim().split("(\\s+)");
        String pageTextString = pageText.getString();
        int itor = -1;
        for (String word : words) {
            ++itor;
            if (word.length() <= 2 || word.charAt(0) != '%' || word.charAt(1) != 'k') continue;
            String temp = word.substring(2);
            String[] temp2 = temp.split("%");
            temp = temp2[0];
            String alt = "key." + temp;
            for (KeyMapping k : ClientProxy.keys) {
                String name = k.getName();
                if (!name.equals(temp) && !name.equals(alt)) continue;
                String keyName = k.getTranslatedKeyMessage().getString();
                if (keyName.length() <= 1) {
                    keyName = keyName.toUpperCase(Locale.ROOT);
                }
                words[itor] = keyName + (temp2.length > 1 ? temp2[1] : "");
                pageTextString = pageTextString.replaceAll(word, words[itor]);
            }
        }
        ArrayList<Object> combinedList = new ArrayList<Object>();
        for (int i = 0; i < words.length; ++i) {
            if (words[i].equals(",") && i != 0) {
                combinedList.set(combinedList.size() - 1, (String)combinedList.getLast() + words[i]);
                continue;
            }
            combinedList.add(words[i]);
        }
        words = combinedList.toArray(new String[0]);
        char[] text = pageTextString.toCharArray();
        int[] wordLength = new int[words.length];
        float[] wordWidths = new float[words.length];
        for (int k = 0; k < words.length; ++k) {
            wordLength[k] = words[k].length();
            wordWidths[k] = font.width(words[k]);
        }
        boolean breakBool = false;
        ArrayList<String> strings = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        while (i < text.length && !breakBool) {
            if (text[i] == '\n') {
                this.lineWidth = 0.0f;
                this.lineHeight += 1.0f;
                strings.add(stringBuilder.toString());
                stringBuilder = new StringBuilder();
                if (this.lineHeight >= activeElement.height && (activeElement = this.resetLinesNewBox(bookParagraph.paragraphElements, boxOn++)) == null) {
                    breakBool = true;
                    break;
                }
                ++i;
                continue;
            }
            if (text[i] == ' ') {
                findNewWord = true;
                stringBuilder.append(' ');
                this.lineWidth += (float)font.width(" ");
                if (this.lineWidth > activeElement.width * 3.75f) {
                    this.lineWidth = 0.0f;
                    this.lineHeight += 1.0f;
                    strings.add(stringBuilder.toString());
                    stringBuilder = new StringBuilder();
                    if (this.lineHeight >= activeElement.height && (activeElement = this.resetLinesNewBox(bookParagraph.paragraphElements, boxOn++)) == null) {
                        breakBool = true;
                        break;
                    }
                }
                ++i;
                continue;
            }
            if (!findNewWord) continue;
            char[] wordText = words[++wordNumber].toCharArray();
            if (this.lineWidth > 0.0f && this.lineWidth + wordWidths[wordNumber] > activeElement.width * 3.75f) {
                this.lineWidth = 0.0f;
                this.lineHeight += 1.0f;
                strings.add(stringBuilder.toString());
                stringBuilder = new StringBuilder();
                if (this.lineHeight >= activeElement.height && (activeElement = this.resetLinesNewBox(bookParagraph.paragraphElements, boxOn++)) == null) {
                    breakBool = true;
                    break;
                }
            }
            for (char character : wordText) {
                stringBuilder.append(character);
                this.lineWidth += (float)font.width(String.valueOf(character));
                if (!(this.lineWidth > activeElement.width * 3.75f)) continue;
                this.lineWidth = 0.0f;
                this.lineHeight += 1.0f;
                strings.add(stringBuilder.toString());
                stringBuilder = new StringBuilder();
                if (!(this.lineHeight >= activeElement.height) || (activeElement = this.resetLinesNewBox(bookParagraph.paragraphElements, boxOn++)) != null) continue;
                breakBool = true;
                break;
            }
            i += wordLength[wordNumber];
        }
        if (!stringBuilder.toString().isEmpty()) {
            strings.add(stringBuilder.toString());
        }
        poseStack.pushPose();
        if (pageOn == PageOn.LEFT_PAGE) {
            PageDrawing.translateToLeftPage(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_UNDER) {
            PageDrawing.translateToLeftPageUnder(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV) {
            PageDrawing.translateToLeftPagePrevious(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        }
        if (pageOn == PageOn.RIGHT_PAGE) {
            PageDrawing.translateToRightPage(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_UNDER) {
            PageDrawing.translateToRightPageUnder(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV) {
            PageDrawing.translateToRightPagePrevious(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        poseStack.translate(-0.521875f, 0.28125f, -6.25E-4f);
        poseStack.scale(0.00272f, 0.00272f, 0.00272f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        int boxId = 0;
        int linenumber = 0;
        boolean flag = true;
        while (flag) {
            ArrayList<String> remainder = new ArrayList<String>();
            if (bookParagraph.paragraphElements.size() > boxId && bookParagraph.paragraphElements.get(boxId) != null) {
                BookParagraphElements box = bookParagraph.paragraphElements.get(boxId);
                boolean alignVerticalMiddle = box.verticalAlign.equals("middle");
                float offsetY = 0.0f;
                if (alignVerticalMiddle) {
                    float f = box.height;
                    Objects.requireNonNull(font);
                    if (Math.round(f * 9.0f) + 1 > strings.size()) {
                        float f2 = box.height;
                        Objects.requireNonNull(font);
                        float f3 = f2 * 9.0f / 2.0f;
                        float f4 = (float)strings.size() / 2.0f;
                        Objects.requireNonNull(font);
                        offsetY = f3 - f4 * 9.0f;
                    }
                }
                for (String s1 : strings) {
                    Objects.requireNonNull(font);
                    float f = box.height;
                    Objects.requireNonNull(font);
                    if ((linenumber + 1) * 9 <= Math.round(f * 9.0f) + 1) {
                        float offsetX = 0.0f;
                        if (bookParagraph.align.equals("middle")) {
                            offsetX = font.width(s1) / 2;
                        }
                        MutableComponent component = Component.literal((String)s1);
                        if (ClientProxy.fontId() != null) {
                            component = component.withStyle(Style.EMPTY.withFont(ClientProxy.fontId()));
                        }
                        Font font2 = Minecraft.getInstance().font;
                        float f5 = box.x * 8.0f - 24.0f - offsetX;
                        float f6 = box.y;
                        Objects.requireNonNull(font);
                        float f7 = f6 * 9.0f;
                        Objects.requireNonNull(font);
                        font2.drawInBatch((Component)component, f5, f7 + (float)(linenumber * 9) - 4.0f + offsetY, HexereiUtil.getColorValue(0.12f, 0.12f, 0.12f), false, poseStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, light);
                        poseStack.pushPose();
                        poseStack.translate(0.25f, 0.25f, 0.0625f);
                        Font font3 = Minecraft.getInstance().font;
                        float f8 = box.x * 8.0f - 24.0f - offsetX;
                        float f9 = box.y;
                        Objects.requireNonNull(font);
                        float f10 = f9 * 9.0f;
                        Objects.requireNonNull(font);
                        font3.drawInBatch((Component)component, f8, f10 + (float)(linenumber * 9) - 4.0f + offsetY, 0x1000000, false, poseStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, light);
                        poseStack.popPose();
                    } else {
                        remainder.add(s1);
                    }
                    ++linenumber;
                }
            } else {
                flag = false;
            }
            if (remainder.isEmpty()) {
                flag = false;
                continue;
            }
            ++boxId;
            linenumber = 0;
            strings = remainder;
        }
        buffer.endBatch();
        poseStack.popPose();
        this.resetLines();
    }

    private void renderHighlight(Rect2i[] highlightAreas, PoseStack poseStack, MultiBufferSource bufferSource, int overlay, int light, float xOffset, float yOffset) {
        for (Rect2i rect2i : highlightAreas) {
            float[] col = HexereiUtil.rgbaIntToFloatArray(-16776961);
            PageDrawing.fill(RenderType.guiTextHighlight(), poseStack, bufferSource, (float)rect2i.getX() + xOffset, (float)rect2i.getY() + yOffset, 0.0f, rect2i.getWidth(), rect2i.getHeight(), (int)(col[0] * 255.0f), (int)(col[1] * 255.0f), (int)(col[2] * 255.0f), (int)(col[3] * 255.0f), overlay, light);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawString(BookWritableTextBox bookWritableTextBox, BookOfShadowsAltarTile altarTile, PoseStack poseStack, MultiBufferSource bufferSource, float xCursor, float yCursor, float zLevel, int light, int overlay, PageOn pageOn, DrawingType drawingType) {
        if (bookWritableTextBox.client == null) {
            bookWritableTextBox.client = new BookWritableTextBox.Client(bookWritableTextBox);
            return;
        }
        BookWritableTextBox.Client.DisplayCache displaycache = bookWritableTextBox.client.getDisplayCache(altarTile.currentBook);
        Font font = ClientProxy.font();
        poseStack.pushPose();
        if (pageOn == PageOn.LEFT_PAGE) {
            PageDrawing.translateToLeftPage(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_UNDER) {
            PageDrawing.translateToLeftPageUnder(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.LEFT_PAGE_PREV) {
            PageDrawing.translateToLeftPagePrevious(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        }
        if (pageOn == PageOn.RIGHT_PAGE) {
            PageDrawing.translateToRightPage(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_UNDER) {
            PageDrawing.translateToRightPageUnder(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        } else if (pageOn == PageOn.RIGHT_PAGE_PREV) {
            PageDrawing.translateToRightPagePrevious(altarTile, poseStack, drawingType, ItemDisplayContext.NONE);
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        poseStack.translate(-0.521875f, 0.28125f, -6.25E-4f);
        poseStack.scale(0.00272f, 0.00272f, 0.00272f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        int linenumber = 0;
        BookParagraphElements box = bookWritableTextBox.paragraphElement;
        float offsetY = 0.0f;
        for (BookWritableTextBox.Client.LineInfo line : displaycache.lines) {
            Objects.requireNonNull(font);
            float f = box.height;
            Objects.requireNonNull(font);
            if ((linenumber + 1) * 9 <= Math.round(f * 9.0f) + 1) {
                float offsetX = 0.0f;
                Component component = ClientProxy.fontId() != null ? Component.literal((String)"").append(line.asComponent).withStyle(Style.EMPTY.withFont(ClientProxy.fontId())) : line.asComponent;
                float f2 = box.x * 8.0f - 24.0f - offsetX;
                float f3 = box.y;
                Objects.requireNonNull(font);
                float f4 = f3 * 9.0f;
                Objects.requireNonNull(font);
                font.drawInBatch(component, f2, f4 + (float)(linenumber * 9) - 4.0f + offsetY, HexereiUtil.getColorValue(0.12f, 0.12f, 0.12f), false, poseStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, light);
                poseStack.pushPose();
                poseStack.translate(0.25f, 0.25f, 0.0625f);
                float f5 = box.x * 8.0f - 24.0f - offsetX;
                float f6 = box.y;
                Objects.requireNonNull(font);
                float f7 = f6 * 9.0f;
                Objects.requireNonNull(font);
                font.drawInBatch(component, f5, f7 + (float)(linenumber * 9) - 4.0f + offsetY, 0x1000000, false, poseStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, light);
                poseStack.popPose();
            }
            ++linenumber;
        }
        if (focusedWritableTextBox != null && focusedWritableTextBox.getRight() == bookWritableTextBox && altarTile == focusedWritableTextBox.getLeft()) {
            if ((int)ClientEvents.getClientTicks() / 6 % 3 == 0 || (int)ClientEvents.getClientTicks() / 6 % 3 == 1) {
                RenderType renderType = RenderType.entityCutout((ResourceLocation)ResourceLocation.parse((String)"hexerei:textures/book/pencil_cursor.png"));
                float f = box.x * 8.0f - 24.0f + (float)displaycache.cursor.x;
                float f8 = box.y;
                Objects.requireNonNull(font);
                PageDrawing.fill(renderType, poseStack, bufferSource, f, f8 * 9.0f - 5.0f + (float)displaycache.cursor.y, -1.0f, 9.0f, 9.0f, 255, 255, 255, 255, overlay, light);
            }
            Rect2i[] rect2iArray = displaycache.selection;
            float f = box.x * 8.0f - 92.0f;
            float f9 = box.y;
            Objects.requireNonNull(font);
            this.renderHighlight(rect2iArray, poseStack, bufferSource, overlay, light, f, f9 * 9.0f - 36.0f);
        } else if (PageDrawing.canInteract(xCursor, yCursor, bookWritableTextBox.paragraphElement.x + 0.45f, bookWritableTextBox.paragraphElement.y, bookWritableTextBox.paragraphElement.width / 6.15f, bookWritableTextBox.paragraphElement.height / 2.57f, altarTile, drawingType)) {
            BookWritableTextBox.Client.Pos2i pos2i = new BookWritableTextBox.Client.Pos2i((int)((xCursor - bookWritableTextBox.paragraphElement.x - 0.45f) / 5.0f * 115.0f), (int)((yCursor - bookWritableTextBox.paragraphElement.y) / 7.1f * 162.0f));
            int i = displaycache.getIndexAtPosition(ClientProxy.font(), pos2i);
            pos2i = bookWritableTextBox.client.getCursorPosOf(i, altarTile.currentBook);
            RenderType renderType = RenderType.entityCutout((ResourceLocation)ResourceLocation.parse((String)"hexerei:textures/book/pencil_cursor.png"));
            float f = box.x * 8.0f - 24.0f + (float)pos2i.x;
            float f10 = box.y;
            Objects.requireNonNull(font);
            PageDrawing.fill(renderType, poseStack, bufferSource, f, f10 * 9.0f - 5.0f + (float)pos2i.y, -1.0f, 9.0f, 9.0f, 255, 255, 255, 255, overlay, light);
        }
        buffer.endBatch();
        poseStack.popPose();
        this.resetLines();
    }

    static {
        pageTextureLocs = new ArrayList();
        overlayTextureLocs = new ArrayList();
        focusedWritableTextBox = null;
        focusedWritableTextBoxLast = null;
        nf = NumberFormat.getIntegerInstance();
        CORNERS = (float)MixingCauldron.SHAPE.min(Direction.Axis.X) + 0.1875f;
        ITEM_LIGHT_ROTATION_3D = (Quaternionf)Util.make(() -> {
            Quaternionf quaternion = new Quaternionf();
            quaternion.setAngleAxis(1.1344640137963142, 1.0, 0.0, 0.0);
            quaternion.rotateAxis(0.87266463f, 0.0f, 1.0f, 0.0f);
            return quaternion;
        });
        BLOCK_LIGHT_ROTATION_3D = (Quaternionf)Util.make(() -> {
            Quaternionf quaternion = new Quaternionf();
            quaternion.setAngleAxis(0.6108652381980153, 1.0, 0.0, 0.0);
            quaternion.rotateAxis(0.61086524f, 0.0f, 1.0f, 0.0f);
            return quaternion;
        });
        ITEM_LIGHT_ROTATION_FLAT = (Quaternionf)Util.make(() -> {
            Quaternionf quaternion = new Quaternionf();
            quaternion.setAngleAxis(-0.7853981633974483, 1.0, 0.0, 0.0);
            return quaternion;
        });
    }

    public static enum PageOn {
        LEFT_PAGE,
        LEFT_PAGE_UNDER,
        LEFT_PAGE_PREV,
        LEFT_PAGE_PREV_PREV,
        RIGHT_PAGE,
        RIGHT_PAGE_UNDER,
        RIGHT_PAGE_PREV,
        RIGHT_PAGE_PREV_PREV,
        MIDDLE_BUTTON;


        public boolean isOnLeftSide() {
            return this == LEFT_PAGE || this == LEFT_PAGE_PREV || this == LEFT_PAGE_PREV_PREV || this == RIGHT_PAGE_UNDER;
        }
    }

    public static enum DrawingType {
        BOOK,
        SCREEN,
        GUI;


        public static DrawingType byId(int id) {
            DrawingType[] type = DrawingType.values();
            return type[id < 0 || id >= type.length ? 0 : id];
        }
    }

    public static class ImageConverter {
        public static NativeImage convertToNativeImage(BufferedImage bufferedImage) {
            int width = bufferedImage.getWidth();
            int height = bufferedImage.getHeight();
            NativeImage nativeImage = new NativeImage(NativeImage.Format.RGBA, width, height, false);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int argb = bufferedImage.getRGB(x, y);
                    int a = argb >> 24 & 0xFF;
                    int r = argb >> 16 & 0xFF;
                    int g = argb >> 8 & 0xFF;
                    int b = argb & 0xFF;
                    int rgba = a << 24 | r << 16 | g << 8 | b;
                    nativeImage.setPixelRGBA(x, y, rgba);
                }
            }
            return nativeImage;
        }

        public static NativeImage convertToNativeImage(BufferedImage bufferedImage, NativeImage baseImage) {
            if (baseImage == null) {
                return null;
            }
            int width = bufferedImage.getWidth();
            int height = bufferedImage.getHeight();
            int baseWidth = baseImage.getWidth();
            int baseHeight = baseImage.getHeight();
            int pasteWidth = Math.min(width, baseWidth);
            int pasteHeight = Math.min(height, baseHeight);
            for (int y = 0; y < pasteHeight; ++y) {
                for (int x = 0; x < pasteWidth; ++x) {
                    int argb = bufferedImage.getRGB(x, y);
                    int a = argb >> 24 & 0xFF;
                    int b = argb >> 16 & 0xFF;
                    int g = argb >> 8 & 0xFF;
                    int r = argb & 0xFF;
                    int rgba = a << 24 | r << 16 | g << 8 | b;
                    baseImage.setPixelRGBA(x, y, rgba);
                }
            }
            return baseImage;
        }
    }
}

