/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.books;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public class PaintData {
    private final List<LayerData> layers;
    private final int width;
    private final int height;
    public ResourceLocation page;
    public UUID uuid;
    public boolean locked = false;
    public UUID lockedByUUID = new UUID(0L, 0L);
    public Component lockedByName = Component.empty();
    public static final Codec<PaintData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("width").forGetter(PaintData::getWidth), (App)Codec.INT.fieldOf("height").forGetter(PaintData::getHeight), (App)LayerData.CODEC.listOf().fieldOf("layers").forGetter(PaintData::getLayers), (App)ResourceLocation.CODEC.fieldOf("page").forGetter(PaintData::getPage), (App)UUIDUtil.CODEC.fieldOf("uuid").forGetter(PaintData::getUuid), (App)Codec.BOOL.optionalFieldOf("locked", (Object)false).forGetter(PaintData::isLocked), (App)UUIDUtil.CODEC.optionalFieldOf("lockedByUUID", (Object)new UUID(0L, 0L)).forGetter(PaintData::getLockedByUUID), (App)ComponentSerialization.CODEC.optionalFieldOf("lockedByName", (Object)Component.empty()).forGetter(PaintData::getLockedByName)).apply((Applicative)instance, PaintData::new));
    public static StreamCodec<ByteBuf, PaintData> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);

    public PaintData(int width, int height, List<LayerData> layers, ResourceLocation page, UUID uuid) {
        this.width = width;
        this.height = height;
        this.layers = layers;
        this.page = page;
        this.uuid = uuid;
    }

    public PaintData(int width, int height, List<LayerData> layers, ResourceLocation page, UUID uuid, boolean locked, UUID lockedByUUID, Component lockedByName) {
        this.width = width;
        this.height = height;
        this.layers = layers;
        this.page = page;
        this.uuid = uuid;
        this.locked = locked;
        this.lockedByUUID = lockedByUUID;
        this.lockedByName = lockedByName;
    }

    public List<LayerData> getLayers() {
        return this.layers;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ResourceLocation getPage() {
        return this.page;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public UUID getLockedByUUID() {
        return this.lockedByUUID;
    }

    public Component getLockedByName() {
        return this.lockedByName;
    }

    public record LayerData(int width, int height, List<Integer> pixels, float opacity, String blendMode, String name) {
        public static final Codec<LayerData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("width").forGetter(LayerData::width), (App)Codec.INT.fieldOf("height").forGetter(LayerData::height), (App)Codec.INT.listOf().fieldOf("pixels").forGetter(LayerData::pixels), (App)Codec.FLOAT.fieldOf("opacity").forGetter(LayerData::opacity), (App)Codec.STRING.fieldOf("blendMode").forGetter(LayerData::blendMode), (App)Codec.STRING.fieldOf("name").forGetter(LayerData::name)).apply((Applicative)instance, LayerData::new));
    }
}

