/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.recipes;

import net.joefoxe.hexerei.data.candle.CandleData;
import net.joefoxe.hexerei.data.recipes.ModRecipeTypes;
import net.joefoxe.hexerei.item.ModItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.shapes.Shapes;

public class AddBaseToCandleRecipe
extends CustomRecipe {
    public AddBaseToCandleRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean matches(CraftingInput pInv, Level pLevel) {
        ItemStack itemstack = ItemStack.EMPTY;
        BlockItem block = null;
        for (int j = 0; j < pInv.size(); ++j) {
            ItemStack itemstack1 = pInv.getItem(j);
            if (itemstack1.isEmpty()) continue;
            if (itemstack1.is((Item)ModItems.CANDLE.get())) {
                if (!itemstack.isEmpty()) {
                    return false;
                }
                itemstack = itemstack1;
                continue;
            }
            Item item = itemstack1.getItem();
            if (!(item instanceof BlockItem)) continue;
            BlockItem blockItem = (BlockItem)item;
            if (block != null) {
                return false;
            }
            block = blockItem;
        }
        return !itemstack.isEmpty() && block != null;
    }

    public ItemStack assemble(CraftingInput pInv, HolderLookup.Provider registries) {
        boolean i = false;
        ItemStack candle = ItemStack.EMPTY;
        BlockItem block = null;
        for (int j = 0; j < pInv.size(); ++j) {
            ItemStack itemstack1 = pInv.getItem(j);
            if (itemstack1.isEmpty()) continue;
            if (itemstack1.is((Item)ModItems.CANDLE.get())) {
                if (!candle.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                candle = itemstack1;
                continue;
            }
            Item item = itemstack1.getItem();
            if (!(item instanceof BlockItem)) continue;
            BlockItem blockItem = (BlockItem)item;
            try {
                if (block != null || !blockItem.getBlock().defaultBlockState().getShape(null, null).equals(Shapes.block())) {
                    return ItemStack.EMPTY;
                }
                block = blockItem;
                continue;
            }
            catch (Exception exception) {
                return ItemStack.EMPTY;
            }
        }
        if (!candle.isEmpty() && block != null) {
            CompoundTag tag;
            ItemStack itemstack2 = candle.copy();
            itemstack2.setCount(1);
            CandleData data = new CandleData();
            data.load(((CustomData)itemstack2.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag(), registries);
            if (BuiltInRegistries.BLOCK.containsValue((Object)block.getBlock())) {
                tag = new CompoundTag();
                tag.putBoolean("layerFromBlockLocation", true);
                tag.putString("layer", BuiltInRegistries.BLOCK.getKey((Object)block.getBlock()).toString());
                data.base.load(tag);
            }
            tag = ((CustomData)itemstack2.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            data.save(tag, registries, true);
            itemstack2.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            return itemstack2;
        }
        return ItemStack.EMPTY;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.getOutput();
    }

    public ItemStack getOutput() {
        return ((Item)ModItems.CANDLE.get()).getDefaultInstance();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.ADD_BASE_TO_CANDLE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return RecipeType.CRAFTING;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    public static class Type
    implements RecipeType<AddBaseToCandleRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

