/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.fluid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.joefoxe.hexerei.data.recipes.FluidMixingRecipe;
import net.joefoxe.hexerei.fluid.PotionFluid;
import net.joefoxe.hexerei.fluid.PotionFluidHandler;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.brewing.BrewingRecipe;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.fluids.FluidStack;

public class PotionMixingRecipes {
    public static final List<Item> SUPPORTED_CONTAINERS = List.of(Items.POTION, Items.SPLASH_POTION, Items.LINGERING_POTION);
    public static List<FluidMixingRecipe> ALL;
    public static Map<Item, List<FluidMixingRecipe>> BY_ITEM;
    public static List<BrewingRecipe> recipes;

    public static List<BrewingRecipe> getAllBrewingRecipes(PotionBrewing potionBrewing) {
        if (recipes.isEmpty()) {
            potionBrewing.getRecipes().stream().filter(recipe -> recipe instanceof BrewingRecipe).map(recipe -> (BrewingRecipe)recipe).forEach(recipes::add);
            for (PotionBrewing.Mix mix : potionBrewing.potionMixes) {
                recipes.add(new BrewingRecipe(PotionMixingRecipes.fromPotion((Holder<Potion>)mix.from()), mix.ingredient(), PotionMixingRecipes.fromPotion((Holder<Potion>)mix.to()).getItems()[0]));
            }
        }
        return recipes;
    }

    private static boolean isContainer(PotionBrewing potionBrewing, ItemStack stack) {
        for (Ingredient ingredient : potionBrewing.containers) {
            if (!ingredient.test(stack)) continue;
            return true;
        }
        return false;
    }

    public static List<FluidMixingRecipe> createRecipes(PotionBrewing potionBrewing) {
        ArrayList<FluidMixingRecipe> mixingRecipes = new ArrayList<FluidMixingRecipe>();
        int recipeIndex = 0;
        ArrayList<Item> allowedSupportedContainers = new ArrayList<Item>();
        ArrayList<ItemStack> supportedContainerStacks = new ArrayList<ItemStack>();
        for (Item container : SUPPORTED_CONTAINERS) {
            ItemStack stack = new ItemStack((ItemLike)container);
            supportedContainerStacks.add(stack);
            if (!PotionMixingRecipes.isContainer(potionBrewing, stack)) continue;
            allowedSupportedContainers.add(container);
        }
        for (Item container : allowedSupportedContainers) {
            PotionFluid.BottleType bottleType = PotionFluidHandler.bottleTypeFromItem(container);
            for (PotionBrewing.Mix mix : potionBrewing.potionMixes) {
                FluidStack fromFluid = PotionFluidHandler.getFluidFromPotion((Holder<Potion>)mix.from(), bottleType, 1000);
                FluidStack toFluid = PotionFluidHandler.getFluidFromPotion((Holder<Potion>)mix.to(), bottleType, 1000);
                if (mix.ingredient().getItems().length == 0 || mix.ingredient().getItems()[0] == null || mix.ingredient().getItems()[0].isEmpty()) continue;
                mixingRecipes.add(PotionMixingRecipes.createRecipe("potion_mixing_vanilla_" + recipeIndex++, mix.ingredient(), fromFluid, toFluid));
            }
        }
        for (PotionBrewing.Mix mix : potionBrewing.containerMixes) {
            Item to;
            Item from = (Item)mix.from().value();
            if (!allowedSupportedContainers.contains(from) || !allowedSupportedContainers.contains(to = (Item)mix.to().value())) continue;
            PotionFluid.BottleType fromBottleType = PotionFluidHandler.bottleTypeFromItem(from);
            PotionFluid.BottleType toBottleType = PotionFluidHandler.bottleTypeFromItem(to);
            Ingredient ingredient = mix.ingredient();
            if (mix.ingredient().getItems()[0] == null) continue;
            for (Holder.Reference potion : BuiltInRegistries.POTION.holders().toList()) {
                FluidStack fromFluid = PotionFluidHandler.getFluidFromPotion((Holder<Potion>)potion, fromBottleType, 1000);
                FluidStack toFluid = PotionFluidHandler.getFluidFromPotion((Holder<Potion>)potion, toBottleType, 1000);
                mixingRecipes.add(PotionMixingRecipes.createRecipe("potion_mixing_vanilla_" + recipeIndex++, ingredient, fromFluid, toFluid));
            }
        }
        recipeIndex = 0;
        for (BrewingRecipe recipe : PotionMixingRecipes.getAllBrewingRecipes(potionBrewing)) {
            ItemStack output = recipe.getOutput();
            if (!SUPPORTED_CONTAINERS.contains(output.getItem())) continue;
            Ingredient input = recipe.getInput();
            Ingredient ingredient = recipe.getIngredient();
            FluidStack outputFluid = null;
            for (ItemStack stack : supportedContainerStacks) {
                if (!input.test(stack)) continue;
                FluidStack inputFluid = PotionFluidHandler.getFluidFromPotionItem(stack);
                if (outputFluid == null) {
                    outputFluid = PotionFluidHandler.getFluidFromPotionItem(output);
                }
                mixingRecipes.add(PotionMixingRecipes.createRecipe("potion_mixing_modded_" + recipeIndex++, ingredient, inputFluid, outputFluid));
            }
        }
        if (mixingRecipes.isEmpty()) {
            mixingRecipes.add(PotionMixingRecipes.createRecipe("potion_mixing_missing", Ingredient.EMPTY, new FluidStack((Fluid)Fluids.WATER, 2000), new FluidStack((Fluid)Fluids.WATER, 2000)));
        }
        return mixingRecipes;
    }

    private static FluidMixingRecipe createRecipe(String id, Ingredient ingredient, FluidStack fromFluid, FluidStack toFluid) {
        NonNullList nonNullList = NonNullList.withSize((int)8, (Object)Ingredient.EMPTY);
        nonNullList.set(0, (Object)ingredient);
        nonNullList.set(4, (Object)ingredient);
        return new FluidMixingRecipe((NonNullList<Ingredient>)nonNullList, fromFluid, toFluid, FluidMixingRecipe.HeatCondition.HEATED);
    }

    public static Map<Item, List<FluidMixingRecipe>> sortRecipesByItem(List<FluidMixingRecipe> all) {
        HashMap<Item, List<FluidMixingRecipe>> byItem = new HashMap<Item, List<FluidMixingRecipe>>();
        HashSet<Item> processedItems = new HashSet<Item>();
        for (FluidMixingRecipe recipe : all) {
            for (Ingredient ingredient : recipe.getIngredients()) {
                for (ItemStack itemStack : ingredient.getItems()) {
                    Item item = itemStack.getItem();
                    if (!processedItems.add(item)) continue;
                    byItem.computeIfAbsent(item, i -> new ArrayList()).add(recipe);
                }
            }
            processedItems.clear();
        }
        return byItem;
    }

    public static Ingredient fromPotion(Holder<Potion> potion) {
        ItemStack stack = new ItemStack((ItemLike)Items.POTION);
        stack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(potion));
        return PotionMixingRecipes.getIngredient(stack);
    }

    public static Ingredient getIngredient(ItemStack input) {
        return DataComponentIngredient.of((boolean)false, (ItemStack)input);
    }

    static {
        recipes = new ArrayList<BrewingRecipe>();
    }
}

