/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.integration.jei;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.CandleDipper;
import net.joefoxe.hexerei.data.recipes.DipperRecipe;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;

public class DipperRecipeCategory
implements IRecipeCategory<DipperRecipe> {
    public static final ResourceLocation UID = HexereiUtil.getResource("dipper");
    public static final ResourceLocation TEXTURE = HexereiUtil.getResource("textures/gui/dipper_jei.png");
    public static final ResourceLocation MIX_TEXTURE = HexereiUtil.getResource("textures/gui/mixing_cauldron_gui_jei.png");
    public static final ResourceLocation TEXTURE_BLANK = HexereiUtil.getResource("textures/block/blank.png");
    private final IDrawable background;
    private final IDrawable cauldron;
    private final IDrawable icon;
    private final IDrawable liquid;

    public DipperRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 100, 92);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.CANDLE_DIPPER.get()));
        this.liquid = helper.createDrawable(MIX_TEXTURE, 182, 2, 12, 10);
        this.cauldron = helper.createDrawable(TEXTURE, 106, 3, 12, 9);
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight();
    }

    public RecipeType<DipperRecipe> getRecipeType() {
        return new RecipeType(UID, DipperRecipe.class);
    }

    public Component getTitle() {
        return ((CandleDipper)ModBlocks.CANDLE_DIPPER.get()).getName();
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DipperRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 15, 14).addItemStack(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 69, 23).addItemStack(recipe.getOutput());
        FluidStack input = recipe.getLiquid();
        if (recipe.getFluidLevelsConsumed() != 0 && !input.isEmpty()) {
            input.setAmount(Mth.clamp((int)recipe.getFluidLevelsConsumed(), (int)0, (int)2000));
        }
        if (!input.isEmpty()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 17, 35).setFluidRenderer((long)input.getAmount(), false, 12, 10).setOverlay(this.liquid, 0, 0).addFluidStack(recipe.getFluid().getFluid(), (long)recipe.getFluid().getAmount(), recipe.getFluid().getComponentsPatch());
        }
    }

    public void draw(DipperRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        String dryingTimeString;
        String dippingTimeString;
        int numberOfDips = recipe.getNumberOfDips();
        int dippingTime = recipe.getDippingTime();
        int dryingTime = recipe.getDryingTime();
        Minecraft minecraft = Minecraft.getInstance();
        this.background.draw(guiGraphics);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(0.6f, 0.6f, 0.6f);
        String numberOfDipsString = numberOfDips < Integer.MAX_VALUE ? Integer.toString(numberOfDips) : "?";
        MutableComponent times_dipped_1 = Component.translatable((String)"gui.jei.category.dipper.times_dipped_1");
        MutableComponent times_dipped_3 = Component.translatable((String)"gui.jei.category.dipper.result", (Object[])new Object[]{numberOfDipsString});
        minecraft.font.drawInBatch((Component)times_dipped_1, 9.996f, 93.296f, -8355712, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        minecraft.font.drawInBatch((Component)times_dipped_3, 108.29f, 93.296f, -8355712, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        Object object = dippingTime < Integer.MAX_VALUE ? dippingTime / 20 + (String)(dippingTime % 20 == 0 ? "" : "." + dippingTime % 20) : (dippingTimeString = "?");
        if (dippingTimeString.charAt(dippingTimeString.length() - 1) == '0' && dippingTime != 0 && dippingTime % 20 != 0) {
            dippingTimeString = dippingTimeString.substring(0, dippingTimeString.length() - 1);
        }
        MutableComponent dip_time_1 = Component.translatable((String)"gui.jei.category.dipper.dip_time_1");
        MutableComponent dip_time_3 = Component.translatable((String)"gui.jei.category.dipper.resultSeconds", (Object[])new Object[]{dippingTimeString});
        minecraft.font.drawInBatch((Component)dip_time_1, 9.996f, 113.288f, -8355712, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        minecraft.font.drawInBatch((Component)dip_time_3, 108.29f, 113.288f, -8355712, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        Object object2 = dryingTime < Integer.MAX_VALUE ? dryingTime / 20 + (String)(dryingTime % 20 == 0 ? "" : "." + dryingTime % 20) : (dryingTimeString = "?");
        if (dryingTimeString.charAt(dryingTimeString.length() - 1) == '0' && dryingTime != 0 && dryingTime % 20 != 0) {
            dryingTimeString = dryingTimeString.substring(0, dryingTimeString.length() - 1);
        }
        MutableComponent dry_time_1 = Component.translatable((String)"gui.jei.category.dipper.dry_time_1");
        MutableComponent dry_time_3 = Component.translatable((String)"gui.jei.category.dipper.resultSeconds", (Object[])new Object[]{dryingTimeString});
        minecraft.font.drawInBatch((Component)dry_time_1, 9.996f, 133.28f, -8355712, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        minecraft.font.drawInBatch((Component)dry_time_3, 108.29f, 133.28f, -8355712, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        String outputName = recipe.getOutput().getHoverName().getString();
        minecraft.font.drawInBatch(outputName, 8.33f, 6.664f, -12566464, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        guiGraphics.pose().popPose();
    }
}

