/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.integration.jei;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Random;
import java.util.function.Supplier;
import mezz.jei.api.gui.drawable.IDrawable;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.MixingCauldron;
import net.joefoxe.hexerei.data.recipes.FluidMixingRecipe;
import net.joefoxe.hexerei.data.recipes.MixingCauldronRecipe;
import net.joefoxe.hexerei.event.ClientEvents;
import net.joefoxe.hexerei.fluid.PotionMixingRecipes;
import net.joefoxe.hexerei.tileentity.renderer.MixingCauldronRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.Tags;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class ExtraCauldronIcon
implements IDrawable {
    private Supplier<ItemStack> extraSupplier;
    private ItemStack extraStack;
    private boolean findNewRecipe;
    private Recipe<?> recipeShown;
    private String type;
    private boolean showOutputItemInstead;

    public ExtraCauldronIcon(Supplier<ItemStack> secondary) {
        this.extraSupplier = secondary;
        this.findNewRecipe = true;
        this.type = "Fluid";
        this.showOutputItemInstead = false;
    }

    public ExtraCauldronIcon(Supplier<ItemStack> secondary, boolean showOutputItemInstead) {
        this.extraSupplier = secondary;
        this.findNewRecipe = true;
        this.type = "Fluid";
        this.showOutputItemInstead = showOutputItemInstead;
    }

    public ExtraCauldronIcon(Supplier<ItemStack> secondary, String type, boolean showOutputItemInstead) {
        this.extraSupplier = secondary;
        this.findNewRecipe = true;
        this.type = type;
        this.showOutputItemInstead = showOutputItemInstead;
    }

    public ExtraCauldronIcon(Supplier<ItemStack> secondary, String type) {
        this.extraSupplier = secondary;
        this.findNewRecipe = true;
        this.type = type;
        this.showOutputItemInstead = false;
    }

    public int getWidth() {
        return 18;
    }

    public int getHeight() {
        return 18;
    }

    public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
        float craftPercent;
        if (this.extraStack == null) {
            this.extraStack = this.extraSupplier.get();
        }
        if ((double)(craftPercent = ClientEvents.getClientTicks() % 100.0f / 100.0f) <= 0.1 && this.findNewRecipe || this.recipeShown == null) {
            this.findNewRecipe = false;
            if (Minecraft.getInstance().level != null) {
                if (this.type.equals("Fluid")) {
                    list = Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((RecipeType)FluidMixingRecipe.Type.INSTANCE);
                    this.recipeShown = ((RecipeHolder)list.get(new Random().nextInt(list.size()))).value();
                } else if (this.type.equals("Potion")) {
                    this.recipeShown = PotionMixingRecipes.ALL.get(new Random().nextInt(PotionMixingRecipes.ALL.size()));
                } else {
                    list = Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((RecipeType)MixingCauldronRecipe.Type.INSTANCE);
                    this.recipeShown = ((RecipeHolder)list.get(new Random().nextInt(list.size()))).value();
                }
            }
        }
        if ((double)craftPercent > 0.1) {
            this.findNewRecipe = true;
        }
        RenderSystem.enableDepthTest();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)xOffset, (float)yOffset, 0.0f);
        guiGraphics.pose().mulPose(new Matrix4f().scale(1.0f, -1.0f, 1.0f));
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(2.0f, -13.0f, 0.0f);
        guiGraphics.pose().scale(10.0f, 10.0f, 10.0f);
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        Vec3 rotationOffset = new Vec3(0.0, 0.0, 0.0);
        float zRot = 0.0f;
        float xRot = 20.0f;
        float yRot = 30.0f;
        guiGraphics.pose().translate(rotationOffset.x, rotationOffset.y, rotationOffset.z);
        guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(zRot));
        guiGraphics.pose().mulPose(Axis.XP.rotationDegrees(xRot));
        guiGraphics.pose().mulPose(Axis.YP.rotationDegrees(yRot));
        guiGraphics.pose().translate(-rotationOffset.x, -rotationOffset.y, -rotationOffset.z);
        BlockState blockState = (BlockState)((MixingCauldron)ModBlocks.MIXING_CAULDRON.get()).defaultBlockState().setValue((Property)MixingCauldron.GUI_RENDER, (Comparable)Boolean.valueOf(true));
        BlockRenderDispatcher rendererer = Minecraft.getInstance().getBlockRenderer();
        rendererer.getBlockModel(blockState);
        BakedModel bakedModel = rendererer.getBlockModel(blockState);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderBlock(guiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0, blockState, -12566464);
        if (this.recipeShown instanceof FluidMixingRecipe || this.recipeShown instanceof MixingCauldronRecipe) {
            Object recipe;
            float fillPercentage = 1.0f;
            Recipe<?> recipe2 = this.recipeShown;
            if (recipe2 instanceof FluidMixingRecipe) {
                recipe = (FluidMixingRecipe)recipe2;
                if (((FluidMixingRecipe)recipe).getLiquid().getFluid().is(Tags.Fluids.GASEOUS)) {
                    MixingCauldronRenderer.renderFluidGUI(guiGraphics.pose(), (MultiBufferSource)buffer, ((FluidMixingRecipe)recipe).getLiquid(), fillPercentage, 1.0f, OverlayTexture.NO_OVERLAY);
                } else {
                    MixingCauldronRenderer.renderFluidGUI(guiGraphics.pose(), (MultiBufferSource)buffer, ((FluidMixingRecipe)recipe).getLiquid(), 1.0f, fillPercentage, OverlayTexture.NO_OVERLAY);
                }
            }
            if ((recipe2 = this.recipeShown) instanceof MixingCauldronRecipe) {
                recipe = (MixingCauldronRecipe)recipe2;
                if (((MixingCauldronRecipe)recipe).getLiquid().getFluid().is(Tags.Fluids.GASEOUS)) {
                    MixingCauldronRenderer.renderFluidGUI(guiGraphics.pose(), (MultiBufferSource)buffer, ((MixingCauldronRecipe)recipe).getLiquid(), fillPercentage, 1.0f, OverlayTexture.NO_OVERLAY);
                } else {
                    MixingCauldronRenderer.renderFluidGUI(guiGraphics.pose(), (MultiBufferSource)buffer, ((MixingCauldronRecipe)recipe).getLiquid(), 1.0f, fillPercentage, OverlayTexture.NO_OVERLAY);
                }
            }
            float height = 0.25f + 0.6875f * fillPercentage;
            Lighting.setupFor3DItems();
            for (int i = 0; i < this.recipeShown.getIngredients().size(); ++i) {
                ItemStack[] items = ((Ingredient)this.recipeShown.getIngredients().get(i)).getItems();
                if (items.length <= 0) continue;
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(0.5, (double)(height + 0.00390625f), 0.5);
                double itemRotationOffset = 0.8 * (double)i + (double)(craftPercent * (20.0f * craftPercent));
                guiGraphics.pose().translate(0.0 + Math.sin(itemRotationOffset) / (double)(3.5f + craftPercent * craftPercent * 10.0f), Math.sin(Math.PI * (double)ClientEvents.getClientTicks() / 30.0 + (double)(i * 20)) / 10.0 * 0.2, 0.0 + Math.cos(itemRotationOffset) / (double)(3.5f + craftPercent * craftPercent * 10.0f));
                guiGraphics.pose().mulPose(Axis.YP.rotationDegrees((float)((double)((float)(45 * i) - 1.0f) + 2.0 * Math.sin((ClientEvents.getClientTicks() + (float)(i * 20)) / 40.0f))));
                guiGraphics.pose().mulPose(Axis.XP.rotationDegrees((float)(82.5 + 5.0 * Math.cos((ClientEvents.getClientTicks() + (float)(i * 22)) / 40.0f))));
                guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees((float)(-2.5 + 5.0 * Math.cos((ClientEvents.getClientTicks() + (float)(i * 24)) / 40.0f))));
                guiGraphics.pose().scale(1.0f - craftPercent * 0.5f, 1.0f - craftPercent * 0.5f, 1.0f - craftPercent * 0.5f);
                guiGraphics.pose().scale(0.4f, 0.4f, 0.4f);
                this.renderItemFixed(items[(int)ClientEvents.getClientTicksWithoutPartial() / 40 % items.length], (Level)Minecraft.getInstance().level, guiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0);
                guiGraphics.pose().popPose();
            }
        }
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(14.0f, -14.0f, 100.0f);
        guiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
        guiGraphics.pose().scale(16.0f, 16.0f, 16.0f);
        guiGraphics.pose().last().normal().rotate((Quaternionfc)Axis.YP.rotationDegrees(-45.0f));
        if (!this.extraStack.isEmpty() || this.showOutputItemInstead) {
            if (!this.showOutputItemInstead) {
                this.renderItem(this.extraStack, (Level)Minecraft.getInstance().level, guiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0);
            } else {
                this.renderItem(this.recipeShown.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()), (Level)Minecraft.getInstance().level, guiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0);
            }
        }
        guiGraphics.pose().popPose();
        guiGraphics.pose().popPose();
        buffer.endBatch();
        RenderSystem.enableDepthTest();
        Lighting.setupFor3DItems();
    }

    private void renderItem(ItemStack stack, Level level, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GUI, combinedLightIn, OverlayTexture.NO_OVERLAY, matrixStackIn, bufferIn, level, 1);
    }

    private void renderItemFixed(ItemStack stack, Level level, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, matrixStackIn, bufferIn, level, 1);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderBlock(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, BlockState state, int color) {
        this.renderSingleBlock(state, matrixStack, bufferIn, combinedLightIn, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, color);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderSingleBlock(BlockState p_110913_, PoseStack poseStack, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, int color) {
        RenderShape rendershape = p_110913_.getRenderShape();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
                    BakedModel bakedmodel = dispatcher.getBlockModel(p_110913_);
                    int i = color;
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    dispatcher.getModelRenderer().renderModel(poseStack.last(), p_110915_.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)p_110913_, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, null);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.getBlock());
                    poseStack.translate(0.2, -0.1, -0.1);
                    IClientItemExtensions.of((Item)stack.getItem()).getCustomRenderer().renderByItem(stack, ItemDisplayContext.NONE, poseStack, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }
}

