/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.integration.jei;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.data.recipes.KeychainRecipe;
import net.joefoxe.hexerei.event.ClientEvents;
import net.joefoxe.hexerei.integration.jei.ExtraKeychainIcon;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.custom.KeychainItem;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class KeychainApplyRecipeCategory
implements IRecipeCategory<KeychainRecipe> {
    public static final ResourceLocation UID = HexereiUtil.getResource("keychain_apply");
    public static final ResourceLocation TEXTURE = HexereiUtil.getResource("textures/gui/add_to_candle_gui_jei.png");
    private IDrawable background;
    private final IDrawable icon;
    public ItemStack itemShown;
    private boolean findNewItem;

    public void getTooltip(ITooltipBuilder tooltip, KeychainRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (this.isHovering(mouseX, mouseY, 33.0, 19.0, 16.0, 16.0)) {
            tooltip.add((FormattedText)Component.translatable((String)"Any Item"));
            tooltip.add((FormattedText)Component.translatable((String)"item shown: - %s", (Object[])new Object[]{Component.translatable((String)this.itemShown.getHoverName().getString()).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xCC5522)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        }
        super.getTooltip(tooltip, (Object)recipe, recipeSlotsView, mouseX, mouseY);
    }

    public boolean isHovering(double mouseX, double mouseY, double x, double y, double width, double height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public KeychainApplyRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 144, 86);
        this.icon = new ExtraKeychainIcon(() -> new ItemStack((ItemLike)ModItems.CANDLE.get()));
        List col = BuiltInRegistries.ITEM.stream().toList();
        Random rand = new Random();
        Object object = col.toArray()[(int)((float)col.size() * rand.nextFloat())];
        if (object instanceof Item) {
            Item item = (Item)object;
            this.itemShown = new ItemStack((ItemLike)item);
        }
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight();
    }

    public RecipeType<KeychainRecipe> getRecipeType() {
        return new RecipeType(HexereiUtil.getResource("keychain_apply"), KeychainRecipe.class);
    }

    public Component getTitle() {
        return Component.translatable((String)"Keychain Attach");
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, KeychainRecipe recipe, IFocusGroup focuses) {
        builder.moveRecipeTransferButton(160, 90);
        builder.setShapeless();
        builder.addSlot(RecipeIngredientRole.INPUT, 15, 19).addItemStack(new ItemStack((ItemLike)ModItems.BROOM_KEYCHAIN.get()));
    }

    public void draw(KeychainRecipe recipe, IRecipeSlotsView view, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        float newItem = ClientEvents.getClientTicks() % 200.0f / 200.0f;
        if (newItem <= 0.05f && this.findNewItem || this.itemShown == null) {
            this.findNewItem = false;
            if (Minecraft.getInstance().level != null) {
                List col = BuiltInRegistries.ITEM.stream().toList();
                Random rand = new Random();
                Object object = col.toArray()[(int)((float)col.size() * rand.nextFloat())];
                if (object instanceof Item) {
                    Item item = (Item)object;
                    this.itemShown = new ItemStack((ItemLike)item);
                }
            }
        }
        if (newItem > 0.05f) {
            this.findNewItem = true;
        }
        Minecraft minecraft = Minecraft.getInstance();
        ItemRenderer renderer = minecraft.getItemRenderer();
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        Component outputName = this.getTitle();
        RenderSystem.enableDepthTest();
        if (this.isHovering(mouseX, mouseY, 33.0, 19.0, 16.0, 16.0)) {
            guiGraphics.fill(33, 19, 49, 35, 0x66FFFFFF);
        }
        if (!renderer.getModel(this.itemShown, null, null, 0).usesBlockLight()) {
            Lighting.setupForFlatItems();
        }
        ItemStack stack = new ItemStack((ItemLike)ModItems.BROOM_KEYCHAIN.get());
        ItemStack keychain = new ItemStack((ItemLike)ModItems.BROOM_KEYCHAIN.get());
        ItemStack other = this.itemShown;
        if (keychain.getItem() instanceof KeychainItem && !other.isEmpty()) {
            CompoundTag tag = ((CustomData)keychain.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            ListTag listtag = new ListTag();
            if (!other.isEmpty()) {
                listtag.add((Object)other.save((HolderLookup.Provider)Hexerei.DynamicRegistries.get()));
            }
            tag.put("Items", (Tag)listtag);
            keychain.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(41.0f, 27.0f, 0.0f);
        guiGraphics.pose().mulPose(new Matrix4f().scale(1.0f, -1.0f, 1.0f));
        guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
        guiGraphics.pose().scale(16.0f, 16.0f, 16.0f);
        guiGraphics.pose().last().normal().rotate((Quaternionfc)Axis.YP.rotationDegrees(-45.0f));
        this.renderItem(this.itemShown, (Level)minecraft.level, guiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0);
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(117.0f, 45.0f, 0.0f);
        guiGraphics.pose().mulPose(new Matrix4f().scale(1.0f, -1.0f, 1.0f));
        guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
        guiGraphics.pose().scale(16.0f, 16.0f, 16.0f);
        guiGraphics.pose().last().normal().rotate((Quaternionfc)Axis.YP.rotationDegrees(-45.0f));
        this.renderItem(keychain, (Level)minecraft.level, guiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0);
        guiGraphics.pose().popPose();
        buffer.endBatch();
        RenderSystem.enableDepthTest();
        Lighting.setupFor3DItems();
        int width = minecraft.font.width((FormattedText)outputName);
        Objects.requireNonNull(minecraft.font);
        float lineHeight = 9.0f / 2.0f;
        if (width > 131) {
            float percent = (float)width / 131.0f;
            guiGraphics.pose().pushPose();
            guiGraphics.pose().scale(1.0f / percent, 1.0f / percent, 1.0f / percent);
            minecraft.font.drawInBatch(outputName, 7.0f * percent, (5.0f + lineHeight) * percent - 4.5f, -12566464, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            guiGraphics.pose().popPose();
        } else {
            minecraft.font.drawInBatch(outputName, 7.0f, 5.0f + lineHeight - 4.5f, -12566464, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
    }

    private void renderItem(ItemStack stack, Level level, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GUI, combinedLightIn, OverlayTexture.NO_OVERLAY, matrixStackIn, bufferIn, level, 1);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderBlock(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, BlockState state, int color) {
        this.renderSingleBlock(state, matrixStack, bufferIn, combinedLightIn, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, color);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderSingleBlock(BlockState p_110913_, PoseStack poseStack, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, int color) {
        RenderShape rendershape = p_110913_.getRenderShape();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
                    BakedModel bakedmodel = dispatcher.getBlockModel(p_110913_);
                    int i = color;
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    dispatcher.getModelRenderer().renderModel(poseStack.last(), p_110915_.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)p_110913_, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, null);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.getBlock());
                    poseStack.translate(0.2, -0.1, -0.1);
                    IClientItemExtensions.of((Item)stack.getItem()).getCustomRenderer().renderByItem(stack, ItemDisplayContext.NONE, poseStack, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }
}

