/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.item.custom;

import java.util.List;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.message.AskForMapDataPacket;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class CrowAmuletItem
extends Item {
    public CrowAmuletItem(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        CompoundTag inv = ((CustomData)pStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (!inv.isEmpty()) {
            ListTag tagList = inv.getList("Items", 10);
            CompoundTag compoundtag = tagList.getCompound(0);
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)pLevel.registryAccess(), (CompoundTag)compoundtag);
            Item item = stack.getItem();
            if (item instanceof MapItem) {
                MapItem mapItem = (MapItem)item;
                mapItem.inventoryTick(pStack, pLevel, pEntity, pSlotId, true);
                MapItemSavedData mapitemsaveddata = MapItem.getSavedData((ItemStack)stack, (Level)pLevel);
                if (mapitemsaveddata == null) {
                    HexereiPacketHandler.sendToServer(new AskForMapDataPacket(stack));
                }
            }
        }
        super.inventoryTick(pStack, pLevel, pEntity, pSlotId, pIsSelected);
    }

    public Component getName(ItemStack pStack) {
        CompoundTag inv = ((CustomData)pStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        ListTag tagList = inv.getList("Items", 10);
        CompoundTag compoundtag = tagList.getCompound(0);
        ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)Hexerei.DynamicRegistries.get(), (CompoundTag)compoundtag);
        if (!stack.isEmpty()) {
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                return Component.translatable((String)"").append(stack.getHoverName()).append((Component)Component.translatable((String)"item.hexerei.crow_filled_amulet"));
            }
            return Component.translatable((String)ItemStack.parseOptional((HolderLookup.Provider)Hexerei.DynamicRegistries.get(), (CompoundTag)compoundtag).getDescriptionId()).append((Component)Component.translatable((String)"item.hexerei.crow_filled_amulet"));
        }
        return super.getName(pStack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        CompoundTag inv = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        ListTag tagList = inv.getList("Items", 10);
        CompoundTag compoundtag = tagList.getCompound(0);
        CompoundTag itemTags = tagList.getCompound(0);
        MutableComponent itemText = Component.translatable((String)ItemStack.parseOptional((HolderLookup.Provider)Hexerei.DynamicRegistries.get(), (CompoundTag)compoundtag).getDescriptionId()).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x998800)));
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            if (!ItemStack.parseOptional((HolderLookup.Provider)Hexerei.DynamicRegistries.get(), (CompoundTag)itemTags).isEmpty()) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.keychain_with_item").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            } else {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.keychain_without_item").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            }
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.crow_blank_amulet").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.cosmetic_only").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        }
        if (!ItemStack.parseOptional((HolderLookup.Provider)Hexerei.DynamicRegistries.get(), (CompoundTag)itemTags).isEmpty()) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.keychain_contains", (Object[])new Object[]{itemText}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

