/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.item.custom;

import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.ResourceOrTag;
import net.joefoxe.hexerei.util.message.DowsingRodUpdatePositionPacket;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.BlockHitResult;

public class DowsingRodItem
extends Item {
    public static final TagKey<Biome> BT_SWAMP = DowsingRodItem.createBiomeTag("has_structure/dark_coven_biomes");
    public BlockPos nearestPos = null;
    public boolean swampMode = true;
    private static final int distBetweenChecks = 30;
    private static final int searchOffset = 10;
    private static final int numOfChecks = 120;
    private static final int maxRadiusI = 600;
    private int radiusI = 0;
    private int angleI = 0;
    private BlockPos playerPos;
    public static final DynamicCommandExceptionType ERROR_INVALID_BIOME = new DynamicCommandExceptionType(p_137850_ -> Component.translatable((String)"commands.locatebiome.invalid", (Object[])new Object[]{p_137850_}));

    public DowsingRodItem(Item.Properties properties) {
        super(properties);
    }

    public static double angleDifference(double angle1, double angle2) {
        double diff = (angle2 - angle1 + 180.0) % 360.0 - 180.0;
        return diff < -180.0 ? diff + 360.0 : diff;
    }

    public void inventoryTick(ItemStack p_41404_, Level world, Entity entity, int p_41407_, boolean p_41408_) {
        super.inventoryTick(p_41404_, world, entity, p_41407_, p_41408_);
        if (entity instanceof Player && (this.nearestPos == null && ((Player)entity).getMainHandItem() == p_41404_ || ((Player)entity).getOffhandItem() == p_41404_)) {
            if (this.swampMode) {
                this.findSwamp(world, entity);
            } else {
                this.findJungle(world, entity);
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        BlockHitResult raytraceresult = DowsingRodItem.getPlayerPOVHitResult((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (playerIn.isSecondaryUseActive()) {
            if (!worldIn.isClientSide) {
                playerIn.getCooldowns().addCooldown((Item)this, 20);
                this.swampMode = !this.swampMode;
                String s = "display.hexerei.dowsing_rod_swamp";
                if (!this.swampMode) {
                    s = "display.hexerei.dowsing_rod_jungle";
                }
                if (this.swampMode) {
                    this.findSwamp(worldIn, (Entity)playerIn);
                } else {
                    this.findJungle(worldIn, (Entity)playerIn);
                }
                playerIn.displayClientMessage((Component)Component.translatable((String)s), true);
            }
            playerIn.swing(handIn);
        } else {
            if (this.swampMode) {
                this.findSwamp(worldIn, (Entity)playerIn);
                playerIn.displayClientMessage((Component)Component.translatable((String)"display.hexerei.dowsing_rod_swamp_new"), true);
            } else {
                this.findJungle(worldIn, (Entity)playerIn);
                playerIn.displayClientMessage((Component)Component.translatable((String)"display.hexerei.dowsing_rod_jungle_new"), true);
            }
            playerIn.swing(handIn);
        }
        if (playerIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            if (this.nearestPos != null) {
                HexereiPacketHandler.sendToPlayerClient(new DowsingRodUpdatePositionPacket(itemstack, this.nearestPos, this.swampMode), serverPlayer);
            }
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }

    public void findSwamp(Level worldIn, Entity entity) {
        ResourceOrTag key;
        ServerLevel serverLevel;
        Pair pair;
        if (worldIn instanceof ServerLevel && (pair = (serverLevel = (ServerLevel)worldIn).findClosestBiome3d((key = ResourceOrTag.get("#c:is_swamp", Registries.BIOME)).holderPredicate(), entity.blockPosition(), 6400, 32, 64)) != null) {
            this.nearestPos = (BlockPos)pair.getFirst();
        }
    }

    public void findJungle(Level worldIn, Entity entity) {
        ResourceOrTag key;
        ServerLevel serverLevel;
        Pair pair;
        if (worldIn instanceof ServerLevel && (pair = (serverLevel = (ServerLevel)worldIn).findClosestBiome3d((key = ResourceOrTag.get("#minecraft:is_jungle", Registries.BIOME)).holderPredicate(), entity.blockPosition(), 6400, 32, 64)) != null) {
            this.nearestPos = (BlockPos)pair.getFirst();
        }
    }

    private static TagKey<Biome> createBiomeTag(String name) {
        return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)HexereiUtil.getResource(name));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.dowsing_rod_2").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.dowsing_rod_3").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.dowsing_rod_4").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.dowsing_rod_5").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.dowsing_rod").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

