/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.item.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Random;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.HerbJar;
import net.joefoxe.hexerei.block.custom.PickableDoublePlant;
import net.joefoxe.hexerei.block.custom.PickablePlant;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.custom.CustomItemRenderer;
import net.joefoxe.hexerei.item.custom.FlowerOutputItem;
import net.joefoxe.hexerei.tileentity.HerbJarTile;
import net.joefoxe.hexerei.tileentity.renderer.HerbJarRenderer;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;

public class HerbJarItemRenderer
extends CustomItemRenderer {
    private HerbJarRenderer renderer;
    public static ModelResourceLocation JAR = ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hexerei", (String)"block/herb_jar_model"));

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderByItem(ItemStack stack, ItemDisplayContext transformType, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        this.renderTileStuff(stack, transformType, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static HerbJarTile loadBlockEntityFromItem(CompoundTag tag, ItemStack item) {
        BlockItem blockItem;
        Block block;
        Item item2 = item.getItem();
        if (item2 instanceof BlockItem && (block = (blockItem = (BlockItem)item2).getBlock()) instanceof HerbJar) {
            HerbJar herbJar = (HerbJar)block;
            HerbJarTile te = (HerbJarTile)herbJar.newBlockEntity(BlockPos.ZERO, (BlockState)((BlockState)block.defaultBlockState().setValue((Property)HerbJar.GUI_RENDER, (Comparable)Boolean.valueOf(true))).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.SOUTH));
            te.itemHandler.deserializeNBT((HolderLookup.Provider)Hexerei.DynamicRegistries.get(), tag.getCompound("Inventory"));
            if (item.has(DataComponents.DYED_COLOR)) {
                te.setComponents(DataComponentMap.builder().set(DataComponents.DYED_COLOR, (Object)((DyedItemColor)item.get(DataComponents.DYED_COLOR))).build());
            }
            if (item.has(DataComponents.CUSTOM_NAME)) {
                te.customName = item.getHoverName();
            }
            return te;
        }
        return null;
    }

    private void renderItem(ItemStack stack, Level level, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, matrixStackIn, bufferIn, level, 1);
    }

    public void renderTileStuff(ItemStack stack, ItemDisplayContext transformType, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        HerbJarTile tileEntityIn = HerbJarItemRenderer.loadBlockEntityFromItem(tag, stack);
        String name = tileEntityIn.getDisplayName().getString();
        DyeColor col = HexereiUtil.getDyeColorNamed(name);
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.2, -0.1, -0.1);
        matrixStackIn.translate(0.5, 0.265625, 0.25);
        matrixStackIn.scale(0.3f, 0.3f, 0.3f);
        this.renderItem(new ItemStack((ItemLike)tileEntityIn.itemHandler.getStackInSlot(0).getItem(), 1), tileEntityIn.getLevel(), matrixStackIn, bufferIn, combinedLightIn);
        matrixStackIn.popPose();
        if (!tileEntityIn.itemHandler.isEmpty()) {
            BlockState state = null;
            Item item = ((ItemStack)tileEntityIn.itemHandler.getContents().get(0)).getItem();
            if (item == ((PickablePlant)((Object)ModBlocks.BELLADONNA_PLANT.get())).asItem() || item == ((FlowerOutputItem)((Object)ModItems.BELLADONNA_FLOWERS.get())).asItem()) {
                state = ((Block)ModBlocks.HERB_JAR_BELLADONNA.get()).defaultBlockState();
            }
            if (item == ((PickableDoublePlant)((Object)ModBlocks.MUGWORT_BUSH.get())).asItem() || item == ((FlowerOutputItem)((Object)ModItems.MUGWORT_LEAVES.get())).asItem() || item == ((FlowerOutputItem)((Object)ModItems.MUGWORT_FLOWERS.get())).asItem()) {
                state = ((Block)ModBlocks.HERB_JAR_MUGWORT.get()).defaultBlockState();
            }
            if (item == ((PickablePlant)((Object)ModBlocks.MANDRAKE_PLANT.get())).asItem() || item == ((FlowerOutputItem)((Object)ModItems.MANDRAKE_FLOWERS.get())).asItem()) {
                state = ((Block)ModBlocks.HERB_JAR_MANDRAKE_PLANT.get()).defaultBlockState();
            }
            if (item == ModItems.MANDRAKE_ROOT.get()) {
                state = ((Block)ModBlocks.HERB_JAR_MANDRAKE_ROOT.get()).defaultBlockState();
            }
            if (item == ((PickableDoublePlant)((Object)ModBlocks.YELLOW_DOCK_BUSH.get())).asItem() || item == ((FlowerOutputItem)((Object)ModItems.YELLOW_DOCK_LEAVES.get())).asItem() || item == ((FlowerOutputItem)((Object)ModItems.YELLOW_DOCK_FLOWERS.get())).asItem()) {
                state = ((Block)ModBlocks.HERB_JAR_YELLOW_DOCK.get()).defaultBlockState();
            }
            Random rand = new Random(0L);
            Minecraft minecraft = Minecraft.getInstance();
            ItemRenderer itemRenderer = minecraft.getItemRenderer();
            ItemModelShaper shaper = itemRenderer.getItemModelShaper();
            boolean is3dModel = shaper.getModelManager().getModel(new ModelResourceLocation(HexereiUtil.getRegistryName(item), "inventory")).isGui3d();
            int a = 0;
            while ((float)a < (float)((ItemStack)tileEntityIn.itemHandler.getContents().get(0)).getCount() / 1024.0f * 10.0f) {
                matrixStackIn.pushPose();
                matrixStackIn.translate(0.2, -0.1, -0.1);
                if (is3dModel) {
                    matrixStackIn.translate(0.0, 0.09375, 0.0);
                }
                if (state != null) {
                    matrixStackIn.translate(0.5, 0.03125 * (double)a, 0.5);
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees((float)(90 * a)));
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(0.0f));
                    this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, state);
                } else {
                    matrixStackIn.translate(0.5, 0.03125 * (double)a + 0.0625, 0.5);
                    matrixStackIn.scale(0.4f, 0.4f, 0.4f);
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees((float)(rand.nextInt(90) * a)));
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(0.0f));
                    matrixStackIn.mulPose(Axis.XP.rotationDegrees((float)(80 + rand.nextInt(20))));
                    if (is3dModel) {
                        matrixStackIn.scale(1.2f, 1.2f, 1.2f);
                    }
                    this.renderItem(new ItemStack((ItemLike)tileEntityIn.itemHandler.getStackInSlot(0).getItem(), 1), tileEntityIn.getLevel(), matrixStackIn, bufferIn, combinedLightIn);
                }
                matrixStackIn.popPose();
                ++a;
            }
        }
        int i = 4607830;
        int j1 = (int)((double)FastColor.ARGB32.red((int)i) * 0.4);
        int k1 = (int)((double)FastColor.ARGB32.green((int)i) * 0.4);
        int l1 = (int)((double)FastColor.ARGB32.blue((int)i) * 0.4);
        int i1 = FastColor.ARGB32.color((int)0, (int)j1, (int)k1, (int)l1);
        int j2 = (int)((double)FastColor.ARGB32.red((int)i) * 0.2);
        int k2 = (int)((double)FastColor.ARGB32.green((int)i) * 0.2);
        int l2 = (int)((double)FastColor.ARGB32.blue((int)i) * 0.2);
        int i2 = FastColor.ARGB32.color((int)0, (int)j2, (int)k2, (int)l2);
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.2, -0.1, -0.1);
        matrixStackIn.translate(0.5, 0.5, 0.24687499999999996);
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
        matrixStackIn.scale(0.0069444445f, -0.0069444445f, 0.0069444445f);
        Component component = null;
        if (stack.has(DataComponents.CUSTOM_NAME)) {
            component = stack.getHoverName();
        }
        if (component == null && tileEntityIn.getItemStackInSlot(0) != ItemStack.EMPTY) {
            component = tileEntityIn.getItemStackInSlot(0).getHoverName().getString().isEmpty() ? tileEntityIn.getItemStackInSlot(0).getItem().getName(tileEntityIn.getItemStackInSlot(0)) : tileEntityIn.getItemStackInSlot(0).getHoverName();
        }
        if (component != null) {
            int y;
            List list = Minecraft.getInstance().font.split((FormattedText)component, 70);
            float f3 = -Minecraft.getInstance().font.width((FormattedCharSequence)list.getFirst()) / 2;
            matrixStackIn.translate(0.0f, 0.0f, 1.0f);
            if (tileEntityIn.components().has(DataComponents.DYED_COLOR)) {
                matrixStackIn.translate(0.0f, 5.0f, 0.0f);
            }
            Minecraft.getInstance().font.drawInBatch((FormattedCharSequence)list.getFirst(), f3, 0.0f, i1, false, matrixStackIn.last().pose(), bufferIn, Font.DisplayMode.NORMAL, 0, combinedLightIn);
            for (y = 0; y < 9; ++y) {
                if (y % 2 == 0) continue;
                matrixStackIn.pushPose();
                matrixStackIn.translate((float)(y % 3 - 1) * 0.25f, (float)(y / 3 - 1) * 0.25f, -0.05f);
                Minecraft.getInstance().font.drawInBatch((FormattedCharSequence)list.getFirst(), f3, 0.0f, i2, false, matrixStackIn.last().pose(), bufferIn, Font.DisplayMode.NORMAL, 0, combinedLightIn);
                matrixStackIn.popPose();
            }
            if (list.size() > 1) {
                matrixStackIn.translate(0.0f, 10.0f, 0.0f);
                f3 = -Minecraft.getInstance().font.width((FormattedCharSequence)list.get(1)) / 2;
                Minecraft.getInstance().font.drawInBatch((FormattedCharSequence)list.get(1), f3, 0.0f, i1, false, matrixStackIn.last().pose(), bufferIn, Font.DisplayMode.NORMAL, 0, combinedLightIn);
                for (y = 0; y < 9; ++y) {
                    if (y % 2 == 0) continue;
                    matrixStackIn.pushPose();
                    matrixStackIn.translate((float)(y % 3 - 1) * 0.25f, (float)(y / 3 - 1) * 0.25f, -0.05f);
                    Minecraft.getInstance().font.drawInBatch((FormattedCharSequence)list.get(1), f3, 0.0f, i2, false, matrixStackIn.last().pose(), bufferIn, Font.DisplayMode.NORMAL, 0, combinedLightIn);
                    matrixStackIn.popPose();
                }
            }
        }
        if (bufferIn instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)bufferIn;
            bufferSource.endBatch();
        }
        matrixStackIn.popPose();
        matrixStackIn.pushPose();
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(0.0f));
        matrixStackIn.translate(0.7, 0.4, 0.4);
        matrixStackIn.scale(1.33f, 1.33f, 1.33f);
        BakedModel baseModel = Minecraft.getInstance().getModelManager().getModel(JAR);
        if (baseModel != Minecraft.getInstance().getModelManager().getMissingModel()) {
            Minecraft.getInstance().getItemRenderer().render(stack, ItemDisplayContext.FIXED, false, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, baseModel);
        }
        matrixStackIn.popPose();
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state) {
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, null);
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, BlockState state, RenderType renderType, int color) {
        this.renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, ModelData.EMPTY, renderType, color);
    }

    public void renderSingleBlock(BlockState p_110913_, PoseStack p_110914_, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, RenderType renderType, int color) {
        RenderShape rendershape = p_110913_.getRenderShape();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
                    BakedModel bakedmodel = dispatcher.getBlockModel(p_110913_);
                    int i = color;
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    for (RenderType rt : bakedmodel.getRenderTypes(p_110913_, RandomSource.create((long)42L), modelData)) {
                        dispatcher.getModelRenderer().renderModel(p_110914_.last(), p_110915_.getBuffer(renderType != null ? renderType : RenderTypeHelper.getEntityRenderType((RenderType)rt, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, rt);
                    }
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.getBlock());
                    IClientItemExtensions.of((ItemStack)stack).getCustomRenderer().renderByItem(stack, ItemDisplayContext.NONE, p_110914_, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }
}

