/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.item.custom;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.joefoxe.hexerei.client.renderer.entity.custom.BroomEntity;
import net.joefoxe.hexerei.sounds.ModSounds;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;

public class WhistleItem
extends Item {
    public WhistleItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        CustomData data = (CustomData)itemstack.get(DataComponents.CUSTOM_DATA);
        if (data != null) {
            CompoundTag tag = data.copyTag();
            if (tag.contains("broomUUID")) {
                playerIn.level().playSound(null, playerIn.getX() + playerIn.getLookAngle().x(), playerIn.getY() + (double)playerIn.getEyeHeight(), playerIn.getZ() + playerIn.getLookAngle().z(), (SoundEvent)ModSounds.BROOM_WHISTLE.get(), SoundSource.PLAYERS, 1.0f, 0.8f + 0.4f * new Random().nextFloat());
                BroomEntity broomFound = null;
                UUID broomUUID = tag.getUUID("broomUUID");
                List list = level.getEntitiesOfClass(BroomEntity.class, playerIn.getBoundingBox().inflate(64.0));
                for (BroomEntity broom : list) {
                    if (broom.broomUUID == null || !broom.broomUUID.toString().equals(broomUUID.toString()) || broom.hasPassenger((Entity)playerIn)) continue;
                    broomFound = broom;
                    broomFound.broomCalled = true;
                    broomFound.floatMode = true;
                    broomFound.broomCalledDelay = (int)broom.distanceTo((Entity)playerIn);
                    playerIn.getCooldowns().addCooldown((Item)this, 40);
                    if (playerIn.isCreative()) break;
                    itemstack.hurtAndBreak(1, (LivingEntity)playerIn, LivingEntity.getSlotForHand((InteractionHand)handIn));
                    break;
                }
                if (broomFound != null) {
                    float xOffset = (float)Math.cos((double)((playerIn.getYRot() - 90.0f) / 180.0f) * Math.PI) * 1.5f;
                    float zOffset = (float)Math.sin((double)((playerIn.getYRot() - 90.0f) / 180.0f) * Math.PI) * 1.5f;
                    broomFound.setYRot(playerIn.getYRot());
                    broomFound.teleportTo(playerIn.xOld - (double)xOffset, playerIn.yOld + (double)(playerIn.getBbHeight() / 2.0f), playerIn.zOld - (double)zOffset);
                    return InteractionResultHolder.success((Object)itemstack);
                }
                playerIn.displayClientMessage((Component)Component.translatable((String)"display.hexerei.broom_whistle_not_found"), true);
                playerIn.getCooldowns().addCooldown((Item)this, 40);
                return InteractionResultHolder.success((Object)itemstack);
            }
            playerIn.displayClientMessage((Component)Component.translatable((String)"display.hexerei.broom_whistle_not_bound"), true);
        }
        playerIn.getCooldowns().addCooldown((Item)this, 40);
        return InteractionResultHolder.success((Object)itemstack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (Screen.hasShiftDown()) {
            CompoundTag tag;
            tooltipComponents.add((Component)Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            boolean flag = false;
            if (data != null && (tag = data.copyTag()).contains("broomUUID")) {
                flag = true;
                tooltipComponents.add((Component)Component.translatable((String)"Bound to: %s", (Object[])new Object[]{tag.getUUID("broomUUID").toString()}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x119911))));
            }
            if (!flag) {
                tooltipComponents.add((Component)Component.translatable((String)"Not Bound").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x991100))));
            }
            tooltipComponents.add((Component)Component.literal((String)""));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.broom_whistle_shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.broom_whistle_shift_2").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        } else {
            CompoundTag tag;
            tooltipComponents.add((Component)Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            boolean flag = false;
            if (data != null && (tag = data.copyTag()).contains("broomUUID")) {
                flag = true;
                tooltipComponents.add((Component)Component.translatable((String)"Bound").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x119911))));
            }
            if (!flag) {
                tooltipComponents.add((Component)Component.translatable((String)"Not Bound").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x991100))));
            }
            tooltipComponents.add((Component)Component.literal((String)""));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.broom_whistle").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.broom_whistle_2").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

