/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.items;

import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public class JarHandler
extends ItemStackHandler {
    public final int stacklimit;

    public JarHandler(int size, int stacklimit) {
        super(size);
        this.stacklimit = stacklimit;
    }

    public boolean isEmpty() {
        return IntStream.range(0, this.getSlots()).allMatch(i -> this.getStackInSlot(i).isEmpty());
    }

    public boolean noValidSlots() {
        return IntStream.range(0, this.getSlots()).mapToObj(arg_0 -> ((JarHandler)this).getStackInSlot(arg_0)).allMatch(ItemStack::isEmpty);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.stacks.set(slot, (Object)stack);
    }

    public int getSlotLimit(int slot) {
        return this.stacklimit;
    }

    public int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return this.stacklimit;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (existing.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int toExtract = Math.min(amount, this.stacklimit);
        if (existing.getCount() <= toExtract) {
            if (!simulate) {
                this.stacks.set(slot, (Object)ItemStack.EMPTY);
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.stacks.set(slot, (Object)existing.copyWithCount(existing.getCount() - toExtract));
            this.onContentsChanged(slot);
        }
        return existing.copyWithCount(toExtract);
    }

    public NonNullList<ItemStack> getContents() {
        return this.stacks;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.getContents().size(); ++i) {
            if (((ItemStack)this.getContents().get(i)).isEmpty()) continue;
            int realCount = Math.min(this.stacklimit, ((ItemStack)this.getContents().get(i)).getCount());
            ItemStack stack = ((ItemStack)this.getContents().get(i)).copyWithCount(1);
            CompoundTag itemTag = new CompoundTag();
            itemTag.putInt("Slot", i);
            itemTag = (CompoundTag)stack.save(provider, (Tag)itemTag);
            itemTag.putInt("ExtendedCount", realCount);
            nbtTagList.add((Object)itemTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.put("Items", (Tag)nbtTagList);
        nbt.putInt("Size", this.getContents().size());
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.setSize(nbt.contains("Size", 3) ? nbt.getInt("Size") : this.getContents().size());
        ListTag tagList = nbt.getList("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.getCompound(i);
            int slot = itemTags.getInt("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)itemTags);
            if (itemTags.contains("ExtendedCount", 3)) {
                stack.setCount(itemTags.getInt("ExtendedCount"));
            }
            this.stacks.set(slot, (Object)stack);
        }
        this.onLoad();
    }
}

