/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.mixin;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import net.joefoxe.hexerei.tileentity.MixingCauldronTile;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={FogRenderer.class})
public abstract class FogRendererMixin {
    private static float fogRed;
    @Shadow
    private static float fogGreen;
    @Shadow
    private static float fogBlue;
    @Shadow
    private static int targetBiomeFog;
    @Shadow
    private static int previousBiomeFog;
    @Shadow
    private static long biomeChangedTime;

    @OnlyIn(value=Dist.CLIENT)
    @Inject(method={"setupColor"}, at={@At(value="HEAD")}, cancellable=true)
    private static void setupColor(Camera pCamera, float pPartialTicks, ClientLevel pLevel, int pRenderDistanceChunks, float pBossColorModifier, CallbackInfo ci) {
        BlockPos cameraPos = pCamera.getBlockPosition();
        Level level = pCamera.getEntity().level();
        BlockEntity be = level.getBlockEntity(cameraPos);
        if (be instanceof MixingCauldronTile) {
            double d1;
            MixingCauldronTile tile = (MixingCauldronTile)be;
            double d0 = pCamera.getPosition().y() - 0.1111111119389534;
            BlockPos blockpos = new BlockPos((int)pCamera.getPosition().x(), (int)d0, (int)pCamera.getPosition().z());
            if (tile.renderedFluid != null && (d1 = (double)((float)blockpos.getY() + (float)tile.renderedFluid.getAmount() / 2000.0f)) > d0) {
                LivingEntity livingentity1;
                FogType fogtype = FogRendererMixin.getFluidInCamera(tile.renderedFluid);
                Entity entity = pCamera.getEntity();
                if (fogtype == FogType.WATER) {
                    long i = Util.getMillis();
                    int j = ((Biome)pLevel.getBiome(new BlockPos((int)pCamera.getPosition().x, (int)pCamera.getPosition().y, (int)pCamera.getPosition().z)).value()).getWaterFogColor();
                    if (biomeChangedTime < 0L) {
                        targetBiomeFog = j;
                        previousBiomeFog = j;
                        biomeChangedTime = i;
                    }
                    int k = targetBiomeFog >> 16 & 0xFF;
                    int l = targetBiomeFog >> 8 & 0xFF;
                    int i1 = targetBiomeFog & 0xFF;
                    int j1 = previousBiomeFog >> 16 & 0xFF;
                    int k1 = previousBiomeFog >> 8 & 0xFF;
                    int l1 = previousBiomeFog & 0xFF;
                    float f = Mth.clamp((float)((float)(i - biomeChangedTime) / 5000.0f), (float)0.0f, (float)1.0f);
                    float f1 = Mth.lerp((float)f, (float)j1, (float)k);
                    float f2 = Mth.lerp((float)f, (float)k1, (float)l);
                    float f3 = Mth.lerp((float)f, (float)l1, (float)i1);
                    fogRed = f1 / 255.0f;
                    fogGreen = f2 / 255.0f;
                    fogBlue = f3 / 255.0f;
                    if (targetBiomeFog != j) {
                        targetBiomeFog = j;
                        previousBiomeFog = Mth.floor((float)f1) << 16 | Mth.floor((float)f2) << 8 | Mth.floor((float)f3);
                        biomeChangedTime = i;
                    }
                } else if (fogtype == FogType.LAVA) {
                    fogRed = 0.6f;
                    fogGreen = 0.1f;
                    fogBlue = 0.0f;
                    biomeChangedTime = -1L;
                } else if (fogtype == FogType.POWDER_SNOW) {
                    fogRed = 0.623f;
                    fogGreen = 0.734f;
                    fogBlue = 0.785f;
                    biomeChangedTime = -1L;
                    RenderSystem.clearColor((float)fogRed, (float)fogGreen, (float)fogBlue, (float)0.0f);
                } else {
                    float f15;
                    float f4 = 0.25f + 0.75f * (float)pRenderDistanceChunks / 32.0f;
                    f4 = 1.0f - (float)Math.pow(f4, 0.25);
                    Vec3 vec3 = pLevel.getSkyColor(pCamera.getPosition(), pPartialTicks);
                    float f6 = (float)vec3.x;
                    float f8 = (float)vec3.y;
                    float f10 = (float)vec3.z;
                    float f11 = Mth.clamp((float)(Mth.cos((float)(pLevel.getTimeOfDay(pPartialTicks) * ((float)Math.PI * 2))) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
                    BiomeManager biomemanager = pLevel.getBiomeManager();
                    Vec3 vec31 = pCamera.getPosition().subtract(2.0, 2.0, 2.0).scale(0.25);
                    Vec3 vec32 = CubicSampler.gaussianSampleVec3((Vec3)vec31, (p_109033_, p_109034_, p_109035_) -> pLevel.effects().getBrightnessDependentFogColor(Vec3.fromRGB24((int)((Biome)biomemanager.getNoiseBiomeAtQuart(p_109033_, p_109034_, p_109035_).value()).getFogColor()), f11));
                    fogRed = (float)vec32.x();
                    fogGreen = (float)vec32.y();
                    fogBlue = (float)vec32.z();
                    if (pRenderDistanceChunks >= 4) {
                        float[] afloat;
                        float f12 = Mth.sin((float)pLevel.getSunAngle(pPartialTicks)) > 0.0f ? -1.0f : 1.0f;
                        Vector3f vector3f = new Vector3f(f12, 0.0f, 0.0f);
                        float f16 = pCamera.getLookVector().dot((Vector3fc)vector3f);
                        if (f16 < 0.0f) {
                            f16 = 0.0f;
                        }
                        if (f16 > 0.0f && (afloat = pLevel.effects().getSunriseColor(pLevel.getTimeOfDay(pPartialTicks), pPartialTicks)) != null) {
                            fogRed = fogRed * (1.0f - (f16 *= afloat[3])) + afloat[0] * f16;
                            fogGreen = fogGreen * (1.0f - f16) + afloat[1] * f16;
                            fogBlue = fogBlue * (1.0f - f16) + afloat[2] * f16;
                        }
                    }
                    fogRed += (f6 - fogRed) * f4;
                    fogGreen += (f8 - fogGreen) * f4;
                    fogBlue += (f10 - fogBlue) * f4;
                    float f13 = pLevel.getRainLevel(pPartialTicks);
                    if (f13 > 0.0f) {
                        float f14 = 1.0f - f13 * 0.5f;
                        float f17 = 1.0f - f13 * 0.4f;
                        fogRed *= f14;
                        fogGreen *= f14;
                        fogBlue *= f17;
                    }
                    if ((f15 = pLevel.getThunderLevel(pPartialTicks)) > 0.0f) {
                        float f18 = 1.0f - f15 * 0.5f;
                        fogRed *= f18;
                        fogGreen *= f18;
                        fogBlue *= f18;
                    }
                    biomeChangedTime = -1L;
                }
                float f5 = ((float)pCamera.getPosition().y - (float)pLevel.getMinBuildHeight()) * pLevel.getLevelData().getClearColorScale();
                if (f5 < 1.0f && fogtype != FogType.LAVA && fogtype != FogType.POWDER_SNOW) {
                    if (f5 < 0.0f) {
                        f5 = 0.0f;
                    }
                    f5 *= f5;
                    fogRed *= f5;
                    fogGreen *= f5;
                    fogBlue *= f5;
                }
                if (pBossColorModifier > 0.0f) {
                    fogRed = fogRed * (1.0f - pBossColorModifier) + fogRed * 0.7f * pBossColorModifier;
                    fogGreen = fogGreen * (1.0f - pBossColorModifier) + fogGreen * 0.6f * pBossColorModifier;
                    fogBlue = fogBlue * (1.0f - pBossColorModifier) + fogBlue * 0.6f * pBossColorModifier;
                }
                float f7 = fogtype == FogType.WATER ? (entity instanceof LocalPlayer ? ((LocalPlayer)entity).getWaterVision() : 1.0f) : (entity instanceof LivingEntity && (livingentity1 = (LivingEntity)entity).hasEffect(MobEffects.NIGHT_VISION) && !livingentity1.hasEffect(MobEffects.DARKNESS) ? GameRenderer.getNightVisionScale((LivingEntity)livingentity1, (float)pPartialTicks) : 0.0f);
                if (fogRed != 0.0f && fogGreen != 0.0f && fogBlue != 0.0f) {
                    float f9 = Math.min(1.0f / fogRed, Math.min(1.0f / fogGreen, 1.0f / fogBlue));
                    fogRed = fogRed * (1.0f - f7) + fogRed * f9 * f7;
                    fogGreen = fogGreen * (1.0f - f7) + fogGreen * f9 * f7;
                    fogBlue = fogBlue * (1.0f - f7) + fogBlue * f9 * f7;
                }
                Vector3f fogColor = FogRendererMixin.getFogColor(pCamera, pPartialTicks, pLevel, pRenderDistanceChunks, pBossColorModifier, fogRed, fogGreen, fogBlue, tile.renderedFluid);
                fogRed = fogColor.x();
                fogGreen = fogColor.y();
                fogBlue = fogColor.z();
                RenderSystem.clearColor((float)fogRed, (float)fogGreen, (float)fogBlue, (float)0.0f);
                ci.cancel();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @Inject(method={"setupFog"}, at={@At(value="HEAD")}, cancellable=true)
    private static void setupFog(Camera pCamera, FogRenderer.FogMode pFogMode, float pFarPlaneDistance, boolean p_234176_, float p_234177_, CallbackInfo ci) {
        BlockPos cameraPos = pCamera.getBlockPosition();
        Level level = pCamera.getEntity().level();
        BlockEntity be = level.getBlockEntity(cameraPos);
        if (be instanceof MixingCauldronTile) {
            double d1;
            MixingCauldronTile tile = (MixingCauldronTile)be;
            double d0 = pCamera.getPosition().y() - 0.1111111119389534;
            BlockPos blockpos = new BlockPos((int)pCamera.getPosition().x(), (int)d0, (int)pCamera.getPosition().z());
            if (tile.renderedFluid != null && (d1 = (double)((float)blockpos.getY() + (float)tile.renderedFluid.getAmount() / 2000.0f)) > d0) {
                FogType fogtype = FogRendererMixin.getFluidInCamera(tile.renderedFluid);
                Entity entity = pCamera.getEntity();
                HexereiUtil.FogData fogrenderer$fogdata = new HexereiUtil.FogData(pFogMode);
                fogrenderer$fogdata.start = -8.0f;
                fogrenderer$fogdata.end = 96.0f;
                if (entity instanceof LocalPlayer) {
                    LocalPlayer localplayer = (LocalPlayer)entity;
                    fogrenderer$fogdata.end *= Math.max(0.25f, FogRendererMixin.getWaterVision(localplayer));
                    Holder holder = localplayer.level().getBiome(localplayer.blockPosition());
                    if (holder.is(BiomeTags.HAS_CLOSER_WATER_FOG)) {
                        fogrenderer$fogdata.end *= 0.85f;
                    }
                }
                if (fogrenderer$fogdata.end > pFarPlaneDistance) {
                    fogrenderer$fogdata.end = pFarPlaneDistance;
                    fogrenderer$fogdata.shape = FogShape.CYLINDER;
                }
                RenderSystem.setShaderFogStart((float)fogrenderer$fogdata.start);
                RenderSystem.setShaderFogEnd((float)fogrenderer$fogdata.end);
                RenderSystem.setShaderFogShape((FogShape)fogrenderer$fogdata.shape);
                FogRendererMixin.onFogRender(pFogMode, fogtype, pCamera, p_234177_, pFarPlaneDistance, fogrenderer$fogdata.start, fogrenderer$fogdata.end, fogrenderer$fogdata.shape, tile.renderedFluid.getFluid());
                ci.cancel();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static float getWaterVision(LocalPlayer localPlayer) {
        float f = 600.0f;
        float f1 = 100.0f;
        if (localPlayer.getWaterVision() >= 600.0f) {
            return 1.0f;
        }
        float f2 = Mth.clamp((float)((float)localPlayer.waterVisionTime / 100.0f), (float)0.0f, (float)1.0f);
        float f3 = (float)localPlayer.waterVisionTime < 100.0f ? 0.0f : Mth.clamp((float)(((float)localPlayer.waterVisionTime - 100.0f) / 500.0f), (float)0.0f, (float)1.0f);
        return f2 * 0.6f + f3 * 0.39999998f;
    }

    private static FogType getFluidInCamera(FluidStack fluidStack) {
        if (fluidStack.getFluid().is(FluidTags.WATER)) {
            return FogType.WATER;
        }
        if (fluidStack.getFluid().is(FluidTags.LAVA)) {
            return FogType.LAVA;
        }
        return FogType.NONE;
    }

    private static Vector3f getFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, float fogRed, float fogGreen, float fogBlue, FluidStack fluid) {
        Vector3f in = new Vector3f(fogRed, fogGreen, fogBlue);
        Vector3f fluidFogColor = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).modifyFogColor(camera, partialTick, level, renderDistance, darkenWorldAmount, in);
        if (fluidFogColor.equals((Object)in) && BuiltInRegistries.FLUID.getKey((Object)fluid.getFluid()).getPath().equals("potion")) {
            float[] f = HexereiUtil.rgbIntToFloatArray(((PotionContents)fluid.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).getColor());
            fluidFogColor = new Vector3f(f[0], f[1], f[2]);
        }
        ViewportEvent.ComputeFogColor event = new ViewportEvent.ComputeFogColor(camera, partialTick, fluidFogColor.x(), fluidFogColor.y(), fluidFogColor.z());
        NeoForge.EVENT_BUS.post((Event)event);
        fluidFogColor.set(event.getRed(), event.getGreen(), event.getBlue());
        return fluidFogColor;
    }

    private static void onFogRender(FogRenderer.FogMode mode, FogType type, Camera camera, float partialTick, float renderDistance, float nearDistance, float farDistance, FogShape shape, Fluid fluid) {
        IClientFluidTypeExtensions.of((Fluid)fluid).modifyFogRender(camera, mode, renderDistance, partialTick, nearDistance, farDistance, shape);
        ViewportEvent.RenderFog event = new ViewportEvent.RenderFog(mode, type, camera, partialTick, nearDistance, farDistance, shape);
        if (NeoForge.EVENT_BUS.post((Event)event) != null) {
            RenderSystem.setShaderFogStart((float)event.getNearPlaneDistance());
            RenderSystem.setShaderFogEnd((float)event.getFarPlaneDistance());
            RenderSystem.setShaderFogShape((FogShape)event.getFogShape());
        }
    }

    static {
        targetBiomeFog = -1;
        previousBiomeFog = -1;
        biomeChangedTime = -1L;
    }
}

