/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.mixin;

import net.joefoxe.hexerei.client.renderer.entity.custom.BroomEntity;
import net.joefoxe.hexerei.config.ModKeyBindings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientCommonPacketListenerImpl;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.CommonListenerCookie;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={ClientPacketListener.class})
public abstract class HexereiClientPacketListenerMixin
extends ClientCommonPacketListenerImpl {
    @Shadow
    public abstract ClientLevel getLevel();

    protected HexereiClientPacketListenerMixin(Minecraft minecraft, Connection connection, CommonListenerCookie commonListenerCookie) {
        super(minecraft, connection, commonListenerCookie);
    }

    @Inject(at={@At(value="HEAD")}, method={"handleSetEntityPassengersPacket"}, cancellable=true)
    private void passengersPacket(ClientboundSetPassengersPacket packet, CallbackInfo ci) {
        PacketUtils.ensureRunningOnSameThread((Packet)packet, (PacketListener)((ClientPacketListener)this), (BlockableEventLoop)this.minecraft);
        Entity entity = this.getLevel().getEntity(packet.getVehicle());
        if (entity instanceof BroomEntity) {
            BroomEntity broom = (BroomEntity)entity;
            if (this.minecraft.player != null) {
                boolean flag = broom.hasIndirectPassenger((Entity)this.minecraft.player);
                broom.ejectPassengers();
                for (int i : packet.getPassengers()) {
                    Entity entity1 = this.getLevel().getEntity(i);
                    if (entity1 == null) continue;
                    entity1.startRiding((Entity)broom, true);
                    if (entity1 != this.minecraft.player || flag) continue;
                    MutableComponent component = Component.translatable((String)"mount.onboard", (Object[])new Object[]{ModKeyBindings.broomDismount.getTranslatedKeyMessage()});
                    this.minecraft.gui.setOverlayMessage((Component)component, false);
                    this.minecraft.getNarrator().sayNow((Component)component);
                }
                ci.cancel();
            }
        }
    }
}

