/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.particle;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ExtinguishParticle
extends TextureSheetParticle {
    protected float scale;
    protected float rotationDir;
    protected float fallingSpeed;
    protected double xdStart;
    protected double ydStart;
    protected double zdStart;
    protected double ydExtra;

    public ExtinguishParticle(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z);
        this.xd = motionX;
        this.yd = motionY;
        this.zd = motionZ;
        this.xdStart = motionX;
        this.ydStart = motionY;
        this.zdStart = motionZ;
        this.ydExtra = (double)new Random().nextFloat() * (motionY / 10.0);
        this.rotationDir = new Random().nextFloat() - 0.5f;
        this.fallingSpeed = new Random().nextFloat();
        this.lifetime = 50 + (int)(new Random().nextFloat() * 50.0f);
        this.quadSize = 0.25f + 0.25f * new Random().nextFloat();
        this.setScale(0.2f);
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.setSize(scale * 0.5f, scale * 0.5f);
    }

    public void tick() {
        this.xd = (double)Math.min(1.0f, (float)(this.lifetime - this.age) / (float)this.lifetime) * this.xdStart;
        this.yd = (double)Math.min(1.0f, (float)this.age / (float)this.lifetime) * this.ydStart + this.ydExtra;
        this.zd = (double)Math.min(1.0f, (float)(this.lifetime - this.age) / (float)this.lifetime) * this.zdStart;
        this.alpha = Math.min(1.0f, (float)(this.lifetime - this.age) / (float)this.lifetime);
        super.tick();
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Random rand = new Random();
            float colorOffset = rand.nextFloat() * 0.6f;
            ExtinguishParticle extinguishParticle = new ExtinguishParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
            extinguishParticle.pickSprite(this.spriteSet);
            extinguishParticle.setColor(0.8f - colorOffset, 0.8f - colorOffset, 0.8f - colorOffset);
            return extinguishParticle;
        }
    }
}

