/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.Altar;
import net.joefoxe.hexerei.data.books.BookChapter;
import net.joefoxe.hexerei.data.books.BookEntity;
import net.joefoxe.hexerei.data.books.BookEntries;
import net.joefoxe.hexerei.data.books.BookManager;
import net.joefoxe.hexerei.data.books.BookPage;
import net.joefoxe.hexerei.data.books.BookPageEntry;
import net.joefoxe.hexerei.data.books.HexereiBookItem;
import net.joefoxe.hexerei.data.books.PageDrawing;
import net.joefoxe.hexerei.item.ModDataComponents;
import net.joefoxe.hexerei.item.data_components.BookData;
import net.joefoxe.hexerei.tileentity.BookOfShadowsAltarTile;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.tileentity.renderer.CrystalBallRenderer;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.message.UpdateBookDataToServer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;

public class BookOfShadowsScreen
extends Screen {
    public final BookOfShadowsAltarTile altar;
    protected int left;
    protected int top;
    int img_width = 244;
    int img_height = 170;
    float mouseGrabbedX = 0.0f;
    float mouseGrabbedY = 0.0f;
    ItemStack fromItem = null;
    Player player;
    InteractionHand hand;
    float flippingFast = 0.0f;
    float flippingFastO = 0.0f;

    public BookOfShadowsScreen(BookOfShadowsAltarTile altar) {
        super((Component)Component.translatable((String)"screen.hexerei.book_of_shadows"));
        this.minecraft = Minecraft.getInstance();
        this.altar = altar;
    }

    public BookOfShadowsScreen(Player player, InteractionHand hand) {
        super((Component)Component.translatable((String)"screen.hexerei.book_of_shadows"));
        ItemStack stack = player.getItemInHand(hand);
        this.player = player;
        this.hand = hand;
        this.minecraft = Minecraft.getInstance();
        this.fromItem = stack;
        this.altar = (BookOfShadowsAltarTile)((BlockEntityType)ModTileEntities.BOOK_OF_SHADOWS_ALTAR_TILE.get()).create(BlockPos.ZERO, ((Altar)ModBlocks.BOOK_OF_SHADOWS_ALTAR.get()).defaultBlockState());
        if (this.altar != null) {
            this.altar.currentBook = (BookData)stack.getOrDefault(ModDataComponents.BOOK, (Object)BookData.EMPTY);
            this.altar.fromItem = true;
            if (this.altar.currentBook.isOpened()) {
                this.altar.openedPercent = 0.5f;
                this.altar.floppedPercent = 0.5f;
            }
        } else {
            this.onClose();
        }
    }

    protected void init() {
        this.left = this.width / 2 - this.img_width / 2;
        this.top = this.height / 2 - this.img_height / 2;
    }

    public Vec2 getLeftCursor(int mouseX, int mouseY) {
        float inputXl = ((float)mouseX - ((float)this.left + (float)this.img_width / 2.0f) + 123.0f) / 123.0f * 6.55f - 0.5f;
        float inputYl = ((float)mouseY - ((float)this.top + (float)this.img_height / 2.0f) + 87.0f) / 174.0f * 9.1f - 1.0f;
        return new Vec2(inputXl, inputYl);
    }

    public Vec2 getRightCursor(int mouseX, int mouseY) {
        float inputXr = ((float)mouseX - ((float)this.left + (float)this.img_width / 2.0f)) / 123.0f * 6.55f - 0.5f + 0.25f;
        float inputYr = ((float)mouseY - ((float)this.top + (float)this.img_height / 2.0f) + 87.0f) / 174.0f * 9.1f - 1.0f;
        return new Vec2(inputXr, inputYr);
    }

    private float easeInOutElastic(double x) {
        double c5 = 1.3962634015954636;
        return (float)(x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : (x < 0.5 ? 4.0 * x * x * x : Math.pow(2.0, -20.0 * x + 10.0) * Math.sin((20.0 * x - 11.125) * c5) / 2.0 + 1.0)));
    }

    public static float easeOutBack(float x) {
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        return 1.0f + c3 * (float)Math.pow(x - 1.0f, 3.0) + c1 * (float)Math.pow(x - 1.0f, 2.0);
    }

    public void render(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float pPartialTick) {
        ItemStack stack;
        ItemStack itemStack = stack = this.fromItem != null ? this.fromItem : this.altar.itemHandler.getStackInSlot(0);
        if (!(stack.getItem() instanceof HexereiBookItem)) {
            return;
        }
        Vec2 left = this.getLeftCursor(mouseX, mouseY);
        Vec2 right = this.getRightCursor(mouseX, mouseY);
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate((float)this.left + (float)this.img_width / 2.0f, (float)this.top + (float)this.img_height / 2.0f, 1500.0f);
        Lighting.setupForFlatItems();
        float scale = 298.75f;
        float guiScale = (float)Minecraft.getInstance().getWindow().getGuiScale();
        if ((int)guiScale == 3) {
            scale = 306.38f;
        }
        if ((int)guiScale == 4) {
            scale = 298.86f;
        }
        if ((int)guiScale == 5) {
            scale = 294.11f;
        }
        scale = 306.38f;
        this.altar.degreesSpunRender = CrystalBallRenderer.lerpAngle(this.altar.degreesSpunOld, this.altar.degreesSpun, pPartialTick);
        this.altar.buttonScaleRender = Math.max(0.0f, BookOfShadowsAltarTile.easeButtons(Mth.lerp((float)pPartialTick, (float)this.altar.buttonScaleOld, (float)this.altar.buttonScale)));
        this.altar.degreesOpenedRender = BookOfShadowsAltarTile.easeOpened(Mth.lerp((float)pPartialTick, (float)this.altar.openedPercentOld, (float)this.altar.openedPercent)) * 90.0f;
        this.altar.degreesFloppedRender = BookOfShadowsAltarTile.easeFlop(Mth.lerp((float)pPartialTick, (float)this.altar.floppedPercentOld, (float)this.altar.floppedPercent)) * 90.0f;
        this.altar.pageOneRotationRender = Mth.lerp((float)pPartialTick, (float)this.altar.pageOneRotationLast, (float)this.altar.pageOneRotation);
        this.altar.pageTwoRotationRender = Mth.lerp((float)pPartialTick, (float)this.altar.pageTwoRotationLast, (float)this.altar.pageTwoRotation);
        this.altar.degreesOpenedRender = this.altar.turnPage == 1 || this.altar.turnPage == 2 ? (this.altar.degreesOpenedRender += Mth.sin((float)(this.altar.pageOneRotationRender / 180.0f * (float)Math.PI)) * 5.0f + Mth.sin((float)(this.altar.pageTwoRotationRender / 180.0f * (float)Math.PI)) * 5.0f) : (this.altar.degreesOpenedRender += Mth.abs((float)Mth.sin((float)(Mth.lerp((float)pPartialTick, (float)this.flippingFastO, (float)this.flippingFast) * (float)Math.PI / 2.0f))) * 25.0f);
        pGuiGraphics.pose().scale(scale, -scale, scale);
        pGuiGraphics.pose().mulPose(Axis.YP.rotationDegrees(this.altar.degreesFloppedRender));
        pGuiGraphics.pose().translate(0.0f, 0.0f, 0.5f);
        pGuiGraphics.pose().mulPose(Axis.XP.rotationDegrees(Mth.sin((float)(Math.max(0.0f, this.altar.degreesOpenedRender) / 90.0f * (float)Math.PI)) * -7.5f));
        if (this.altar.turnPage == 1 || this.altar.turnPage == 2) {
            pGuiGraphics.pose().mulPose(Axis.XP.rotationDegrees(Mth.sin((float)(this.altar.pageOneRotationRender / 180.0f * (float)Math.PI)) * -10.0f));
            pGuiGraphics.pose().mulPose(Axis.XP.rotationDegrees(Mth.sin((float)(this.altar.pageTwoRotationRender / 180.0f * (float)Math.PI)) * -10.0f));
        }
        pGuiGraphics.pose().mulPose(Axis.XP.rotationDegrees(Mth.sin((float)(Mth.lerp((float)pPartialTick, (float)this.flippingFastO, (float)this.flippingFast) * (float)Math.PI / 2.0f)) * -5.0f));
        pGuiGraphics.pose().translate(0.0f, 0.0f, -0.5f);
        pGuiGraphics.pose().translate(-0.5f, -1.4375f, -0.5f);
        pGuiGraphics.pose().translate(0.0041f, 0.0f, 0.0f);
        MultiBufferSource.BufferSource buffer = pGuiGraphics.bufferSource();
        boolean isBookOfShadows = this.altar.currentBook != null && this.altar.currentBook.book().equals((Object)HexereiUtil.getResource("book_of_shadows"));
        float degreesSpunRender = this.altar.degreesSpunRender;
        float degreesOpenedRender = this.altar.degreesOpenedRender;
        float floppedPercent = this.altar.floppedPercent;
        float degreesFloppedRender = this.altar.degreesFloppedRender;
        this.altar.degreesSpunRender = -180.0f;
        this.altar.degreesOpenedRender = Math.clamp(this.altar.degreesOpenedRender, 0.0f, 90.0f);
        this.altar.floppedPercent = 0.0f;
        this.altar.degreesFloppedRender = 0.0f;
        DyeColor col = HexereiUtil.getDyeColorNamed(stack.getHoverName().getString());
        Lighting.setupForFlatItems();
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate(0.5f, 1.125f, 0.5f);
        pGuiGraphics.pose().translate((float)Math.sin(this.altar.degreesSpunRender / 57.3f) / 32.0f * (this.altar.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(this.altar.degreesSpunRender / 57.3f) / 32.0f * (this.altar.degreesOpenedRender / 5.0f - 12.0f));
        pGuiGraphics.pose().translate(0.0f, (BookOfShadowsAltarTile.easeFlop(1.0f - this.altar.degreesFlopped / 90.0f) - 1.0f) / 16.0f, 0.0f);
        pGuiGraphics.pose().mulPose(Axis.YP.rotationDegrees(this.altar.degreesSpunRender));
        pGuiGraphics.pose().mulPose(Axis.XP.rotationDegrees(-90.0f));
        pGuiGraphics.pose().mulPose(Axis.YP.rotationDegrees(-this.altar.degreesFloppedRender));
        pGuiGraphics.pose().translate(0.0f, 0.0f, -(this.altar.degreesFloppedRender / 10.0f) / 32.0f);
        pGuiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(this.altar.degreesOpenedRender - 90.0f));
        pGuiGraphics.pose().translate(0.03125f * (this.altar.degreesOpenedRender / 90.0f), 0.03125f * (1.0f - this.altar.degreesOpenedRender / 90.0f), 0.0f);
        pGuiGraphics.pose().translate(0.001953125f, 0.0f, 0.0f);
        if (isBookOfShadows) {
            this.renderBlock(pGuiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0, ((Block)ModBlocks.BOOK_OF_SHADOWS_COVER.get()).defaultBlockState(), HexereiBookItem.getColor2(stack));
            this.renderBlock(pGuiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0, ((Block)ModBlocks.BOOK_OF_SHADOWS_COVER_CORNERS.get()).defaultBlockState(), col == null ? HexereiBookItem.getColor1(stack) : HexereiUtil.getColorValue(col));
        } else {
            this.renderBlock(pGuiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0, ((Block)ModBlocks.BOOK_COVER.get()).defaultBlockState(), HexereiBookItem.getColor2(stack));
            this.renderBlock(pGuiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0, ((Block)ModBlocks.BOOK_COVER_CORNERS.get()).defaultBlockState(), col == null ? HexereiBookItem.getColor1(stack) : HexereiUtil.getColorValue(col));
        }
        pGuiGraphics.pose().popPose();
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate(0.5f, 1.125f, 0.5f);
        pGuiGraphics.pose().translate((float)Math.sin(this.altar.degreesSpunRender / 57.3f) / 32.0f * (this.altar.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(this.altar.degreesSpunRender / 57.3f) / 32.0f * (this.altar.degreesOpenedRender / 5.0f - 12.0f));
        pGuiGraphics.pose().translate(0.0f, (BookOfShadowsAltarTile.easeFlop(1.0f - this.altar.degreesFlopped / 90.0f) - 1.0f) / 16.0f, 0.0f);
        pGuiGraphics.pose().mulPose(Axis.YP.rotationDegrees(this.altar.degreesSpunRender));
        pGuiGraphics.pose().mulPose(Axis.XP.rotationDegrees(-90.0f));
        pGuiGraphics.pose().mulPose(Axis.YP.rotationDegrees(-this.altar.degreesFloppedRender));
        pGuiGraphics.pose().translate(0.0f, 0.0f, -(this.altar.degreesFloppedRender / 10.0f) / 32.0f);
        pGuiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(-(this.altar.degreesOpenedRender - 90.0f)));
        pGuiGraphics.pose().translate(-0.03125f * (this.altar.degreesOpenedRender / 90.0f), 0.03125f * (1.0f - this.altar.degreesOpenedRender / 90.0f), 0.0f);
        pGuiGraphics.pose().translate(-0.001953125f, 0.0f, 0.0f);
        if (isBookOfShadows) {
            this.renderBlock(pGuiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0, ((Block)ModBlocks.BOOK_OF_SHADOWS_BACK.get()).defaultBlockState(), HexereiBookItem.getColor2(stack));
            this.renderBlock(pGuiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0, ((Block)ModBlocks.BOOK_OF_SHADOWS_BACK_CORNERS.get()).defaultBlockState(), col == null ? HexereiBookItem.getColor1(stack) : HexereiUtil.getColorValue(col));
        } else {
            this.renderBlock(pGuiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0, ((Block)ModBlocks.BOOK_BACK.get()).defaultBlockState(), HexereiBookItem.getColor2(stack));
            this.renderBlock(pGuiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0, ((Block)ModBlocks.BOOK_BACK_CORNERS.get()).defaultBlockState(), col == null ? HexereiBookItem.getColor1(stack) : HexereiUtil.getColorValue(col));
        }
        pGuiGraphics.pose().popPose();
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate(0.5f, 1.125f, 0.5f);
        pGuiGraphics.pose().translate((float)Math.sin(this.altar.degreesSpunRender / 57.3f) / 32.0f * (this.altar.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(this.altar.degreesSpunRender / 57.3f) / 32.0f * (this.altar.degreesOpenedRender / 5.0f - 12.0f));
        pGuiGraphics.pose().translate(0.0f, (BookOfShadowsAltarTile.easeFlop(1.0f - this.altar.degreesFlopped / 90.0f) - 1.0f) / 16.0f, 0.0f);
        pGuiGraphics.pose().mulPose(Axis.YP.rotationDegrees(this.altar.degreesSpunRender));
        pGuiGraphics.pose().mulPose(Axis.XP.rotationDegrees(-90.0f));
        pGuiGraphics.pose().mulPose(Axis.YP.rotationDegrees(-this.altar.degreesFloppedRender));
        pGuiGraphics.pose().translate(0.0f, 0.0f, -(this.altar.degreesFloppedRender / 10.0f) / 32.0f);
        if (isBookOfShadows) {
            this.renderBlock(pGuiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0, ((Block)ModBlocks.BOOK_OF_SHADOWS_BINDING.get()).defaultBlockState(), HexereiBookItem.getColor2(stack));
        } else {
            this.renderBlock(pGuiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0, ((Block)ModBlocks.BOOK_BINDING.get()).defaultBlockState(), HexereiBookItem.getColor2(stack));
        }
        pGuiGraphics.pose().popPose();
        if (buffer instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource multiBufferSource = buffer;
            multiBufferSource.endBatch();
        }
        Lighting.setupForFlatItems();
        if (this.altar.openedPercent != 1.0f) {
            this.altar.drawing.drawPages(this.altar, left.x, left.y, right.x, right.y, pGuiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.NO_OVERLAY, pPartialTick, PageDrawing.DrawingType.SCREEN);
        }
        buffer.endBatch();
        pGuiGraphics.pose().popPose();
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate(0.0f, 0.0f, 2500.0f);
        Lighting.setupForFlatItems();
        if (this.altar.currentBook.isOpened() && this.altar.openedPercent < 0.15f && this.altar.turnPage == 0 && (this.altar.drawing.drawTooltipStack || this.altar.drawing.drawTooltipText)) {
            List<Object> tooltip;
            List<Object> list = this.altar.drawing.tooltipStack != null && !this.altar.drawing.tooltipStack.isEmpty() ? this.altar.drawing.tooltipStack.getTooltipLines(Item.TooltipContext.EMPTY, Hexerei.proxy.getPlayer(), (TooltipFlag)(Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL)) : (tooltip = new ArrayList<Component>());
            if (!tooltip.isEmpty()) {
                tooltip.addAll(this.altar.drawing.tooltipText);
            } else {
                tooltip = this.altar.drawing.tooltipText;
            }
            if (this.altar.drawing.tooltipStack != null && !this.altar.drawing.tooltipStack.isEmpty()) {
                String modId = HexereiUtil.getRegistryName(this.altar.drawing.tooltipStack.getItem()).getNamespace();
                String modName = PageDrawing.getModNameForModId(modId);
                MutableComponent modNameComponent = Component.translatable((String)modName);
                modNameComponent.withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(0x5555FF));
                if (tooltip.isEmpty() || !((Component)tooltip.getLast()).getString().equals(modName)) {
                    tooltip.add(modNameComponent);
                }
            }
            pGuiGraphics.renderTooltip(this.font, tooltip, this.altar.drawing.tooltipStack != null && !this.altar.drawing.tooltipStack.isEmpty() ? this.altar.drawing.tooltipStack.getTooltipImage() : Optional.empty(), mouseX, mouseY);
        }
        pGuiGraphics.pose().popPose();
        this.altar.degreesSpunRender = degreesSpunRender;
        this.altar.degreesOpenedRender = degreesOpenedRender;
        this.altar.floppedPercent = floppedPercent;
        this.altar.degreesFloppedRender = degreesFloppedRender;
        Lighting.setupFor3DItems();
        super.render(pGuiGraphics, mouseX, mouseY, pPartialTick);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        Vec2 left = this.getLeftCursor((int)mouseX, (int)mouseY);
        Vec2 right = this.getRightCursor((int)mouseX, (int)mouseY);
        if (this.altar.openedPercent < 0.15f && this.altar.drawing.releaseClick(this.altar, (Player)Minecraft.getInstance().player, left.x, left.y, right.x, right.y, PageDrawing.DrawingType.SCREEN)) {
            if (this.fromItem != null) {
                HexereiPacketHandler.sendToServer(new UpdateBookDataToServer(this.hand, this.altar.currentBook));
            }
            return true;
        }
        MouseHandler handler = Minecraft.getInstance().mouseHandler;
        if (handler.mouseGrabbed) {
            handler.mouseGrabbed = false;
            InputConstants.grabOrReleaseMouse((long)this.minecraft.getWindow().getWindow(), (int)212993, (double)0.0, (double)0.0);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public void onClose() {
        PageDrawing.clearFocusedWritableTextBox();
        if (this.fromItem != null) {
            HexereiPacketHandler.sendToServer(new UpdateBookDataToServer(this.hand, this.altar.currentBook));
        }
        MouseHandler handler = Minecraft.getInstance().mouseHandler;
        if (handler.mouseGrabbed) {
            InputConstants.grabOrReleaseMouse((long)this.minecraft.getWindow().getWindow(), (int)212993, (double)0.0, (double)0.0);
        }
        super.onClose();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Vec2 left = this.getLeftCursor((int)mouseX, (int)mouseY);
        Vec2 right = this.getRightCursor((int)mouseX, (int)mouseY);
        if (!this.altar.currentBook.isOpened() && this.altar.openedPercent > 0.75f) {
            this.altar.currentBook = this.altar.currentBook.setOpened(true);
            if (this.fromItem != null) {
                HexereiPacketHandler.sendToServer(new UpdateBookDataToServer(this.hand, this.altar.currentBook));
            }
        } else if (this.altar.openedPercent < 0.35f && this.altar.drawing.interactClick(this.altar, (Player)Minecraft.getInstance().player, left.x, left.y, right.x, right.y, PageDrawing.DrawingType.SCREEN)) {
            if (this.fromItem != null) {
                HexereiPacketHandler.sendToServer(new UpdateBookDataToServer(this.hand, this.altar.currentBook));
            }
            boolean clicked = false;
            BookEntries bookEntries = BookManager.getBookEntries(this.altar.currentBook.getBook());
            if (bookEntries != null) {
                for (BookChapter bookChapter : bookEntries.chapterList) {
                    for (BookPageEntry bookPageEntry : bookChapter.pages) {
                        BookPage page = BookManager.getBookPages(this.altar.currentBook.getBook(), ResourceLocation.parse((String)bookPageEntry.location));
                        if (page == null) continue;
                        for (BookEntity bookEntity : page.entityList) {
                            if (!bookEntity.markedForUpdate || !bookEntity.clicked) continue;
                            clicked = true;
                        }
                    }
                }
            }
            MouseHandler handler = Minecraft.getInstance().mouseHandler;
            if (!handler.mouseGrabbed && clicked) {
                handler.mouseGrabbed = true;
                this.mouseGrabbedX = (float)handler.xpos;
                this.mouseGrabbedY = (float)handler.ypos;
                InputConstants.grabOrReleaseMouse((long)this.minecraft.getWindow().getWindow(), (int)212995, (double)this.mouseGrabbedX, (double)this.mouseGrabbedY);
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public Component getTitle() {
        return super.getTitle();
    }

    private void onDone() {
        this.minecraft.setScreen(null);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void tick() {
        this.flippingFastO = this.flippingFast;
        this.flippingFast = this.altar.turnPage == -1 ? HexereiUtil.moveTo(this.flippingFast, 1.0f, 0.025f + 0.1f * (1.0f - this.flippingFast)) : HexereiUtil.moveTo(this.flippingFast, 0.0f, 0.05f + 0.1f * (1.0f - this.flippingFast));
        if (this.fromItem != null) {
            this.altar.tickClient();
            this.altar.tickBook(this.fromItem, true);
        }
        if (!this.isValid()) {
            this.onDone();
        }
    }

    private boolean isValid() {
        if (this.fromItem != null) {
            return this.minecraft != null && this.minecraft.player != null && this.altar != null && this.altar.currentBook != null;
        }
        return this.minecraft != null && this.minecraft.player != null && this.altar != null && this.altar.currentBook != null && this.altar.openedPercent < 1.0f;
    }

    private void renderItem(ItemStack stack, Level level, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, matrixStackIn, bufferIn, level, 1);
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state) {
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, null);
    }

    public void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state, int color) {
        this.renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, color);
    }

    public void renderSingleBlock(BlockState p_110913_, PoseStack p_110914_, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, int color) {
        RenderShape rendershape = p_110913_.getRenderShape();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
                    BakedModel bakedmodel = dispatcher.getBlockModel(p_110913_);
                    int i = color;
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    dispatcher.getModelRenderer().renderModel(p_110914_.last(), p_110915_.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)p_110913_, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, null);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.getBlock());
                    IClientItemExtensions.of((Item)stack.getItem()).getCustomRenderer().renderByItem(stack, ItemDisplayContext.NONE, p_110914_, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }
}

