/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.screen;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.joefoxe.hexerei.client.renderer.entity.custom.OwlEntity;
import net.joefoxe.hexerei.data.owl.ClientOwlCourierDepotData;
import net.joefoxe.hexerei.data.owl.OwlCourierDepotData;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.message.SendOwlCourierPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;

public class OwlCourierSendScreen
extends Screen {
    private final ResourceLocation GUI = HexereiUtil.getResource("textures/gui/owl_courier_delivery_gui.png");
    public final OwlEntity owl;
    private List<ListButton> listButtons = new ArrayList<ListButton>();
    private ListButton sendButton;
    int ticks = 0;
    float scroll = 0.0f;
    float scrollOld = 0.0f;
    float scrollTarget = 0.0f;
    boolean scrollClicked = false;
    double scrollClickedPos = 0.0;
    int img_width = 124;
    int img_height = 164;
    int left;
    int top;
    int button_height = 16;
    int button_space = 3;
    int button_selected = 0;
    ScissorArea scissorArea;
    InteractionHand hand;

    public OwlCourierSendScreen(OwlEntity owl, InteractionHand hand, int selected) {
        super((Component)Component.translatable((String)"hexerei.owl_message.destination"));
        this.minecraft = Minecraft.getInstance();
        this.owl = owl;
        this.hand = hand;
        if (this.minecraft.player != null && selected != this.minecraft.player.getInventory().selected) {
            this.onClose();
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.listButtons.size() > 6) {
            this.scrollTarget = (float)((double)this.scrollTarget + (double)(((float)(this.button_height + this.button_space) + (float)(this.button_height + this.button_space) * Mth.abs((float)(this.scrollTarget - this.scroll))) / (float)(this.listButtons.size() * this.button_height - this.scissorArea.height)) * -scrollY);
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (pMouseX >= (double)(this.left + 250 - 149) && pMouseX < (double)(this.left + 250 - 149 + 10) && pMouseY >= (double)((float)(this.top + 21) + this.scroll * 101.0f) && pMouseY < (double)((float)(this.top + 21 + 5) + this.scroll * 101.0f)) {
            this.scrollClicked = true;
            this.scrollClickedPos = pMouseY - (double)((float)(this.top + 21) + this.scroll * 101.0f);
            return true;
        }
        if (pMouseX >= (double)(this.left + 250 - 149) && pMouseX < (double)(this.left + 250 - 149 + 8) && pMouseY >= (double)(this.top + 21) && pMouseY < (double)(this.top + 21 + 106)) {
            this.scroll = (float)(pMouseY - (double)(this.top + 23)) / 101.0f;
            this.scrollClicked = true;
            this.scrollClickedPos = pMouseY - (double)((float)(this.top + 21) + this.scroll * 101.0f);
        }
        for (ListButton button : this.listButtons) {
            if (!button.isHovered || !button.mouseClicked(pMouseX, pMouseY, pButton)) continue;
            return true;
        }
        if (this.sendButton != null && this.sendButton.isHovered && this.sendButton.mouseClicked(pMouseX, pMouseY, pButton)) {
            return true;
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        this.scrollClicked = false;
        for (ListButton button : this.listButtons) {
            if (!button.isHovered || !button.mouseReleased(pMouseX, pMouseY, pButton)) continue;
            return true;
        }
        if (this.sendButton != null && this.sendButton.isHovered && this.sendButton.mouseReleased(pMouseX, pMouseY, pButton)) {
            return true;
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    protected void init() {
        this.left = this.width / 2 - this.img_width / 2;
        this.top = this.height / 2 - this.img_height / 2;
        this.scissorArea = new ScissorArea(this, this.left + 163 - 149, this.top + 21, 94, 106);
        this.listButtons.clear();
        int i = 0;
        int listSize = ClientOwlCourierDepotData.getDepots().size();
        if (this.minecraft != null && this.minecraft.player != null) {
            ClientPacketListener handler = this.minecraft.player.connection;
            listSize += handler.getOnlinePlayers().size();
            for (PlayerInfo playerInfo : handler.getOnlinePlayers()) {
                int compare = this.minecraft.player.getUUID().compareTo(playerInfo.getProfile().getId());
                if (compare == 0) continue;
                this.listButtons.add(new ListButton(this.left + 163 - 149, this.top + 21 + (this.button_height + this.button_space) * i, listSize < 7 ? 94 : 88, this.button_height, button -> {
                    for (ListButton lb : this.listButtons) {
                        lb.isSelected = false;
                    }
                    button.isSelected = true;
                    this.button_selected = button.index;
                }, button -> {
                    this.onDone();
                    HexereiPacketHandler.sendToServer(new SendOwlCourierPacket((Entity)this.owl, playerInfo.getProfile().getId(), this.hand));
                }, this.scissorArea, playerInfo.getProfile().getName(), true, false, i));
                ++i;
            }
        }
        for (Map.Entry<GlobalPos, OwlCourierDepotData> entry : ClientOwlCourierDepotData.getDepots().entrySet()) {
            this.listButtons.add(new ListButton(this.left + 164 - 149, this.top + 21 + (this.button_height + this.button_space) * i, listSize < 7 ? 94 : 88, this.button_height, button -> {
                for (ListButton lb : this.listButtons) {
                    lb.isSelected = false;
                }
                button.isSelected = true;
                this.button_selected = button.index;
            }, button -> {
                this.onDone();
                HexereiPacketHandler.sendToServer(new SendOwlCourierPacket((Entity)this.owl, (GlobalPos)entry.getKey(), this.hand));
            }, this.scissorArea, entry.getValue().name, false, entry.getValue().isFull(), i));
            ++i;
        }
        if (this.listButtons.isEmpty()) {
            this.minecraft.player.sendSystemMessage((Component)Component.translatable((String)"screen.hexerei.owl_send_screen.no_destinations"));
            this.onDone();
        }
        this.sendButton = new ListButton(this.left + 186 - 149, this.top + 133, 50, this.button_height, button -> this.listButtons.get((int)this.button_selected).onComplete.onPress(this.listButtons.get(this.button_selected)), button -> {}, new ScissorArea(this, this.left + 186 - 149, this.top + 133, 50, this.button_height), "Send", false, false, i){

            @Override
            public int getY(float partialTicks) {
                return this.y;
            }

            @Override
            public void tooltip(List<Component> list) {
                if (this.isHovered() && !this.isDisabled()) {
                    list.add((Component)Component.translatable((String)"screen.hexerei.owl_send_screen.send_to", (Object[])new Object[]{OwlCourierSendScreen.this.listButtons.get((int)OwlCourierSendScreen.this.button_selected).name}).withStyle(Style.EMPTY.withColor(0xAAAAAA)));
                }
            }

            @Override
            public boolean isDisabled() {
                return OwlCourierSendScreen.this.listButtons.get((int)OwlCourierSendScreen.this.button_selected).isDisabled;
            }
        };
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate(0.0f, 0.0f, 5.0f);
        if (this.listButtons.size() > 6) {
            if (this.scrollClicked) {
                this.scrollTarget = this.scroll = Mth.clamp((float)((float)((double)(pMouseY - this.top - 21) - this.scrollClickedPos) / 101.0f), (float)0.0f, (float)1.0f);
                this.scrollOld = this.scroll;
            }
        } else {
            this.scroll = 0.0f;
        }
        float scrollLerp = Mth.lerp((float)pPartialTick, (float)this.scrollOld, (float)this.scroll);
        Lighting.setupForFlatItems();
        pGuiGraphics.drawCenteredString(this.font, this.title, this.width / 2, this.top + 4, 0x333333);
        for (ListButton button : this.listButtons) {
            button.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        }
        if (this.sendButton != null) {
            this.sendButton.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        }
        pGuiGraphics.blit(this.GUI, this.left, this.top, 0, 0, this.img_width, this.img_height);
        if (this.listButtons.size() > 6) {
            pGuiGraphics.blit(this.GUI, this.left + 252 - 149, this.top + 21, 127, 177, 6, 53);
            pGuiGraphics.blit(this.GUI, this.left + 252 - 149, this.top + 21 + 53, 134, 177, 6, 53);
            pGuiGraphics.pose().pushPose();
            pGuiGraphics.pose().translate(0.0f, 0.0f, 5.0f);
            pGuiGraphics.blit(this.GUI, this.left + 250 - 149, this.top + 21 + (int)(101.0f * scrollLerp), 127, 171, 10, 5);
            pGuiGraphics.pose().popPose();
        }
        ArrayList<Component> tooltipLines = new ArrayList<Component>();
        for (ListButton button : this.listButtons) {
            button.tooltip(tooltipLines);
        }
        if (this.sendButton != null) {
            this.sendButton.tooltip(tooltipLines);
        }
        if (!tooltipLines.isEmpty()) {
            pGuiGraphics.renderTooltip(this.font, tooltipLines, Optional.empty(), pMouseX, pMouseY);
        }
        Lighting.setupFor3DItems();
        pGuiGraphics.pose().popPose();
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
    }

    public Component getTitle() {
        return super.getTitle();
    }

    private void onDone() {
        this.minecraft.setScreen(null);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void tick() {
        ++this.ticks;
        this.scrollOld = this.scroll;
        if (this.scroll == 1.0f && this.scrollTarget > 1.0f) {
            this.scrollTarget = 1.0f;
        }
        if (this.scroll == 0.0f && this.scrollTarget < 0.0f) {
            this.scrollTarget = 0.0f;
        }
        float scrollDist = this.listButtons.size() * (this.button_height + this.button_space) - this.scissorArea.height;
        if (this.listButtons.size() > 0) {
            float dist = Mth.abs((float)(scrollDist * this.scrollTarget - scrollDist * this.scroll));
            float scale = dist / scrollDist;
            float speed = scale / 10.0f;
            this.scroll = Mth.clamp((float)HexereiUtil.moveTo(this.scroll, this.scrollTarget, Math.max(speed, 0.002f)), (float)0.0f, (float)1.0f);
        } else {
            this.scrollTarget = 0.0f;
            this.scroll = 0.0f;
        }
        if (!this.isValid()) {
            this.onDone();
        }
    }

    private boolean isValid() {
        return this.minecraft != null && this.minecraft.player != null && this.owl != null && this.owl.distanceTo((Entity)this.minecraft.player) < 8.0f;
    }

    private static void bufferQuad(ResourceLocation atlasLocation, GuiGraphics guiGraphics, float x, float y, float z, float width, float height, float uOffset, float vOffset, int uWidth, int vHeight, int spriteWidth, int spriteHeight, float alpha) {
        OwlCourierSendScreen.blit(guiGraphics, atlasLocation, x, x + width, y, y + height, z, uWidth, vHeight, uOffset, vOffset, spriteWidth, spriteHeight, alpha);
    }

    private static void blit(GuiGraphics guiGraphics, ResourceLocation atlasLocation, float x1, float x2, float y1, float y2, float blitOffset, int uWidth, int vHeight, float uOffset, float vOffset, int textureWidth, int textureHeight, float alpha) {
        OwlCourierSendScreen.innerBlit(guiGraphics, atlasLocation, x1, x2, y1, y2, blitOffset, (uOffset + 0.0f) / (float)textureWidth, (uOffset + (float)uWidth) / (float)textureWidth, (vOffset + 0.0f) / (float)textureHeight, (vOffset + (float)vHeight) / (float)textureHeight, alpha);
    }

    private static void innerBlit(GuiGraphics guiGraphics, ResourceLocation atlasLocation, float x1, float x2, float y1, float y2, float blitOffset, float minU, float maxU, float minV, float maxV, float alpha) {
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        if (alpha == 1.0f) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)atlasLocation);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferbuilder.addVertex(matrix4f, x1, y1, blitOffset).setUv(minU, minV).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha);
            bufferbuilder.addVertex(matrix4f, x1, y2, blitOffset).setUv(minU, maxV).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha);
            bufferbuilder.addVertex(matrix4f, x2, y2, blitOffset).setUv(maxU, maxV).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha);
            bufferbuilder.addVertex(matrix4f, x2, y1, blitOffset).setUv(maxU, minV).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha);
            BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        } else {
            VertexConsumer vertexBuilder = guiGraphics.bufferSource().getBuffer(RenderType.entityTranslucentCull((ResourceLocation)atlasLocation));
            vertexBuilder.addVertex(matrix4f, x1, y1, blitOffset).setUv(minU, minV).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha);
            vertexBuilder.addVertex(matrix4f, x1, y2, blitOffset).setUv(minU, maxV).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha);
            vertexBuilder.addVertex(matrix4f, x2, y2, blitOffset).setUv(maxU, maxV).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha);
            vertexBuilder.addVertex(matrix4f, x2, y1, blitOffset).setUv(maxU, minV).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha);
        }
    }

    public static void nineSlice(ResourceLocation atlasLocation, GuiGraphics guiGraphics, float posX, float posY, float posZ, float width, float height, int sliceLeftWidth, int sliceRightWidth, int sliceTopHeight, int sliceBottomHeight, int spriteWidth, int spriteHeight, float uOffset, float vOffset, int uWidth, int vHeight, float alpha) {
        int middleTextureWidth = uWidth - sliceLeftWidth - sliceRightWidth;
        int middleTextureHeight = vHeight - sliceBottomHeight - sliceTopHeight;
        float topV1 = vOffset + (float)sliceTopHeight;
        float leftU1 = uOffset + (float)sliceLeftWidth;
        float rightU0 = uOffset + (float)uWidth - (float)sliceRightWidth;
        float bottomV0 = vOffset + (float)vHeight - (float)sliceBottomHeight;
        float middleU0 = leftU1 + 1.0f;
        float middleU1 = rightU0 + 1.0f;
        float middleV0 = vOffset + (float)(sliceTopHeight + 1);
        float middleV1 = vOffset + (float)vHeight - (float)(sliceBottomHeight + 1);
        float leftX = posX + (float)sliceLeftWidth;
        float rightX = posX + width - (float)sliceRightWidth;
        float topY = posY + (float)sliceTopHeight;
        float bottomY = posY + height - (float)sliceBottomHeight;
        float middleWidth = rightX - leftX;
        float middleHeight = bottomY - topY;
        OwlCourierSendScreen.bufferQuad(atlasLocation, guiGraphics, posX, posY, posZ, sliceLeftWidth, sliceTopHeight, uOffset, vOffset, sliceLeftWidth, sliceTopHeight, spriteWidth, spriteHeight, alpha);
        OwlCourierSendScreen.bufferQuad(atlasLocation, guiGraphics, rightX, posY, posZ, sliceRightWidth, sliceTopHeight, rightU0, vOffset, sliceRightWidth, sliceTopHeight, spriteWidth, spriteHeight, alpha);
        OwlCourierSendScreen.bufferQuad(atlasLocation, guiGraphics, posX, bottomY, posZ, sliceLeftWidth, sliceBottomHeight, uOffset, bottomV0, sliceRightWidth, sliceTopHeight, spriteWidth, spriteHeight, alpha);
        OwlCourierSendScreen.bufferQuad(atlasLocation, guiGraphics, rightX, bottomY, posZ, sliceRightWidth, sliceBottomHeight, rightU0, bottomV0, sliceRightWidth, sliceTopHeight, spriteWidth, spriteHeight, alpha);
        OwlCourierSendScreen.bufferQuad(atlasLocation, guiGraphics, leftX, posY, posZ, middleWidth, sliceTopHeight, middleU0, vOffset, middleTextureWidth, sliceTopHeight, spriteWidth, spriteHeight, alpha);
        OwlCourierSendScreen.bufferQuad(atlasLocation, guiGraphics, leftX, bottomY, posZ, middleWidth, sliceBottomHeight, middleU0, bottomV0, middleTextureWidth, sliceTopHeight, spriteWidth, spriteHeight, alpha);
        OwlCourierSendScreen.bufferQuad(atlasLocation, guiGraphics, posX, topY, posZ, sliceLeftWidth, middleHeight, uOffset, middleV0, sliceLeftWidth, middleTextureHeight, spriteWidth, spriteHeight, alpha);
        OwlCourierSendScreen.bufferQuad(atlasLocation, guiGraphics, rightX, topY, posZ, sliceRightWidth, middleHeight, rightU0, middleV0, sliceLeftWidth, middleTextureHeight, spriteWidth, spriteHeight, alpha);
        OwlCourierSendScreen.bufferQuad(atlasLocation, guiGraphics, leftX, topY, posZ, middleWidth, middleHeight, middleU0, middleV0 + 1.0f, middleTextureWidth, middleTextureHeight, spriteWidth, spriteHeight, alpha);
        guiGraphics.bufferSource().endBatch();
    }

    private class ScissorArea {
        protected int width;
        protected int height;
        private int x;
        private int y;

        public ScissorArea(OwlCourierSendScreen owlCourierSendScreen, int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }

    private class ListButton {
        protected int width;
        protected int height;
        private int x;
        public int y;
        private boolean isHovered = false;
        private boolean isDisabled;
        private boolean isSelected;
        private OnPress onPress;
        private OnPress onComplete;
        private ScissorArea scissorArea;
        private String name;
        private boolean isPlayerButton;
        private int index;

        public ListButton(int x, int y, int width, int height, OnPress onPress, OnPress onComplete, ScissorArea scissorArea, String name, boolean isPlayerButton, boolean isDisabled, int index) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.onPress = onPress;
            this.onComplete = onComplete;
            this.scissorArea = scissorArea;
            this.name = name;
            this.isPlayerButton = isPlayerButton;
            this.isDisabled = isDisabled;
            this.index = index;
            this.isSelected = index == OwlCourierSendScreen.this.button_selected;
        }

        public boolean isHovered() {
            return this.isHovered;
        }

        public boolean isDisabled() {
            return this.isDisabled;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public int getX() {
            return this.x;
        }

        public int getY(float partialTicks) {
            float scrollLerp = Mth.lerp((float)partialTicks, (float)OwlCourierSendScreen.this.scrollOld, (float)OwlCourierSendScreen.this.scroll);
            return this.y - (int)(scrollLerp * (float)(OwlCourierSendScreen.this.listButtons.size() * (OwlCourierSendScreen.this.button_height + OwlCourierSendScreen.this.button_space) - this.scissorArea.height - OwlCourierSendScreen.this.button_space));
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public void tooltip(List<Component> list) {
            if (this.isHovered()) {
                if (this.isDisabled()) {
                    list.add((Component)Component.translatable((String)"screen.hexerei.owl_send_screen.depot_too_full").withStyle(Style.EMPTY.withColor(0xFFAAAA)));
                } else {
                    list.add((Component)Component.translatable((String)(this.isPlayerButton ? "screen.hexerei.owl_send_screen.to_player" : "screen.hexerei.owl_send_screen.to_depot"), (Object[])new Object[]{this.name}).withStyle(Style.EMPTY.withColor(0xAAAAAA)));
                }
            }
        }

        public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            this.isHovered = pMouseX < this.scissorArea.x || pMouseY < this.scissorArea.y || pMouseX >= this.scissorArea.x + this.scissorArea.width || pMouseY >= this.scissorArea.y + this.scissorArea.height ? false : pMouseX >= this.getX() && pMouseY >= this.getY(pPartialTick) && pMouseX < this.getX() + this.width && pMouseY < this.getY(pPartialTick) + this.height;
            float alpha = 1.0f;
            pGuiGraphics.pose().pushPose();
            pGuiGraphics.pose().translate(0.0f, 0.0f, 4.0f);
            pGuiGraphics.enableScissor(this.scissorArea.x, this.scissorArea.y, this.scissorArea.x + this.scissorArea.width + 1, this.scissorArea.y + this.scissorArea.height);
            Minecraft minecraft = Minecraft.getInstance();
            pGuiGraphics.setColor(1.0f, this.isPlayerButton ? 0.75f : 1.0f, 1.0f, alpha);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            int offset = this.getTextureOffset();
            OwlCourierSendScreen.nineSlice(OwlCourierSendScreen.this.GUI, pGuiGraphics, this.getX(), this.getY(pPartialTick), 0.0f, this.getWidth(), this.getHeight(), 4, 4, 4, 4, 256, 256, 139 + offset, 165.0f, 9, 9, alpha);
            if (this.isDisabled()) {
                pGuiGraphics.setColor(0.5f, 0.5f, 0.5f, 0.5f);
            } else {
                pGuiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            }
            int i = 0xEEEEEE;
            this.renderString(pGuiGraphics, minecraft.font, i | Mth.ceil((float)(alpha * 255.0f)) << 24, pPartialTick);
            pGuiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            pGuiGraphics.disableScissor();
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            pGuiGraphics.pose().popPose();
        }

        public void renderString(GuiGraphics pGuiGraphics, Font pFont, int pColor, float partialTicks) {
            this.renderScrollingString(pGuiGraphics, pFont, 4, pColor, partialTicks);
        }

        private int getTextureOffset() {
            int i = 0;
            if (this.isSelected()) {
                return i + 20;
            }
            if (this.isDisabled()) {
                return i + 10;
            }
            if (this.isHovered()) {
                return i + 30;
            }
            return i;
        }

        protected static void renderScrollingString(GuiGraphics pGuiGraphics, Font pFont, Component pText, int pMinX, int pMinY, int pMaxX, int pMaxY, int pColor, float ticks) {
            int i = pFont.width((FormattedText)pText);
            int j = (pMinY + pMaxY - 9) / 2 + 1;
            int k = pMaxX - pMinX;
            if (i > k) {
                int l = i - k;
                double d0 = (double)ticks / 20.0;
                double d1 = Math.max((double)l * 0.5, 3.0);
                double d2 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d0 / d1) + Math.PI) / 2.0 + 0.5;
                double d3 = Mth.lerp((double)d2, (double)0.0, (double)l);
                pGuiGraphics.enableScissor(pMinX - 1, pMinY, pMaxX + 1, pMaxY);
                pGuiGraphics.drawString(pFont, pText, pMinX - (int)d3, j, pColor);
                pGuiGraphics.disableScissor();
            } else {
                pGuiGraphics.drawCenteredString(pFont, pText, (pMinX + pMaxX) / 2, j, pColor);
            }
        }

        protected void renderScrollingString(GuiGraphics pGuiGraphics, Font pFont, int pWidth, int pColor, float partialTicks) {
            int i = this.getX() + pWidth;
            int j = this.getX() + this.getWidth() - pWidth;
            ListButton.renderScrollingString(pGuiGraphics, pFont, (Component)Component.literal((String)this.name), i, this.getY(partialTicks), j, this.getY(partialTicks) + this.getHeight(), pColor, (float)OwlCourierSendScreen.this.ticks + partialTicks);
        }

        public void onClick(double pMouseX, double pMouseY) {
            this.onPress.onPress(this);
        }

        public void onRelease(double pMouseX, double pMouseY) {
        }

        public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
            boolean flag;
            if (this.isValidClickButton(pButton) && (flag = this.clicked(pMouseX, pMouseY))) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                this.onClick(pMouseX, pMouseY);
                return true;
            }
            return false;
        }

        public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
            if (this.isValidClickButton(pButton)) {
                this.onRelease(pMouseX, pMouseY);
                return true;
            }
            return false;
        }

        protected boolean isValidClickButton(int pButton) {
            return pButton == 0;
        }

        protected boolean clicked(double pMouseX, double pMouseY) {
            return this.isHovered() && !this.isDisabled();
        }

        public static interface OnPress {
            public void onPress(ListButton var1);
        }
    }
}

