/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.math.Axis;
import java.util.Map;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.data.books.HexereiBookItem;
import net.joefoxe.hexerei.data.books.PageDrawing;
import net.joefoxe.hexerei.tileentity.BookOfShadowsAltarTile;
import net.joefoxe.hexerei.tileentity.renderer.CrystalBallRenderer;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;

public class BookOfShadowsAltarRenderer
implements BlockEntityRenderer<BookOfShadowsAltarTile> {
    private final Minecraft minecraft = Minecraft.getInstance();
    private final ItemRenderer itemRenderer = this.minecraft.getItemRenderer();

    public static double getDistanceToEntity(Entity entity, BlockPos pos) {
        double deltaX = entity.getX() - (double)pos.getX();
        double deltaY = entity.getY() - (double)pos.getY();
        double deltaZ = entity.getZ() - (double)pos.getZ();
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public AABB getRenderBoundingBox(BookOfShadowsAltarTile blockEntity) {
        return super.getRenderBoundingBox((BlockEntity)blockEntity).inflate(5.0, 5.0, 5.0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void render(BookOfShadowsAltarTile altarTile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ResourceLocation loc;
        if (!altarTile.getLevel().getBlockState(altarTile.getBlockPos()).hasBlockEntity()) return;
        if (!(altarTile.getLevel().getBlockEntity(altarTile.getBlockPos()) instanceof BookOfShadowsAltarTile)) {
            return;
        }
        ItemStack stack = altarTile.itemHandler.getStackInSlot(0);
        if (stack.getItem() instanceof HexereiBookItem) {
            boolean isBookOfShadows = altarTile.currentBook != null && altarTile.currentBook.book().equals((Object)HexereiUtil.getResource("book_of_shadows"));
            MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
            altarTile.degreesSpunRender = CrystalBallRenderer.lerpAngle(altarTile.degreesSpunOld, altarTile.degreesSpun, partialTicks);
            altarTile.buttonScaleRender = Math.max(0.0f, BookOfShadowsAltarTile.easeButtons(Mth.lerp((float)partialTicks, (float)altarTile.buttonScaleOld, (float)altarTile.buttonScale)));
            altarTile.degreesOpenedRender = BookOfShadowsAltarTile.easeOpened(Mth.lerp((float)partialTicks, (float)altarTile.openedPercentOld, (float)altarTile.openedPercent)) * 90.0f;
            altarTile.degreesFloppedRender = BookOfShadowsAltarTile.easeFlop(Mth.lerp((float)partialTicks, (float)altarTile.floppedPercentOld, (float)altarTile.floppedPercent)) * 90.0f;
            altarTile.pageOneRotationRender = Mth.lerp((float)partialTicks, (float)altarTile.pageOneRotationLast, (float)altarTile.pageOneRotation);
            altarTile.pageTwoRotationRender = Mth.lerp((float)partialTicks, (float)altarTile.pageTwoRotationLast, (float)altarTile.pageTwoRotation);
            DyeColor col = HexereiUtil.getDyeColorNamed(stack.getHoverName().getString());
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.5f, 1.125f, 0.5f);
            matrixStackIn.translate((float)Math.sin(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f));
            matrixStackIn.translate(0.0f, (BookOfShadowsAltarTile.easeFlop(1.0f - altarTile.degreesFlopped / 90.0f) - 1.0f) / 16.0f, 0.0f);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(altarTile.degreesSpunRender));
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpenedRender / 2.0f + 45.0f)));
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(-altarTile.degreesFloppedRender));
            matrixStackIn.translate(0.0f, -0.00390625f * (1.0f - altarTile.degreesOpenedRender / 90.0f), -(altarTile.degreesFloppedRender / 10.0f) / 32.0f);
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(altarTile.degreesOpenedRender - 90.0f));
            matrixStackIn.translate(0.03125f * (altarTile.degreesOpenedRender / 90.0f), 0.03125f * (1.0f - altarTile.degreesOpenedRender / 90.0f), 0.0f);
            if (isBookOfShadows) {
                this.renderBlock(matrixStackIn, (MultiBufferSource)buffer, combinedLightIn, ((Block)ModBlocks.BOOK_OF_SHADOWS_COVER.get()).defaultBlockState(), HexereiBookItem.getColor2(stack));
                this.renderBlock(matrixStackIn, (MultiBufferSource)buffer, combinedLightIn, ((Block)ModBlocks.BOOK_OF_SHADOWS_COVER_CORNERS.get()).defaultBlockState(), col == null ? HexereiBookItem.getColor1(stack) : HexereiUtil.getColorValue(col));
            } else {
                this.renderBlock(matrixStackIn, (MultiBufferSource)buffer, combinedLightIn, ((Block)ModBlocks.BOOK_COVER.get()).defaultBlockState(), HexereiBookItem.getColor2(stack));
                this.renderBlock(matrixStackIn, (MultiBufferSource)buffer, combinedLightIn, ((Block)ModBlocks.BOOK_COVER_CORNERS.get()).defaultBlockState(), col == null ? HexereiBookItem.getColor1(stack) : HexereiUtil.getColorValue(col));
            }
            matrixStackIn.popPose();
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.5f, 1.125f, 0.5f);
            matrixStackIn.translate((float)Math.sin(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f));
            matrixStackIn.translate(0.0f, (BookOfShadowsAltarTile.easeFlop(1.0f - altarTile.degreesFlopped / 90.0f) - 1.0f) / 16.0f, 0.0f);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(altarTile.degreesSpunRender));
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpenedRender / 2.0f + 45.0f)));
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(-altarTile.degreesFloppedRender));
            matrixStackIn.translate(0.0f, -0.00390625f * (1.0f - altarTile.degreesOpenedRender / 90.0f), -(altarTile.degreesFloppedRender / 10.0f) / 32.0f);
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(-(altarTile.degreesOpenedRender - 90.0f)));
            matrixStackIn.translate(-0.03125f * (altarTile.degreesOpenedRender / 90.0f), 0.03125f * (1.0f - altarTile.degreesOpenedRender / 90.0f), 0.0f);
            if (isBookOfShadows) {
                this.renderBlock(matrixStackIn, (MultiBufferSource)buffer, combinedLightIn, ((Block)ModBlocks.BOOK_OF_SHADOWS_BACK.get()).defaultBlockState(), HexereiBookItem.getColor2(stack));
                this.renderBlock(matrixStackIn, (MultiBufferSource)buffer, combinedLightIn, ((Block)ModBlocks.BOOK_OF_SHADOWS_BACK_CORNERS.get()).defaultBlockState(), col == null ? HexereiBookItem.getColor1(stack) : HexereiUtil.getColorValue(col));
            } else {
                this.renderBlock(matrixStackIn, (MultiBufferSource)buffer, combinedLightIn, ((Block)ModBlocks.BOOK_BACK.get()).defaultBlockState(), HexereiBookItem.getColor2(stack));
                this.renderBlock(matrixStackIn, (MultiBufferSource)buffer, combinedLightIn, ((Block)ModBlocks.BOOK_BACK_CORNERS.get()).defaultBlockState(), col == null ? HexereiBookItem.getColor1(stack) : HexereiUtil.getColorValue(col));
            }
            matrixStackIn.popPose();
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.5f, 1.125f, 0.5f);
            matrixStackIn.translate((float)Math.sin(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f));
            matrixStackIn.translate(0.0f, (BookOfShadowsAltarTile.easeFlop(1.0f - altarTile.degreesFlopped / 90.0f) - 1.0f) / 16.0f, 0.0f);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(altarTile.degreesSpunRender));
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpenedRender / 2.0f + 45.0f)));
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(-altarTile.degreesFloppedRender));
            matrixStackIn.translate(0.0f, 0.0f, -(altarTile.degreesFloppedRender / 10.0f) / 32.0f);
            if (isBookOfShadows) {
                this.renderBlock(matrixStackIn, (MultiBufferSource)buffer, combinedLightIn, ((Block)ModBlocks.BOOK_OF_SHADOWS_BINDING.get()).defaultBlockState(), HexereiBookItem.getColor2(stack));
            } else {
                this.renderBlock(matrixStackIn, (MultiBufferSource)buffer, combinedLightIn, ((Block)ModBlocks.BOOK_BINDING.get()).defaultBlockState(), HexereiBookItem.getColor2(stack));
            }
            matrixStackIn.popPose();
            buffer.endBatch();
            Vec2 ip = PageDrawing.getIntersectPoint(Minecraft.getInstance().player.getLookAngle(), Minecraft.getInstance().player.getEyePosition(), altarTile, PageDrawing.PageOn.LEFT_PAGE);
            Vec2 ip2 = PageDrawing.getIntersectPoint(Minecraft.getInstance().player.getLookAngle(), Minecraft.getInstance().player.getEyePosition(), altarTile, PageDrawing.PageOn.RIGHT_PAGE);
            if (ip == null) {
                ip = new Vec2(50.0f, 50.0f);
            }
            if (ip2 == null) {
                ip2 = new Vec2(50.0f, 50.0f);
            }
            if (altarTile.openedPercent != 1.0f) {
                altarTile.drawing.drawPages(altarTile, ip.x, ip.y, ip2.x, ip2.y, matrixStackIn, (MultiBufferSource)buffer, combinedLightIn, combinedOverlayIn, partialTicks, PageDrawing.DrawingType.BOOK);
            }
            buffer.endBatch();
            if (altarTile.openedPercent == 1.0f) return;
            try {
                buffer = Minecraft.getInstance().renderBuffers().bufferSource();
                altarTile.drawing.drawTooltips(altarTile, matrixStackIn, (MultiBufferSource)buffer, combinedLightIn, combinedOverlayIn, partialTicks);
                return;
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
                return;
            }
        }
        if (stack.isEmpty()) return;
        FlowerPotBlock block = (FlowerPotBlock)Blocks.FLOWER_POT;
        Map map = block.getFullPotsView();
        BlockState blockState = map.getOrDefault(loc = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()), () -> Blocks.AIR).get().defaultBlockState();
        if (!blockState.isAir()) {
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.1875f, 1.015625f, 0.1875f);
            matrixStackIn.translate(Math.cos((float)blockState.getBlock().toString().length() * 14.0f) / 4.0, 0.0, Math.sin((float)blockState.getBlock().toString().length() * 14.0f) / 4.0);
            matrixStackIn.scale(0.65f, 0.65f, 0.65f);
            this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, blockState);
            matrixStackIn.popPose();
            return;
        }
        BakedModel itemModel = this.itemRenderer.getModel(stack, altarTile.getLevel(), null, 0);
        boolean is3dModel = itemModel.isGui3d();
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (is3dModel) {
                matrixStackIn.translate(0.5f, 1.171875f, 0.5f);
                matrixStackIn.scale(0.65f, 0.65f, 0.65f);
                this.renderItem(stack, altarTile.getLevel(), matrixStackIn, bufferIn, combinedLightIn);
                return;
            }
        }
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.5f, 1.015625f, 0.5f);
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(90.0f));
        matrixStackIn.scale(0.45f, 0.45f, 0.45f);
        this.renderItem(stack, altarTile.getLevel(), matrixStackIn, bufferIn, combinedLightIn);
        matrixStackIn.popPose();
    }

    private void renderItem(ItemStack stack, Level level, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, matrixStackIn, bufferIn, level, 1);
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state) {
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, null);
    }

    public void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state, int color) {
        this.renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, color);
    }

    public void renderSingleBlock(BlockState p_110913_, PoseStack p_110914_, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, int color) {
        RenderShape rendershape = p_110913_.getRenderShape();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
                    BakedModel bakedmodel = dispatcher.getBlockModel(p_110913_);
                    int i = color;
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    dispatcher.getModelRenderer().renderModel(p_110914_.last(), p_110915_.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)p_110913_, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, null);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.getBlock());
                    IClientItemExtensions.of((Item)stack.getItem()).getCustomRenderer().renderByItem(stack, ItemDisplayContext.NONE, p_110914_, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }
}

