/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.WallDryingRack;
import net.joefoxe.hexerei.tileentity.DryingRackTile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;

public class DryingRackRenderer
implements BlockEntityRenderer<DryingRackTile> {
    public static double getDistanceToEntity(Entity entity, BlockPos pos) {
        double deltaX = entity.getX() - (double)pos.getX();
        double deltaY = entity.getY() - (double)pos.getY();
        double deltaZ = entity.getZ() - (double)pos.getZ();
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public void render(DryingRackTile tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tileEntityIn.hasLevel()) {
            return;
        }
        BlockState state = tileEntityIn.getBlockState();
        if (!state.hasBlockEntity()) {
            return;
        }
        float rotation = 0.0f;
        if (state.getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.NORTH) {
            rotation = 180.0f;
        } else if (state.getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.SOUTH) {
            rotation = 0.0f;
        } else if (state.getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.EAST) {
            rotation = 90.0f;
        } else if (state.getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.WEST) {
            rotation = 270.0f;
        }
        if (!((ItemStack)tileEntityIn.getItems().get(0)).isEmpty()) {
            if (((ItemStack)tileEntityIn.getItems().get(0)).getItem() == Items.BROWN_MUSHROOM || ((ItemStack)tileEntityIn.getItems().get(0)).getItem() == Items.RED_MUSHROOM) {
                matrixStackIn.pushPose();
                matrixStackIn.translate(0.5f, 0.0f, 0.5f);
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(rotation));
                matrixStackIn.translate(-0.5f, 0.0f, -0.5f);
                matrixStackIn.translate(0.25f, 0.22f, 0.525f);
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(15.0f));
                matrixStackIn.translate(0.0f, 0.09f, 0.0f);
                if (((ItemStack)tileEntityIn.getItems().get(0)).getItem() == Items.BROWN_MUSHROOM) {
                    this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.HERB_DRYING_RACK_BROWN_MUSHROOM_1.get()).defaultBlockState());
                }
                if (((ItemStack)tileEntityIn.getItems().get(0)).getItem() == Items.RED_MUSHROOM) {
                    this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.HERB_DRYING_RACK_RED_MUSHROOM_1.get()).defaultBlockState());
                }
                matrixStackIn.popPose();
                if (((ItemStack)tileEntityIn.getItems().get(0)).getCount() >= 2) {
                    matrixStackIn.pushPose();
                    matrixStackIn.translate(0.5f, 0.0f, 0.5f);
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(rotation));
                    matrixStackIn.translate(-0.5f, 0.0f, -0.5f);
                    matrixStackIn.translate(0.25f, 0.22f, 0.525f);
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(15.0f));
                    matrixStackIn.translate(0.0f, -0.03f, 0.0f);
                    if (((ItemStack)tileEntityIn.getItems().get(0)).getItem() == Items.BROWN_MUSHROOM) {
                        this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.HERB_DRYING_RACK_BROWN_MUSHROOM_2.get()).defaultBlockState());
                    }
                    if (((ItemStack)tileEntityIn.getItems().get(0)).getItem() == Items.RED_MUSHROOM) {
                        this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.HERB_DRYING_RACK_RED_MUSHROOM_2.get()).defaultBlockState());
                    }
                    matrixStackIn.popPose();
                }
                if (((ItemStack)tileEntityIn.getItems().get(0)).getCount() >= 3) {
                    matrixStackIn.pushPose();
                    matrixStackIn.translate(0.5f, 0.0f, 0.5f);
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(rotation));
                    matrixStackIn.translate(-0.5f, 0.0f, -0.5f);
                    matrixStackIn.translate(0.25f, 0.22f, 0.525f);
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(15.0f));
                    matrixStackIn.translate(0.0f, -0.15f, 0.0f);
                    if (((ItemStack)tileEntityIn.getItems().get(0)).getItem() == Items.BROWN_MUSHROOM) {
                        this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.HERB_DRYING_RACK_BROWN_MUSHROOM_1.get()).defaultBlockState());
                    }
                    if (((ItemStack)tileEntityIn.getItems().get(0)).getItem() == Items.RED_MUSHROOM) {
                        this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.HERB_DRYING_RACK_RED_MUSHROOM_1.get()).defaultBlockState());
                    }
                    matrixStackIn.popPose();
                }
            } else {
                matrixStackIn.pushPose();
                matrixStackIn.translate(0.5f, 0.0f, 0.5f);
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(rotation));
                matrixStackIn.translate(-0.5f, 0.0f, -0.5f);
                matrixStackIn.translate(0.25f, 0.22f, 0.525f);
                if (state.getBlock() instanceof WallDryingRack) {
                    matrixStackIn.translate(0.0f, 0.1f, 0.275f);
                }
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(15.0f));
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(180.0f));
                matrixStackIn.scale(0.45f, 0.45f, 0.45f);
                this.renderItem((ItemStack)tileEntityIn.getItems().get(0), tileEntityIn.getLevel(), matrixStackIn, bufferIn, combinedLightIn);
                matrixStackIn.popPose();
                if (((ItemStack)tileEntityIn.getItems().get(0)).getCount() >= 2) {
                    matrixStackIn.pushPose();
                    matrixStackIn.translate(0.5f, 0.0f, 0.5f);
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(rotation));
                    matrixStackIn.translate(-0.5f, 0.0f, -0.5f);
                    matrixStackIn.translate(0.25f, 0.22f, 0.525f);
                    matrixStackIn.translate(0.075f, 0.05f, -0.025f);
                    if (state.getBlock() instanceof WallDryingRack) {
                        matrixStackIn.translate(0.0f, 0.1f, 0.275f);
                    }
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(15.0f));
                    matrixStackIn.mulPose(Axis.ZP.rotationDegrees(180.0f));
                    matrixStackIn.scale(0.45f, 0.45f, 0.45f);
                    this.renderItem((ItemStack)tileEntityIn.getItems().get(0), tileEntityIn.getLevel(), matrixStackIn, bufferIn, combinedLightIn);
                    matrixStackIn.popPose();
                }
                if (((ItemStack)tileEntityIn.getItems().get(0)).getCount() >= 3) {
                    matrixStackIn.pushPose();
                    matrixStackIn.translate(0.5f, 0.0f, 0.5f);
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(rotation));
                    matrixStackIn.translate(-0.5f, 0.0f, -0.5f);
                    matrixStackIn.translate(0.25f, 0.22f, 0.525f);
                    matrixStackIn.translate(-0.075f, 0.025f, -0.025f);
                    if (state.getBlock() instanceof WallDryingRack) {
                        matrixStackIn.translate(0.0f, 0.1f, 0.275f);
                    }
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(15.0f));
                    matrixStackIn.mulPose(Axis.ZP.rotationDegrees(180.0f));
                    matrixStackIn.scale(0.45f, 0.45f, 0.45f);
                    this.renderItem((ItemStack)tileEntityIn.getItems().get(0), tileEntityIn.getLevel(), matrixStackIn, bufferIn, combinedLightIn);
                    matrixStackIn.popPose();
                }
            }
        }
        if (!((ItemStack)tileEntityIn.getItems().get(1)).isEmpty()) {
            if (((ItemStack)tileEntityIn.getItems().get(1)).getItem() == Items.BROWN_MUSHROOM || ((ItemStack)tileEntityIn.getItems().get(1)).getItem() == Items.RED_MUSHROOM) {
                matrixStackIn.pushPose();
                matrixStackIn.translate(0.5f, 0.0f, 0.5f);
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(rotation));
                matrixStackIn.translate(-0.5f, 0.0f, -0.5f);
                matrixStackIn.translate(0.5f, 0.22f, 0.525f);
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(15.0f));
                matrixStackIn.translate(0.0f, 0.09f, 0.0f);
                if (((ItemStack)tileEntityIn.getItems().get(1)).getItem() == Items.BROWN_MUSHROOM) {
                    this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.HERB_DRYING_RACK_BROWN_MUSHROOM_1.get()).defaultBlockState());
                }
                if (((ItemStack)tileEntityIn.getItems().get(1)).getItem() == Items.RED_MUSHROOM) {
                    this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.HERB_DRYING_RACK_RED_MUSHROOM_1.get()).defaultBlockState());
                }
                matrixStackIn.popPose();
                if (((ItemStack)tileEntityIn.getItems().get(1)).getCount() >= 2) {
                    matrixStackIn.pushPose();
                    matrixStackIn.translate(0.5f, 0.0f, 0.5f);
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(rotation));
                    matrixStackIn.translate(-0.5f, 0.0f, -0.5f);
                    matrixStackIn.translate(0.5f, 0.22f, 0.525f);
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(15.0f));
                    matrixStackIn.translate(0.0f, -0.03f, 0.0f);
                    if (((ItemStack)tileEntityIn.getItems().get(1)).getItem() == Items.BROWN_MUSHROOM) {
                        this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.HERB_DRYING_RACK_BROWN_MUSHROOM_2.get()).defaultBlockState());
                    }
                    if (((ItemStack)tileEntityIn.getItems().get(1)).getItem() == Items.RED_MUSHROOM) {
                        this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.HERB_DRYING_RACK_RED_MUSHROOM_2.get()).defaultBlockState());
                    }
                    matrixStackIn.popPose();
                }
                if (((ItemStack)tileEntityIn.getItems().get(1)).getCount() >= 3) {
                    matrixStackIn.pushPose();
                    matrixStackIn.translate(0.5f, 0.0f, 0.5f);
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(rotation));
                    matrixStackIn.translate(-0.5f, 0.0f, -0.5f);
                    matrixStackIn.translate(0.5f, 0.22f, 0.525f);
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(15.0f));
                    matrixStackIn.translate(0.0f, -0.15f, 0.0f);
                    if (((ItemStack)tileEntityIn.getItems().get(1)).getItem() == Items.BROWN_MUSHROOM) {
                        this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.HERB_DRYING_RACK_BROWN_MUSHROOM_1.get()).defaultBlockState());
                    }
                    if (((ItemStack)tileEntityIn.getItems().get(1)).getItem() == Items.RED_MUSHROOM) {
                        this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.HERB_DRYING_RACK_RED_MUSHROOM_1.get()).defaultBlockState());
                    }
                    matrixStackIn.popPose();
                }
            } else {
                matrixStackIn.pushPose();
                matrixStackIn.translate(0.5f, 0.0f, 0.5f);
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(rotation));
                matrixStackIn.translate(-0.5f, 0.0f, -0.5f);
                matrixStackIn.translate(0.5f, 0.22f, 0.525f);
                if (state.getBlock() instanceof WallDryingRack) {
                    matrixStackIn.translate(0.0f, 0.1f, 0.275f);
                }
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(15.0f));
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(180.0f));
                matrixStackIn.scale(0.45f, 0.45f, 0.45f);
                this.renderItem((ItemStack)tileEntityIn.getItems().get(1), tileEntityIn.getLevel(), matrixStackIn, bufferIn, combinedLightIn);
                matrixStackIn.popPose();
                if (((ItemStack)tileEntityIn.getItems().get(1)).getCount() >= 2) {
                    matrixStackIn.pushPose();
                    matrixStackIn.translate(0.5f, 0.0f, 0.5f);
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(rotation));
                    matrixStackIn.translate(-0.5f, 0.0f, -0.5f);
                    matrixStackIn.translate(0.5f, 0.22f, 0.525f);
                    matrixStackIn.translate(0.075f, 0.05f, -0.025f);
                    if (state.getBlock() instanceof WallDryingRack) {
                        matrixStackIn.translate(0.0f, 0.1f, 0.275f);
                    }
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(15.0f));
                    matrixStackIn.mulPose(Axis.ZP.rotationDegrees(180.0f));
                    matrixStackIn.scale(0.45f, 0.45f, 0.45f);
                    this.renderItem((ItemStack)tileEntityIn.getItems().get(1), tileEntityIn.getLevel(), matrixStackIn, bufferIn, combinedLightIn);
                    matrixStackIn.popPose();
                }
                if (((ItemStack)tileEntityIn.getItems().get(1)).getCount() >= 3) {
                    matrixStackIn.pushPose();
                    matrixStackIn.translate(0.5f, 0.0f, 0.5f);
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(rotation));
                    matrixStackIn.translate(-0.5f, 0.0f, -0.5f);
                    matrixStackIn.translate(0.5f, 0.22f, 0.525f);
                    matrixStackIn.translate(-0.075f, 0.025f, -0.025f);
                    if (state.getBlock() instanceof WallDryingRack) {
                        matrixStackIn.translate(0.0f, 0.1f, 0.275f);
                    }
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(15.0f));
                    matrixStackIn.mulPose(Axis.ZP.rotationDegrees(180.0f));
                    matrixStackIn.scale(0.45f, 0.45f, 0.45f);
                    this.renderItem((ItemStack)tileEntityIn.getItems().get(1), tileEntityIn.getLevel(), matrixStackIn, bufferIn, combinedLightIn);
                    matrixStackIn.popPose();
                }
            }
        }
        if (!((ItemStack)tileEntityIn.getItems().get(2)).isEmpty()) {
            if (((ItemStack)tileEntityIn.getItems().get(2)).getItem() == Items.BROWN_MUSHROOM || ((ItemStack)tileEntityIn.getItems().get(2)).getItem() == Items.RED_MUSHROOM) {
                matrixStackIn.pushPose();
                matrixStackIn.translate(0.5f, 0.0f, 0.5f);
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(rotation));
                matrixStackIn.translate(-0.5f, 0.0f, -0.5f);
                matrixStackIn.translate(0.75f, 0.22f, 0.525f);
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(15.0f));
                matrixStackIn.translate(0.0f, 0.09f, 0.0f);
                if (((ItemStack)tileEntityIn.getItems().get(2)).getItem() == Items.BROWN_MUSHROOM) {
                    this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.HERB_DRYING_RACK_BROWN_MUSHROOM_1.get()).defaultBlockState());
                }
                if (((ItemStack)tileEntityIn.getItems().get(2)).getItem() == Items.RED_MUSHROOM) {
                    this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.HERB_DRYING_RACK_RED_MUSHROOM_1.get()).defaultBlockState());
                }
                matrixStackIn.popPose();
                if (((ItemStack)tileEntityIn.getItems().get(2)).getCount() >= 2) {
                    matrixStackIn.pushPose();
                    matrixStackIn.translate(0.5f, 0.0f, 0.5f);
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(rotation));
                    matrixStackIn.translate(-0.5f, 0.0f, -0.5f);
                    matrixStackIn.translate(0.75f, 0.22f, 0.525f);
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(15.0f));
                    matrixStackIn.translate(0.0f, -0.03f, 0.0f);
                    if (((ItemStack)tileEntityIn.getItems().get(2)).getItem() == Items.BROWN_MUSHROOM) {
                        this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.HERB_DRYING_RACK_BROWN_MUSHROOM_2.get()).defaultBlockState());
                    }
                    if (((ItemStack)tileEntityIn.getItems().get(2)).getItem() == Items.RED_MUSHROOM) {
                        this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.HERB_DRYING_RACK_RED_MUSHROOM_2.get()).defaultBlockState());
                    }
                    matrixStackIn.popPose();
                }
                if (((ItemStack)tileEntityIn.getItems().get(2)).getCount() >= 3) {
                    matrixStackIn.pushPose();
                    matrixStackIn.translate(0.5f, 0.0f, 0.5f);
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(rotation));
                    matrixStackIn.translate(-0.5f, 0.0f, -0.5f);
                    matrixStackIn.translate(0.75f, 0.22f, 0.525f);
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(15.0f));
                    matrixStackIn.translate(0.0f, -0.15f, 0.0f);
                    if (((ItemStack)tileEntityIn.getItems().get(2)).getItem() == Items.BROWN_MUSHROOM) {
                        this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.HERB_DRYING_RACK_BROWN_MUSHROOM_1.get()).defaultBlockState());
                    }
                    if (((ItemStack)tileEntityIn.getItems().get(2)).getItem() == Items.RED_MUSHROOM) {
                        this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.HERB_DRYING_RACK_RED_MUSHROOM_1.get()).defaultBlockState());
                    }
                    matrixStackIn.popPose();
                }
            } else {
                matrixStackIn.pushPose();
                matrixStackIn.translate(0.5f, 0.0f, 0.5f);
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(rotation));
                matrixStackIn.translate(-0.5f, 0.0f, -0.5f);
                matrixStackIn.translate(0.75f, 0.22f, 0.525f);
                if (state.getBlock() instanceof WallDryingRack) {
                    matrixStackIn.translate(0.0f, 0.1f, 0.275f);
                }
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(15.0f));
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(180.0f));
                matrixStackIn.scale(0.45f, 0.45f, 0.45f);
                this.renderItem((ItemStack)tileEntityIn.getItems().get(2), tileEntityIn.getLevel(), matrixStackIn, bufferIn, combinedLightIn);
                matrixStackIn.popPose();
                if (((ItemStack)tileEntityIn.getItems().get(2)).getCount() >= 2) {
                    matrixStackIn.pushPose();
                    matrixStackIn.translate(0.5f, 0.0f, 0.5f);
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(rotation));
                    matrixStackIn.translate(-0.5f, 0.0f, -0.5f);
                    matrixStackIn.translate(0.75f, 0.22f, 0.525f);
                    matrixStackIn.translate(0.075f, 0.05f, -0.025f);
                    if (state.getBlock() instanceof WallDryingRack) {
                        matrixStackIn.translate(0.0f, 0.1f, 0.275f);
                    }
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(15.0f));
                    matrixStackIn.mulPose(Axis.ZP.rotationDegrees(180.0f));
                    matrixStackIn.scale(0.45f, 0.45f, 0.45f);
                    this.renderItem((ItemStack)tileEntityIn.getItems().get(2), tileEntityIn.getLevel(), matrixStackIn, bufferIn, combinedLightIn);
                    matrixStackIn.popPose();
                }
                if (((ItemStack)tileEntityIn.getItems().get(2)).getCount() >= 3) {
                    matrixStackIn.pushPose();
                    matrixStackIn.translate(0.5f, 0.0f, 0.5f);
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(rotation));
                    matrixStackIn.translate(-0.5f, 0.0f, -0.5f);
                    matrixStackIn.translate(0.75f, 0.22f, 0.525f);
                    matrixStackIn.translate(-0.075f, 0.025f, -0.025f);
                    if (state.getBlock() instanceof WallDryingRack) {
                        matrixStackIn.translate(0.0f, 0.1f, 0.275f);
                    }
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(15.0f));
                    matrixStackIn.mulPose(Axis.ZP.rotationDegrees(180.0f));
                    matrixStackIn.scale(0.45f, 0.45f, 0.45f);
                    this.renderItem((ItemStack)tileEntityIn.getItems().get(2), tileEntityIn.getLevel(), matrixStackIn, bufferIn, combinedLightIn);
                    matrixStackIn.popPose();
                }
            }
        }
    }

    private void renderItem(ItemStack stack, Level level, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, matrixStackIn, bufferIn, level, 1);
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state) {
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, null);
    }
}

