/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.tileentity.PestleAndMortarTile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;

public class PestleAndMortarRenderer
implements BlockEntityRenderer<PestleAndMortarTile> {
    public void render(PestleAndMortarTile tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tileEntityIn.getLevel().getBlockState(tileEntityIn.getBlockPos()).hasBlockEntity() || !(tileEntityIn.getLevel().getBlockEntity(tileEntityIn.getBlockPos()) instanceof PestleAndMortarTile)) {
            return;
        }
        float craftPercent = (float)(tileEntityIn.grindingTimeMax - tileEntityIn.grindingTime) / (float)tileEntityIn.grindingTimeMax;
        float craftPercent2 = (float)(tileEntityIn.grindingTimeMax - tileEntityIn.grindingTime) / 100.0f;
        float height = 0.375f;
        for (int i = 0; i < 5; ++i) {
            ItemStack item = tileEntityIn.getItemStackInSlot(i);
            if (item.isEmpty()) continue;
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.5, (double)(height + 0.00390625f), 0.5);
            float currentTime = (float)tileEntityIn.getLevel().getGameTime() + partialTicks;
            double itemRotationOffset = 2.512 * (double)i + (double)((float)tileEntityIn.grindingTime / 6.0f) - Math.pow(Mth.sin((float)(craftPercent2 * 3.14f * 5.0f - 3.14f)), 2.0);
            matrixStackIn.translate(0.0 + Math.sin(itemRotationOffset) / (double)(6.5f + craftPercent2 * craftPercent2 * 10.0f), (double)(-0.13333334f * craftPercent), 0.0 + Math.cos(itemRotationOffset) / (double)(6.5f + craftPercent2 * craftPercent2 * 10.0f));
            matrixStackIn.mulPose(Axis.YP.rotationDegrees((float)itemRotationOffset * 58.0f - 8.0f));
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(55.0f - 40.0f * craftPercent));
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(-2.5f));
            matrixStackIn.scale(0.4f, 0.4f, 0.4f);
            this.renderItem(item, tileEntityIn.getLevel(), partialTicks, matrixStackIn, bufferIn, combinedLightIn);
            matrixStackIn.popPose();
        }
        ItemStack item2 = tileEntityIn.getItemStackInSlot(5);
        if (!item2.isEmpty()) {
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.5, (double)(height + 0.00390625f - 0.125f), 0.5);
            float currentTime = (float)tileEntityIn.getLevel().getGameTime() + partialTicks;
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(45.0f - craftPercent * craftPercent * 720.0f));
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(75.0f));
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(-2.5f));
            matrixStackIn.scale(0.4f, 0.4f, 0.4f);
            if (item2.getCount() >= 8) {
                matrixStackIn.translate(0.140625f, -0.125f, -0.078125f);
                this.renderItem(item2, tileEntityIn.getLevel(), partialTicks, matrixStackIn, bufferIn, combinedLightIn);
                matrixStackIn.translate(-0.203125f, 0.0625f, 0.15625f);
                matrixStackIn.translate(-0.140625f, 0.0f, -0.078125f);
                this.renderItem(item2, tileEntityIn.getLevel(), partialTicks, matrixStackIn, bufferIn, combinedLightIn);
                matrixStackIn.translate(0.203125f, 0.125f, 0.078125f);
            } else if (item2.getCount() >= 2) {
                matrixStackIn.translate(0.140625f, 0.0f, -0.078125f);
                this.renderItem(item2, tileEntityIn.getLevel(), partialTicks, matrixStackIn, bufferIn, combinedLightIn);
                matrixStackIn.translate(-0.203125f, 0.125f, 0.078125f);
            }
            this.renderItem(item2, tileEntityIn.getLevel(), partialTicks, matrixStackIn, bufferIn, combinedLightIn);
            matrixStackIn.popPose();
        }
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.5, 0.28125, 0.5);
        int rotationOffset = 0;
        if (tileEntityIn.getLevel().getBlockState(tileEntityIn.getBlockPos()).getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.NORTH) {
            rotationOffset = 0;
        }
        if (tileEntityIn.getLevel().getBlockState(tileEntityIn.getBlockPos()).getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.WEST) {
            rotationOffset = 90;
        }
        if (tileEntityIn.getLevel().getBlockState(tileEntityIn.getBlockPos()).getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.SOUTH) {
            rotationOffset = 180;
        }
        if (tileEntityIn.getLevel().getBlockState(tileEntityIn.getBlockPos()).getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.EAST) {
            rotationOffset = 270;
        }
        double itemRotationOffset = 2.512 + (double)((float)tileEntityIn.grindingTime / 6.0f) - Math.pow(Mth.sin((float)(craftPercent2 * 3.14f * 5.0f - 3.14f)), 2.0);
        double pestleYOffset = Math.pow(Mth.sin((float)(craftPercent2 * 3.14f * 5.0f - 1.2f)), 10.0) / 4.0;
        double pestleTwistOffset = Math.pow(Mth.sin((float)(craftPercent2 * 3.14f * 5.0f - 3.14f)), 10.0) / 4.0;
        double pestleTwistOffset2 = Math.pow(Mth.sin((float)(craftPercent2 * 3.14f * 5.0f - 3.14f)), 10.0) / 4.0 - Math.pow(Mth.cos((float)(craftPercent2 * 3.14f * 5.0f - 3.14f)), 10.0) / 4.0;
        if (!tileEntityIn.crafting) {
            pestleYOffset = 0.0;
            pestleTwistOffset = 0.0;
        }
        matrixStackIn.mulPose(Axis.YP.rotationDegrees((float)rotationOffset + (float)itemRotationOffset / 6.28f * 360.0f + 65.0f));
        matrixStackIn.translate(0.05, pestleYOffset, 0.0);
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(-((float)itemRotationOffset) / 6.28f * 360.0f - 90.0f + (float)pestleTwistOffset * 150.0f - 30.0f));
        if (!tileEntityIn.crafting) {
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(-20.0f));
        } else {
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(-40.0f * (float)pestleTwistOffset2));
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(40.0f * (float)pestleTwistOffset));
        }
        this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.PESTLE_AND_MORTAR_PESTLE.get()).defaultBlockState());
        matrixStackIn.popPose();
    }

    private void renderItem(ItemStack stack, Level level, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, matrixStackIn, bufferIn, level, 1);
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state) {
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, null);
    }
}

