/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;

public class DynamicTextureHandler {
    public static FileToIdConverter TEXTURE_ID_CONVERTER = new FileToIdConverter("textures", ".png");
    public static Map<ResourceLocation, DynamicBaseSprite> textures = new HashMap<ResourceLocation, DynamicBaseSprite>();

    public static DynamicBaseSprite addNewSprite(ResourceLocation location, BlockState state) {
        TextureAtlasSprite sprite = DynamicTextureHandler.getFirstSprite(state);
        if (sprite != null && !textures.containsKey(location)) {
            try {
                NativeImage image = sprite.contents().getOriginalImage();
                AnimationMetadataSection metadata = DynamicTextureHandler.getAnimationMetadata(sprite.contents().name());
                FrameSize frameSize = metadata.calculateFrameSize(image.getWidth(), image.getHeight());
                int scale = 2;
                int width = 3;
                int height = 2;
                Tuple<NativeImage, Map<Direction, Integer>> tuple = DynamicTextureHandler.createCubeTexture(state, frameSize, sprite, scale, width, height);
                DynamicBaseSprite baseSprite = new DynamicBaseSprite((NativeImage)tuple.getA(), location, scale, width, height);
                textures.put(location, baseSprite);
                Minecraft.getInstance().getTextureManager().register(location, (AbstractTexture)baseSprite);
                return baseSprite;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Tuple<NativeImage, Map<Direction, Integer>> createCubeTexture(BlockState state, FrameSize frameSize, TextureAtlasSprite defaultSprite, int texScale, int width, int height) {
        HashMap<Direction, Integer> tintIndex = new HashMap<Direction, Integer>();
        for (Direction dir : Direction.values()) {
            tintIndex.put(dir, -1);
        }
        BakedModel model = Minecraft.getInstance().getModelManager().getBlockModelShaper().getBlockModel(state);
        FrameSize oldFrameSize = frameSize;
        frameSize = new FrameSize(32, 32);
        NativeImage newImage = new NativeImage(frameSize.width(), frameSize.height(), true);
        int currentY = 0;
        int scale = (int)((float)frameSize.width() / 16.0f);
        int rotation = 0;
        TextureAtlasSprite sprite = defaultSprite;
        Direction dir = Direction.UP;
        List list = model.getQuads(state, dir, RandomSource.create());
        if (list.size() > 0) {
            sprite = ((BakedQuad)list.get(0)).getSprite();
            rotation = DynamicTextureHandler.detectRotation(DynamicTextureHandler.normalizeUVs(DynamicTextureHandler.getUVs(((BakedQuad)list.get(0)).getVertices())));
            tintIndex.put(dir, ((BakedQuad)list.get(0)).getTintIndex());
        }
        list = model.getQuads(state, null, RandomSource.create());
        for (BakedQuad quad : list) {
            if (quad.getDirection() != dir) continue;
            sprite = quad.getSprite();
            rotation = DynamicTextureHandler.detectRotation(DynamicTextureHandler.normalizeUVs(DynamicTextureHandler.getUVs(quad.getVertices())));
            tintIndex.put(dir, quad.getTintIndex());
        }
        BlockColors blockColors = Minecraft.getInstance().getBlockColors();
        int col = (Integer)tintIndex.get(dir) == -1 ? -1 : blockColors.getColor(state, null, null, ((Integer)tintIndex.get(dir)).intValue());
        DynamicTextureHandler.rebuildFace(DynamicTextureHandler.firstFrameTexture(sprite.contents().getOriginalImage(), oldFrameSize), newImage, 0, currentY, scale, width, width, rotation, col);
        rotation = 0;
        sprite = defaultSprite;
        dir = Direction.DOWN;
        list = model.getQuads(state, dir, RandomSource.create());
        if (list.size() > 0) {
            sprite = ((BakedQuad)list.get(0)).getSprite();
            rotation = DynamicTextureHandler.detectRotation(DynamicTextureHandler.normalizeUVs(DynamicTextureHandler.getUVs(((BakedQuad)list.get(0)).getVertices())));
            tintIndex.put(dir, ((BakedQuad)list.get(0)).getTintIndex());
        }
        list = model.getQuads(state, null, RandomSource.create());
        for (BakedQuad quad : list) {
            if (quad.getDirection() != dir) continue;
            sprite = quad.getSprite();
            rotation = DynamicTextureHandler.detectRotation(DynamicTextureHandler.normalizeUVs(DynamicTextureHandler.getUVs(quad.getVertices())));
            tintIndex.put(dir, quad.getTintIndex());
        }
        col = (Integer)tintIndex.get(dir) == -1 ? -1 : Minecraft.getInstance().getBlockColors().getColor(state, null, null, ((Integer)tintIndex.get(dir)).intValue());
        DynamicTextureHandler.rebuildFace(DynamicTextureHandler.firstFrameTexture(sprite.contents().getOriginalImage(), oldFrameSize), newImage, width * scale, currentY, scale, width, width, rotation, col);
        currentY += width * scale;
        rotation = 0;
        sprite = defaultSprite;
        list = model.getQuads(state, Direction.NORTH, RandomSource.create());
        if (list.size() > 0) {
            sprite = ((BakedQuad)list.get(0)).getSprite();
            rotation = DynamicTextureHandler.detectRotation(DynamicTextureHandler.normalizeUVs(DynamicTextureHandler.getUVs(((BakedQuad)list.get(0)).getVertices())));
            tintIndex.put(Direction.NORTH, ((BakedQuad)list.get(0)).getTintIndex());
        }
        col = (Integer)tintIndex.get(Direction.NORTH) == -1 ? -1 : Minecraft.getInstance().getBlockColors().getColor(state, null, null, ((Integer)tintIndex.get(Direction.NORTH)).intValue());
        DynamicTextureHandler.rebuildFace(DynamicTextureHandler.firstFrameTexture(sprite.contents().getOriginalImage(), oldFrameSize), newImage, 0, currentY, scale, height, width, rotation, col);
        rotation = 0;
        sprite = defaultSprite;
        list = model.getQuads(state, Direction.SOUTH, RandomSource.create());
        if (list.size() > 0) {
            sprite = ((BakedQuad)list.get(0)).getSprite();
            rotation = DynamicTextureHandler.detectRotation(DynamicTextureHandler.normalizeUVs(DynamicTextureHandler.getUVs(((BakedQuad)list.get(0)).getVertices())));
            tintIndex.put(Direction.SOUTH, ((BakedQuad)list.get(0)).getTintIndex());
        }
        col = (Integer)tintIndex.get(Direction.SOUTH) == -1 ? -1 : Minecraft.getInstance().getBlockColors().getColor(state, null, null, ((Integer)tintIndex.get(Direction.SOUTH)).intValue());
        DynamicTextureHandler.rebuildFace(DynamicTextureHandler.firstFrameTexture(sprite.contents().getOriginalImage(), oldFrameSize), newImage, height * scale, currentY, scale, height, width, rotation, col);
        currentY += width * scale;
        rotation = 0;
        sprite = defaultSprite;
        list = model.getQuads(state, Direction.WEST, RandomSource.create());
        if (list.size() > 0) {
            sprite = ((BakedQuad)list.get(0)).getSprite();
            rotation = DynamicTextureHandler.detectRotation(DynamicTextureHandler.normalizeUVs(DynamicTextureHandler.getUVs(((BakedQuad)list.get(0)).getVertices())));
            tintIndex.put(Direction.WEST, ((BakedQuad)list.get(0)).getTintIndex());
        }
        col = (Integer)tintIndex.get(Direction.WEST) == -1 ? -1 : Minecraft.getInstance().getBlockColors().getColor(state, null, null, ((Integer)tintIndex.get(Direction.WEST)).intValue());
        DynamicTextureHandler.rebuildFace(DynamicTextureHandler.firstFrameTexture(sprite.contents().getOriginalImage(), oldFrameSize), newImage, 0, currentY, scale, height, width, rotation, col);
        rotation = 0;
        sprite = defaultSprite;
        list = model.getQuads(state, Direction.EAST, RandomSource.create());
        if (list.size() > 0) {
            sprite = ((BakedQuad)list.get(0)).getSprite();
            rotation = DynamicTextureHandler.detectRotation(DynamicTextureHandler.normalizeUVs(DynamicTextureHandler.getUVs(((BakedQuad)list.get(0)).getVertices())));
            tintIndex.put(Direction.EAST, ((BakedQuad)list.get(0)).getTintIndex());
        }
        col = (Integer)tintIndex.get(Direction.EAST) == -1 ? -1 : Minecraft.getInstance().getBlockColors().getColor(state, null, null, ((Integer)tintIndex.get(Direction.EAST)).intValue());
        DynamicTextureHandler.rebuildFace(DynamicTextureHandler.firstFrameTexture(sprite.contents().getOriginalImage(), oldFrameSize), newImage, height * scale, currentY, scale, height, width, rotation, col);
        return new Tuple((Object)newImage, tintIndex);
    }

    public static Vec2[] getUVs(int[] verts) {
        Vec2[] uvs = new Vec2[4];
        for (int i = 0; i < 4; ++i) {
            float u = Float.intBitsToFloat(verts[i * 8 + 4]);
            float v = Float.intBitsToFloat(verts[i * 8 + 5]);
            uvs[i] = new Vec2(u, v);
        }
        return uvs;
    }

    public static Vec2[] normalizeUVs(Vec2[] uvs) {
        float minU = Float.MAX_VALUE;
        float maxU = Float.MIN_VALUE;
        float minV = Float.MAX_VALUE;
        float maxV = Float.MIN_VALUE;
        Vec2[] returnUVs = new Vec2[4];
        for (Vec2 uv : uvs) {
            if (uv.x < minU) {
                minU = uv.x;
            }
            if (uv.x > maxU) {
                maxU = uv.x;
            }
            if (uv.y < minV) {
                minV = uv.y;
            }
            if (!(uv.y > maxV)) continue;
            maxV = uv.y;
        }
        for (int i = 0; i < uvs.length; ++i) {
            float normalizedU = (uvs[i].x - minU) / (maxU - minU);
            float normalizedV = (uvs[i].y - minV) / (maxV - minV);
            returnUVs[i] = new Vec2(normalizedU, normalizedV);
        }
        return returnUVs;
    }

    public static int detectRotation(Vec2[] uvs) {
        Vec2[] rotation0 = new Vec2[]{new Vec2(0.0f, 0.0f), new Vec2(0.0f, 1.0f), new Vec2(1.0f, 1.0f), new Vec2(1.0f, 0.0f)};
        Vec2[] rotation90 = new Vec2[]{new Vec2(0.0f, 1.0f), new Vec2(1.0f, 1.0f), new Vec2(1.0f, 0.0f), new Vec2(0.0f, 0.0f)};
        Vec2[] rotation180 = new Vec2[]{new Vec2(1.0f, 1.0f), new Vec2(1.0f, 0.0f), new Vec2(0.0f, 0.0f), new Vec2(0.0f, 1.0f)};
        Vec2[] rotation270 = new Vec2[]{new Vec2(1.0f, 0.0f), new Vec2(0.0f, 0.0f), new Vec2(0.0f, 1.0f), new Vec2(1.0f, 1.0f)};
        if (DynamicTextureHandler.matchUVs(uvs, rotation0)) {
            return 0;
        }
        if (DynamicTextureHandler.matchUVs(uvs, rotation90)) {
            return 90;
        }
        if (DynamicTextureHandler.matchUVs(uvs, rotation180)) {
            return 180;
        }
        if (DynamicTextureHandler.matchUVs(uvs, rotation270)) {
            return 270;
        }
        return -1;
    }

    private static boolean matchUVs(Vec2[] uvs, Vec2[] rotation) {
        for (int i = 0; i < uvs.length; ++i) {
            if (uvs[i].equals(rotation[i])) continue;
            return false;
        }
        return true;
    }

    public static void rebuildFace(NativeImage src, NativeImage dest, int destX, int destY, int scale, int sizeX, int sizeY, int rotation, int col) {
        int gridSizeX = Math.round(sizeX * scale);
        int gridSizeY = Math.round(sizeY * scale);
        int totalPoints = gridSizeX * gridSizeY;
        float centerX = (float)gridSizeX / 2.0f;
        float centerY = (float)gridSizeY / 2.0f;
        float[][] points = new float[totalPoints][2];
        for (int y = 0; y < gridSizeY; ++y) {
            for (int x = 0; x < gridSizeX; ++x) {
                points[y * gridSizeX + x] = new float[]{x, y};
                float[] fArray = points[y * gridSizeX + x];
                fArray[0] = fArray[0] / (float)Math.max(1, gridSizeX - 1);
                float[] fArray2 = points[y * gridSizeX + x];
                fArray2[1] = fArray2[1] / (float)Math.max(1, gridSizeY - 1);
            }
        }
        for (float[] point : points) {
            int writeX = Mth.clamp((int)(destX + Mth.floor((float)Mth.clamp((float)(point[0] * (float)(sizeX * scale)), (float)0.0f, (float)(sizeX * scale - 1)))), (int)0, (int)(dest.getWidth() - 1));
            int writeY = Mth.clamp((int)(destY + Mth.floor((float)Mth.clamp((float)(point[1] * (float)(sizeY * scale)), (float)0.0f, (float)(sizeY * scale - 1)))), (int)0, (int)(dest.getHeight() - 1));
            float dx = 0.5f - point[0];
            float dy = 0.5f - point[1];
            float dist = (float)Math.sqrt(dx * dx + dy * dy);
            float offsetX = centerX / 2.0f * Math.max(0.0f, 0.8f - dist) * dx;
            float offsetY = centerY / 2.0f * Math.max(0.0f, 0.8f - dist) * dy;
            Vec2 uv1 = new Vec2(point[0], point[1]);
            Vec2 uv2 = DynamicTextureHandler.rotateUV(uv1, rotation);
            float getXf = Mth.clamp((float)((float)src.getWidth() * uv2.x + offsetX), (float)0.0f, (float)(src.getWidth() - 1));
            float getYf = Mth.clamp((float)((float)src.getHeight() * uv2.y + offsetY), (float)0.0f, (float)(src.getHeight() - 1));
            int getX = Mth.clamp((int)Mth.floor((float)getYf), (int)0, (int)(src.getWidth() - 1));
            int getY = Mth.clamp((int)Mth.floor((float)getXf), (int)0, (int)(src.getHeight() - 1));
            int color = src.getPixelRGBA(getX, getY);
            float alpha = (float)((color = DynamicTextureHandler.mergeColors(col, color)) >> NativeImage.Format.RGBA.alphaOffset() & 0xFF) / 255.0f;
            if (!(alpha > 0.0f)) continue;
            dest.setPixelRGBA(writeX, writeY, color);
        }
    }

    public static int mergeColors(int col, int color) {
        if (col == -1) {
            return color;
        }
        float r = (float)(col >> 16 & 0xFF) / 255.0f;
        float g = (float)(col >> 8 & 0xFF) / 255.0f;
        float b = (float)(col & 0xFF) / 255.0f;
        float newR = (float)(color >> NativeImage.Format.RGBA.redOffset() & 0xFF) / 255.0f * r;
        float newG = (float)(color >> NativeImage.Format.RGBA.greenOffset() & 0xFF) / 255.0f * g;
        float newB = (float)(color >> NativeImage.Format.RGBA.blueOffset() & 0xFF) / 255.0f * b;
        float alpha = (float)(color >> NativeImage.Format.RGBA.alphaOffset() & 0xFF) / 255.0f;
        return HexereiUtil.getColorValueAlpha(newR, newG, newB, alpha);
    }

    public static Vec2 rotateUV(Vec2 uv, int angle) {
        double radians = Math.toRadians(angle);
        float u = uv.x - 0.5f;
        float v = uv.y - 0.5f;
        float rotatedU = (float)((double)u * Math.cos(radians) - (double)v * Math.sin(radians));
        float rotatedV = (float)((double)u * Math.sin(radians) + (double)v * Math.cos(radians));
        return new Vec2(rotatedU += 0.5f, rotatedV += 0.5f);
    }

    public static NativeImage firstFrameTexture(NativeImage originalImage, FrameSize frameSize) {
        int width = frameSize.width();
        int height = frameSize.height();
        NativeImage newImage = new NativeImage(width, height, true);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int color = originalImage.getPixelRGBA(x, y);
                newImage.setPixelRGBA(x, y, color);
            }
        }
        return newImage;
    }

    public static AnimationMetadataSection getAnimationMetadata(ResourceLocation textureLocation) throws IOException {
        Optional optional2;
        Minecraft minecraft = Minecraft.getInstance();
        ResourceManager resourceManager = minecraft.getResourceManager();
        Optional optional = resourceManager.getResource(TEXTURE_ID_CONVERTER.idToFile(textureLocation));
        AnimationMetadataSection defaultMetadata = AnimationMetadataSection.EMPTY;
        if (optional.isPresent() && (optional2 = ((Resource)optional.get()).metadata().getSection((MetadataSectionSerializer)AnimationMetadataSection.SERIALIZER)).isPresent()) {
            return (AnimationMetadataSection)optional2.get();
        }
        return defaultMetadata;
    }

    public static TextureAtlasSprite getFirstSprite(BlockState blockState) {
        Minecraft minecraft = Minecraft.getInstance();
        BakedModel model = minecraft.getModelManager().getBlockModelShaper().getBlockModel(blockState);
        for (Direction direction : Direction.values()) {
            List quads = model.getQuads(blockState, direction, RandomSource.create());
            if (quads.isEmpty()) continue;
            return ((BakedQuad)quads.get(0)).getSprite();
        }
        List unculledQuads = model.getQuads(blockState, null, RandomSource.create());
        if (!unculledQuads.isEmpty()) {
            return ((BakedQuad)unculledQuads.get(0)).getSprite();
        }
        return null;
    }

    public static BakedQuad getFirstQuad(BlockState blockState) {
        Minecraft minecraft = Minecraft.getInstance();
        BakedModel model = minecraft.getModelManager().getBlockModelShaper().getBlockModel(blockState);
        for (Direction direction : Direction.values()) {
            List quads = model.getQuads(blockState, direction, RandomSource.create());
            if (quads.isEmpty()) continue;
            return (BakedQuad)quads.get(0);
        }
        List unculledQuads = model.getQuads(blockState, null, RandomSource.create());
        if (!unculledQuads.isEmpty()) {
            return (BakedQuad)unculledQuads.get(0);
        }
        return null;
    }

    public static class DynamicBaseSprite
    extends DynamicTexture {
        public ResourceLocation location;
        public float scale;
        public int width;
        public int height;

        public DynamicBaseSprite(NativeImage image, ResourceLocation location, float scale, int width, int height) {
            super(image);
            this.location = location;
            this.scale = scale;
            this.width = width;
            this.height = height;
        }
    }
}

