/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import net.joefoxe.hexerei.tileentity.BookOfShadowsAltarTile;
import net.joefoxe.hexerei.util.AbstractPacket;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BookBookmarkDeleteToServer
extends AbstractPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, BookBookmarkDeleteToServer> CODEC = StreamCodec.ofMember(BookBookmarkDeleteToServer::encode, BookBookmarkDeleteToServer::new);
    public static final CustomPacketPayload.Type<BookBookmarkDeleteToServer> TYPE = new CustomPacketPayload.Type(HexereiUtil.getResource("book_bookmark_delete_server"));
    BlockPos bookAltar;
    int slot;

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public BookBookmarkDeleteToServer(BookOfShadowsAltarTile bookAltar, int slot) {
        this.bookAltar = bookAltar.getBlockPos();
        this.slot = slot;
    }

    public BookBookmarkDeleteToServer(RegistryFriendlyByteBuf buf) {
        this.bookAltar = buf.readBlockPos();
        this.slot = buf.readInt();
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.bookAltar);
        buffer.writeInt(this.slot);
    }

    @Override
    public void onServerReceived(MinecraftServer server, ServerPlayer player) {
        BlockEntity blockEntity = player.level().getBlockEntity(this.bookAltar);
        if (blockEntity instanceof BookOfShadowsAltarTile) {
            BookOfShadowsAltarTile book = (BookOfShadowsAltarTile)blockEntity;
            book.deleteBookmark(this.slot);
        }
    }
}

