/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import java.util.HashMap;
import java.util.Map;
import net.joefoxe.hexerei.data.books.BookEntries;
import net.joefoxe.hexerei.data.books.BookManager;
import net.joefoxe.hexerei.util.AbstractPacket;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class BookEntriesPacket
extends AbstractPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, BookEntriesPacket> CODEC = StreamCodec.ofMember(BookEntriesPacket::encode, BookEntriesPacket::new);
    public static final CustomPacketPayload.Type<BookEntriesPacket> TYPE = new CustomPacketPayload.Type(HexereiUtil.getResource("book_entries"));
    protected Map<ResourceLocation, BookEntries> bookEntries = new HashMap<ResourceLocation, BookEntries>();

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public BookEntriesPacket(Map<ResourceLocation, BookEntries> bookEntries) {
        this.bookEntries = bookEntries;
    }

    public BookEntriesPacket(RegistryFriendlyByteBuf buf) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            ResourceLocation book = buf.readResourceLocation();
            CompoundTag tag = buf.readNbt();
            if (tag == null) continue;
            this.bookEntries.put(book, BookEntries.loadFromTag(tag));
        }
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(this.bookEntries.size());
        this.bookEntries.forEach((resourceLocation, bookEntries1) -> {
            buffer.writeResourceLocation(resourceLocation);
            buffer.writeNbt((Tag)BookEntries.saveToTag(bookEntries1));
        });
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        this.bookEntries.forEach((resourceLocation, bookEntries1) -> {
            BookManager.clearBookEntries(resourceLocation);
            BookManager.addBookEntries(bookEntries1);
        });
    }
}

