/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import net.joefoxe.hexerei.item.ModDataComponents;
import net.joefoxe.hexerei.item.data_components.BookData;
import net.joefoxe.hexerei.tileentity.BookOfShadowsAltarTile;
import net.joefoxe.hexerei.util.AbstractPacket;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BookSyncDataPacket
extends AbstractPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, BookSyncDataPacket> CODEC = StreamCodec.ofMember(BookSyncDataPacket::encode, BookSyncDataPacket::new);
    public static final CustomPacketPayload.Type<BookSyncDataPacket> TYPE = new CustomPacketPayload.Type(HexereiUtil.getResource("book_sync_data"));
    BlockPos pos;

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public BookSyncDataPacket(BlockPos pos) {
        this.pos = pos;
    }

    public BookSyncDataPacket(RegistryFriendlyByteBuf buffer) {
        this(buffer.readBlockPos());
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        BlockEntity blockEntity = minecraft.level.getBlockEntity(this.pos);
        if (blockEntity instanceof BookOfShadowsAltarTile) {
            BookOfShadowsAltarTile book = (BookOfShadowsAltarTile)blockEntity;
            book.currentBook = (BookData)book.itemHandler.getStackInSlot(0).get(ModDataComponents.BOOK);
        }
    }
}

