/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import java.util.ArrayList;
import java.util.List;
import net.joefoxe.hexerei.block.custom.Candle;
import net.joefoxe.hexerei.data.candle.PotionCandleEffect;
import net.joefoxe.hexerei.tileentity.CandleTile;
import net.joefoxe.hexerei.util.AbstractPacket;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CandleEffectParticlePacket
extends AbstractPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, CandleEffectParticlePacket> CODEC = StreamCodec.ofMember(CandleEffectParticlePacket::encode, CandleEffectParticlePacket::new);
    public static final CustomPacketPayload.Type<CandleEffectParticlePacket> TYPE = new CustomPacketPayload.Type(HexereiUtil.getResource("candle_effect_particle"));
    BlockPos pos;
    List<String> particleLocations;
    int livingId;
    int stage;

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public CandleEffectParticlePacket(BlockPos pos, List<String> particleLocations, int livingId, int stage) {
        this.pos = pos;
        this.particleLocations = particleLocations;
        this.livingId = livingId;
        this.stage = stage;
    }

    public CandleEffectParticlePacket(RegistryFriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        int size = buffer.readInt();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            list.add(buffer.readUtf());
        }
        this.particleLocations = list;
        this.livingId = buffer.readInt();
        this.stage = buffer.readInt();
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeInt(this.particleLocations.size());
        for (String particleLocation : this.particleLocations) {
            buffer.writeUtf(particleLocation);
        }
        buffer.writeInt(this.livingId);
        buffer.writeInt(this.stage);
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        BlockEntity blockEntity;
        if (player.level().getBlockEntity(this.pos) != null && (blockEntity = player.level().getBlockEntity(this.pos)) instanceof CandleTile) {
            Entity entity;
            CandleTile candleTile = (CandleTile)blockEntity;
            if (this.stage == 0 && (entity = player.level().getEntity(this.livingId)) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                PotionCandleEffect.spawnParticles(player.level(), this.particleLocations, livingEntity);
            }
            if (this.stage == 1) {
                Candle.spawnParticleWave(player.level(), this.pos, true, this.particleLocations, 10);
            }
        }
    }
}

