/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import net.joefoxe.hexerei.client.renderer.entity.custom.CrowEntity;
import net.joefoxe.hexerei.util.AbstractPacket;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class CrowCanAttackToServer
extends AbstractPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, CrowCanAttackToServer> CODEC = StreamCodec.ofMember(CrowCanAttackToServer::encode, CrowCanAttackToServer::new);
    public static final CustomPacketPayload.Type<CrowCanAttackToServer> TYPE = new CustomPacketPayload.Type(HexereiUtil.getResource("crow_can_attack_server"));
    int sourceId;
    boolean canAttack;

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public CrowCanAttackToServer(CrowEntity entity, boolean canAttack) {
        this.sourceId = entity.getId();
        this.canAttack = canAttack;
        entity.canAttack = canAttack;
    }

    public CrowCanAttackToServer(FriendlyByteBuf buf) {
        this.sourceId = buf.readInt();
        this.canAttack = buf.readBoolean();
    }

    public static void encode(CrowCanAttackToServer object, FriendlyByteBuf buffer) {
        buffer.writeInt(object.sourceId);
        buffer.writeBoolean(object.canAttack);
    }

    @Override
    public void onServerReceived(MinecraftServer server, ServerPlayer player) {
        Entity entity = player.level().getEntity(this.sourceId);
        if (entity instanceof CrowEntity) {
            CrowEntity crowEntity = (CrowEntity)entity;
            crowEntity.canAttack = this.canAttack;
        }
    }
}

