/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.world.structure.structures;

import com.mojang.serialization.Codec;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.MahoganyLog;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockRotProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class HexereiMahoganyTreeFeature
extends Feature<NoneFeatureConfiguration> {
    private static final ResourceLocation MAHOGANY_TREE1 = ResourceLocation.parse((String)"hexerei:mahogany_tree1");
    private static final ResourceLocation MAHOGANY_TREE2 = ResourceLocation.parse((String)"hexerei:mahogany_tree2");
    private static final ResourceLocation MAHOGANY_TREE3 = ResourceLocation.parse((String)"hexerei:mahogany_tree3");
    private static final ResourceLocation MAHOGANY_TREE4 = ResourceLocation.parse((String)"hexerei:mahogany_tree4");
    private static final ResourceLocation[] MAHOGANY_TREE = new ResourceLocation[]{MAHOGANY_TREE1, MAHOGANY_TREE2, MAHOGANY_TREE3, MAHOGANY_TREE4};

    public HexereiMahoganyTreeFeature(Codec codec) {
        super(codec);
    }

    public static boolean isAirOrLeavesAt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, state -> state.isAir() || state.is(BlockTags.LEAVES));
    }

    public static boolean isAirOrLeavesOrLogsAt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, state -> state.canBeReplaced() || state.isAir() || state.is(Blocks.BAMBOO) || state.is(BlockTags.LEAVES) || state.is(BlockTags.LOGS));
    }

    private static boolean isDirtOrFarmlandAt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, state -> {
            Block block = state.getBlock();
            return HexereiMahoganyTreeFeature.isDirt((BlockState)state) || block == Blocks.FARMLAND;
        });
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel reader = context.level();
        BlockPos pos = context.origin();
        RandomSource rand = context.random();
        int i = rand.nextInt(MAHOGANY_TREE.length);
        if (!HexereiMahoganyTreeFeature.isDirtOrFarmlandAt((LevelSimulatedReader)reader, pos.below())) {
            return false;
        }
        for (int j = 0; j < 8; ++j) {
            BlockPos upPos = new BlockPos((Vec3i)pos).above(j + 1);
            if (!HexereiMahoganyTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos)) {
                return false;
            }
            if (!HexereiMahoganyTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.north())) {
                return false;
            }
            if (!HexereiMahoganyTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.south())) {
                return false;
            }
            if (!HexereiMahoganyTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.east())) {
                return false;
            }
            if (!HexereiMahoganyTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.east().north())) {
                return false;
            }
            if (!HexereiMahoganyTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.east().south())) {
                return false;
            }
            if (!HexereiMahoganyTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.west())) {
                return false;
            }
            if (!HexereiMahoganyTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.west().north())) {
                return false;
            }
            if (HexereiMahoganyTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.west().south())) continue;
            return false;
        }
        BlockRotProcessor BlockRotProcessor2 = new BlockRotProcessor(0.9f);
        StructureTemplateManager templatemanager = reader.getLevel().getServer().getStructureManager();
        StructureTemplate template = templatemanager.getOrCreate(MAHOGANY_TREE[i]);
        if (template == null) {
            Hexerei.LOGGER.error("Identifier to the specified nbt file was not found! : {}", (Object)MAHOGANY_TREE[i]);
            return false;
        }
        Rotation rotation = Rotation.getRandom((RandomSource)rand);
        BlockPos halfLengths = new BlockPos(template.getSize().getX() / 2, template.getSize().getY() / 2, template.getSize().getZ() / 2);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        StructurePlaceSettings placementsettings = new StructurePlaceSettings().setRotation(rotation).setRotationPivot(halfLengths).setIgnoreEntities(false);
        BlockPos.MutableBlockPos pos1 = mutable.set((Vec3i)pos).move(-halfLengths.getX(), 0, -halfLengths.getZ());
        template.placeInWorld((ServerLevelAccessor)reader, (BlockPos)pos1, (BlockPos)pos1, placementsettings, rand, 2);
        for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
            BlockPos.MutableBlockPos pos2 = new BlockPos.MutableBlockPos().set((Vec3i)pos.below().relative(direction));
            int length = rand.nextInt(3) + 1;
            int branch = rand.nextInt(length) + 1;
            for (int count = 0; HexereiMahoganyTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, (BlockPos)pos2) && count <= length; ++count) {
                if (reader instanceof Level) {
                    Level level = (Level)reader;
                    level.setBlockAndUpdate((BlockPos)pos2, ((MahoganyLog)((Object)ModBlocks.MAHOGANY_LOG.get())).defaultBlockState());
                } else {
                    reader.setBlock((BlockPos)pos2, ((MahoganyLog)((Object)ModBlocks.MAHOGANY_LOG.get())).defaultBlockState(), 3);
                }
                if (branch == count) {
                    pos2.move(direction);
                }
                pos2.move(Direction.DOWN);
            }
        }
        return true;
    }
}

