/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import dev.latvian.mods.kubejs.error.InvalidRecipeComponentException;
import dev.latvian.mods.kubejs.error.MissingRequiredValueException;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.kubejs.script.SourceLine;
import dev.latvian.mods.kubejs.util.WrappedJS;
import dev.latvian.mods.rhino.Context;
import java.util.Map;
import java.util.Objects;

public final class RecipeComponentValue<T>
implements WrappedJS,
Map.Entry<RecipeKey<T>, T> {
    public static final RecipeComponentValue<?>[] EMPTY_ARRAY = new RecipeComponentValue[0];
    public final RecipeKey<T> key;
    public final int index;
    public T value;
    public boolean write;

    public RecipeComponentValue(RecipeKey<T> key, int index) {
        this.key = key;
        this.index = index;
        this.value = null;
        this.write = false;
    }

    public RecipeComponentValue<T> copy() {
        RecipeComponentValue<T> copy = new RecipeComponentValue<T>(this.key, this.index);
        copy.value = this.value;
        copy.write = this.write;
        return copy;
    }

    public boolean matches(Context cx, KubeRecipe recipe, ReplacementMatchInfo match) {
        return this.value != null && (match.componentType().isEmpty() || this.key.component.equals(match.componentType().get())) && this.key.component.matches(cx, recipe, this.value, match);
    }

    public boolean replace(Context cx, KubeRecipe recipe, ReplacementMatchInfo match, Object with) {
        Object newValue;
        Object v0 = newValue = this.value == null ? null : this.key.component.replace(cx, recipe, this.value, match, with);
        if (this.value != newValue) {
            this.value = newValue;
            this.write();
            return true;
        }
        return false;
    }

    @Override
    public RecipeKey<T> getKey() {
        return this.key;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public T setValue(T newValue) {
        T v = this.value;
        this.value = newValue;
        return v;
    }

    public boolean shouldWrite() {
        return this.write;
    }

    public void write() {
        this.write = true;
    }

    public String toString() {
        return "%s = %s".formatted(this.key.name, this.value);
    }

    @Override
    public boolean equals(Object obj) {
        Map.Entry e;
        return obj == this || obj instanceof Map.Entry && this.key == (e = (Map.Entry)obj).getKey() && Objects.equals(this.value, e.getValue());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public void validate(SourceLine sourceLine) {
        if (this.key.allowEmpty) {
            return;
        }
        if (this.value != null) {
            try {
                this.key.component.validate(this.value);
            }
            catch (Throwable cause) {
                throw new InvalidRecipeComponentException(this, cause).source(sourceLine);
            }
        } else if (!this.key.optional()) {
            throw new InvalidRecipeComponentException(this, (Throwable)new MissingRequiredValueException()).source(sourceLine);
        }
    }
}

